/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.iterable.Range;
import explicit.QuantAbstractRefine;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import prism.OptionsIntervalIteration;
import prism.Pair;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismSettingsListener;
import prism.PrismUtils;
import settings.BooleanSetting;
import settings.ChoiceSetting;
import settings.ColorSetting;
import settings.DefaultSettingOwner;
import settings.DoubleSetting;
import settings.FileSelector;
import settings.FileSetting;
import settings.FontColorPair;
import settings.FontColorSetting;
import settings.IntegerSetting;
import settings.LongSetting;
import settings.MultipleLineStringSetting;
import settings.RangeConstraint;
import settings.Setting;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingTable;
import settings.SingleLineStringSetting;

public class PrismSettings
implements Observer {
    public static final String DEFAULT_STRING = "";
    public static final int DEFAULT_INT = 0;
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final long DEFAULT_LONG = 0L;
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final Color DEFAULT_COLOUR = Color.white;
    public static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    public static final FontColorPair DEFAULT_FONT_COLOUR = new FontColorPair(new Font("monospaced", 0, 12), Color.black);
    public static final File DEFAULT_FILE = null;
    public static final String STRING_TYPE = "s";
    public static final String INTEGER_TYPE = "i";
    public static final String FLOAT_TYPE = "f";
    public static final String DOUBLE_TYPE = "d";
    public static final String LONG_TYPE = "l";
    public static final String BOOLEAN_TYPE = "b";
    public static final String COLOUR_TYPE = "c";
    public static final String CHOICE_TYPE = "ch";
    public static final String FONT_COLOUR_TYPE = "fct";
    public static final String FILE_TYPE = "fi";
    public static final Range RANGE_EXPORT_DOUBLE_PRECISION = Range.closed(1, 17);
    public static final int DEFAULT_EXPORT_MODEL_PRECISION = 16;
    public static final String PRISM_ENGINE = "prism.engine";
    public static final String PRISM_HEURISTIC = "prism.heuristic";
    public static final String PRISM_VERBOSE = "prism.verbose";
    public static final String PRISM_FAIRNESS = "prism.fairness";
    public static final String PRISM_PRECOMPUTATION = "prism.precomputation";
    public static final String PRISM_PROB0 = "prism.prob0";
    public static final String PRISM_PROB1 = "prism.prob1";
    public static final String PRISM_PRE_REL = "prism.preRel";
    public static final String PRISM_FIX_DEADLOCKS = "prism.fixDeadlocks";
    public static final String PRISM_DO_PROB_CHECKS = "prism.doProbChecks";
    public static final String PRISM_SUM_ROUND_OFF = "prism.sumRoundOff";
    public static final String PRISM_COMPACT = "prism.compact";
    public static final String PRISM_LIN_EQ_METHOD = "prism.linEqMethod";
    public static final String PRISM_LIN_EQ_METHOD_PARAM = "prism.linEqMethodParam";
    public static final String PRISM_TOPOLOGICAL_VI = "prism.topologicalVI";
    public static final String PRISM_PMAX_QUOTIENT = "prism.pmaxQuotient";
    public static final String PRISM_INTERVAL_ITER = "prism.intervalIter";
    public static final String PRISM_INTERVAL_ITER_OPTIONS = "prism.intervalIterOptions";
    public static final String PRISM_MDP_SOLN_METHOD = "prism.mdpSolnMethod";
    public static final String PRISM_MDP_MULTI_SOLN_METHOD = "prism.mdpMultiSolnMethod";
    public static final String PRISM_IMDP_SOLN_METHOD = "prism.imdpSolnMethod";
    public static final String PRISM_TERM_CRIT = "prism.termCrit";
    public static final String PRISM_TERM_CRIT_PARAM = "prism.termCritParam";
    public static final String PRISM_MAX_ITERS = "prism.maxIters";
    public static final String PRISM_EXPORT_ITERATIONS = "prism.exportIterations";
    public static final String PRISM_GRID_RESOLUTION = "prism.gridResolution";
    public static final String PRISM_EXPORT_MODEL_PRECISION = "prism.exportModelPrecision";
    public static final String PRISM_EXPORT_MODEL_HEADERS = "prism.exportModelHeaders";
    public static final String PRISM_CUDD_MAX_MEM = "prism.cuddMaxMem";
    public static final String PRISM_CUDD_EPSILON = "prism.cuddEpsilon";
    public static final String PRISM_DD_EXTRA_STATE_VARS = "prism.ddExtraStateVars";
    public static final String PRISM_DD_EXTRA_ACTION_VARS = "prism.ddExtraActionVars";
    public static final String PRISM_NUM_SB_LEVELS = "prism.numSBLevels";
    public static final String PRISM_SB_MAX_MEM = "prism.SBMaxMem";
    public static final String PRISM_NUM_SOR_LEVELS = "prism.numSORLevels";
    public static final String PRISM_SOR_MAX_MEM = "prism.SORMaxMem";
    public static final String PRISM_DO_SS_DETECTION = "prism.doSSDetect";
    public static final String PRISM_EXTRA_DD_INFO = "prism.extraDDInfo";
    public static final String PRISM_EXTRA_REACH_INFO = "prism.extraReachInfo";
    public static final String PRISM_SCC_METHOD = "prism.sccMethod";
    public static final String PRISM_SYMM_RED_PARAMS = "prism.symmRedParams";
    public static final String PRISM_EXACT_ENABLED = "prism.exact.enabled";
    public static final String PRISM_PTA_METHOD = "prism.ptaMethod";
    public static final String PRISM_TRANSIENT_METHOD = "prism.transientMethod";
    public static final String PRISM_AR_OPTIONS = "prism.arOptions";
    public static final String PRISM_PATH_VIA_AUTOMATA = "prism.pathViaAutomata";
    public static final String PRISM_NO_DA_SIMPLIFY = "prism.noDaSimplify";
    public static final String PRISM_EXPORT_ADV = "prism.exportAdv";
    public static final String PRISM_EXPORT_ADV_FILENAME = "prism.exportAdvFilename";
    public static final String PRISM_MULTI_MAX_POINTS = "prism.multiMaxIters";
    public static final String PRISM_PARETO_EPSILON = "prism.paretoEpsilon";
    public static final String PRISM_EXPORT_PARETO_FILENAME = "prism.exportParetoFileName";
    public static final String PRISM_LTL2DA_TOOL = "prism.ltl2daTool";
    public static final String PRISM_LTL2DA_SYNTAX = "prism.ltl2daSyntax";
    public static final String PRISM_JDD_SANITY_CHECKS = "prism.ddsanity";
    public static final String PRISM_PARAM_ENABLED = "prism.param.enabled";
    public static final String PRISM_PARAM_PRECISION = "prism.param.precision";
    public static final String PRISM_PARAM_SPLIT = "prism.param.split";
    public static final String PRISM_PARAM_BISIM = "prism.param.bisim";
    public static final String PRISM_PARAM_FUNCTION = "prism.param.function";
    public static final String PRISM_PARAM_ELIM_ORDER = "prism.param.elimOrder";
    public static final String PRISM_PARAM_RANDOM_POINTS = "prism.param.randomPoints";
    public static final String PRISM_PARAM_SUBSUME_REGIONS = "prism.param.subsumeRegions";
    public static final String PRISM_PARAM_DAG_MAX_ERROR = "prism.param.functionDagMaxError";
    public static final String PRISM_FAU_EPSILON = "prism.fau.epsilon";
    public static final String PRISM_FAU_DELTA = "prism.fau.delta";
    public static final String PRISM_FAU_INTERVALS = "prism.fau.intervals";
    public static final String PRISM_FAU_INITIVAL = "prism.fau.initival";
    public static final String PRISM_FAU_ARRAYTHRESHOLD = "prism.fau.arraythreshold";
    public static final String SIMULATOR_DEFAULT_NUM_SAMPLES = "simulator.defaultNumSamples";
    public static final String SIMULATOR_DEFAULT_CONFIDENCE = "simulator.defaultConfidence";
    public static final String SIMULATOR_DEFAULT_WIDTH = "simulator.defaultWidth";
    public static final String SIMULATOR_DEFAULT_APPROX = "simulator.defaultApprox";
    public static final String SIMULATOR_DEFAULT_MAX_PATH = "simulator.defaultMaxPath";
    public static final String SIMULATOR_DECIDE = "simulator.decide";
    public static final String SIMULATOR_ITERATIONS_TO_DECIDE = "simulator.iterationsToDecide";
    public static final String SIMULATOR_MAX_REWARD = "simulator.maxReward";
    public static final String SIMULATOR_SIMULTANEOUS = "simulator.simultaneous";
    public static final String SIMULATOR_FIELD_CHOICE = "simulator.fieldChoice";
    public static final String SIMULATOR_NEW_PATH_ASK_VIEW = "simulator.newPathAskView";
    public static final String SIMULATOR_RENDER_ALL_VALUES = "simulator.renderAllValues";
    public static final String SIMULATOR_NETWORK_FILE = "simulator.networkFile";
    public static final String MODEL_AUTO_PARSE = "model.autoParse";
    public static final String MODEL_AUTO_MANUAL = "model.autoManual";
    public static final String MODEL_PARSE_DELAY = "model.parseDelay";
    public static final String MODEL_PRISM_EDITOR_FONT = "model.prismEditor.font";
    public static final String MODEL_SHOW_LINE_NUMBERS = "model.prismEditor.lineNumbers";
    public static final String MODEL_PRISM_EDITOR_BG_COLOUR = "model.prismEditor.bgColour";
    public static final String MODEL_PRISM_EDITOR_NUMERIC_COLOUR = "model.prismEditor.numericColour";
    public static final String MODEL_PRISM_EDITOR_NUMERIC_STYLE = "model.prismEditor.numericStyle";
    public static final String MODEL_PRISM_EDITOR_IDENTIFIER_COLOUR = "model.prismEditor.identifierColour";
    public static final String MODEL_PRISM_EDITOR_IDENTIFIER_STYLE = "model.prismEditor.identifierStyle";
    public static final String MODEL_PRISM_EDITOR_KEYWORD_COLOUR = "model.prismEditor.keywordColour";
    public static final String MODEL_PRISM_EDITOR_KEYWORD_STYLE = "model.prismEditor.keywordStyle";
    public static final String MODEL_PRISM_EDITOR_COMMENT_COLOUR = "model.prismEditor.commentColour";
    public static final String MODEL_PRISM_EDITOR_COMMENT_STYLE = "model.prismEditor.commentStyle";
    public static final String MODEL_PEPA_EDITOR_FONT = "model.pepaEditor.font";
    public static final String MODEL_PEPA_EDITOR_BG_COLOUR = "model.pepaEditor.bgColour";
    public static final String MODEL_PEPA_EDITOR_COMMENT_COLOUR = "model.pepaEditor.commentColour";
    public static final String MODEL_PEPA_EDITOR_COMMENT_STYLE = "model.pepaEditor.commentStyle";
    public static final String PROPERTIES_FONT = "properties.font";
    public static final String PROPERTIES_SELECTION_COLOUR = "properties.selectionColour";
    public static final String PROPERTIES_WARNING_COLOUR = "properties.warningColour";
    public static final String PROPERTIES_ADDITION_STRATEGY = "properties.additionStategy";
    public static final String PROPERTIES_CLEAR_LIST_ON_LOAD = "properties.clearListOnLoad";
    public static final String LOG_FONT = "log.font";
    public static final String LOG_SELECTION_COLOUR = "log.selectionColour";
    public static final String LOG_BG_COLOUR = "log.bgColour";
    public static final String LOG_BUFFER_LENGTH = "log.bufferLength";
    public static final String[] propertyOwnerNames = new String[]{"PRISM", "Simulator", "Model", "Properties", "Log"};
    public static final int[] propertyOwnerIDs = new int[]{9, 12, 10, 11, 13};
    public static final Object[][][] propertyData = new Object[][][]{{{"ch", "prism.engine", "Engine", "2.1", "Hybrid", "MTBDD,Sparse,Hybrid,Explicit", "Which engine (hybrid, sparse, MTBDD, explicit) should be used for model checking."}, {"ch", "prism.heuristic", "Heuristic mode", "4.5", "None", "None,Speed,Memory", "Which heuristic mode to use for picking engines/settings (none, speed, memory)."}, {"b", "prism.exact.enabled", "Do exact model checking", "4.2.1", false, "", "Perform exact model checking."}, {"ch", "prism.ptaMethod", "PTA model checking method", "3.3", "Stochastic games", "Digital clocks,Stochastic games,Backwards reachability", "Which method to use for model checking of PTAs."}, {"ch", "prism.transientMethod", "Transient probability computation method", "3.3", "Uniformisation", "Uniformisation,Fast adaptive uniformisation", "Which method to use for computing transient probabilities in CTMCs."}, {"ch", "prism.linEqMethod", "Linear equations method", "2.1", "Jacobi", "Power,Jacobi,Gauss-Seidel,Backwards Gauss-Seidel,Pseudo-Gauss-Seidel,Backwards Pseudo-Gauss-Seidel,JOR,SOR,Backwards SOR,Pseudo-SOR,Backwards Pseudo-SOR", "Which iterative method to use when solving linear equation systems."}, {"d", "prism.linEqMethodParam", "Over-relaxation parameter", "2.1", 0.9, "", "Over-relaxation parameter for iterative numerical methods such as JOR/SOR."}, {"b", "prism.topologicalVI", "Use topological value iteration", "4.3.1", false, "", "Use topological value iteration in iterative numerical methods."}, {"b", "prism.pmaxQuotient", "For Pmax computations, compute in the MEC quotient", "4.3.1", false, "", "For Pmax computations, compute in the MEC quotient."}, {"b", "prism.intervalIter", "Use interval iteration", "4.3.1", false, "", "Use interval iteration (from above and below) in iterative numerical methods."}, {"s", "prism.intervalIterOptions", "Interval iteration options", "4.3.1", "", "", "Interval iteration options, a comma-separated list of the following:\n" + OptionsIntervalIteration.getOptionsDescription()}, {"ch", "prism.mdpSolnMethod", "MDP solution method", "4.0", "Value iteration", "Value iteration,Gauss-Seidel,Policy iteration,Modified policy iteration,Linear programming", "Which method to use when solving Markov decision processes."}, {"ch", "prism.mdpMultiSolnMethod", "MDP multi-objective solution method", "4.0.3", "Value iteration", "Value iteration,Gauss-Seidel,Linear programming", "Which method to use when solving multi-objective queries on Markov decision processes."}, {"ch", "prism.imdpSolnMethod", "IMDP/DTMC solution method", "4.7", "Gauss-Seidel", "Value iteration,Gauss-Seidel", "Which method to use when solving interval Markov decision processes and Markov chains."}, {"ch", "prism.termCrit", "Termination criteria", "2.1", "Relative", "Absolute,Relative", "Criteria to use for checking termination of iterative numerical methods."}, {"d", "prism.termCritParam", "Termination epsilon", "2.1", 1.0E-6, "0.0,", "Epsilon value to use for checking termination of iterative numerical methods."}, {"i", "prism.maxIters", "Termination max. iterations", "2.1", 10000, "0,", "Maximum number of iterations to perform if iterative methods do not converge."}, {"b", "prism.exportIterations", "Export iterations (debug/visualisation)", "4.3.1", false, "", "Export solution vectors for iteration algorithms to iterations.html"}, {"i", "prism.gridResolution", "Fixed grid resolution", "4.5", 10, "1,", "The resolution for the fixed grid approximation algorithm for POMDPs."}, {"i", "prism.exportModelPrecision", "Precision of model export", "4.7", 16, String.valueOf(RANGE_EXPORT_DOUBLE_PRECISION.min()) + "-" + String.valueOf(RANGE_EXPORT_DOUBLE_PRECISION.max()), "Export model probabilities/rewards to n significant decimal places."}, {"b", "prism.exportModelHeaders", "Include headers in model exports", "4.7", true, "", "Whether to include #-commented header lines when exporting model data to explicit files."}, {"b", "prism.precomputation", "Use precomputation", "2.1", true, "", "Whether to use model checking precomputation algorithms (Prob0, Prob1, etc.), where optional."}, {"b", "prism.prob0", "Use Prob0 precomputation", "4.0.2", true, "", "Whether to use model checking precomputation algorithm Prob0 (if precomputation enabled)."}, {"b", "prism.prob1", "Use Prob1 precomputation", "4.0.2", true, "", "Whether to use model checking precomputation algorithm Prob1 (if precomputation enabled)."}, {"b", "prism.preRel", "Use predecessor relation", "4.2.1", true, "", "Whether to use a pre-computed predecessor relation in several algorithms."}, {"b", "prism.fairness", "Use fairness", "2.1", false, "", "Constrain to fair adversaries when model checking MDPs."}, {"b", "prism.fixDeadlocks", "Automatically fix deadlocks", "4.0.3", true, "", "Automatically fix deadlocks, where necessary, when constructing probabilistic models."}, {"b", "prism.doProbChecks", "Do probability/rate checks", "2.1", true, "", "Perform sanity checks on model probabilities/rates when constructing probabilistic models."}, {"d", "prism.sumRoundOff", "Probability sum threshold", "2.1", 1.0E-5, "0.0,", "Round-off threshold for places where doubles are summed and compared to integers (e.g. checking that probabilities sum to 1 in an update)."}, {"b", "prism.doSSDetect", "Use steady-state detection", "2.1", true, "0,", "Use steady-state detection during CTMC transient probability computation."}, {"ch", "prism.sccMethod", "SCC decomposition method", "3.2", "Lockstep", "Xie-Beerel,Lockstep,SCC-Find", "Which algorithm to use for (symbolic) decomposition of a graph into strongly connected components (SCCs)."}, {"s", "prism.symmRedParams", "Symmetry reduction parameters", "3.2", "", "", "Parameters for symmetry reduction (format: \"i j\" where i and j are the number of modules before and after the symmetric ones; empty string means symmetry reduction disabled)."}, {"s", "prism.arOptions", "Abstraction refinement options", "3.3", "", "", "Various options passed to the asbtraction-refinement engine (e.g. for PTA model checking)."}, {"b", "prism.pathViaAutomata", "All path formulas via automata", "4.2.1", false, "", "Handle all path formulas via automata constructions."}, {"b", "prism.noDaSimplify", "Do not simplify deterministic automata", "4.3", false, "", "Do not attempt to simplify deterministic automata, acceptance conditions (for debugging)."}, {"i", "prism.multiMaxIters", "Max. multi-objective corner points", "4.0.3", 50, "0,", "Maximum number of corner points to explore if (value iteration based) multi-objective model checking does not converge."}, {"d", "prism.paretoEpsilon", "Pareto approximation threshold", "4.0.3", 0.01, "0.0,", "Determines to what precision the Pareto curve will be approximated."}, {"s", "prism.exportParetoFileName", "Pareto curve export filename", "4.0.3", "", "0,", "If non-empty, any Pareto curve generated will be exported to this file."}, {"b", "prism.verbose", "Verbose output", "2.1", false, "", "Display verbose output to log."}, {"b", "prism.extraDDInfo", "Extra MTBDD information", "3.1.1", false, "0,", "Display extra information about (MT)BDDs used during and after model construction."}, {"b", "prism.extraReachInfo", "Extra reachability information", "3.1.1", false, "0,", "Display extra information about progress of reachability during model construction."}, {"b", "prism.compact", "Use compact schemes", "2.1", true, "", "Use additional optimisations for compressing sparse matrices and vectors with repeated values."}, {"i", "prism.numSBLevels", "Hybrid sparse levels", "2.1", -1, "-1,", "Number of MTBDD levels ascended when adding sparse matrices to hybrid engine data structures (-1 means use default)."}, {"i", "prism.SBMaxMem", "Hybrid sparse memory (KB)", "2.1", 1024, "0,", "Maximum memory usage when adding sparse matrices to hybrid engine data structures (KB)."}, {"i", "prism.numSORLevels", "Hybrid GS levels", "2.1", -1, "-1,", "Number of MTBDD levels descended for hybrid engine data structures block division with GS/SOR."}, {"i", "prism.SORMaxMem", "Hybrid GS memory (KB)", "2.1", 1024, "0,", "Maximum memory usage for hybrid engine data structures block division with GS/SOR (KB)."}, {"s", "prism.cuddMaxMem", "CUDD max. memory", "4.2.1", new String("1g"), "", "Maximum memory available to CUDD (underlying BDD/MTBDD library), e.g. 125k, 50m, 4g. Note: Restart PRISM after changing this."}, {"d", "prism.cuddEpsilon", "CUDD epsilon", "2.1", 1.0E-15, "0.0,", "Epsilon value used by CUDD (underlying BDD/MTBDD library) for terminal cache comparisons."}, {"i", "prism.ddExtraStateVars", "Extra DD state var allocation", "4.3.1", 20, "", "Number of extra DD state variables preallocated for use in model transformation."}, {"i", "prism.ddExtraActionVars", "Extra DD action var allocation", "4.3.1", 20, "", "Number of extra DD action variables preallocated for use in model transformation."}, {"ch", "prism.exportAdv", "Adversary export", "3.3", "None", "None,DTMC,MDP", "Type of adversary to generate and export during MDP model checking"}, {"s", "prism.exportAdvFilename", "Adversary export filename", "3.3", "adv.tra", "", "Name of file for MDP adversary export (if enabled)"}, {"s", "prism.ltl2daTool", "Use external LTL->DA tool", "4.2.1", "", null, "If non-empty, the path to the executable for the external LTL->DA tool."}, {"ch", "prism.ltl2daSyntax", "LTL syntax for external LTL->DA tool", "4.2.1", "LBT", "LBT,Spin,Spot,Rabinizer", "The syntax for LTL formulas passed to the external LTL->DA tool."}, {"b", "prism.ddsanity", "Do BDD sanity checks", "4.3.1", false, "", "Perform internal sanity checks during computations (can cause significant slow-down)."}, {"b", "prism.param.enabled", "Do parametric model checking", "4.1", false, "", "Perform parametric model checking."}, {"s", "prism.param.precision", "Parametric model checking precision", "4.1", "5/100", "", "Maximal volume of area to remain undecided in each step when performing parametric model checking."}, {"ch", "prism.param.split", "Parametric model checking split method", "4.1", "Longest", "Longest,All", "Strategy to use when splitting a region during parametric model checking. Either split on longest side, or split on all sides."}, {"ch", "prism.param.bisim", "Parametric model checking bisimulation method", "4.1", "Weak", "Weak,Strong,None", "Type of bisimulation used to reduce model size during paramteric model checking. For reward-based properties, weak bisimulation cannot be used."}, {"ch", "prism.param.function", "Parametric model checking function representation", "4.1", "JAS-cached", "JAS-cached,JAS,DAG", "Type of representation for functions used during parametric model checking."}, {"ch", "prism.param.elimOrder", "Parametric model checking state elimination order", "4.1", "Backward", "Arbitrary,Forward,Forward-reversed,Backward,Backward-reversed,Random", "Order in which states are eliminated during unbounded parametric model checking analysis."}, {"i", "prism.param.randomPoints", "Parametric model checking random evaluations", "4.1", 5, "", "Number of random points to evaluate per region to increase chance of correctness during parametric model checking."}, {"b", "prism.param.subsumeRegions", "Parametric model checking region subsumption", "4.1", true, "", "Subsume adjacent regions during parametric model checking."}, {"d", "prism.param.functionDagMaxError", "Parametric model checking max. DAG error", "4.1", 1.0E-100, "", "Maximal error probability (i.e. maximum probability of of a wrong result) in DAG function representation used for parametric model checking."}, {"d", "prism.fau.epsilon", "FAU epsilon", "4.1", 1.0E-6, "", "For fast adaptive uniformisation (FAU), decides how much probability may be lost due to truncation of birth process."}, {"d", "prism.fau.delta", "FAU cut off delta", "4.1", 1.0E-12, "", "For fast adaptive uniformisation (FAU), states whose probability is below this value will be removed."}, {"i", "prism.fau.arraythreshold", "FAU array threshold", "4.1", 100, "", "For fast adaptive uniformisation (FAU), after this number of iterations without changes to the state space, storage is switched to a faster, fixed-size data structure."}, {"i", "prism.fau.intervals", "FAU time intervals", "4.1", 1, "", "For fast adaptive uniformisation (FAU), the time period is split into this number of of intervals."}, {"d", "prism.fau.initival", "FAU initial time interval", "4.1", 1.0, "", "For fast adaptive uniformisation (FAU), the length of initial time interval to analyse."}}, {{"i", "simulator.defaultNumSamples", "Default number of samples", "4.0", 1000, "1,", "Default number of samples when using approximate (simulation-based) model checking (CI/ACI/APMC methods)."}, {"d", "simulator.defaultConfidence", "Default confidence parameter", "4.0", 0.01, "0,1", "Default value for the 'confidence' parameter when using approximate (simulation-based) model checking (CI/ACI/APMC/SPRT methods). For CI/ACI, this means that the corresponding 'confidence level' is 100 x (1 - confidence)%; for APMC, this is the probability of the 'approximation' being exceeded; for SPRT, this is the acceptable probability for type I/II errors."}, {"d", "simulator.defaultWidth", "Default width of confidence interval", "4.0", 0.05, "0,", "Default (half-)width of the confidence interval when using approximate (simulation-based) model checking (CI/ACI/SPRT methods). For SPRT, this refers to the 'indifference' parameter."}, {"d", "simulator.defaultApprox", "Default approximation parameter", "4.0", 0.05, "0,", "Default value for the 'approximation' parameter when using approximate (simulation-based) model checking (APMC method)."}, {"l", "simulator.defaultMaxPath", "Default maximum path length", "2.1", 10000L, "1,", "Default maximum path length when using approximate (simulation-based) model checking."}, {"b", "simulator.decide", "Decide S^2=0 or not automatically", "4.0", true, "", "Let PRISM choose whether, after a certain number of iterations, the standard error is null or not."}, {"i", "simulator.iterationsToDecide", "Number of iterations to decide", "4.0", 10000, "1,", "Number of iterations to decide whether the standard error is null or not."}, {"d", "simulator.maxReward", "Maximum reward", "4.0", 1000.0, "1,", "Maximum reward for CI/ACI methods. It helps these methods in displaying the progress in case of rewards computation."}, {"b", "simulator.simultaneous", "Check properties simultaneously", "2.1", true, "", "Check multiple properties simultaneously over the same set of execution paths (simulator only)."}, {"ch", "simulator.fieldChoice", "Values used in dialog", "2.1", "Last used values", "Last used values,Always use defaults", "How to choose values for the simulation dialog: remember previously used values or revert to the defaults each time."}, {"b", "simulator.newPathAskView", "Ask for view configuration", "2.1", false, "", "Display dialog with display options when creating a new simulation path."}, {"ch", "simulator.renderAllValues", "Path render style", "3.2", "Render all values", "Render changes,Render all values", "Display style for paths in the simulator user interface: only show variable values when they change, or show all values regardless."}, {"fi", "simulator.networkFile", "Network profile", "2.1", new File(""), "", "File specifying the network profile used by the distributed PRISM simulator."}}, {{"b", "model.autoParse", "Auto parse", "2.1", true, "", "Parse PRISM models automatically as they are loaded/edited in the text editor."}, {"b", "model.autoManual", "Manual parse for large models", "2.1", true, "", "Disable automatic model parsing when loading large PRISM models."}, {"i", "model.parseDelay", "Parse delay (ms)", "2.1", 1000, "0,", "Time delay (after typing has finished) before an automatic re-parse of the model is performed."}, {"fct", "model.prismEditor.font", "PRISM editor font", "2.1", new FontColorPair(new Font("monospaced", 0, 12), Color.black), "", "Font used in the PRISM model text editor."}, {"b", "model.prismEditor.lineNumbers", "PRISM editor line numbers", "3.2", true, "", "Enable or disable line numbers in the PRISM model text editor"}, {"c", "model.prismEditor.bgColour", "PRISM editor background", "2.1", new Color(255, 255, 255), "", "Background colour for the PRISM model text editor."}, {"c", "model.prismEditor.numericColour", "PRISM editor numeric colour", "2.1", new Color(0, 0, 255), "", "Syntax highlighting colour for numerical values in the PRISM model text editor."}, {"ch", "model.prismEditor.numericStyle", "PRISM editor numeric style", "2.1", "Plain", "Plain,Italic,Bold,Bold Italic", "Syntax highlighting style for numerical values in the PRISM model text editor."}, {"c", "model.prismEditor.identifierColour", "PRISM editor identifier colour", "2.1", new Color(255, 0, 0), "", "Syntax highlighting colour for identifiers values in the PRISM model text editor"}, {"ch", "model.prismEditor.identifierStyle", "PRISM editor identifier style", "2.1", "Plain", "Plain,Italic,Bold,Bold Italic", "Syntax highlighting style for identifiers in the PRISM model text editor."}, {"c", "model.prismEditor.keywordColour", "PRISM editor keyword colour", "2.1", new Color(0, 0, 0), "", "Syntax highlighting colour for keywords in the PRISM model text editor"}, {"ch", "model.prismEditor.keywordStyle", "PRISM editor keyword style", "2.1", "Bold", "Plain,Italic,Bold,Bold Italic", "Syntax highlighting style for keywords in the PRISM model text editor."}, {"c", "model.prismEditor.commentColour", "PRISM editor comment colour", "2.1", new Color(0, 99, 0), "", "Syntax highlighting colour for comments in the PRISM model text editor."}, {"ch", "model.prismEditor.commentStyle", "PRISM editor comment style", "2.1", "Italic", "Plain,Italic,Bold,Bold Italic", "Syntax highlighting style for comments in the PRISM model text editor."}, {"fct", "model.pepaEditor.font", "PEPA editor font", "2.1", new FontColorPair(new Font("monospaced", 0, 12), Color.black), "", "Font used in the PEPA model text editor."}, {"c", "model.pepaEditor.bgColour", "PEPA editor background", "2.1", new Color(255, 250, 240), "", "Background colour for the PEPA model text editor."}, {"c", "model.pepaEditor.commentColour", "PEPA editor comment colour", "2.1", new Color(0, 99, 0), "", "Syntax highlighting colour for comments in the PEPA model text editor."}, {"ch", "model.pepaEditor.commentStyle", "PEPA editor comment style", "2.1", "Italic", "Plain,Italic,Bold,Bold Italic", "Syntax highlighting style for comments in the PEPA model text editor."}}, {{"fct", "properties.font", "Display font", "2.1", new FontColorPair(new Font("monospaced", 0, 12), Color.black), "", "Font used for the properties list."}, {"c", "properties.warningColour", "Warning colour", "2.1", new Color(255, 130, 130), "", "Colour used to indicate that a property is invalid."}, {"ch", "properties.additionStategy", "Property addition strategy", "2.1", "Warn when invalid", "Warn when invalid,Do not allow invalid", "How to deal with properties that are invalid."}, {"b", "properties.clearListOnLoad", "Clear list when load model", "2.1", true, "", "Clear the properties list whenever a new model is loaded."}}, {{"fct", "log.font", "Display font", "2.1", new FontColorPair(new Font("monospaced", 0, 12), Color.black), "", "Font used for the log display."}, {"c", "log.bgColour", "Background colour", "2.1", new Color(255, 255, 255), "", "Background colour for the log display."}, {"i", "log.bufferLength", "Buffer length", "2.1", 10000, "1,", "Length of the buffer for the log display."}}};
    public static final String[] oldPropertyNames = new String[]{"simulator.apmcStrategy", "simulator.engine", "simulator.newPathAskDefault"};
    public DefaultSettingOwner[] optionOwners = new DefaultSettingOwner[propertyOwnerIDs.length];
    private Hashtable<String, Setting> data;
    private boolean modified;
    private ArrayList<PrismSettingsListener> settingsListeners;
    protected boolean exportPropAut = false;
    protected String exportPropAutType = "txt";
    protected String exportPropAutFilename = "da.txt";

    public PrismSettings() {
        int n = 0;
        for (int i = 0; i < propertyOwnerIDs.length; ++i) {
            this.optionOwners[i] = new DefaultSettingOwner(propertyOwnerNames[i], propertyOwnerIDs[i]);
            for (int j = 0; j < propertyData[i].length; ++j) {
                Setting setting;
                ++n;
                Object[] objectArray = propertyData[i][j];
                String string = (String)objectArray[1];
                String string2 = (String)objectArray[2];
                String string3 = (String)objectArray[3];
                Object object = objectArray[4];
                String string4 = (String)objectArray[5];
                String string5 = (String)objectArray[6];
                if (objectArray[0].equals(STRING_TYPE)) {
                    setting = new SingleLineStringSetting(string2, (String)object, string5, (SettingOwner)this.optionOwners[i], false);
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(INTEGER_TYPE)) {
                    setting = string4.equals(DEFAULT_STRING) ? new IntegerSetting(string2, (Integer)object, string5, (SettingOwner)this.optionOwners[i], false) : new IntegerSetting(string2, (Integer)object, string5, (SettingOwner)this.optionOwners[i], false, new RangeConstraint(string4));
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(DOUBLE_TYPE)) {
                    setting = string4.equals(DEFAULT_STRING) ? new DoubleSetting(string2, (Double)object, string5, (SettingOwner)this.optionOwners[i], false) : new DoubleSetting(string2, (Double)object, string5, (SettingOwner)this.optionOwners[i], false, new RangeConstraint(string4));
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(BOOLEAN_TYPE)) {
                    setting = new BooleanSetting(string2, (Boolean)object, string5, (SettingOwner)this.optionOwners[i], false);
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(LONG_TYPE)) {
                    setting = string4.equals(DEFAULT_STRING) ? new LongSetting(string2, (Long)object, string5, (SettingOwner)this.optionOwners[i], false) : new LongSetting(string2, (Long)object, string5, (SettingOwner)this.optionOwners[i], false, new RangeConstraint(string4));
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(COLOUR_TYPE)) {
                    setting = new ColorSetting(string2, (Color)object, string5, (SettingOwner)this.optionOwners[i], false);
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(CHOICE_TYPE)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        stringArray[n2++] = stringTokenizer.nextToken();
                    }
                    setting = new ChoiceSetting(string2, stringArray, (String)object, string5, this.optionOwners[i], false);
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(FONT_COLOUR_TYPE)) {
                    setting = new FontColorSetting(string2, (FontColorPair)object, string5, (SettingOwner)this.optionOwners[i], false);
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                if (objectArray[0].equals(FILE_TYPE)) {
                    setting = new FileSetting(string2, (File)object, string5, (SettingOwner)this.optionOwners[i], false);
                    setting.setKey(string);
                    setting.setVersion(string3);
                    this.optionOwners[i].addSetting(setting);
                    continue;
                }
                System.err.println("Fatal error when loading properties: unknown setting type " + String.valueOf(objectArray[0]));
            }
            this.optionOwners[i].addObserver(this);
        }
        this.modified = false;
        this.populateHashTable(n);
        this.settingsListeners = new ArrayList();
    }

    public PrismSettings(PrismSettings prismSettings) {
        this();
        for (Map.Entry<String, Setting> entry : prismSettings.data.entrySet()) {
            try {
                this.set(entry.getKey(), entry.getValue().getValue());
            }
            catch (PrismException prismException) {
                System.err.println(prismException);
            }
        }
    }

    private void populateHashTable(int n) {
        this.data = new Hashtable(n);
        for (int i = 0; i < this.optionOwners.length; ++i) {
            for (int j = 0; j < this.optionOwners[i].getNumSettings(); ++j) {
                this.data.put(this.optionOwners[i].getSetting(j).getKey(), this.optionOwners[i].getSetting(j));
            }
        }
    }

    private Setting settingFromHash(String string) {
        return this.data.get(string);
    }

    public void addSettingsListener(PrismSettingsListener prismSettingsListener) {
        this.settingsListeners.add(prismSettingsListener);
    }

    public void removeSettingsListener(PrismSettingsListener prismSettingsListener) {
        this.settingsListeners.remove(prismSettingsListener);
    }

    public void notifySettingsListeners() {
        for (int i = 0; i < this.settingsListeners.size(); ++i) {
            PrismSettingsListener prismSettingsListener = this.settingsListeners.get(i);
            prismSettingsListener.notifySettings(this);
        }
    }

    public File getLocationForSettingsFile() {
        File file;
        String string = Prism.getToolName().toLowerCase();
        File file2 = new File(System.getProperty("user.home") + File.separator + "." + string);
        if (file2.exists() && !file2.isDirectory()) {
            return file2;
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("win") >= 0) {
            file = new File(System.getProperty("user.home") + File.separator + "." + string);
        } else if (string2.indexOf("mac") >= 0) {
            file = new File(System.getProperty("user.home") + "/Library/Preferences/" + string + ".settings");
        } else if (string2.indexOf("nix") >= 0 || string2.indexOf("nux") >= 0 || string2.indexOf("aix") >= 0 || string2.indexOf("sunos") >= 0 || string2.indexOf("bsd") >= 0) {
            Object object = System.getenv("XDG_CONFIG_HOME");
            if (object == null) {
                object = System.getProperty("user.home") + "/.config";
            }
            if (((String)object).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            file = new File((String)object + "/" + string + ".settings");
        } else {
            file = new File(System.getProperty("user.home") + File.separator + "." + string);
        }
        return file;
    }

    public synchronized void saveSettingsFile() throws PrismException {
        this.saveSettingsFile(this.getLocationForSettingsFile());
    }

    public synchronized void saveSettingsFile(File file) throws PrismException {
        File file2 = null;
        try {
            file2 = file.getAbsoluteFile().getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
        }
        catch (Exception exception) {
            if (file2 != null) {
                throw new PrismException("Error creating required directories (" + String.valueOf(file2) + ") for file " + String.valueOf(file) + ": " + exception.getMessage());
            }
            throw new PrismException("Error creating required directories for file " + String.valueOf(file) + ": " + exception.getMessage());
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("# " + Prism.getToolName() + " settings file\n");
            fileWriter.write("# (created by version " + Prism.getVersion() + ")\n");
            for (int i = 0; i < this.optionOwners.length; ++i) {
                fileWriter.write("\n");
                for (int j = 0; j < this.optionOwners[i].getNumSettings(); ++j) {
                    Setting setting = this.optionOwners[i].getSetting(j);
                    fileWriter.write(setting.getKey() + "=");
                    String string = setting.toString();
                    while (string.indexOf(10) != -1) {
                        fileWriter.write(string.substring(0, string.indexOf(10)) + "\\");
                        if (string.substring(string.indexOf(10)).length() > 0) {
                            string = string.substring(string.indexOf(10) + 1);
                            continue;
                        }
                        string = DEFAULT_STRING;
                    }
                    fileWriter.write(string + "\n");
                }
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new PrismException("Error exporting properties file: " + iOException.getMessage());
        }
        this.modified = false;
    }

    public synchronized void loadSettingsFile() throws PrismException {
        this.loadSettingsFile(this.getLocationForSettingsFile());
    }

    public synchronized void loadSettingsFile(File file) throws PrismException {
        String string = null;
        String string2 = DEFAULT_STRING;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        try {
            Matcher matcher;
            String string3 = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            if (bufferedReader.ready()) {
                string = bufferedReader.readLine();
            }
            if (bufferedReader.ready()) {
                string = bufferedReader.readLine();
            }
            if ((matcher = Pattern.compile("# \\(created by version (.+)\\)").matcher(string)).find()) {
                string3 = matcher.group(1);
            }
            bufferedReader.close();
            if (string3 == null) {
                string3 = "0";
            }
            if (PrismUtils.compareVersions(string3, Prism.getVersion()) == -1) {
                bl2 = true;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            while (bufferedReader.ready()) {
                Object object;
                Setting setting;
                string = bufferedReader.readLine();
                if (!bl) {
                    String string4;
                    int n;
                    if (string.startsWith("#") || (n = string.indexOf(61)) == -1) continue;
                    string2 = string.substring(0, n);
                    String string5 = string4 = n == string.length() - 1 ? DEFAULT_STRING : string.substring(n + 1);
                    if (string4.endsWith("\\")) {
                        bl = true;
                        stringBuffer = new StringBuffer(string4.substring(0, string4.length() - 1));
                        continue;
                    }
                    setting = this.settingFromHash(string2);
                    if (setting == null || bl2 && PrismUtils.compareVersions(string3, setting.getVersion()) <= 0) continue;
                    try {
                        object = setting.parseStringValue(string4);
                        setting.setValue(object);
                    }
                    catch (SettingException settingException) {
                        System.err.println("Warning: PRISM setting \"" + string2 + "\" has invalid value \"" + string4 + "\"");
                    }
                    continue;
                }
                if (string.endsWith("\\")) {
                    stringBuffer.append(string.substring(0, string.length() - 1));
                    continue;
                }
                setting = this.settingFromHash(string2);
                if (setting != null) {
                    if (bl2 && PrismUtils.compareVersions(string3, setting.getVersion()) <= 0) continue;
                    try {
                        object = setting.parseStringValue(stringBuffer.toString() + string);
                        setting.setValue(object);
                    }
                    catch (SettingException settingException) {
                        System.err.println("Warning: PRISM setting \"" + string2 + "\" has invalid value \"" + stringBuffer.toString() + string + "\"");
                    }
                } else {
                    System.err.println("Warning: PRISM setting \"" + string2 + "\" is unknown.");
                }
                bl = false;
                stringBuffer = null;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("Error importing properties file: " + iOException.getMessage());
        }
        this.modified = false;
        if (bl2) {
            try {
                this.saveSettingsFile(file);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        this.notifySettingsListeners();
    }

    public synchronized void loadDefaults() {
        for (int i = 0; i < propertyOwnerIDs.length; ++i) {
            for (int j = 0; j < propertyData[i].length; ++j) {
                Setting setting = this.settingFromHash(propertyData[i][j][1].toString());
                if (setting == null) continue;
                try {
                    setting.setValue(propertyData[i][j][4]);
                    continue;
                }
                catch (SettingException settingException) {
                    System.err.println("Warning: Error with default value for PRISM setting \"" + setting.getName() + "\"");
                }
            }
        }
        this.notifySettingsListeners();
    }

    public void setExportPropAut(boolean bl) throws PrismException {
        this.exportPropAut = bl;
    }

    public void setExportPropAutType(String string) throws PrismException {
        this.exportPropAutType = string;
    }

    public void setExportPropAutFilename(String string) throws PrismException {
        this.exportPropAutFilename = string;
    }

    public boolean getExportPropAut() {
        return this.exportPropAut;
    }

    public String getExportPropAutType() {
        return this.exportPropAutType;
    }

    public String getExportPropAutFilename() {
        return this.exportPropAutFilename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int setFromCommandLineSwitch(String[] stringArray, int n) throws PrismException {
        Pair<String, String> pair = PrismSettings.splitSwitch(stringArray[n]);
        String string = (String)pair.first;
        String string2 = (String)pair.second;
        Map<String, String> map = PrismSettings.splitOptionsString(string2);
        if (string.equals("mtbdd") || string.equals("m")) {
            this.set(PRISM_ENGINE, "MTBDD");
            return n + 1;
        }
        if (string.equals("sparse") || string.equals(STRING_TYPE)) {
            this.set(PRISM_ENGINE, "Sparse");
            return n + 1;
        }
        if (string.equals("hybrid") || string.equals("h")) {
            this.set(PRISM_ENGINE, "Hybrid");
            return n + 1;
        }
        if (string.equals("explicit") || string.equals("ex")) {
            this.set(PRISM_ENGINE, "Explicit");
            return n + 1;
        }
        if (string.equals("exact")) {
            this.set(PRISM_EXACT_ENABLED, true);
            return n + 1;
        }
        if (string.equals("ptamethod")) {
            String string3;
            if (n >= stringArray.length - 1) throw new PrismException("No parameter specified for -" + string + " switch");
            if ((string3 = stringArray[++n]).equals("digital")) {
                this.set(PRISM_PTA_METHOD, "Digital clocks");
                return n + 1;
            } else if (string3.equals("games")) {
                this.set(PRISM_PTA_METHOD, "Stochastic games");
                return n + 1;
            } else {
                if (!string3.equals("backwards") && !string3.equals("bw")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: digital, games, backwards)");
                this.set(PRISM_PTA_METHOD, "Backwards reachability");
            }
            return n + 1;
        }
        if (string.equals("transientmethod")) {
            String string4;
            if (n >= stringArray.length - 1) throw new PrismException("No parameter specified for -" + string + " switch");
            if ((string4 = stringArray[++n]).equals("unif")) {
                this.set(PRISM_TRANSIENT_METHOD, "Uniformisation");
                return n + 1;
            } else {
                if (!string4.equals("fau")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: unif, fau)");
                this.set(PRISM_TRANSIENT_METHOD, "Fast adaptive uniformisation");
            }
            return n + 1;
        }
        if (string.equals("heuristic")) {
            String string5;
            if (n >= stringArray.length - 1) throw new PrismException("No parameter specified for -" + string + " switch");
            if ((string5 = stringArray[++n]).equals("none")) {
                this.set(PRISM_HEURISTIC, "None");
                return n + 1;
            } else if (string5.equals("speed")) {
                this.set(PRISM_HEURISTIC, "Speed");
                return n + 1;
            } else {
                if (!string5.equals("memory")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: none, speed, memory)");
                this.set(PRISM_HEURISTIC, "Memory");
            }
            return n + 1;
        }
        if (string.equals("power") || string.equals("pow") || string.equals("pwr")) {
            this.set(PRISM_LIN_EQ_METHOD, "Power");
            return n + 1;
        }
        if (string.equals("jacobi") || string.equals("jac")) {
            this.set(PRISM_LIN_EQ_METHOD, "Jacobi");
            return n + 1;
        }
        if (string.equals("gaussseidel") || string.equals("gs")) {
            this.set(PRISM_LIN_EQ_METHOD, "Gauss-Seidel");
            this.set(PRISM_MDP_SOLN_METHOD, "Gauss-Seidel");
            this.set(PRISM_MDP_MULTI_SOLN_METHOD, "Gauss-Seidel");
            this.set(PRISM_IMDP_SOLN_METHOD, "Gauss-Seidel");
            return n + 1;
        }
        if (string.equals("bgaussseidel") || string.equals("bgs")) {
            this.set(PRISM_LIN_EQ_METHOD, "Backwards Gauss-Seidel");
            return n + 1;
        }
        if (string.equals("pgaussseidel") || string.equals("pgs")) {
            this.set(PRISM_LIN_EQ_METHOD, "Pseudo-Gauss-Seidel");
            return n + 1;
        }
        if (string.equals("bpgaussseidel") || string.equals("bpgs")) {
            this.set(PRISM_LIN_EQ_METHOD, "Backwards Pseudo-Gauss-Seidel");
            return n + 1;
        }
        if (string.equals("jor")) {
            this.set(PRISM_LIN_EQ_METHOD, "JOR");
            return n + 1;
        }
        if (string.equals("sor")) {
            this.set(PRISM_LIN_EQ_METHOD, "SOR");
            return n + 1;
        }
        if (string.equals("bsor")) {
            this.set(PRISM_LIN_EQ_METHOD, "Backwards SOR");
            return n + 1;
        }
        if (string.equals("psor")) {
            this.set(PRISM_LIN_EQ_METHOD, "Pseudo-SOR");
            return n + 1;
        }
        if (string.equals("bpsor")) {
            this.set(PRISM_LIN_EQ_METHOD, "Backwards Pseudo-SOR");
            return n + 1;
        }
        if (string.equals("valiter")) {
            this.set(PRISM_MDP_SOLN_METHOD, "Value iteration");
            this.set(PRISM_MDP_MULTI_SOLN_METHOD, "Value iteration");
            this.set(PRISM_IMDP_SOLN_METHOD, "Value iteration");
            return n + 1;
        }
        if (string.equals("politer")) {
            this.set(PRISM_MDP_SOLN_METHOD, "Policy iteration");
            return n + 1;
        }
        if (string.equals("modpoliter")) {
            this.set(PRISM_MDP_SOLN_METHOD, "Modified policy iteration");
            return n + 1;
        }
        if (string.equals("linprog") || string.equals("lp")) {
            this.set(PRISM_MDP_SOLN_METHOD, "Linear programming");
            this.set(PRISM_MDP_MULTI_SOLN_METHOD, "Linear programming");
            return n + 1;
        }
        if (string.equals("intervaliter") || string.equals("ii")) {
            this.set(PRISM_INTERVAL_ITER, true);
            if (string2 == null) return n + 1;
            string2 = string2.trim();
            try {
                OptionsIntervalIteration.validate(string2);
            }
            catch (PrismException prismException) {
                throw new PrismException("In options for -" + string + " switch: " + prismException.getMessage());
            }
            Object object = this.getString(PRISM_INTERVAL_ITER_OPTIONS);
            object = DEFAULT_STRING.equals(object) ? string2 : (String)object + "," + string2;
            this.set(PRISM_INTERVAL_ITER_OPTIONS, object);
            return n + 1;
        }
        if (string.equals("pmaxquotient")) {
            this.set(PRISM_PMAX_QUOTIENT, true);
            return n + 1;
        } else if (string.equals("topological")) {
            this.set(PRISM_TOPOLOGICAL_VI, true);
            return n + 1;
        } else if (string.equals("omega")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                this.set(PRISM_LIN_EQ_METHOD_PARAM, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("relative") || string.equals("rel")) {
            this.set(PRISM_TERM_CRIT, "Relative");
            return n + 1;
        } else if (string.equals("absolute") || string.equals("abs")) {
            this.set(PRISM_TERM_CRIT, "Absolute");
            return n + 1;
        } else if (string.equals("epsilon") || string.equals("e")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_TERM_CRIT_PARAM, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("maxiters")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n2 = Integer.parseInt(stringArray[++n]);
                if (n2 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_MAX_ITERS, n2);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("exportiterations")) {
            this.set(PRISM_EXPORT_ITERATIONS, true);
            return n + 1;
        } else if (string.equals("gridresolution")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n3 = Integer.parseInt(stringArray[++n]);
                if (n3 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_GRID_RESOLUTION, n3);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("exportmodelprecision")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n4 = Integer.parseInt(stringArray[++n]);
                if (!RANGE_EXPORT_DOUBLE_PRECISION.contains(n4)) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_EXPORT_MODEL_PRECISION, n4);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("noexportheaders")) {
            this.set(PRISM_EXPORT_MODEL_HEADERS, false);
            return n + 1;
        } else if (string.equals("nopre")) {
            this.set(PRISM_PRECOMPUTATION, false);
            return n + 1;
        } else if (string.equals("noprob0")) {
            this.set(PRISM_PROB0, false);
            return n + 1;
        } else if (string.equals("noprob1")) {
            this.set(PRISM_PROB1, false);
            return n + 1;
        } else if (string.equals("noprerel")) {
            this.set(PRISM_PRE_REL, false);
            return n + 1;
        } else if (string.equals("fixdl")) {
            this.set(PRISM_FIX_DEADLOCKS, true);
            return n + 1;
        } else if (string.equals("nofixdl")) {
            this.set(PRISM_FIX_DEADLOCKS, false);
            return n + 1;
        } else if (string.equals("fair")) {
            this.set(PRISM_FAIRNESS, true);
            return n + 1;
        } else if (string.equals("nofair")) {
            this.set(PRISM_FAIRNESS, false);
            return n + 1;
        } else if (string.equals("noprobchecks")) {
            this.set(PRISM_DO_PROB_CHECKS, false);
            return n + 1;
        } else if (string.equals("sumroundoff")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_SUM_ROUND_OFF, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("nossdetect")) {
            this.set(PRISM_DO_SS_DETECTION, false);
            return n + 1;
        } else if (string.equals("sccmethod") || string.equals("bsccmethod")) {
            String string6;
            if (n >= stringArray.length - 1) throw new PrismException("No parameter specified for -" + string + " switch");
            if ((string6 = stringArray[++n]).equals("xiebeerel")) {
                this.set(PRISM_SCC_METHOD, "Xie-Beerel");
                return n + 1;
            } else if (string6.equals("lockstep")) {
                this.set(PRISM_SCC_METHOD, "Lockstep");
                return n + 1;
            } else {
                if (!string6.equals("sccfind")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: xiebeerel, lockstep, sccfind)");
                this.set(PRISM_SCC_METHOD, "SCC-Find");
            }
            return n + 1;
        } else if (string.equals("symm")) {
            if (n >= stringArray.length - 2) throw new PrismException("-symm switch requires two parameters (num. modules before/after symmetric ones)");
            this.set(PRISM_SYMM_RED_PARAMS, stringArray[++n] + " " + stringArray[++n]);
            return n + 1;
        } else if (string.equals("aroptions")) {
            if (n >= stringArray.length - 1) throw new PrismException("No parameter specified for -" + string + " switch");
            Object object = this.getString(PRISM_AR_OPTIONS);
            object = DEFAULT_STRING.equals(object) ? stringArray[++n].trim() : (String)object + "," + stringArray[++n].trim();
            this.set(PRISM_AR_OPTIONS, object);
            return n + 1;
        } else if (string.equals("pathviaautomata")) {
            this.set(PRISM_PATH_VIA_AUTOMATA, true);
            return n + 1;
        } else if (string.equals("nodasimplify")) {
            this.set(PRISM_NO_DA_SIMPLIFY, true);
            return n + 1;
        } else if (string.equals("multimaxpoints")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n5 = Integer.parseInt(stringArray[++n]);
                if (n5 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_MULTI_MAX_POINTS, n5);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("paretoepsilon")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new PrismException("Value for -" + string + " switch must be non-negative");
                }
                this.set(PRISM_PARETO_EPSILON, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("exportpareto")) {
            if (n >= stringArray.length - 1) throw new PrismException("No file specified for -" + string + " switch");
            this.set(PRISM_EXPORT_PARETO_FILENAME, stringArray[++n]);
            return n + 1;
        } else if (string.equals("verbose") || string.equals("v")) {
            this.set(PRISM_VERBOSE, true);
            return n + 1;
        } else if (string.equals("extraddinfo")) {
            this.set(PRISM_EXTRA_DD_INFO, true);
            return n + 1;
        } else if (string.equals("extrareachinfo")) {
            this.set(PRISM_EXTRA_REACH_INFO, true);
            return n + 1;
        } else if (string.equals("nocompact")) {
            this.set(PRISM_COMPACT, false);
            return n + 1;
        } else if (string.equals("sbl")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n6 = Integer.parseInt(stringArray[++n]);
                if (n6 < -1) {
                    throw new NumberFormatException();
                }
                this.set(PRISM_NUM_SB_LEVELS, n6);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("sbmax")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n7 = Integer.parseInt(stringArray[++n]);
                if (n7 < 0) {
                    throw new NumberFormatException();
                }
                this.set(PRISM_SB_MAX_MEM, n7);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("sorl") || string.equals("gsl")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n8 = Integer.parseInt(stringArray[++n]);
                if (n8 < -1) {
                    throw new NumberFormatException();
                }
                this.set(PRISM_NUM_SOR_LEVELS, n8);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("sormax") || string.equals("gsmax")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n9 = Integer.parseInt(stringArray[++n]);
                if (n9 < 0) {
                    throw new NumberFormatException();
                }
                this.set(PRISM_SOR_MAX_MEM, n9);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("cuddmaxmem")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            this.set(PRISM_CUDD_MAX_MEM, stringArray[++n]);
            return n + 1;
        } else if (string.equals("cuddepsilon")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_CUDD_EPSILON, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("ddextrastatevars")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n10 = Integer.parseInt(stringArray[++n]);
                if (n10 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_DD_EXTRA_STATE_VARS, n10);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("ddextraactionvars")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n11 = Integer.parseInt(stringArray[++n]);
                if (n11 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_DD_EXTRA_ACTION_VARS, n11);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("exportadv")) {
            if (n >= stringArray.length - 1) throw new PrismException("No file specified for -" + string + " switch");
            this.set(PRISM_EXPORT_ADV, "DTMC");
            this.set(PRISM_EXPORT_ADV_FILENAME, stringArray[++n]);
            return n + 1;
        } else if (string.equals("exportadvmdp")) {
            if (n >= stringArray.length - 1) throw new PrismException("No file specified for -" + string + " switch");
            this.set(PRISM_EXPORT_ADV, "MDP");
            this.set(PRISM_EXPORT_ADV_FILENAME, stringArray[++n]);
            return n + 1;
        } else if (string.equals("ltl2datool")) {
            if (n >= stringArray.length - 1) throw new PrismException("The -" + string + " switch requires one argument (path to the executable)");
            String string7 = stringArray[++n];
            this.set(PRISM_LTL2DA_TOOL, string7);
            return n + 1;
        } else if (string.equals("ltl2dasyntax")) {
            String string8;
            if (n >= stringArray.length - 1) throw new PrismException("The -" + string + " switch requires one argument (options are: lbt, spin, spot, rabinizer)");
            switch (string8 = stringArray[++n]) {
                case "lbt": {
                    this.set(PRISM_LTL2DA_SYNTAX, "LBT");
                    return n + 1;
                }
                case "spin": {
                    this.set(PRISM_LTL2DA_SYNTAX, "Spin");
                    return n + 1;
                }
                case "spot": {
                    this.set(PRISM_LTL2DA_SYNTAX, "Spot");
                    return n + 1;
                }
                case "rabinizer": {
                    this.set(PRISM_LTL2DA_SYNTAX, "Rabinizer");
                    return n + 1;
                }
                default: {
                    throw new PrismException("Unrecognised option for -" + string + " switch (options are: lbt, spin, spot, rabinizer)");
                }
            }
        } else if (string.equals("ddsanity")) {
            this.set(PRISM_JDD_SANITY_CHECKS, true);
            return n + 1;
        } else if (string.equals("param")) {
            this.set(PRISM_PARAM_ENABLED, true);
            return n + 1;
        } else if (string.equals("paramprecision")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            this.set(PRISM_PARAM_PRECISION, stringArray[++n]);
            return n + 1;
        } else if (string.equals("paramsplit")) {
            String string9;
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            if ((string9 = stringArray[++n]).equals("longest")) {
                this.set(PRISM_PARAM_SPLIT, "Longest");
                return n + 1;
            } else {
                if (!string9.equals("all")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: longest, all)");
                this.set(PRISM_PARAM_SPLIT, "All");
            }
            return n + 1;
        } else if (string.equals("parambisim")) {
            String string10;
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            if ((string10 = stringArray[++n]).equals("strong")) {
                this.set(PRISM_PARAM_BISIM, "Strong");
                return n + 1;
            } else if (string10.equals("weak")) {
                this.set(PRISM_PARAM_BISIM, "Weak");
                return n + 1;
            } else {
                if (!string10.equals("none")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: strong, weak, none)");
                this.set(PRISM_PARAM_BISIM, "None");
            }
            return n + 1;
        } else if (string.equals("paramfunction")) {
            String string11;
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            if ((string11 = stringArray[++n]).equals("jascached")) {
                this.set(PRISM_PARAM_FUNCTION, "JAS-cached");
                return n + 1;
            } else if (string11.equals("jas")) {
                this.set(PRISM_PARAM_FUNCTION, "JAS");
                return n + 1;
            } else {
                if (!string11.equals("dag")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: jascached, jas, dag)");
                this.set(PRISM_PARAM_FUNCTION, "DAG");
            }
            return n + 1;
        } else if (string.equals("paramelimorder")) {
            String string12;
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            if ((string12 = stringArray[++n]).equals("arb")) {
                this.set(PRISM_PARAM_ELIM_ORDER, "Arbitrary");
                return n + 1;
            } else if (string12.equals("fw")) {
                this.set(PRISM_PARAM_ELIM_ORDER, "Forward");
                return n + 1;
            } else if (string12.equals("fwrev")) {
                this.set(PRISM_PARAM_ELIM_ORDER, "Forward-reversed");
                return n + 1;
            } else if (string12.equals("bw")) {
                this.set(PRISM_PARAM_ELIM_ORDER, "Backward");
                return n + 1;
            } else if (string12.equals("bwrev")) {
                this.set(PRISM_PARAM_ELIM_ORDER, "Backward-reversed");
                return n + 1;
            } else {
                if (!string12.equals("rand")) throw new PrismException("Unrecognised option for -" + string + " switch (options are: arb,fw,fwrev,bw,bwrev,rand)");
                this.set(PRISM_PARAM_ELIM_ORDER, "Random");
            }
            return n + 1;
        } else if (string.equals("paramrandompoints")) {
            try {
                int n12 = Integer.parseInt(stringArray[++n]);
                if (n12 < 0) {
                    throw new NumberFormatException();
                }
                this.set(PRISM_PARAM_RANDOM_POINTS, n12);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("paramsubsumeregions")) {
            boolean bl = Boolean.parseBoolean(stringArray[++n]);
            this.set(PRISM_PARAM_SUBSUME_REGIONS, bl);
            return n + 1;
        } else if (string.equals("paramdagmaxerror")) {
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException();
                }
                this.set(PRISM_PARAM_DAG_MAX_ERROR, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("fauepsilon")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_FAU_EPSILON, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("faudelta")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_FAU_DELTA, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("fauarraythreshold")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n13 = Integer.parseInt(stringArray[++n]);
                if (n13 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_FAU_ARRAYTHRESHOLD, n13);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("fauintervals")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                int n14 = Integer.parseInt(stringArray[++n]);
                if (n14 < 0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_FAU_INTERVALS, n14);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else if (string.equals("fauinitival")) {
            if (n >= stringArray.length - 1) throw new PrismException("No value specified for -" + string + " switch");
            try {
                double d = Double.parseDouble(stringArray[++n]);
                if (d < 0.0) {
                    throw new NumberFormatException(DEFAULT_STRING);
                }
                this.set(PRISM_FAU_INITIVAL, d);
                return n + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid value for -" + string + " switch");
            }
        } else {
            if (!string.equals("exportpropaut")) throw new PrismException("Invalid switch -" + string + " (type \"prism -help\" for full list)");
            if (n >= stringArray.length - 1) throw new PrismException("No file specified for -" + string + " switch");
            this.setExportPropAut(true);
            this.setExportPropAutFilename(stringArray[++n]);
            this.setExportPropAutType("txt");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().equals("txt")) {
                    this.setExportPropAutType("txt");
                    continue;
                }
                if (entry.getKey().equals("dot")) {
                    this.setExportPropAutType("dot");
                    continue;
                }
                if (!entry.getKey().equals("hoa")) throw new PrismException("Unknown option \"" + entry.getKey() + "\" for -" + string + " switch");
                this.setExportPropAutType("hoa");
            }
        }
        return n + 1;
    }

    private static Pair<String, String> splitSwitch(String string) {
        if ((string = string.substring(1)).charAt(0) == '-') {
            string = string.substring(1);
        }
        int n = string.indexOf(58);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        return new Pair<String, Object>(string, string2);
    }

    private static Map<String, String> splitOptionsString(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null || DEFAULT_STRING.equals(string)) {
            return hashMap;
        }
        for (String string2 : stringArray = string.split(",")) {
            int n = string2.indexOf("=");
            if (n == -1) {
                hashMap.put(string2, null);
                continue;
            }
            hashMap.put(string2.substring(0, n), string2.substring(n + 1));
        }
        return hashMap;
    }

    public static void printHelp(PrismLog prismLog) {
        prismLog.println();
        prismLog.println("EXPORT OPTIONS:");
        prismLog.println("-exportmodelprecision <n>....... Export probabilities/rewards with n significant decimal places");
        prismLog.println("-noexportheaders ............... Don't include headers when exporting rewards");
        prismLog.println();
        prismLog.println("ENGINES/METHODS:");
        prismLog.println("-mtbdd (or -m) ................. Use the MTBDD engine");
        prismLog.println("-sparse (or -s) ................ Use the Sparse engine");
        prismLog.println("-hybrid (or -h) ................ Use the Hybrid engine [default]");
        prismLog.println("-explicit (or -ex) ............. Use the explicit engine");
        prismLog.println("-exact ......................... Perform exact (arbitrary precision) model checking");
        prismLog.println("-ptamethod <name> .............. Specify PTA engine (games, digital, backwards) [default: games]");
        prismLog.println("-transientmethod <name> ........ CTMC transient analysis method (unif, fau) [default: unif]");
        prismLog.println("-heuristic <mode> .............. Automatic choice of engines/settings (none, speed, memory) [default: none]");
        prismLog.println();
        prismLog.println("SOLUTION METHODS (LINEAR EQUATIONS):");
        prismLog.println("-power (or -pow, -pwr) ......... Use the Power method for numerical computation");
        prismLog.println("-jacobi (or -jac) .............. Use Jacobi for numerical computation [default]");
        prismLog.println("-gaussseidel (or -gs) .......... Use Gauss-Seidel for numerical computation");
        prismLog.println("-bgaussseidel (or -bgs) ........ Use Backwards Gauss-Seidel for numerical computation");
        prismLog.println("-pgaussseidel (or -pgs) ........ Use Pseudo Gauss-Seidel for numerical computation");
        prismLog.println("-bpgaussseidel (or -bpgs) ...... Use Backwards Pseudo Gauss-Seidel for numerical computation");
        prismLog.println("-jor ........................... Use JOR for numerical computation");
        prismLog.println("-sor ........................... Use SOR for numerical computation");
        prismLog.println("-bsor .......................... Use Backwards SOR for numerical computation");
        prismLog.println("-psor .......................... Use Pseudo SOR for numerical computation");
        prismLog.println("-bpsor ......................... Use Backwards Pseudo SOR for numerical computation");
        prismLog.println("-omega <x> ..................... Set over-relaxation parameter (for JOR/SOR/...) [default: 0.9]");
        prismLog.println();
        prismLog.println("SOLUTION METHODS (MDPS):");
        prismLog.println("-valiter ....................... Use value iteration for solving MDPs [default]");
        prismLog.println("-gaussseidel (or -gs) .......... Use Gauss-Seidel value iteration for solving MDPs");
        prismLog.println("-politer ....................... Use policy iteration for solving MDPs");
        prismLog.println("-modpoliter .................... Use modified policy iteration for solving MDPs");
        prismLog.println("-intervaliter (or -ii) ......... Use interval iteration to solve MDPs/MCs (see -help -ii)");
        prismLog.println("-topological ................... Use topological value iteration");
        prismLog.println();
        prismLog.println("SOLUTION METHOD SETTINGS");
        prismLog.println("-relative (or -rel) ............ Use relative error for detecting convergence [default]");
        prismLog.println("-absolute (or -abs) ............ Use absolute error for detecting convergence");
        prismLog.println("-epsilon <x> (or -e <x>) ....... Set value of epsilon (for convergence check) [default: 1e-6]");
        prismLog.println("-maxiters <n> .................. Set max number of iterations [default: 10000]");
        prismLog.println("-gridresolution <n> .............Set resolution for fixed grid approximation (POMDP) [default: 10]");
        prismLog.println();
        prismLog.println("MODEL CHECKING OPTIONS:");
        prismLog.println("-nopre ......................... Skip precomputation algorithms (where optional)");
        prismLog.println("-noprob0 ....................... Skip precomputation algorithm Prob0 (where optional)");
        prismLog.println("-noprob1 ....................... Skip precomputation algorithm Prob1 (where optional)");
        prismLog.println("-noprerel ...................... Do not pre-compute/use predecessor relation, e.g. for precomputation");
        prismLog.println("-fair .......................... Use fairness (for model checking of MDPs)");
        prismLog.println("-nofair ........................ Don't use fairness (for model checking of MDPs) [default]");
        prismLog.println("-fixdl ......................... Automatically put self-loops in deadlock states [default]");
        prismLog.println("-nofixdl ....................... Do not automatically put self-loops in deadlock states");
        prismLog.println("-noprobchecks .................. Disable checks on model probabilities/rates");
        prismLog.println("-sumroundoff <x> ............... Set probability sum threshold [default: 1-e5]");
        prismLog.println("-zerorewardcheck ............... Check for absence of zero-reward loops");
        prismLog.println("-nossdetect .................... Disable steady-state detection for CTMC transient computations");
        prismLog.println("-sccmethod <name> .............. Specify (symbolic) SCC computation method (xiebeerel, lockstep, sccfind)");
        prismLog.println("-symm <string> ................. Symmetry reduction options string");
        prismLog.println("-aroptions <string> ............ Abstraction-refinement engine options string");
        prismLog.println("-pathviaautomata ............... Handle all path formulas via automata constructions");
        prismLog.println("-nodasimplify .................. Do not attempt to simplify deterministic automata, acceptance conditions");
        prismLog.println("-exportadv <file> .............. Export an adversary from MDP model checking (as a DTMC)");
        prismLog.println("-exportadvmdp <file> ........... Export an adversary from MDP model checking (as an MDP)");
        prismLog.println("-ltl2datool <exec> ............. Run executable <exec> to convert LTL formulas to deterministic automata");
        prismLog.println("-ltl2dasyntax <x> .............. Specify output format for -ltl2datool switch (lbt, spin, spot, rabinizer)");
        prismLog.println("-exportiterations .............. Export vectors for iteration algorithms to file");
        prismLog.println("-pmaxquotient .................. For Pmax computations in MDPs, compute in the MEC quotient");
        prismLog.println();
        prismLog.println("MULTI-OBJECTIVE MODEL CHECKING:");
        prismLog.println("-linprog (or -lp) .............. Use linear programming for multi-objective model checking");
        prismLog.println("-multimaxpoints <n> ............ Maximal number of corner points for (valiter-based) multi-objective");
        prismLog.println("-paretoepsilon <x> ............. Threshold for Pareto curve approximation");
        prismLog.println("-exportpareto <file> ........... When computing Pareto curves, export points to a file");
        prismLog.println();
        prismLog.println("OUTPUT OPTIONS:");
        prismLog.println("-verbose (or -v) ............... Verbose mode: print out state lists and probability vectors");
        prismLog.println("-extraddinfo ................... Display extra info about some (MT)BDDs");
        prismLog.println("-extrareachinfo ................ Display extra info about progress of reachability");
        prismLog.println();
        prismLog.println("SPARSE/HYBRID/MTBDD OPTIONS:");
        prismLog.println("-nocompact ..................... Switch off \"compact\" sparse storage schemes");
        prismLog.println("-sbl <n> ....................... Set number of levels (for hybrid engine) [default: -1]");
        prismLog.println("-sbmax <n> ..................... Set memory limit (KB) (for hybrid engine) [default: 1024]");
        prismLog.println("-gsl <n> (or sorl <n>) ......... Set number of levels for hybrid GS/SOR [default: -1]");
        prismLog.println("-gsmax <n> (or sormax <n>) ..... Set memory limit (KB) for hybrid GS/SOR [default: 1024]");
        prismLog.println("-cuddmaxmem <n> ................ Set max memory for CUDD package, e.g. 125k, 50m, 4g [default: 1g]");
        prismLog.println("-cuddepsilon <x> ............... Set epsilon value for CUDD package [default: 1e-15]");
        prismLog.println("-ddsanity ...................... Enable internal sanity checks (causes slow-down)");
        prismLog.println("-ddextrastatevars <n> .......... Set the number of preallocated state vars [default: 20]");
        prismLog.println("-ddextraactionvars <n> ......... Set the number of preallocated action vars [default: 20]");
        prismLog.println();
        prismLog.println("PARAMETRIC MODEL CHECKING OPTIONS:");
        prismLog.println("-param <vals> .................. Do parametric model checking with parameters (and ranges) <vals>");
        prismLog.println("-paramprecision <x> ............ Set max undecided region for parameter synthesis [default: 5/100]");
        prismLog.println("-paramsplit <name> ............. Set method to split parameter regions (longest,all) [default: longest]");
        prismLog.println("-parambisim <name> ............. Set bisimulation minimisation for parameter synthesis (weak,strong,none) [default: weak]");
        prismLog.println("-paramfunction <name> .......... Set function representation for parameter synthesis (jascached,jas) [default: jascached]");
        prismLog.println("-paramelimorder <name> ......... Set elimination order for parameter synthesis (arb,fw,fwrev,bw,bwrev,rand) [default: bw]");
        prismLog.println("-paramrandompoints <n> ......... Set number of random points to evaluate per region [default: 5]");
        prismLog.println("-paramsubsumeregions <b> ....... Subsume adjacent regions during analysis [default: true]");
        prismLog.println("-paramdagmaxerror <b> .......... Maximal error probability allowed for DAG function representation [default: 1E-100]");
        prismLog.println();
        prismLog.println("FAST ADAPTIVE UNIFORMISATION (FAU) OPTIONS:");
        prismLog.println("-fauepsilon <x> ................ Set probability threshold of birth process in FAU [default: 1e-6]");
        prismLog.println("-faudelta <x> .................. Set probability threshold for irrelevant states in FAU [default: 1e-12]");
        prismLog.println("-fauarraythreshold <x> ......... Set threshold when to switch to sparse matrix in FAU [default: 100]");
        prismLog.println("-fauintervals <x> .............. Set number of intervals to divide time intervals into for FAU [default: 1]");
        prismLog.println("-fauinitival <x> ............... Set length of additional initial time interval for FAU [default: 1.0]");
    }

    public static boolean printHelpSwitch(PrismLog prismLog, String string) {
        if (string.equals("aroptions")) {
            prismLog.println("Switch: -aroptions <string>\n");
            prismLog.println("<string> is a comma-separated list of options regarding abstraction-refinement:");
            QuantAbstractRefine.printOptions(prismLog);
            return true;
        }
        if (string.equals("ii") || string.equals("intervaliter")) {
            prismLog.println("Switch: -intervaliter (or -ii) optionally takes a comma-separated list of options:\n");
            prismLog.println(" -intervaliter:option1,option2,...\n");
            prismLog.println("where the options are one of the following:\n");
            prismLog.println(OptionsIntervalIteration.getOptionsDescription());
            return true;
        }
        return false;
    }

    public synchronized void set(String string, Object object) throws PrismException {
        Setting setting = this.settingFromHash(string);
        if (setting == null) {
            throw new PrismException("Property " + string + " is not valid");
        }
        try {
            String string2 = setting.toString();
            if (object instanceof String) {
                setting.setValue(setting.parseStringValue((String)object));
            } else if (object instanceof Integer && setting instanceof ChoiceSetting) {
                int n = (Integer)object;
                ((ChoiceSetting)setting).setSelectedIndex(n);
            } else {
                setting.setValue(object);
            }
            this.notifySettingsListeners();
            if (!setting.toString().equals(string2)) {
                this.modified = true;
            }
        }
        catch (SettingException settingException) {
            throw new PrismException(settingException.getMessage());
        }
    }

    public synchronized void setChoice(String string, int n) throws PrismException {
        this.set(string, n - 1);
    }

    public synchronized void setFileSelector(String string, FileSelector fileSelector) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof FileSetting) {
            FileSetting fileSetting = (FileSetting)setting;
            fileSetting.setFileSelector(fileSelector);
        }
    }

    public synchronized String getString(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof SingleLineStringSetting) {
            return ((SingleLineStringSetting)setting).getStringValue();
        }
        if (setting instanceof MultipleLineStringSetting) {
            return ((MultipleLineStringSetting)setting).getStringValue();
        }
        if (setting instanceof ChoiceSetting) {
            return ((ChoiceSetting)setting).getStringValue();
        }
        return DEFAULT_STRING;
    }

    public synchronized int getInteger(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof IntegerSetting) {
            return ((IntegerSetting)setting).getIntegerValue();
        }
        if (setting instanceof ChoiceSetting) {
            return ((ChoiceSetting)setting).getCurrentIndex();
        }
        return 0;
    }

    public synchronized double getDouble(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof DoubleSetting) {
            return ((DoubleSetting)setting).getDoubleValue();
        }
        return 0.0;
    }

    public synchronized boolean getBoolean(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof BooleanSetting) {
            return ((BooleanSetting)setting).getBooleanValue();
        }
        return false;
    }

    public synchronized long getLong(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof LongSetting) {
            return ((LongSetting)setting).getLongValue();
        }
        return 0L;
    }

    public synchronized int getChoice(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof ChoiceSetting) {
            return ((ChoiceSetting)setting).getCurrentIndex() + 1;
        }
        return 0;
    }

    public synchronized Color getColor(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof ColorSetting) {
            return ((ColorSetting)setting).getColorValue();
        }
        return DEFAULT_COLOUR;
    }

    public synchronized FontColorPair getFontColorPair(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof FontColorSetting) {
            return ((FontColorSetting)setting).getFontColorValue();
        }
        return DEFAULT_FONT_COLOUR;
    }

    public synchronized File getFile(String string) {
        Setting setting = this.settingFromHash(string);
        if (setting instanceof FileSetting) {
            return ((FileSetting)setting).getFileValue();
        }
        return DEFAULT_FILE;
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.modified = true;
        this.notifySettingsListeners();
    }

    public static void main(String[] stringArray) {
        PrismSettings prismSettings = new PrismSettings();
        JFrame jFrame = new JFrame("Prism Settings");
        jFrame.setDefaultCloseOperation(3);
        ArrayList<DefaultSettingOwner> arrayList = new ArrayList<DefaultSettingOwner>();
        for (int i = 0; i < prismSettings.optionOwners.length; ++i) {
            arrayList.add(prismSettings.optionOwners[i]);
        }
        SettingTable settingTable = new SettingTable(jFrame);
        settingTable.setOwners(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            SettingOwner settingOwner = (SettingOwner)arrayList.get(i);
            settingOwner.setDisplay(settingTable);
        }
        jFrame.getContentPane().add(settingTable);
        jFrame.getContentPane().setSize(100, 300);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

