/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.iterable.Range;
import dv.DoubleVector;
import explicit.CTMC;
import explicit.CTMCModelChecker;
import explicit.ConstructModel;
import explicit.DTMC;
import explicit.DTMCModelChecker;
import explicit.ExplicitFiles2Model;
import explicit.ExplicitFiles2Rewards;
import explicit.FastAdaptiveUniformisation;
import explicit.FastAdaptiveUniformisationModelChecker;
import explicit.ModelModelGenerator;
import explicit.SCCComputer;
import explicit.SCCConsumer;
import explicit.SCCConsumerStore;
import explicit.StateModelChecker;
import hybrid.PrismHybrid;
import io.ExplicitModelImporter;
import io.ModelExportFormat;
import io.ModelExportOptions;
import io.ModelExportTask;
import io.PrismExplicitImporter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import mtbdd.PrismMTBDD;
import odd.ODDUtils;
import param.Function;
import param.ParamMode;
import param.ParamModelChecker;
import parser.PrismParser;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ForLoop;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import prism.Evaluator;
import prism.Model;
import prism.ModelGenerator;
import prism.ModelInfo;
import prism.ModelType;
import prism.OptionsIntervalIteration;
import prism.PEPA2Prism;
import prism.Preprocessor;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLanguageTranslator;
import prism.PrismLog;
import prism.PrismModelListener;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import prism.PrismUtils;
import prism.Result;
import prism.ResultsCollection;
import prism.RewardGenerator;
import prism.RewardInfo;
import prism.SBML2Prism;
import prism.StateVector;
import prism.UndefinedConstants;
import prism.Version;
import pta.DigitalClocks;
import pta.PTAModelChecker;
import simulator.GenerateSimulationPath;
import simulator.ModulesFileModelGenerator;
import simulator.SimulatorEngine;
import simulator.method.SimulationMethod;
import sparse.PrismSparse;
import strat.Strategy;
import strat.StrategyExportOptions;
import strat.StrategyGenerator;
import symbolic.build.ExplicitFiles2MTBDD;
import symbolic.build.ExplicitModel2MTBDD;
import symbolic.build.MTBDD2ExplicitModel;
import symbolic.build.ModelGenerator2MTBDD;
import symbolic.build.Modules2MTBDD;
import symbolic.comp.ECComputer;
import symbolic.comp.ProbModelChecker;
import symbolic.comp.StochModelChecker;
import symbolic.model.NondetModel;
import symbolic.states.StateList;
import symbolic.states.StateListMTBDD;
import symbolic.states.StateValues;

public class Prism
extends PrismComponent
implements PrismSettingsListener {
    private static String version = Version.versionString;
    private static String versionSuffix = Version.versionSuffixString;
    public static final int MTBDD = 1;
    public static final int SPARSE = 2;
    public static final int HYBRID = 3;
    public static final int EXPLICIT = 4;
    private static String[] engineStrings = new String[]{"?", "MTBDD", "Sparse", "Hybrid", "Explicit"};
    public static final int POWER = 1;
    public static final int JACOBI = 2;
    public static final int GAUSSSEIDEL = 3;
    public static final int BGAUSSSEIDEL = 4;
    public static final int PGAUSSSEIDEL = 5;
    public static final int BPGAUSSSEIDEL = 6;
    public static final int JOR = 7;
    public static final int SOR = 8;
    public static final int BSOR = 9;
    public static final int PSOR = 10;
    public static final int BPSOR = 11;
    public static final int MDP_VALITER = 1;
    public static final int MDP_GAUSSSEIDEL = 2;
    public static final int MDP_POLITER = 3;
    public static final int MDP_MODPOLITER = 4;
    public static final int MDP_LP = 5;
    public static final int MDP_MULTI_VALITER = 1;
    public static final int MDP_MULTI_GAUSSSEIDEL = 2;
    public static final int MDP_MULTI_LP = 3;
    public static final int ABSOLUTE = 1;
    public static final int RELATIVE = 2;
    public static final int EXPORT_PLAIN = 1;
    public static final int EXPORT_MATLAB = 2;
    public static final int EXPORT_DOT = 3;
    public static final int EXPORT_ROWS = 5;
    public static final int EXPORT_DOT_STATES = 6;
    public static final int EXPORT_ADV_NONE = 1;
    public static final int EXPORT_ADV_DTMC = 2;
    public static final int EXPORT_ADV_MDP = 3;
    public static final int XIEBEEREL = 1;
    public static final int LOCKSTEP = 2;
    public static final int SCCFIND = 3;
    protected static final int MTBDD_STATES_THRESHOLD = 100000000;
    protected boolean exportDigital = false;
    protected File exportDigitalFile = null;
    protected boolean exportTarget = false;
    protected String exportTargetFilename = null;
    protected boolean exportProductTrans = false;
    protected String exportProductTransFilename = null;
    protected boolean exportProductStates = false;
    protected String exportProductStatesFilename = null;
    protected boolean exportProductVector = false;
    protected String exportProductVectorFilename = null;
    protected boolean storeVector = false;
    protected boolean genStrat = false;
    protected boolean restrictStratToReach = true;
    protected boolean doBisim = false;
    private boolean doReach = true;
    private boolean bsccComp = true;
    private boolean checkZeroLoops = false;
    private int construction = 3;
    private int ordering = 1;
    private int reachMethod = REACH_BFS;
    private static PrismParser thePrismParser = null;
    private static boolean prismParserInUse = false;
    private SimulatorEngine theSimulator = null;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private List<PrismModelListener> modelListeners;
    private ModelDetails currentModelDetails = new ModelDetails();
    private Strategy<?> strategy = null;
    private ExplicitModelImporter modelImporter;
    private boolean param = false;
    private String[] paramNames;
    private String[] paramLowerBounds;
    private String[] paramUpperBounds;
    private boolean cuddStarted = false;
    private int engineOld = -1;
    private boolean engineSwitched = false;
    public static int REACH_BFS = 1;
    public static int REACH_FRONTIER = 2;

    public Prism(PrismLog prismLog) {
        this.mainLog = prismLog;
        this.settings = new PrismSettings();
        this.settings.addSettingsListener(this);
        this.modelListeners = new ArrayList<PrismModelListener>();
    }

    public void loadUserSettingsFile() {
        this.loadUserSettingsFile(null);
    }

    public void loadUserSettingsFile(File file) {
        try {
            if (file == null) {
                this.settings.loadSettingsFile();
            } else {
                this.settings.loadSettingsFile(file);
            }
        }
        catch (PrismException prismException) {
            try {
                if (file == null) {
                    this.settings.saveSettingsFile();
                } else {
                    this.settings.saveSettingsFile(file);
                }
            }
            catch (PrismException prismException2) {
                this.mainLog.printWarning("Failed to create new PRISM settings file.");
            }
        }
    }

    public void setMainLog(PrismLog prismLog) {
        this.mainLog = prismLog;
        JDD.SetOutputStream(this.mainLog.getFilePointer());
        PrismMTBDD.setMainLog(this.mainLog);
        PrismSparse.setMainLog(this.mainLog);
        PrismHybrid.setMainLog(this.mainLog);
    }

    public void setEngine(int n) throws PrismException {
        this.settings.setChoice("prism.engine", n);
    }

    public void setVerbose(boolean bl) throws PrismException {
        this.settings.set("prism.verbose", bl);
    }

    public void setFairness(boolean bl) throws PrismException {
        this.settings.set("prism.fairness", bl);
    }

    public void setPrecomp(boolean bl) throws PrismException {
        this.settings.set("prism.precomputation", bl);
    }

    public void setProb0(boolean bl) throws PrismException {
        this.settings.set("prism.prob0", bl);
    }

    public void setProb1(boolean bl) throws PrismException {
        this.settings.set("prism.prob1", bl);
    }

    public void setFixDeadlocks(boolean bl) throws PrismException {
        this.settings.set("prism.fixDeadlocks", bl);
    }

    public void setDoProbChecks(boolean bl) throws PrismException {
        this.settings.set("prism.doProbChecks", bl);
    }

    public void setSumRoundOff(double d) throws PrismException {
        this.settings.set("prism.sumRoundOff", d);
    }

    public void setCompact(boolean bl) throws PrismException {
        this.settings.set("prism.compact", bl);
    }

    public void setLinEqMethod(int n) throws PrismException {
        this.settings.setChoice("prism.linEqMethod", n);
    }

    public void setLinEqMethodParam(double d) throws PrismException {
        this.settings.set("prism.linEqMethodParam", d);
    }

    public void setMDPSolnMethod(int n) throws PrismException {
        this.settings.setChoice("prism.mdpSolnMethod", n);
    }

    public void setMDPMultiSolnMethod(int n) throws PrismException {
        this.settings.setChoice("prism.mdpMultiSolnMethod", n);
    }

    public void setTermCrit(int n) throws PrismException {
        this.settings.setChoice("prism.termCrit", n);
    }

    public void setTermCritParam(double d) throws PrismException {
        this.settings.set("prism.termCritParam", d);
    }

    public void setMaxIters(int n) throws PrismException {
        this.settings.set("prism.maxIters", n);
    }

    public void setGridResolution(int n) throws PrismException {
        this.settings.set("prism.gridResolution", n);
    }

    public void setCUDDMaxMem(String string) throws PrismException {
        this.settings.set("prism.cuddMaxMem", string);
    }

    public void setCUDDEpsilon(double d) throws PrismException {
        this.settings.set("prism.cuddEpsilon", d);
    }

    public void setNumSBLevels(int n) throws PrismException {
        this.settings.set("prism.numSBLevels", n);
    }

    public void setSBMaxMem(int n) throws PrismException {
        this.settings.set("prism.SBMaxMem", n);
    }

    public void setNumSORLevels(int n) throws PrismException {
        this.settings.set("prism.numSORLevels", n);
    }

    public void setSORMaxMem(int n) throws PrismException {
        this.settings.set("prism.SORMaxMem", n);
    }

    public void setDoSSDetect(boolean bl) throws PrismException {
        this.settings.set("prism.doSSDetect", bl);
    }

    public void setExtraDDInfo(boolean bl) throws PrismException {
        this.settings.set("prism.extraDDInfo", bl);
    }

    public void setExtraReachInfo(boolean bl) throws PrismException {
        this.settings.set("prism.extraReachInfo", bl);
    }

    public void setSCCMethod(int n) throws PrismException {
        this.settings.setChoice("prism.sccMethod", n);
    }

    public void setExportAdv(int n) throws PrismException {
        this.settings.setChoice("prism.exportAdv", n);
    }

    public void setExportAdvFilename(String string) throws PrismException {
        this.settings.set("prism.exportAdvFilename", string);
    }

    public void setParametric(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.param = true;
        this.paramNames = stringArray;
        this.paramLowerBounds = stringArray2;
        this.paramUpperBounds = stringArray3;
    }

    public void setParametricOff() {
        this.param = false;
    }

    public void setExportDigital(boolean bl) throws PrismException {
        this.exportDigital = bl;
    }

    public void setExportDigitalFile(File file) throws PrismException {
        this.exportDigitalFile = file;
    }

    public void setExportTarget(boolean bl) throws PrismException {
        this.exportTarget = bl;
    }

    public void setExportTargetFilename(String string) throws PrismException {
        this.exportTargetFilename = string;
    }

    public void setExportProductTrans(boolean bl) throws PrismException {
        this.exportProductTrans = bl;
    }

    public void setExportProductTransFilename(String string) throws PrismException {
        this.exportProductTransFilename = string;
    }

    public void setExportProductStates(boolean bl) throws PrismException {
        this.exportProductStates = bl;
    }

    public void setExportProductStatesFilename(String string) throws PrismException {
        this.exportProductStatesFilename = string;
    }

    public void setExportProductVector(boolean bl) throws PrismException {
        this.exportProductVector = bl;
    }

    public void setExportProductVectorFilename(String string) throws PrismException {
        this.exportProductVectorFilename = string;
    }

    public void setStoreVector(boolean bl) {
        this.storeVector = bl;
    }

    public void setGenStrat(boolean bl) {
        this.genStrat = bl;
    }

    public void setRestrictStratToReach(boolean bl) {
        this.restrictStratToReach = bl;
    }

    public void setDoBisim(boolean bl) {
        this.doBisim = bl;
    }

    public void setDoReach(boolean bl) throws PrismException {
        this.doReach = bl;
    }

    public void setBSCCComp(boolean bl) throws PrismException {
        this.bsccComp = bl;
    }

    public void setCheckZeroLoops(boolean bl) {
        this.checkZeroLoops = bl;
    }

    public void setConstruction(int n) throws PrismException {
        this.construction = n;
    }

    public void setOrdering(int n) throws PrismException {
        this.ordering = n;
    }

    public void setReachMethod(int n) {
        this.reachMethod = n;
    }

    public static String getToolName() {
        return "PRISM";
    }

    public static String getCommandLineName() {
        return "prism";
    }

    public static String getVersion() {
        Object object = version;
        if (versionSuffix.length() > 0) {
            object = (String)object + "." + versionSuffix;
        }
        return object;
    }

    public PrismLog getMainLog() {
        return this.mainLog;
    }

    @Override
    public PrismSettings getSettings() {
        return this.settings;
    }

    public int getEngine() {
        return this.settings.getChoice("prism.engine");
    }

    public boolean getExplicit() {
        return this.getEngine() == 4;
    }

    public boolean getFixDeadlocks() {
        return this.settings.getBoolean("prism.fixDeadlocks");
    }

    public boolean getDoProbChecks() {
        return this.settings.getBoolean("prism.doProbChecks");
    }

    public double getSumRoundOff() {
        return this.settings.getDouble("prism.sumRoundOff");
    }

    public int getLinEqMethod() {
        return this.settings.getChoice("prism.linEqMethod");
    }

    public double getLinEqMethodParam() {
        return this.settings.getDouble("prism.linEqMethodParam");
    }

    public int getMDPSolnMethod() {
        return this.settings.getChoice("prism.mdpSolnMethod");
    }

    public int getMDPMultiSolnMethod() {
        return this.settings.getChoice("prism.mdpMultiSolnMethod");
    }

    public int getTermCrit() {
        return this.settings.getChoice("prism.termCrit");
    }

    public double getTermCritParam() {
        return this.settings.getDouble("prism.termCritParam");
    }

    public int getMaxIters() {
        return this.settings.getInteger("prism.maxIters");
    }

    public int getGridResolution() {
        return this.settings.getInteger("prism.gridResolution");
    }

    public boolean getVerbose() {
        return this.settings.getBoolean("prism.verbose");
    }

    public boolean getPrecomp() {
        return this.settings.getBoolean("prism.precomputation");
    }

    public boolean getProb0() {
        return this.settings.getBoolean("prism.prob0");
    }

    public boolean getProb1() {
        return this.settings.getBoolean("prism.prob1");
    }

    public boolean getPreRel() {
        return this.settings.getBoolean("prism.preRel");
    }

    public boolean getFairness() {
        return this.settings.getBoolean("prism.fairness");
    }

    public int getSBMaxMem() {
        return this.settings.getInteger("prism.SBMaxMem");
    }

    public int getNumSBLevels() {
        return this.settings.getInteger("prism.numSBLevels");
    }

    public int getSORMaxMem() {
        return this.settings.getInteger("prism.SORMaxMem");
    }

    public boolean getDoSSDetect() {
        return this.settings.getBoolean("prism.doSSDetect");
    }

    public boolean getExtraDDInfo() {
        return this.settings.getBoolean("prism.extraDDInfo");
    }

    public boolean getExtraReachInfo() {
        return this.settings.getBoolean("prism.extraReachInfo");
    }

    public int getNumSORLevels() {
        return this.settings.getInteger("prism.numSORLevels");
    }

    public boolean getCompact() {
        return this.settings.getBoolean("prism.compact");
    }

    public String getCUDDMaxMem() {
        return this.settings.getString("prism.cuddMaxMem");
    }

    public double getCUDDEpsilon() {
        return this.settings.getDouble("prism.cuddEpsilon");
    }

    public int getSCCMethod() {
        return this.settings.getChoice("prism.sccMethod");
    }

    public int getExportAdv() {
        return this.settings.getChoice("prism.exportAdv");
    }

    public String getExportAdvFilename() {
        return this.settings.getString("prism.exportAdvFilename");
    }

    public boolean getExportTarget() {
        return this.exportTarget;
    }

    public String getExportTargetFilename() {
        return this.exportTargetFilename;
    }

    public boolean getExportProductTrans() {
        return this.exportProductTrans;
    }

    public String getExportProductTransFilename() {
        return this.exportProductTransFilename;
    }

    public boolean getExportProductStates() {
        return this.exportProductStates;
    }

    public String getExportProductStatesFilename() {
        return this.exportProductStatesFilename;
    }

    public boolean getExportProductVector() {
        return this.exportProductVector;
    }

    public String getExportProductVectorFilename() {
        return this.exportProductVectorFilename;
    }

    public boolean getStoreVector() {
        return this.storeVector;
    }

    public boolean getGenStrat() {
        return this.genStrat;
    }

    public boolean getRestrictStratToReach() {
        return this.restrictStratToReach;
    }

    public boolean getDoBisim() {
        return this.doBisim;
    }

    public boolean getDoReach() {
        return this.doReach;
    }

    public boolean getBSCCComp() {
        return this.bsccComp;
    }

    public boolean getCheckZeroLoops() {
        return this.checkZeroLoops;
    }

    public int getConstruction() {
        return this.construction;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public int getReachMethod() {
        return this.reachMethod;
    }

    public int getIntervalIterationFlags() throws PrismException {
        int n = 0;
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this.settings);
        if (optionsIntervalIteration.isEnforceMonotonicityFromBelow()) {
            ++n;
        }
        if (optionsIntervalIteration.isEnforceMonotonicityFromAbove()) {
            n += 2;
        }
        if (optionsIntervalIteration.isSelectMidpointForResult()) {
            n += 4;
        }
        return n;
    }

    public void addModelListener(PrismModelListener prismModelListener) {
        this.modelListeners.add(prismModelListener);
    }

    public static String getEngineString(int n) {
        return engineStrings[n];
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
        if (this.cuddStarted) {
            JDD.SetCUDDEpsilon(prismSettings.getDouble("prism.cuddEpsilon"));
            try {
                long l = PrismUtils.convertMemoryStringtoKB(this.getCUDDMaxMem());
                JDD.SetCUDDMaxMem(l);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        SanityJDD.enabled = prismSettings.getBoolean("prism.ddsanity");
        PrismSparse.SetExportIterations(prismSettings.getBoolean("prism.exportIterations"));
        PrismHybrid.SetExportIterations(prismSettings.getBoolean("prism.exportIterations"));
        PrismMTBDD.SetExportIterations(prismSettings.getBoolean("prism.exportIterations"));
    }

    public static PrismParser getPrismParser() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Class<Prism> clazz = Prism.class;
        synchronized (Prism.class) {
            try {
                while (prismParserInUse) {
                    Prism.class.wait();
                }
                prismParserInUse = true;
                if (thePrismParser == null) {
                    thePrismParser = new PrismParser();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return thePrismParser;
            }
            catch (InterruptedException interruptedException) {
                Prism.class.notify();
                throw interruptedException;
            }
        }
    }

    public static synchronized void releasePrismParser() {
        prismParserInUse = false;
        Prism.class.notify();
    }

    public SimulatorEngine getSimulator() {
        if (this.theSimulator == null) {
            this.theSimulator = new SimulatorEngine(this);
        }
        return this.theSimulator;
    }

    public symbolic.comp.SCCComputer getSCCComputer(symbolic.model.Model model) throws PrismException {
        return symbolic.comp.SCCComputer.createSCCComputer(this, model);
    }

    public symbolic.comp.SCCComputer getSCCComputer(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2) throws PrismException {
        return symbolic.comp.SCCComputer.createSCCComputer(this, jDDNode, jDDNode2, jDDVars, jDDVars2);
    }

    public SCCComputer getExplicitSCCComputer(explicit.Model<?> model, SCCConsumer sCCConsumer) throws PrismException {
        return SCCComputer.createSCCComputer(this, model, sCCConsumer);
    }

    public ECComputer getECComputer(NondetModel nondetModel) throws PrismException {
        return ECComputer.createECComputer(this, nondetModel);
    }

    public ECComputer getECComputer(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3) throws PrismException {
        return ECComputer.createECComputer(this, jDDNode, jDDNode2, jDDNode3, jDDVars, jDDVars2, jDDVars3);
    }

    public explicit.ECComputer getExplicitECComputer(explicit.NondetModel<?> nondetModel) throws PrismException {
        return explicit.ECComputer.createECComputer(this, nondetModel);
    }

    public static List<String> getListOfKeywords() {
        return PrismParser.getListOfKeywords();
    }

    public void initialise() throws PrismException {
        boolean bl = this.getSettings().getBoolean("PRISM_VERBOSE");
        this.mainLog.setVerbosityLevel(bl ? 2 : 0);
        this.mainLog.print(Prism.getToolName() + "\n");
        this.mainLog.print(new String(new char[Prism.getToolName().length()]).replace("\u0000", "=") + "\n");
        this.mainLog.print("\nVersion: " + Prism.getVersion() + "\n");
        this.mainLog.print("Date: " + String.valueOf(new Date()) + "\n");
        try {
            String string = InetAddress.getLocalHost().getHostName();
            this.mainLog.print("Hostname: " + string + "\n");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.mainLog.print("Memory limits: cudd=" + this.getCUDDMaxMem());
        this.mainLog.println(", java(heap)=" + PrismUtils.convertBytesToMemoryString(Runtime.getRuntime().maxMemory()));
        long l = PrismUtils.convertMemoryStringtoKB(this.getCUDDMaxMem());
        JDD.InitialiseCUDD(l, this.getCUDDEpsilon());
        this.cuddStarted = true;
        JDD.SetOutputStream(this.mainLog.getFilePointer());
        PrismNative.initialise(this);
        PrismMTBDD.initialise(this.mainLog, this.mainLog);
        PrismSparse.initialise(this.mainLog, this.mainLog);
        PrismHybrid.initialise(this.mainLog, this.mainLog);
        DoubleVector.setCUDDManager();
        ODDUtils.setCUDDManager();
    }

    public void setSimulatorSeed(int n) throws PrismException {
        this.getSimulator().setRandomNumberGeneratorSeed(n);
    }

    public ModulesFile parseModelFile(File file) throws FileNotFoundException, PrismLangException {
        return this.parseModelFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesFile parseModelFile(File file, ModelType modelType) throws FileNotFoundException, PrismLangException {
        ModulesFile modulesFile = null;
        this.mainLog.print("\nParsing PRISM model file \"" + String.valueOf(file) + "\"...\n");
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                modulesFile = prismParser.parseModulesFile(fileInputStream, modelType);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        modulesFile.tidyUp();
        return modulesFile;
    }

    public ModulesFile parseModelString(String string) throws PrismLangException {
        return this.parseModelString(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesFile parseModelString(String string, ModelType modelType) throws PrismLangException {
        ModulesFile modulesFile = null;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                modulesFile = prismParser.parseModulesFile(new ByteArrayInputStream(string.getBytes()), modelType);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        modulesFile.tidyUp();
        return modulesFile;
    }

    public ModulesFile importPepaFile(File file) throws PrismException, PrismLangException {
        return this.importModelFile("pepa", file);
    }

    public ModulesFile importPepaString(String string) throws PrismException, PrismLangException {
        return this.importModelString("pepa", string);
    }

    public ModulesFile importSBMLFile(File file) throws PrismException, PrismLangException {
        return this.importModelFile("sbml", file);
    }

    public ModulesFile importSBMLString(String string) throws PrismException, PrismLangException {
        return this.importModelString("sbml", string);
    }

    public ModulesFile importModelFile(String string, File file) throws PrismException, PrismLangException {
        this.mainLog.print("\nImporting " + string.toUpperCase() + " file \"" + String.valueOf(file) + "\"...\n");
        PrismLanguageTranslator prismLanguageTranslator = this.createPrismLanguageTranslator(string);
        prismLanguageTranslator.load(file);
        String string2 = prismLanguageTranslator.translateToString();
        return this.parseModelString(string2);
    }

    public ModulesFile importModelString(String string, String string2) throws PrismException, PrismLangException {
        this.mainLog.print("\nImporting " + string.toUpperCase() + " model...\n");
        PrismLanguageTranslator prismLanguageTranslator = this.createPrismLanguageTranslator(string);
        prismLanguageTranslator.load(string2);
        String string3 = prismLanguageTranslator.translateToString();
        return this.parseModelString(string3);
    }

    private PrismLanguageTranslator createPrismLanguageTranslator(String string) throws PrismException {
        PrismLanguageTranslator prismLanguageTranslator = null;
        switch (string) {
            case "pepa": {
                prismLanguageTranslator = new PEPA2Prism();
                break;
            }
            case "sbml": {
                prismLanguageTranslator = new SBML2Prism();
                break;
            }
            default: {
                throw new PrismException("Unknown import language \"" + string + "\"");
            }
        }
        return prismLanguageTranslator;
    }

    public ModulesFile importPrismPreprocFile(File file, String[] stringArray) throws PrismException {
        this.mainLog.print("\nImporting PRISM preprocessor file \"" + String.valueOf(file) + "\"...\n");
        Preprocessor preprocessor = new Preprocessor(this, file);
        preprocessor.setParameters(stringArray);
        String string = preprocessor.preprocess();
        if (string == null) {
            throw new PrismException("No preprocessing information");
        }
        return this.parseModelString(string);
    }

    public PropertiesFile parsePropertiesFile(File file) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(this.getModelInfo(), file, true);
    }

    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, File file) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(modelInfo, file, true);
    }

    public PropertiesFile parsePropertiesFile(File file, boolean bl) throws FileNotFoundException, PrismLangException {
        return this.parsePropertiesFile(this.getModelInfo(), file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFile parsePropertiesFile(ModelInfo modelInfo, File file, boolean bl) throws FileNotFoundException, PrismLangException {
        PropertiesFile propertiesFile = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                propertiesFile = prismParser.parsePropertiesFile(modelInfo, fileInputStream);
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        if (bl) {
            propertiesFile.tidyUp();
        }
        return propertiesFile;
    }

    public PropertiesFile parsePropertiesString(String string) throws PrismLangException {
        return this.parsePropertiesString(this.getModelInfo(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFile parsePropertiesString(ModelInfo modelInfo, String string) throws PrismLangException {
        PropertiesFile propertiesFile = null;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                propertiesFile = prismParser.parsePropertiesFile(modelInfo, new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        propertiesFile.tidyUp();
        return propertiesFile;
    }

    public static Expression parseSingleExpressionString(String string) throws PrismLangException {
        Expression expression;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                expression = prismParser.parseSingleExpression(new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForLoop parseForLoopString(String string) throws PrismLangException {
        ForLoop forLoop;
        try {
            PrismParser prismParser = Prism.getPrismParser();
            try {
                forLoop = prismParser.parseForLoop(new ByteArrayInputStream(string.getBytes()));
            }
            finally {
                Prism.releasePrismParser();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PrismLangException("Concurrency error in parser");
        }
        return forLoop;
    }

    public static boolean isKeyword(String string) {
        return PrismParser.isKeyword(string);
    }

    public static boolean isValidIdentifier(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '_' && !Character.isLetter(c)) {
            return false;
        }
        if (!IDENTIFIER_PATTERN.matcher(string).matches()) {
            return false;
        }
        return !PrismParser.isKeyword(string);
    }

    public static String toIdentifier(Object object) {
        String string = object.toString().replaceAll("[^_a-zA-Z0-9]+", "_");
        return Prism.isValidIdentifier(string) ? string : "_" + string;
    }

    public void clearModel() throws PrismException {
        this.setModelSource(null);
        this.setModelType(null);
        this.setModelInfo(null);
        this.setPRISMModel(null);
        this.setModelGenerator(null);
        this.setRewardInfo(null);
        this.setRewardGenerator(null);
        this.setDefinedMFConstants(null);
        this.clearBuiltModel();
    }

    public void loadPRISMModel(ModulesFile modulesFile) throws PrismException {
        if (modulesFile == null) {
            this.clearModel();
        }
        this.setModelSource(ModelSource.PRISM_MODEL);
        this.setModelType(modulesFile.getModelType());
        this.setModelInfo(modulesFile);
        this.setPRISMModel(modulesFile);
        this.setRewardInfo(modulesFile);
        this.resetGenerators();
        this.setDefinedMFConstants(null);
        this.clearBuiltModel();
        this.printModelInfo();
    }

    public void loadModelGenerator(ModelGenerator<?> modelGenerator) throws PrismException {
        if (modelGenerator == null) {
            this.clearModel();
        }
        this.mainLog.println("Loading model generator " + modelGenerator.getClass().getName() + "...");
        this.setModelSource(ModelSource.MODEL_GENERATOR);
        this.setModelType(modelGenerator.getModelType());
        this.setModelInfo(modelGenerator);
        this.setPRISMModel(null);
        this.setModelGenerator(modelGenerator);
        RewardGenerator<Object> rewardGenerator = modelGenerator instanceof RewardGenerator ? (RewardGenerator<Object>)((Object)modelGenerator) : new RewardGenerator<Object>(){};
        this.setRewardInfo(rewardGenerator);
        this.setRewardGenerator(rewardGenerator);
        this.setDefinedMFConstants(null);
        this.clearBuiltModel();
        this.printModelInfo();
        this.mainLog.println();
    }

    private void resetGenerators() throws PrismException {
        if (this.getModelSource() == ModelSource.PRISM_MODEL) {
            this.setModelGenerator(null);
            this.setRewardGenerator(this.getPRISMModel());
        }
    }

    public void setPRISMModelConstants(Values values) throws PrismException {
        this.setPRISMModelConstants(values, false);
    }

    public void setPRISMModelConstants(Values values, boolean bl) throws PrismException {
        boolean bl2;
        boolean bl3 = this.getUndefinedModelValues() == null || this.getUndefinedModelValues().getNumValues() == 0;
        boolean bl4 = values == null || values.getNumValues() == 0;
        boolean bl5 = bl2 = this.areUndefinedModelValuesExact() == bl;
        if (bl3 && bl4 && bl2) {
            return;
        }
        if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().equals(values) && bl2) {
            return;
        }
        this.clearBuiltModel();
        this.setDefinedMFConstants(values, bl);
        if (this.getPRISMModel() != null) {
            this.getPRISMModel().setSomeUndefinedConstants(values, bl);
        }
        if (!bl2) {
            this.resetGenerators();
        } else if (this.getModelGenerator(false) != null) {
            this.getModelGenerator(false).setSomeUndefinedConstants(values, bl);
        }
    }

    public void loadPRISMModelAndBuiltModel(ModulesFile modulesFile, symbolic.model.Model model) throws PrismException {
        this.setModelSource(ModelSource.PRISM_MODEL);
        this.clearBuiltModel();
        this.setPRISMModel(modulesFile);
        this.setModelType(modulesFile == null ? null : modulesFile.getModelType());
        this.setModelInfo(modulesFile);
        this.setRewardInfo(modulesFile);
        this.setDefinedMFConstants(null);
        this.setBuiltModel(ModelBuildType.SYMBOLIC, model);
    }

    public void loadBuiltModel(symbolic.model.Model model) throws PrismException {
        this.setModelSource(ModelSource.BUILT_MODEL);
        this.clearBuiltModel();
        this.setPRISMModel(null);
        this.setModelType(model == null ? null : model.getModelType());
        this.setDefinedMFConstants(null);
        this.setBuiltModel(ModelBuildType.SYMBOLIC, model);
    }

    public void loadModelFromExplicitFiles(File file, File file2, File file3, List<File> list, ModelType modelType) throws PrismException {
        this.loadModelFromExplicitFiles(file, file2, file3, list, null, modelType);
    }

    public void loadModelFromExplicitFiles(File file, File file2, File file3, List<File> list, List<File> list2, ModelType modelType) throws PrismException {
        PrismExplicitImporter prismExplicitImporter = new PrismExplicitImporter(file, file2, file3, list, list2, modelType);
        this.loadModelFromExplicitFiles(prismExplicitImporter);
    }

    public void loadModelFromExplicitFiles(ExplicitModelImporter explicitModelImporter) throws PrismException {
        this.mainLog.println("\nImporting model from " + explicitModelImporter.sourceString() + "...");
        this.setModelSource(ModelSource.EXPLICIT_FILES);
        this.setPRISMModel(null);
        this.modelImporter = explicitModelImporter;
        this.clearBuiltModel();
        this.setModelInfo(explicitModelImporter.getModelInfo());
        this.setModelType(this.getModelInfo().getModelType());
        this.setRewardInfo(explicitModelImporter.getRewardInfo());
        this.setDefinedMFConstants(null);
        this.printModelInfo();
    }

    private void printModelInfo() throws PrismException {
        this.printModelInfo(this.getModelInfo(), this.getRewardInfo());
    }

    private void printModelInfo(ModelInfo modelInfo, RewardInfo rewardInfo) throws PrismException {
        this.mainLog.println();
        if (this.getModelSource() == ModelSource.EXPLICIT_FILES && this.modelImporter != null) {
            this.mainLog.println("Type:        " + this.modelImporter.getModelTypeString());
        } else {
            this.mainLog.println("Type:        " + String.valueOf((Object)modelInfo.getModelType()));
        }
        if (modelInfo instanceof ModulesFile) {
            this.mainLog.println("Modules:     " + String.join((CharSequence)" ", ((ModulesFile)modelInfo).getModuleNames()));
        }
        this.mainLog.println("Variables:   " + String.join((CharSequence)" ", modelInfo.getVarNames()));
        if (modelInfo.getModelType().partiallyObservable()) {
            this.mainLog.println("Observables: \"" + String.join((CharSequence)"\" \"", modelInfo.getObservableNames()) + "\"");
        }
        if (modelInfo.getNumLabels() > 0) {
            this.mainLog.println("Labels:      \"" + String.join((CharSequence)"\" \"", modelInfo.getLabelNames()) + "\"");
        }
        if (rewardInfo != null && rewardInfo.getNumRewardStructs() > 0) {
            this.mainLog.println("Rewards:     " + String.join((CharSequence)" ", rewardInfo.getRewardStructReferences()));
        }
    }

    public ModelSource getModelSource() {
        return this.currentModelDetails.modelSource;
    }

    public boolean isModelSourceDigitalClocks() {
        return this.currentModelDetails.modelDigitalClocks;
    }

    public ModelType getModelType() {
        return this.currentModelDetails.modelType;
    }

    public ModelInfo getModelInfo() {
        return this.currentModelDetails.modelInfo;
    }

    public ModulesFile getPRISMModel() {
        return this.currentModelDetails.modulesFile;
    }

    public PrismEngine getCurrentEngine() {
        if (this.param) {
            return PrismEngine.PARAM;
        }
        if (this.settings.getBoolean("prism.exact.enabled")) {
            return PrismEngine.EXACT;
        }
        if (this.getEngine() == 4) {
            return PrismEngine.EXPLICIT;
        }
        return PrismEngine.SYMBOLIC;
    }

    public ModelGenerator<?> getModelGenerator() throws PrismException {
        return this.getModelGenerator(true);
    }

    private ModelGenerator<?> getModelGenerator(boolean bl) throws PrismException {
        if (this.currentModelDetails.modelGenerator == null && bl) {
            switch (this.getModelSource().ordinal()) {
                case 0: {
                    if (this.getPRISMModel() != null) {
                        ModulesFileModelGenerator<Function> modulesFileModelGenerator = null;
                        modulesFileModelGenerator = this.getCurrentEngine() == PrismEngine.PARAM ? ModulesFileModelGenerator.createForRationalFunctions(this.getPRISMModel(), this.paramNames, this.paramLowerBounds, this.paramUpperBounds, this) : (this.getCurrentEngine() == PrismEngine.EXACT ? ModulesFileModelGenerator.createForRationalFunctions(this.getPRISMModel(), this) : ModulesFileModelGenerator.create(this.getPRISMModel(), this));
                        this.setModelGenerator(modulesFileModelGenerator);
                        this.setRewardGenerator(modulesFileModelGenerator);
                        break;
                    }
                    throw new PrismException("There is no currently loaded PRISM model");
                }
                case 1: {
                    throw new PrismException("There is no currently loaded model generator");
                }
                case 2: 
                case 3: {
                    this.buildModelIfRequired();
                    break;
                }
                default: {
                    throw new PrismException("Unknown model source");
                }
            }
        }
        if (this.currentModelDetails.modelGenerator == null && bl) {
            throw new PrismException("Could not create a model generator");
        }
        return this.currentModelDetails.modelGenerator;
    }

    public RewardInfo getRewardInfo() throws PrismException {
        return this.currentModelDetails.rewardInfo;
    }

    public RewardGenerator<?> getRewardGenerator() throws PrismException {
        return this.currentModelDetails.rewardGenerator;
    }

    public Values getUndefinedModelValues() {
        return this.currentModelDetails.definedMFConstants;
    }

    public boolean areUndefinedModelValuesExact() {
        return this.currentModelDetails.definedMFConstantsAreExact;
    }

    public Model<?> getBuiltModel() {
        return this.currentModelDetails.model;
    }

    private symbolic.model.Model getBuiltModelSymbolic() {
        return this.currentModelDetails.modelSymb;
    }

    public explicit.Model<?> getBuiltModelExplicit() {
        return this.currentModelDetails.modelExpl;
    }

    public ModelBuildType getBuiltModelType() {
        return this.currentModelDetails.modelBuildType;
    }

    public boolean modelCanBeBuilt() {
        return !this.getModelType().realTime();
    }

    public ModelBuildType getModelBuildTypeForEngine(PrismEngine prismEngine) {
        switch (prismEngine.ordinal()) {
            case 1: {
                return ModelBuildType.EXPLICIT;
            }
            case 0: {
                return ModelBuildType.SYMBOLIC;
            }
            case 2: {
                return ModelBuildType.EXACT;
            }
            case 3: {
                return ModelBuildType.PARAM;
            }
        }
        return null;
    }

    public boolean modelIsBuilt() {
        ModelBuildType modelBuildType = this.getModelBuildTypeForEngine(this.getCurrentEngine());
        return modelBuildType != null && this.getBuiltModelType() == modelBuildType;
    }

    public boolean someModelIsBuilt() {
        return this.getBuiltModelType() != null;
    }

    public Strategy<?> getStrategy() {
        return this.strategy;
    }

    public void buildModel() throws PrismException {
        this.mainLog.printSeparator();
        this.chooseEngineForModelBuild();
        this.doBuildModel();
    }

    public void buildModelIfRequired() throws PrismException {
        this.chooseEngineForModelBuild();
        if (!this.modelIsBuilt()) {
            this.doBuildModel();
        }
    }

    private void chooseEngineForModelBuild() {
        switch (this.getModelType()) {
            case IDTMC: 
            case IMDP: 
            case LTS: 
            case POMDP: {
                if (this.getCurrentEngine() != PrismEngine.SYMBOLIC) break;
                this.mainLog.println("\nSwitching to explicit engine, which supports " + String.valueOf((Object)this.getModelType()) + "s...");
                this.engineOld = this.getEngine();
                this.engineSwitched = true;
                try {
                    this.setEngine(4);
                }
                catch (PrismException prismException) {}
                break;
            }
            default: {
                if (!this.engineSwitched) break;
                try {
                    this.setEngine(this.engineOld);
                }
                catch (PrismException prismException) {
                    // empty catch block
                }
                this.engineSwitched = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBuildModel() throws PrismException {
        this.clearBuiltModel();
        try {
            int n;
            Object object;
            if (this.getModelType().realTime()) {
                throw new PrismException("You cannot build a " + String.valueOf((Object)this.getModelType()) + " model explicitly, only perform model checking");
            }
            this.mainLog.print("\nBuilding model (engine:" + this.getCurrentEngine().toString().toLowerCase() + ")...\n");
            if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().getNumValues() > 0) {
                this.mainLog.println("Model constants: " + String.valueOf(this.getUndefinedModelValues()));
            }
            long l = System.currentTimeMillis();
            block2 : switch (this.getCurrentEngine().ordinal()) {
                case 0: {
                    Object object2;
                    Object object3;
                    Object object4;
                    explicit.Model<?> model;
                    switch (this.getModelSource().ordinal()) {
                        case 0: {
                            model = new Modules2MTBDD(this, this.getPRISMModel());
                            object = ((Modules2MTBDD)((Object)model)).translate();
                            this.setBuiltModel(ModelBuildType.SYMBOLIC, (Model<?>)object);
                            break block2;
                        }
                        case 1: {
                            object4 = new ModelGenerator2MTBDD(this);
                            object3 = this.getModelGenerator();
                            object = ((ModelGenerator2MTBDD)object4).build((ModelGenerator<Double>)object3, this.getRewardGenerator());
                            this.setBuiltModel(ModelBuildType.SYMBOLIC, (Model<?>)object);
                            break block2;
                        }
                        case 2: {
                            object2 = new ExplicitFiles2MTBDD(this);
                            object = ((ExplicitFiles2MTBDD)object2).build(this.modelImporter);
                            this.setBuiltModel(ModelBuildType.SYMBOLIC, (Model<?>)object);
                            break block2;
                        }
                    }
                    throw new PrismException("Cannot do symbolic model construction for model source " + String.valueOf((Object)this.getModelSource()));
                }
                case 1: 
                case 2: 
                case 3: {
                    Object object2;
                    Object object3;
                    Object object4;
                    explicit.Model<?> model;
                    switch (this.getModelSource().ordinal()) {
                        case 0: 
                        case 1: {
                            try {
                                this.getModelGenerator();
                            }
                            catch (PrismException prismException) {
                                throw prismException.prepend("Explicit engine: ");
                            }
                            object4 = new ConstructModel(this);
                            ((ConstructModel)object4).setFixDeadlocks(this.getFixDeadlocks());
                            model = ((ConstructModel)object4).constructModel(this.getModelGenerator());
                            this.setBuiltModel(this.getModelBuildTypeForEngine(this.getCurrentEngine()), model);
                            break block2;
                        }
                        case 2: {
                            object3 = new ExplicitFiles2Model(this);
                            object2 = this.getCurrentEngine() == PrismEngine.EXACT ? Evaluator.forBigRational() : Evaluator.forDouble();
                            model = ((ExplicitFiles2Model)object3).build(this.modelImporter, object2);
                            this.setBuiltModel(this.getModelBuildTypeForEngine(this.getCurrentEngine()), model);
                            this.setModelGenerator(new ModelModelGenerator(this.getBuiltModelExplicit(), this.getModelInfo()));
                            ExplicitFiles2Rewards explicitFiles2Rewards = new ExplicitFiles2Rewards(this, this.modelImporter, this.getBuiltModelExplicit(), object2);
                            this.setRewardGenerator(explicitFiles2Rewards.getRewardGenerator());
                            break block2;
                        }
                    }
                    throw new PrismException("Cannot do explicit model construction for model source " + String.valueOf((Object)this.getModelSource()));
                }
                default: {
                    throw new PrismException("Unknown engine " + String.valueOf((Object)this.getCurrentEngine()));
                }
            }
            l = System.currentTimeMillis() - l;
            this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
            if (this.isModelSourceDigitalClocks()) {
                this.doBuildModelDigitalClocksChecks();
            }
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                object = this.getBuiltModelSymbolic().getDeadlockStates();
                n = object.size();
                if (n > 0) {
                    if (this.getFixDeadlocks()) {
                        this.mainLog.printWarning("Deadlocks detected and fixed in " + n + " states");
                    } else {
                        this.getBuiltModelSymbolic().printTransInfo(this.mainLog, this.getExtraDDInfo());
                        this.mainLog.print("\n" + n + " deadlock states found");
                        if (!this.getVerbose() && n > 10) {
                            this.mainLog.print(". The first 10 are below. Use verbose mode to view them all.\n");
                            object.print(this.mainLog, 10);
                        } else {
                            this.mainLog.print(":\n");
                            object.print(this.mainLog);
                        }
                        this.mainLog.print("\nTip: Use the \"fix deadlocks\" option to automatically add self-loops in deadlock states.\n");
                        throw new PrismException("Model contains " + n + " deadlock states");
                    }
                }
            } else {
                object = this.getBuiltModelExplicit().getDeadlockStatesList();
                n = this.getBuiltModelExplicit().getNumDeadlockStates();
                if (n > 0) {
                    if (this.getFixDeadlocks()) {
                        this.mainLog.printWarning("Deadlocks detected and fixed in " + n + " states");
                    } else {
                        this.mainLog.print(this.getBuiltModelExplicit().infoStringTable());
                        this.mainLog.print("\n" + n + " deadlock states found");
                        if (!this.getVerbose() && n > 10) {
                            this.mainLog.print(". The first 10 are below. Use verbose mode to view them all.\n");
                            ((explicit.StateValues)object).print(this.mainLog, 10);
                        } else {
                            this.mainLog.print(":\n");
                            ((explicit.StateValues)object).print(this.mainLog);
                        }
                        this.mainLog.print("\nTip: Use the \"fix deadlocks\" option to automatically add self-loops in deadlock states.\n");
                        throw new PrismException("Model contains " + n + " deadlock states");
                    }
                }
            }
            this.mainLog.println();
            this.mainLog.println("Type:        " + String.valueOf((Object)this.getBuiltModel().getModelType()));
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                this.getBuiltModelSymbolic().printTransInfo(this.mainLog, this.getExtraDDInfo());
            } else {
                this.mainLog.print(this.getBuiltModelExplicit().infoStringTable());
            }
            for (PrismModelListener prismModelListener : this.modelListeners) {
                if (prismModelListener == null) continue;
                prismModelListener.notifyModelBuildSuccessful();
            }
            return;
        }
        catch (PrismException prismException) {
            Iterator<PrismModelListener> iterator = this.modelListeners.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw prismException;
                }
                PrismModelListener prismModelListener = iterator.next();
                if (prismModelListener == null) continue;
                prismModelListener.notifyModelBuildFailed(prismException);
            }
        }
    }

    private void doBuildModelDigitalClocksChecks() throws PrismException {
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            StateList stateList = this.getBuiltModelSymbolic().getDeadlockStates();
            if (stateList.size() > 0) {
                throw new PrismException("Timelock in PTA, e.g. in state (" + String.valueOf(stateList.getFirstAsValues()) + ")");
            }
        } else if (this.getBuiltModelExplicit().getNumDeadlockStates() > 0) {
            int n = this.getBuiltModelExplicit().getFirstDeadlockState();
            String string = this.getBuiltModelExplicit().getStatesList().get(n).toString(this.getModelInfo());
            throw new PrismException("Timelock in PTA, e.g. in state " + string);
        }
    }

    public symbolic.model.Model buildModelExplicit(ModulesFile modulesFile) throws PrismException {
        if (modulesFile.getModelType().realTime()) {
            throw new PrismException("You cannot build a " + String.valueOf((Object)modulesFile.getModelType()) + " model explicitly, only perform model checking");
        }
        this.mainLog.print("\nBuilding model...\n");
        if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().getNumValues() > 0) {
            this.mainLog.println("Model constants: " + String.valueOf(this.getUndefinedModelValues()));
        }
        ConstructModel constructModel = new ConstructModel(this);
        ModulesFileModelGenerator<Double> modulesFileModelGenerator = ModulesFileModelGenerator.createForDoubles(modulesFile, this);
        explicit.Model<Double> model = constructModel.constructModel(modulesFileModelGenerator);
        List<State> list = constructModel.getStatesList();
        ExplicitModel2MTBDD explicitModel2MTBDD = new ExplicitModel2MTBDD(this);
        long l = System.currentTimeMillis();
        symbolic.model.Model model2 = explicitModel2MTBDD.buildModel(model, list, modulesFile, false);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model construction: " + (double)l / 1000.0 + " seconds.");
        return model2;
    }

    public void exportPRISMModel(File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting parsed PRISM file ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        prismLog.print(this.getPRISMModel().toString());
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportPRISMModelWithExpandedConstants(File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting parsed PRISM file (with constant expansion) ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        ModulesFile modulesFile = (ModulesFile)this.getPRISMModel().deepCopy();
        modulesFile = (ModulesFile)modulesFile.replaceConstants(this.getPRISMModel().getConstantValues());
        prismLog.print(modulesFile.toString());
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportBuiltModel(File file, ModelExportFormat modelExportFormat) throws PrismException {
        this.exportBuiltModelTask(ModelExportTask.fromFormat(file, modelExportFormat));
    }

    public void exportBuiltModel(File file, ModelExportOptions modelExportOptions) throws PrismException {
        this.exportBuiltModelTask(ModelExportTask.fromOptions(file, modelExportOptions));
    }

    public void exportBuiltModelTransitions(File file, ModelExportFormat modelExportFormat) throws PrismException {
        this.exportBuiltModel(file, modelExportFormat);
    }

    public void exportBuiltModelTransitions(File file, ModelExportOptions modelExportOptions) throws PrismException {
        this.exportBuiltModel(file, modelExportOptions);
    }

    public void exportBuiltModelStateRewards(File file, ModelExportFormat modelExportFormat) throws PrismException {
        this.exportBuiltModelStateRewards(file, new ModelExportOptions(modelExportFormat));
    }

    public void exportBuiltModelStateRewards(File file, ModelExportOptions modelExportOptions) throws PrismException {
        if (this.getRewardInfo().getNumRewardStructs() == 0) {
            this.mainLog.println("\nOmitting state reward export as there are no reward structures");
            return;
        }
        this.exportBuiltModelTask(new ModelExportTask(ModelExportTask.ModelExportEntity.STATE_REWARDS, file, modelExportOptions));
    }

    public void exportBuiltModelTransRewards(File file, ModelExportFormat modelExportFormat) throws FileNotFoundException, PrismException {
        this.exportBuiltModelTransRewards(file, new ModelExportOptions(modelExportFormat));
    }

    public void exportBuiltModelTransRewards(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        if (this.getRewardInfo().getNumRewardStructs() == 0) {
            this.mainLog.println("\nOmitting transition reward export as there are no reward structures");
            return;
        }
        this.exportBuiltModelTask(new ModelExportTask(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, file, modelExportOptions));
    }

    public void exportBuiltModelStates(File file, ModelExportFormat modelExportFormat) throws FileNotFoundException, PrismException {
        this.exportBuiltModelStates(file, new ModelExportOptions(modelExportFormat));
    }

    public void exportBuiltModelStates(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        this.exportBuiltModelTask(new ModelExportTask(ModelExportTask.ModelExportEntity.STATES, file, modelExportOptions));
    }

    public void exportBuiltModelObservations(File file, ModelExportFormat modelExportFormat) throws FileNotFoundException, PrismException {
        this.exportBuiltModelObservations(file, new ModelExportOptions(modelExportFormat));
    }

    public void exportBuiltModelObservations(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        if (!this.getModelType().partiallyObservable()) {
            this.mainLog.println("\nOmitting observations export as the model is not partially observable");
            return;
        }
        this.exportBuiltModelTask(new ModelExportTask(ModelExportTask.ModelExportEntity.OBSERVATIONS, file, modelExportOptions));
    }

    public void exportBuiltModelLabels(File file, ModelExportFormat modelExportFormat) throws FileNotFoundException, PrismException {
        this.exportBuiltModelLabels(file, new ModelExportOptions(modelExportFormat));
    }

    public void exportBuiltModelLabels(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        this.exportBuiltModelLabels(null, file, modelExportOptions);
    }

    public void exportBuiltModelLabels(PropertiesFile propertiesFile, File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        ModelExportTask modelExportTask = new ModelExportTask(ModelExportTask.ModelExportEntity.LABELS, file, modelExportOptions);
        if (propertiesFile != null) {
            modelExportTask.setLabelExportSet(ModelExportTask.LabelExportSet.ALL);
            modelExportTask.setExtraLabelsSource(propertiesFile);
        }
        this.exportBuiltModelTask(modelExportTask);
    }

    public void exportBuiltModelPropLabels(PropertiesFile propertiesFile, File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        ModelExportTask modelExportTask = new ModelExportTask(ModelExportTask.ModelExportEntity.LABELS, file, modelExportOptions);
        modelExportTask.setLabelExportSet(ModelExportTask.LabelExportSet.EXTRA);
        modelExportTask.setExtraLabelsSource(propertiesFile);
        this.exportBuiltModelTask(modelExportTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportBuiltModelTask(ModelExportTask modelExportTask) throws PrismException {
        if (!modelExportTask.isApplicable(this.getModelInfo())) {
            return;
        }
        boolean bl = false;
        int n = -1;
        try {
            this.buildModelIfRequired();
            this.mainLog.println("\n" + modelExportTask.getMessage());
            ModelExportOptions modelExportOptions = this.newMergedModelExportOptions(modelExportTask.getExportOptions());
            switch (modelExportTask.getEntity()) {
                case MODEL: {
                    this.doExportBuiltModel(new ModelExportTask(modelExportTask, modelExportOptions));
                    return;
                }
                case STATE_REWARDS: {
                    this.doExportBuiltModelStateRewards(modelExportTask.getFile(), modelExportOptions);
                    return;
                }
                case TRANSITION_REWARDS: {
                    this.doExportBuiltModelTransRewards(modelExportTask.getFile(), modelExportOptions);
                    return;
                }
                case STATES: {
                    this.doExportBuiltModelStates(modelExportTask.getFile(), modelExportOptions);
                    return;
                }
                case OBSERVATIONS: {
                    this.doExportBuiltModelObservations(modelExportTask.getFile(), modelExportOptions);
                    return;
                }
                case LABELS: {
                    this.doExportBuiltModelLabels(new ModelExportTask(modelExportTask, modelExportOptions));
                    return;
                }
            }
            return;
        }
        finally {
            if (bl) {
                this.setEngine(n);
            }
        }
    }

    private void doExportBuiltModel(ModelExportTask modelExportTask) throws PrismException {
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            if (modelExportTask.getExportOptions().getFormat() == ModelExportFormat.DRN) {
                MTBDD2ExplicitModel mTBDD2ExplicitModel = new MTBDD2ExplicitModel(this);
                explicit.Model<Double> model = mTBDD2ExplicitModel.convertModel(this.getBuiltModelSymbolic());
                StateModelChecker stateModelChecker = StateModelChecker.createModelChecker(this.getModelType(), this);
                RewardGenerator<Double> rewardGenerator = mTBDD2ExplicitModel.getRewardConverter(this.getBuiltModelSymbolic(), model, this.getRewardInfo());
                stateModelChecker.setModelCheckingInfo(this.getModelInfo(), null, rewardGenerator);
                stateModelChecker.exportModel(model, modelExportTask);
            } else {
                symbolic.comp.StateModelChecker stateModelChecker = this.createModelChecker(null);
                stateModelChecker.exportModel(modelExportTask);
            }
        } else {
            StateModelChecker stateModelChecker = this.createModelCheckerExplicit(null);
            stateModelChecker.exportModel(this.getBuiltModelExplicit(), modelExportTask);
        }
    }

    private void doExportBuiltModelStateRewards(File file, ModelExportOptions modelExportOptions) throws PrismException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getRewardInfo().getNumRewardStructs();
        for (int i = 0; i < n; ++i) {
            PrismComponent prismComponent;
            File file2;
            String string;
            String string2 = string = file != null ? file.getPath() : null;
            if (string != null && n > 1) {
                string = PrismUtils.addCounterSuffixToFilename(string, i + 1);
                arrayList.add(string);
            }
            File file3 = file2 = string == null ? null : new File(string);
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                prismComponent = this.createModelChecker(null);
                ((symbolic.comp.StateModelChecker)prismComponent).exportStateRewards(i, file2, modelExportOptions);
                continue;
            }
            prismComponent = this.createModelCheckerExplicit(null);
            ((StateModelChecker)prismComponent).exportStateRewards(this.getBuiltModelExplicit(), i, file2, modelExportOptions);
        }
        if (arrayList.size() > 1) {
            this.mainLog.println("Rewards were exported to multiple files: " + PrismUtils.joinString(arrayList, ","));
        }
    }

    private void doExportBuiltModelTransRewards(File file, ModelExportOptions modelExportOptions) throws PrismException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getRewardInfo().getNumRewardStructs();
        for (int i = 0; i < n; ++i) {
            PrismComponent prismComponent;
            File file2;
            String string;
            String string2 = string = file != null ? file.getPath() : null;
            if (string != null && n > 1) {
                string = PrismUtils.addCounterSuffixToFilename(string, i + 1);
                arrayList.add(string);
            }
            File file3 = file2 = string == null ? null : new File(string);
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                prismComponent = this.createModelChecker(null);
                ((symbolic.comp.StateModelChecker)prismComponent).exportTransRewards(i, file2, modelExportOptions);
                continue;
            }
            prismComponent = this.createModelCheckerExplicit(null);
            ((StateModelChecker)prismComponent).exportTransRewards(this.getBuiltModelExplicit(), i, file2, modelExportOptions);
        }
        if (arrayList.size() > 1) {
            this.mainLog.println("Rewards were exported to multiple files: " + PrismUtils.joinString(arrayList, ","));
        }
    }

    private void doExportBuiltModelStates(File file, ModelExportOptions modelExportOptions) throws PrismException {
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            symbolic.comp.StateModelChecker stateModelChecker = this.createModelChecker(null);
            stateModelChecker.exportStates(file, modelExportOptions);
        } else {
            StateModelChecker stateModelChecker = this.createModelCheckerExplicit(null);
            stateModelChecker.exportStates(this.getBuiltModelExplicit(), file, modelExportOptions);
        }
    }

    private void doExportBuiltModelObservations(File file, ModelExportOptions modelExportOptions) throws PrismException {
        StateModelChecker stateModelChecker = this.createModelCheckerExplicit(null);
        stateModelChecker.exportObservations(this.getBuiltModelExplicit(), file, modelExportOptions);
    }

    private void doExportBuiltModelLabels(ModelExportTask modelExportTask) throws PrismException {
        ASTElement aSTElement;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (modelExportTask.getLabelExportSet() == ModelExportTask.LabelExportSet.MODEL || modelExportTask.getLabelExportSet() == ModelExportTask.LabelExportSet.ALL) {
            if (modelExportTask.initLabelIncluded()) {
                arrayList.add("init");
            }
            if (modelExportTask.deadlockLabelIncluded()) {
                arrayList.add("deadlock");
            }
            arrayList.addAll(this.getModelInfo().getLabelNames());
        }
        if (modelExportTask.getLabelExportSet() == ModelExportTask.LabelExportSet.EXTRA || modelExportTask.getLabelExportSet() == ModelExportTask.LabelExportSet.ALL) {
            aSTElement = modelExportTask.getExtraLabelsSource().getLabelList();
            new Range(((LabelList)aSTElement).size()).map(arg_0 -> Prism.lambda$doExportBuiltModelLabels$0((LabelList)aSTElement, arg_0)).collect(arrayList);
        }
        aSTElement = modelExportTask.getExtraLabelsSource();
        File file = modelExportTask.getFile();
        ModelExportOptions modelExportOptions = modelExportTask.getExportOptions();
        if (this.getBuiltModelType() != ModelBuildType.SYMBOLIC) {
            StateModelChecker stateModelChecker = this.createModelCheckerExplicit((PropertiesFile)aSTElement);
            stateModelChecker.exportLabels(this.getBuiltModelExplicit(), arrayList, file, modelExportOptions);
        } else {
            symbolic.comp.StateModelChecker stateModelChecker = this.createModelChecker((PropertiesFile)aSTElement);
            stateModelChecker.exportLabels(arrayList, file, modelExportOptions);
        }
    }

    public void exportBSCCsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        symbolic.comp.SCCComputer sCCComputer = null;
        SCCConsumerStore sCCConsumerStore = null;
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing BSCCs...");
        long l = System.currentTimeMillis();
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            sCCComputer = this.getSCCComputer(this.getBuiltModelSymbolic());
            sCCComputer.computeBSCCs();
        } else {
            sCCConsumerStore = new SCCConsumerStore();
            this.getExplicitSCCComputer(this.getBuiltModelExplicit(), sCCConsumerStore).computeSCCs();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for BSCC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting BSCCs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.getModelInfo().getNumVars(); ++n2) {
            prismLog.print(this.getModelInfo().getVarName(n2));
            if (n2 >= this.getModelInfo().getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = this.getBuiltModelType() == ModelBuildType.SYMBOLIC ? sCCComputer.getBSCCs().size() : sCCConsumerStore.getBSCCs().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("BSCC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("bscc" + (n2 + 1) + "=[");
            }
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                if (n != 2) {
                    new StateListMTBDD(sCCComputer.getBSCCs().get(n2), this.getBuiltModelSymbolic()).print(prismLog);
                } else {
                    new StateListMTBDD(sCCComputer.getBSCCs().get(n2), this.getBuiltModelSymbolic()).printMatlab(prismLog);
                }
                JDD.Deref(sCCComputer.getBSCCs().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(sCCConsumerStore.getBSCCs().get(n2), this.getBuiltModelExplicit()).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            JDD.Deref(sCCComputer.getNotInBSCCs());
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportMECsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        ECComputer eCComputer = null;
        explicit.ECComputer eCComputer2 = null;
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing MECs...");
        long l = System.currentTimeMillis();
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            eCComputer = this.getECComputer((NondetModel)this.getBuiltModelSymbolic());
            eCComputer.computeMECStates();
        } else {
            eCComputer2 = this.getExplicitECComputer((explicit.NondetModel)this.getBuiltModelExplicit());
            eCComputer2.computeMECStates();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for MEC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting MECs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.getModelInfo().getNumVars(); ++n2) {
            prismLog.print(this.getModelInfo().getVarName(n2));
            if (n2 >= this.getModelInfo().getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = this.getBuiltModelType() == ModelBuildType.SYMBOLIC ? eCComputer.getMECStates().size() : eCComputer2.getMECStates().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("MEC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("mec" + (n2 + 1) + "=[");
            }
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                if (n != 2) {
                    new StateListMTBDD(eCComputer.getMECStates().get(n2), this.getBuiltModelSymbolic()).print(prismLog);
                } else {
                    new StateListMTBDD(eCComputer.getMECStates().get(n2), this.getBuiltModelSymbolic()).printMatlab(prismLog);
                }
                JDD.Deref(eCComputer.getMECStates().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(eCComputer2.getMECStates().get(n2), this.getBuiltModelExplicit()).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportSCCsToFile(int n, File file) throws FileNotFoundException, PrismException {
        int n2;
        symbolic.comp.SCCComputer sCCComputer = null;
        SCCConsumerStore sCCConsumerStore = null;
        if (n == 5) {
            n = 1;
        }
        this.buildModelIfRequired();
        this.mainLog.println("\nComputing SCCs...");
        long l = System.currentTimeMillis();
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            sCCComputer = this.getSCCComputer(this.getBuiltModelSymbolic());
            sCCComputer.computeSCCs();
        } else {
            sCCConsumerStore = new SCCConsumerStore();
            this.getExplicitSCCComputer(this.getBuiltModelExplicit(), sCCConsumerStore).computeSCCs();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for SCC computation: " + (double)l / 1000.0 + " seconds.");
        this.mainLog.print("\nExporting SCCs ");
        this.mainLog.print(Prism.getStringForExportType(n) + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("Variables: (");
        for (n2 = 0; n2 < this.getModelInfo().getNumVars(); ++n2) {
            prismLog.print(this.getModelInfo().getVarName(n2));
            if (n2 >= this.getModelInfo().getNumVars() - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        int n3 = this.getBuiltModelType() == ModelBuildType.SYMBOLIC ? sCCComputer.getSCCs().size() : sCCConsumerStore.getSCCs().size();
        for (n2 = 0; n2 < n3; ++n2) {
            prismLog.println();
            if (n == 2) {
                prismLog.print("% ");
            }
            prismLog.println("SCC " + (n2 + 1) + "/" + n3 + ":");
            if (n == 2) {
                prismLog.println("scc" + (n2 + 1) + "=[");
            }
            if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
                if (n != 2) {
                    new StateListMTBDD(sCCComputer.getSCCs().get(n2), this.getBuiltModelSymbolic()).print(prismLog);
                } else {
                    new StateListMTBDD(sCCComputer.getSCCs().get(n2), this.getBuiltModelSymbolic()).printMatlab(prismLog);
                }
                JDD.Deref(sCCComputer.getSCCs().get(n2));
            } else {
                explicit.StateValues.createFromBitSet(sCCConsumerStore.getSCCs().get(n2), this.getBuiltModelExplicit()).print(prismLog, true, n == 2, true, true);
            }
            if (n != 2) continue;
            prismLog.println("];");
        }
        if (this.getBuiltModelType() == ModelBuildType.SYMBOLIC) {
            JDD.Deref(sCCComputer.getNotInSCCs());
        }
        if (file != null) {
            prismLog.close();
        }
    }

    private ModelExportOptions newMergedModelExportOptions(ModelExportOptions modelExportOptions) {
        ModelExportOptions modelExportOptions2 = new ModelExportOptions();
        modelExportOptions2.setModelPrecision(this.settings.getInteger("prism.exportModelPrecision"));
        modelExportOptions2.setPrintHeaders(this.settings.getBoolean("prism.exportModelHeaders"));
        modelExportOptions2.apply(modelExportOptions);
        return modelExportOptions2;
    }

    public Result modelCheck(String string) throws PrismException {
        PropertiesFile propertiesFile = this.parsePropertiesString(string);
        if (propertiesFile.getNumProperties() != 1) {
            throw new PrismException("There should be exactly one property to check (there are " + propertiesFile.getNumProperties() + ")");
        }
        return this.modelCheck(propertiesFile, propertiesFile.getPropertyObject(0));
    }

    public Result modelCheck(PropertiesFile propertiesFile, Expression expression) throws PrismException, PrismLangException {
        return this.modelCheck(propertiesFile, new Property(expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result modelCheck(PropertiesFile propertiesFile, Property property) throws PrismException, PrismLangException {
        Result result = null;
        Values values = propertiesFile.getConstantValues();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = -1;
        if (!this.isModelSourceDigitalClocks()) {
            this.mainLog.printSeparator();
        }
        this.mainLog.println("\nModel checking: " + String.valueOf(property));
        if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().getNumValues() > 0) {
            this.mainLog.println("Model constants: " + String.valueOf(this.getUndefinedModelValues()));
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + String.valueOf(values));
        }
        property.getExpression().checkValid(this.getModelType());
        this.clearStrategy();
        if (this.getCurrentEngine() == PrismEngine.EXACT && this.getModelType() != ModelType.DTMC && this.getModelType() != ModelType.CTMC && this.getModelType() != ModelType.MDP && this.getModelType().isProbabilistic()) {
            throw new PrismNotSupportedException("Exact model checking not supported for " + String.valueOf((Object)this.getModelType()) + "s");
        }
        if (this.getCurrentEngine() == PrismEngine.PARAM) {
            if (this.getModelType() != ModelType.DTMC && this.getModelType() != ModelType.CTMC && this.getModelType() != ModelType.MDP && this.getModelType().isProbabilistic()) {
                throw new PrismNotSupportedException("Parametric model checking not supported for " + String.valueOf((Object)this.getModelType()) + "s");
            }
            if (this.getModelType() == ModelType.MDP && this.getFairness()) {
                throw new PrismNotSupportedException("Parametric model checking does not support checking MDPs under fairness");
            }
        }
        if (this.getModelType().realTime()) {
            return this.modelCheckPTA(propertiesFile, property.getExpression(), values);
        }
        if (this.getModelType() == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
            FastAdaptiveUniformisationModelChecker fastAdaptiveUniformisationModelChecker = new FastAdaptiveUniformisationModelChecker(this, this.getPRISMModel(), propertiesFile);
            return fastAdaptiveUniformisationModelChecker.check(property.getExpression());
        }
        if (this.settings.getString("prism.heuristic").equals("Speed")) {
            this.mainLog.printWarning("Switching to sparse engine and (backwards) Gauss Seidel (default for heuristic=speed).");
            bl = true;
            n = this.getEngine();
            this.setEngine(2);
            this.settings.set("prism.linEqMethod", "Backwards Gauss-Seidel");
        }
        if (this.getModelType() == ModelType.MDP && !Expression.containsMultiObjective(property.getExpression()) && this.getMDPSolnMethod() != 1 && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow use of chosen MDP solution method.");
            bl = true;
            n = this.getEngine();
            bl3 = true;
            this.setEngine(4);
        }
        if (Expression.containsNonProbLTLFormula(property.getExpression()) && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow non-probabilistic LTL model checking.");
            bl = true;
            n = this.getEngine();
            bl3 = true;
            this.setEngine(4);
        }
        if (this.settings.getBoolean("prism.intervalIter") && this.getCurrentEngine() == PrismEngine.SYMBOLIC && this.getModelType() == ModelType.MDP && Expression.containsMinReward(property.getExpression())) {
            this.mainLog.printWarning("Switching to explicit engine to allow interval iteration on Rmin operator.");
            bl = true;
            n = this.getEngine();
            bl3 = true;
            this.setEngine(4);
        }
        if ((this.getModelType() == ModelType.IDTMC || this.getModelType() == ModelType.IMDP) && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow model checking of interval model.");
            bl = true;
            n = this.getEngine();
            bl3 = true;
            this.setEngine(4);
        }
        if (this.genStrat && this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
            this.mainLog.printWarning("Switching to explicit engine to allow strategy generation.");
            bl = true;
            n = this.getEngine();
            bl3 = true;
            this.setEngine(4);
        }
        try {
            this.buildModelIfRequired();
            if (this.genStrat && this.getModelType().nondeterministic() && this.getCurrentEngine() == PrismEngine.SYMBOLIC && !((NondetModel)this.getBuiltModelSymbolic()).areAllChoiceActionsUnique()) {
                throw new PrismException("Cannot generate strategies with the current engine because some state of the model do not have unique action labels for each choice. Either switch to the explicit engine or add more action labels to the model");
            }
            if (this.getCurrentEngine() == PrismEngine.SYMBOLIC && this.getEngine() != 1 && !bl3) {
                if (this.getBuiltModelSymbolic().numStatesExceedsInt()) {
                    this.mainLog.printWarning("Switching to MTBDD engine, as number of states is too large for " + engineStrings[this.getEngine()] + " engine.");
                    bl2 = true;
                } else if (this.settings.getString("prism.heuristic").equals("Speed") && this.getBuiltModelSymbolic().getNumStates() > 100000000) {
                    this.mainLog.printWarning("Switching to MTBDD engine (default for heuristic=speed and this state space size).");
                    bl2 = true;
                }
                if (bl2) {
                    bl = true;
                    n = this.getEngine();
                    this.setEngine(1);
                    this.settings.set("prism.linEqMethod", "Jacobi");
                }
            }
            if (this.getCurrentEngine() == PrismEngine.SYMBOLIC) {
                symbolic.comp.StateModelChecker stateModelChecker = this.createModelChecker(propertiesFile);
                result = stateModelChecker.check(property.getExpression());
            } else if (this.getCurrentEngine() == PrismEngine.EXPLICIT) {
                StateModelChecker stateModelChecker = this.createModelCheckerExplicit(propertiesFile);
                result = stateModelChecker.check(this.getBuiltModelExplicit(), property.getExpression());
            } else if (this.getCurrentEngine() == PrismEngine.EXACT) {
                ParamModelChecker paramModelChecker = new ParamModelChecker(this, ParamMode.EXACT);
                paramModelChecker.setModelCheckingInfo(this.getPRISMModel(), propertiesFile, this.getRewardGenerator());
                result = paramModelChecker.check(this.getBuiltModelExplicit(), property.getExpression());
            } else if (this.getCurrentEngine() == PrismEngine.PARAM) {
                ParamModelChecker paramModelChecker = new ParamModelChecker(this, ParamMode.PARAMETRIC);
                paramModelChecker.setModelCheckingInfo(this.getPRISMModel(), propertiesFile, this.getRewardGenerator());
                result = paramModelChecker.check(this.getBuiltModelExplicit(), property.getExpression());
            }
            if (result.getStrategy() != null) {
                this.strategy = result.getStrategy();
            }
        }
        finally {
            if (bl) {
                this.setEngine(n);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result modelCheckPTA(PropertiesFile propertiesFile, Expression expression, Values values) throws PrismException, PrismLangException {
        expression.checkValid(this.getModelType());
        this.clearStrategy();
        if (this.settings.getString("prism.ptaMethod").equals("Digital clocks") || this.getModelType() == ModelType.POPTA) {
            this.setModelSourceIsDigitalClocks(true);
            ModulesFile modulesFile = this.getPRISMModel();
            try {
                DigitalClocks digitalClocks = new DigitalClocks(this);
                digitalClocks.translate(modulesFile, propertiesFile, expression);
                this.loadPRISMModel(digitalClocks.getNewModulesFile());
                if (this.exportDigital) {
                    try {
                        this.exportPRISMModel(this.exportDigitalFile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.mainLog.printWarning("PRISM code export failed: Couldn't open file \"" + String.valueOf(this.exportDigitalFile) + "\" for output");
                    }
                    catch (PrismException prismException) {
                        this.mainLog.printWarning("PRISM code export failed: " + prismException.getMessage());
                    }
                }
                Result result = this.modelCheck(digitalClocks.getNewPropertiesFile(), digitalClocks.getNewPropertyToCheck());
                return result;
            }
            finally {
                this.setModelSourceIsDigitalClocks(false);
                Strategy<?> strategy = this.strategy;
                this.strategy = null;
                this.setPRISMModel(modulesFile);
                this.setModelType(modulesFile.getModelType());
                this.clearBuiltModel();
                this.strategy = strategy;
            }
        }
        PTAModelChecker pTAModelChecker = new PTAModelChecker(this, this.getPRISMModel(), propertiesFile);
        return pTAModelChecker.check(expression);
    }

    public void checkModelForSimulation() throws PrismException {
        try {
            this.getModelGenerator();
            if (this.getModelType().realTime()) {
                throw new PrismException(String.valueOf((Object)this.getModelType()) + "s are not currently supported");
            }
        }
        catch (PrismException prismException) {
            throw prismException.prepend("Simulation not possible: ");
        }
    }

    public void loadModelIntoSimulator() throws PrismException {
        ModelGenerator<Double> modelGenerator = null;
        try {
            modelGenerator = this.getModelGenerator();
        }
        catch (PrismException prismException) {
            throw prismException.prepend("Simulation not possible: ");
        }
        this.getSimulator().loadModel(modelGenerator, this.getRewardGenerator());
    }

    public void loadStrategyIntoSimulator() throws PrismException {
        if (this.getStrategy() != null && this.getStrategy() instanceof StrategyGenerator) {
            this.getSimulator().loadStrategy((StrategyGenerator)((Object)this.getStrategy()));
        }
    }

    public boolean isPropertyOKForSimulation(Expression expression) {
        return this.getSimulator().isPropertyOKForSimulation(expression);
    }

    public void checkPropertyForSimulation(Expression expression) throws PrismException {
        this.getSimulator().checkPropertyForSimulation(expression);
    }

    public Result modelCheckSimulator(PropertiesFile propertiesFile, Expression expression, Values values, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        if (this.getCurrentEngine() == PrismEngine.EXACT) {
            throw new PrismNotSupportedException("Simulation does not support exact computation");
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nSimulating: " + String.valueOf(expression));
        if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().getNumValues() > 0) {
            this.mainLog.println("Model constants: " + String.valueOf(this.getUndefinedModelValues()));
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + String.valueOf(values));
        }
        if (this.getModelType().nondeterministic() && this.getModelType().removeNondeterminism() != this.getModelType()) {
            this.mainLog.printWarning("For simulation, nondeterminism in " + String.valueOf((Object)this.getModelType()) + " is resolved uniformly (resulting in " + String.valueOf((Object)this.getModelType().removeNondeterminism()) + ").");
        }
        expression.checkValid(this.getModelType().removeNondeterminism());
        this.clearStrategy();
        this.loadModelIntoSimulator();
        Result result = this.getSimulator().modelCheckSingleProperty(propertiesFile, expression, state, l, simulationMethod);
        return result;
    }

    public Result[] modelCheckSimulatorSimultaneously(PropertiesFile propertiesFile, List<Expression> list, Values values, State state, long l, SimulationMethod simulationMethod) throws PrismException {
        if (this.getCurrentEngine() == PrismEngine.EXACT) {
            throw new PrismNotSupportedException("Simulation does not support exact computation");
        }
        this.mainLog.printSeparator();
        this.mainLog.print("\nSimulating");
        if (list.size() == 1) {
            this.mainLog.println(": " + String.valueOf(list.get(0)));
        } else {
            this.mainLog.println(" " + list.size() + " properties:");
            for (int i = 0; i < list.size(); ++i) {
                this.mainLog.println(" " + String.valueOf(list.get(i)));
            }
        }
        if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().getNumValues() > 0) {
            this.mainLog.println("Model constants: " + String.valueOf(this.getUndefinedModelValues()));
        }
        if (values != null && values.getNumValues() > 0) {
            this.mainLog.println("Property constants: " + String.valueOf(values));
        }
        if (this.getModelType().nondeterministic() && this.getModelType().removeNondeterminism() != this.getModelType()) {
            this.mainLog.printWarning("For simulation, nondeterminism in " + String.valueOf((Object)this.getModelType()) + " is resolved uniformly (resulting in " + String.valueOf((Object)this.getModelType().removeNondeterminism()) + ").");
        }
        for (Expression expression : list) {
            expression.checkValid(this.getModelType().removeNondeterminism());
        }
        this.clearStrategy();
        this.loadModelIntoSimulator();
        Result[] resultArray = this.getSimulator().modelCheckMultipleProperties(propertiesFile, list, state, l, simulationMethod);
        return resultArray;
    }

    public void modelCheckSimulatorExperiment(PropertiesFile propertiesFile, UndefinedConstants undefinedConstants, ResultsCollection resultsCollection, Expression expression, State state, long l, SimulationMethod simulationMethod) throws PrismException, InterruptedException {
        if (this.getCurrentEngine() == PrismEngine.EXACT) {
            throw new PrismNotSupportedException("Simulation does not support exact computation");
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nSimulating: " + String.valueOf(expression));
        if (this.getUndefinedModelValues() != null && this.getUndefinedModelValues().getNumValues() > 0) {
            this.mainLog.println("Model constants: " + String.valueOf(this.getUndefinedModelValues()));
        }
        this.mainLog.println("Property constants: " + undefinedConstants.getPFDefinedConstantsString());
        this.clearStrategy();
        this.loadModelIntoSimulator();
        this.getSimulator().modelCheckExperiment(propertiesFile, undefinedConstants, resultsCollection, expression, state, l, simulationMethod);
    }

    public void exportStrategy(StrategyExportOptions strategyExportOptions, File file) throws FileNotFoundException, PrismException {
        if (this.getStrategy() == null) {
            throw new PrismException("There is no current strategy to export");
        }
        this.exportStrategy(this.getStrategy(), strategyExportOptions, file);
    }

    public void exportStrategy(StrategyExportOptions.StrategyExportType strategyExportType, File file) throws FileNotFoundException, PrismException {
        this.exportStrategy(new StrategyExportOptions(strategyExportType), file);
    }

    public void exportStrategy(Strategy<?> strategy, StrategyExportOptions strategyExportOptions, File file) throws FileNotFoundException, PrismException {
        this.mainLog.print("\nExporting strategy " + strategyExportOptions.description() + " ");
        this.mainLog.println(Prism.getDestinationStringForFile(file));
        PrismLog prismLog = this.getPrismLogForFile(file);
        strategyExportOptions = strategyExportOptions.clone();
        strategyExportOptions.setModelPrecision(this.settings.getInteger("prism.exportModelPrecision"));
        strategy.export(prismLog, strategyExportOptions);
        if (file != null) {
            prismLog.close();
        }
    }

    public void exportStrategy(Strategy<?> strategy, StrategyExportOptions.StrategyExportType strategyExportType, File file) throws FileNotFoundException, PrismException {
        this.exportStrategy(strategy, new StrategyExportOptions(strategyExportType), file);
    }

    public void generateSimulationPath(String string, long l, File file) throws PrismException, PrismLangException {
        this.loadModelIntoSimulator();
        GenerateSimulationPath generateSimulationPath = new GenerateSimulationPath(this.getSimulator(), this.mainLog);
        generateSimulationPath.generateSimulationPath(null, string, l, file);
    }

    public void exportSteadyStateProbabilities(File file, ModelExportFormat modelExportFormat) throws PrismException {
        this.exportSteadyStateProbabilities(file, new ModelExportOptions(modelExportFormat), null);
    }

    public void exportSteadyStateProbabilities(File file, ModelExportFormat modelExportFormat, File file2) throws PrismException {
        this.exportSteadyStateProbabilities(file, new ModelExportOptions(modelExportFormat), file2);
    }

    public void exportSteadyStateProbabilities(File file, ModelExportOptions modelExportOptions, File file2) throws PrismException {
        StateVector stateVector = this.computeSteadyStateProbabilities(file2);
        this.mainLog.print("\nExporting steady-state probabilities ");
        this.mainLog.println(modelExportOptions.getFormat().description() + " " + Prism.getDestinationStringForFile(file));
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            stateVector.print(prismLog, file == null, modelExportOptions.getFormat() == ModelExportFormat.MATLAB, file == null, file == null);
        }
        stateVector.clear();
    }

    public StateVector computeSteadyStateProbabilities(File file) throws PrismException {
        StateVector stateVector;
        if (this.getModelType() != ModelType.CTMC && this.getModelType() != ModelType.DTMC) {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        if (this.getCurrentEngine() == PrismEngine.EXACT || this.getCurrentEngine() == PrismEngine.PARAM) {
            throw new PrismException("Steady-state probabilities cannot be computed with " + this.getCurrentEngine().description() + " engine");
        }
        this.mainLog.printSeparator();
        this.mainLog.println("\nComputing steady-state probabilities...");
        this.buildModelIfRequired();
        long l = System.currentTimeMillis();
        switch (this.getBuiltModelType().ordinal()) {
            case 0: {
                stateVector = this.computeSteadyStateProbabilities(this.getBuiltModelSymbolic(), file);
                break;
            }
            case 1: {
                stateVector = this.computeSteadyStateProbabilitiesExplicit(this.getBuiltModelExplicit(), file);
                break;
            }
            default: {
                throw new PrismException("Steady-state probability computation not supported for " + this.getBuiltModelType().description() + " models");
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for steady-state probability computation: " + (double)l / 1000.0 + " seconds.");
        return stateVector;
    }

    protected StateValues computeSteadyStateProbabilities(symbolic.model.Model model, File file) throws PrismException {
        ProbModelChecker probModelChecker;
        if (model.getModelType() == ModelType.DTMC) {
            probModelChecker = new ProbModelChecker(this, model, null);
        } else if (model.getModelType() == ModelType.CTMC) {
            probModelChecker = new StochModelChecker(this, model, null);
        } else {
            throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
        }
        return probModelChecker.doSteadyState(file);
    }

    protected explicit.StateValues computeSteadyStateProbabilitiesExplicit(explicit.Model<?> model, File file) throws PrismException {
        explicit.StateValues stateValues;
        switch (model.getModelType()) {
            case DTMC: {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
                stateValues = dTMCModelChecker.doSteadyState((DTMC<Double>)((DTMC)model), file);
                break;
            }
            case CTMC: {
                CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(this);
                stateValues = cTMCModelChecker.doSteadyState((CTMC<Double>)((CTMC)model), file);
                break;
            }
            default: {
                throw new PrismException("Steady-state probabilities only computed for DTMCs/CTMCs");
            }
        }
        return stateValues;
    }

    public void exportTransientProbabilities(double d, File file, ModelExportFormat modelExportFormat) throws PrismException {
        this.exportTransientProbabilities(d, file, new ModelExportOptions(modelExportFormat), null);
    }

    public void exportTransientProbabilities(double d, File file, ModelExportFormat modelExportFormat, File file2) throws PrismException {
        this.exportTransientProbabilities(d, file, new ModelExportOptions(modelExportFormat), file2);
    }

    public void exportTransientProbabilities(String string, File file, ModelExportOptions modelExportOptions, File file2) throws PrismException {
        String string2 = this.getModelType().continuousTime() ? "double" : "int";
        UndefinedConstants undefinedConstants = new UndefinedConstants(null, this.parsePropertiesString(null, "const " + string2 + " T; T;"));
        try {
            undefinedConstants.defineUsingConstSwitch("T=" + string);
        }
        catch (PrismException prismException) {
            if (string.contains(":")) {
                throw new PrismException("\"" + string + "\" is not a valid time range for a " + String.valueOf((Object)this.getModelType()));
            }
            throw new PrismException("\"" + string + "\" is not a valid time for a " + String.valueOf((Object)this.getModelType()));
        }
        this.exportTransientProbabilities(undefinedConstants, file, modelExportOptions, file2);
    }

    public void exportTransientProbabilities(double d, File file, ModelExportOptions modelExportOptions, File file2) throws PrismException {
        StateVector stateVector = this.computeTransientProbabilities(d, file2);
        this.mainLog.print("\nExporting transient probabilities ");
        this.mainLog.println(modelExportOptions.getFormat().description() + " " + Prism.getDestinationStringForFile(file));
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            stateVector.print(prismLog, file == null, modelExportOptions.getFormat() == ModelExportFormat.MATLAB, file == null, file == null);
        }
        stateVector.clear();
    }

    public StateVector computeTransientProbabilities(double d, File file) throws PrismException {
        StateVector stateVector;
        if (this.getModelType() != ModelType.CTMC && this.getModelType() != ModelType.DTMC) {
            throw new PrismException("Transient probabilities only computed for DTMCs/CTMCs");
        }
        if (this.getCurrentEngine() == PrismEngine.EXACT || this.getCurrentEngine() == PrismEngine.PARAM) {
            throw new PrismException("Transient probabilities cannot be computed with " + this.getCurrentEngine().description() + " engine");
        }
        if (d < 0.0) {
            throw new PrismException("Cannot compute transient probabilities for negative time value");
        }
        this.mainLog.printSeparator();
        String string = this.getModelType().continuousTime() ? Double.toString(d) : Integer.toString((int)d);
        this.mainLog.println("\nComputing transient probabilities (time = " + string + ")...");
        long l = System.currentTimeMillis();
        if (this.getModelType() == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
            if (file != null) {
                throw new PrismException("Fast adaptive uniformisation cannot read an initial distribution from a file");
            }
            ModulesFileModelGenerator<Double> modulesFileModelGenerator = ModulesFileModelGenerator.createForDoubles(this.getPRISMModel(), this);
            FastAdaptiveUniformisation fastAdaptiveUniformisation = new FastAdaptiveUniformisation(this, modulesFileModelGenerator);
            fastAdaptiveUniformisation.setConstantValues(this.getPRISMModel().getConstantValues());
            stateVector = fastAdaptiveUniformisation.doTransient(d);
        } else {
            this.buildModelIfRequired();
            switch (this.getBuiltModelType().ordinal()) {
                case 0: {
                    if (this.getModelType() == ModelType.DTMC) {
                        ProbModelChecker probModelChecker = new ProbModelChecker(this, this.getBuiltModelSymbolic(), null);
                        stateVector = probModelChecker.doTransient((int)d, file);
                        break;
                    }
                    StochModelChecker stochModelChecker = new StochModelChecker(this, this.getBuiltModelSymbolic(), null);
                    stateVector = stochModelChecker.doTransient(d, file);
                    break;
                }
                case 1: {
                    if (this.getModelType() == ModelType.DTMC) {
                        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
                        stateVector = dTMCModelChecker.doTransient((DTMC<Double>)((DTMC)this.getBuiltModelExplicit()), (int)d, file);
                        break;
                    }
                    CTMCModelChecker cTMCModelChecker = new CTMCModelChecker(this);
                    stateVector = cTMCModelChecker.doTransient((CTMC<Double>)((CTMC)this.getBuiltModelExplicit()), d, file);
                    break;
                }
                default: {
                    throw new PrismException("Transient probability computation not supported for " + this.getBuiltModelType().description() + " models");
                }
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
        return stateVector;
    }

    public void exportTransientProbabilities(UndefinedConstants undefinedConstants, File file, ModelExportOptions modelExportOptions, File file2) throws PrismException {
        if (this.getModelType() != ModelType.CTMC && this.getModelType() != ModelType.DTMC) {
            throw new PrismException("Transient probabilities only computed for DTMCs/CTMCs");
        }
        if (this.getCurrentEngine() == PrismEngine.EXACT || this.getCurrentEngine() == PrismEngine.PARAM) {
            throw new PrismException("Transient probabilities cannot be computed with " + this.getCurrentEngine().description() + " engine");
        }
        StateVector stateVector = null;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        explicit.StateValues stateValues3 = null;
        explicit.StateValues stateValues4 = null;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < undefinedConstants.getNumPropertyIterations(); ++i) {
            Object object;
            Object object2;
            Object object3 = undefinedConstants.getPFConstantValues().getValue(0);
            if (this.getModelType().continuousTime()) {
                d = (Double)object3;
            } else {
                n = (Integer)object3;
            }
            if (this.getModelType().continuousTime() ? (Double)object3 < 0.0 : (Integer)object3 < 0) {
                throw new PrismException("Cannot compute transient probabilities for negative time value");
            }
            this.mainLog.printSeparator();
            this.mainLog.println("\nComputing transient probabilities (time = " + String.valueOf(object3) + ")...");
            long l = System.currentTimeMillis();
            if (this.getModelType() == ModelType.CTMC && this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
                if (file2 != null) {
                    throw new PrismException("Fast adaptive uniformisation cannot read an initial distribution from a file");
                }
                object2 = ModulesFileModelGenerator.createForDoubles(this.getPRISMModel(), this);
                object = new FastAdaptiveUniformisation(this, (ModelGenerator<Double>)object2);
                ((FastAdaptiveUniformisation)object).setConstantValues(this.getPRISMModel().getConstantValues());
                if (i == 0) {
                    stateValues3 = ((FastAdaptiveUniformisation)object).doTransient(d);
                    stateVector = stateValues3;
                    d2 = 0.0;
                } else {
                    stateValues3 = ((FastAdaptiveUniformisation)object).doTransient(d - d2, stateValues3);
                    stateVector = stateValues3;
                }
            } else {
                this.buildModelIfRequired();
                switch (this.getBuiltModelType().ordinal()) {
                    case 0: {
                        if (this.getModelType().continuousTime()) {
                            object2 = new StochModelChecker(this, this.getBuiltModelSymbolic(), null);
                            if (i == 0) {
                                stateValues2 = ((ProbModelChecker)object2).readDistributionFromFile(file2);
                                d2 = 0.0;
                            }
                            stateValues = ((StochModelChecker)object2).doTransient(d - d2, stateValues2);
                            stateVector = stateValues;
                        } else {
                            object2 = new ProbModelChecker(this, this.getBuiltModelSymbolic(), null);
                            if (i == 0) {
                                stateValues2 = ((ProbModelChecker)object2).readDistributionFromFile(file2);
                                n2 = 0;
                            }
                            stateValues = ((ProbModelChecker)object2).doTransient(n - n2, stateValues2);
                            stateVector = stateValues;
                        }
                        if (stateValues2 == null) break;
                        stateValues2.clear();
                        break;
                    }
                    case 1: {
                        if (this.getModelType().continuousTime()) {
                            object2 = new CTMCModelChecker(this);
                            if (i == 0) {
                                stateValues4 = ((explicit.ProbModelChecker)object2).readDistributionFromFile(file2, this.getBuiltModelExplicit());
                                d2 = 0.0;
                            }
                            stateValues3 = ((CTMCModelChecker)object2).doTransient((CTMC<Double>)((CTMC)this.getBuiltModelExplicit()), d - d2, stateValues4);
                            stateVector = stateValues3;
                        } else {
                            object2 = new DTMCModelChecker(this);
                            if (i == 0) {
                                stateValues4 = ((explicit.ProbModelChecker)object2).readDistributionFromFile(file2, this.getBuiltModelExplicit());
                                n2 = 0;
                            }
                            stateValues3 = ((DTMCModelChecker)object2).doTransient((DTMC<Double>)((DTMC)this.getBuiltModelExplicit()), n - n2, stateValues4);
                            stateVector = stateValues3;
                        }
                        if (stateValues4 == null) break;
                        stateValues4.clear();
                        break;
                    }
                    default: {
                        throw new PrismException("Transient probability computation not supported for " + this.getBuiltModelType().description() + " models");
                    }
                }
            }
            l = System.currentTimeMillis() - l;
            this.mainLog.println("\nTime for transient probability computation: " + (double)l / 1000.0 + " seconds.");
            object2 = file != null && undefinedConstants.getNumPropertyIterations() > 1 ? new File(PrismUtils.addSuffixToFilename(file.getPath(), object3.toString())) : file;
            this.mainLog.print("\nExporting transient probabilities ");
            this.mainLog.println(modelExportOptions.getFormat().description() + " " + Prism.getDestinationStringForFile((File)object2));
            object = this.getPrismLogForFile((File)object2);
            try {
                if (!this.settings.getString("prism.transientMethod").equals("Fast adaptive uniformisation")) {
                    stateVector.print((PrismLog)object, file == null, modelExportOptions.getFormat() == ModelExportFormat.MATLAB, file == null, true);
                } else {
                    stateVector.print((PrismLog)object, file == null, modelExportOptions.getFormat() == ModelExportFormat.MATLAB, true, false);
                }
            }
            finally {
                if (object != null) {
                    ((PrismLog)object).close();
                }
            }
            stateValues2 = stateValues;
            stateValues4 = stateValues3;
            n2 = n;
            d2 = d;
            undefinedConstants.iterateProperty();
        }
        stateVector.clear();
    }

    public void explicitBuildTest() throws PrismException {
    }

    public void closeDown() {
        this.closeDown(true);
    }

    public void closeDown(boolean bl) {
        this.clearBuiltModel();
        PrismNative.closeDown();
        PrismMTBDD.closeDown();
        PrismSparse.closeDown();
        PrismHybrid.closeDown();
        ParamModelChecker.closeDown();
        if (this.cuddStarted) {
            JDD.CloseDownCUDD(bl);
            this.cuddStarted = false;
        }
    }

    private void setModelSource(ModelSource modelSource) throws PrismException {
        this.currentModelDetails.modelSource = modelSource;
    }

    private void setModelSourceIsDigitalClocks(boolean bl) throws PrismException {
        this.currentModelDetails.modelDigitalClocks = bl;
    }

    private void setModelType(ModelType modelType) throws PrismException {
        this.currentModelDetails.modelType = modelType;
    }

    private void setModelInfo(ModelInfo modelInfo) throws PrismException {
        this.currentModelDetails.modelInfo = modelInfo;
    }

    private void setPRISMModel(ModulesFile modulesFile) throws PrismException {
        this.currentModelDetails.modulesFile = modulesFile;
    }

    private void setModelGenerator(ModelGenerator modelGenerator) throws PrismException {
        this.currentModelDetails.modelGenerator = modelGenerator;
    }

    private void setRewardInfo(RewardInfo rewardInfo) throws PrismException {
        this.currentModelDetails.rewardInfo = rewardInfo;
    }

    private void setRewardGenerator(RewardGenerator rewardGenerator) throws PrismException {
        this.currentModelDetails.rewardGenerator = rewardGenerator;
    }

    private void setDefinedMFConstants(Values values) throws PrismException {
        this.setDefinedMFConstants(values, false);
    }

    private void setDefinedMFConstants(Values values, boolean bl) throws PrismException {
        this.currentModelDetails.definedMFConstants = values;
        this.currentModelDetails.definedMFConstantsAreExact = bl;
    }

    private void setBuiltModel(ModelBuildType modelBuildType, Model<?> model) throws PrismException {
        switch (modelBuildType.ordinal()) {
            case 0: {
                if (!(model instanceof symbolic.model.Model)) {
                    throw new PrismException("Attempt to store model of incorrect type");
                }
                this.currentModelDetails.model = model;
                this.currentModelDetails.modelSymb = (symbolic.model.Model)model;
                this.currentModelDetails.modelExpl = null;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (!(model instanceof explicit.Model)) {
                    throw new PrismException("Attempt to store model of incorrect type");
                }
                this.currentModelDetails.model = model;
                this.currentModelDetails.modelSymb = null;
                this.currentModelDetails.modelExpl = (explicit.Model)model;
                break;
            }
            default: {
                throw new PrismException("Unknown built model type");
            }
        }
        this.currentModelDetails.modelBuildType = modelBuildType;
    }

    private void clearBuiltModel() {
        this.currentModelDetails.model = null;
        if (this.currentModelDetails.modelSymb != null) {
            this.currentModelDetails.modelSymb.clear();
            this.currentModelDetails.modelSymb = null;
        }
        this.currentModelDetails.modelExpl = null;
        this.currentModelDetails.modelBuildType = null;
        this.clearStrategy();
    }

    private void clearStrategy() {
        if (this.strategy != null) {
            this.strategy.clear();
            this.strategy = null;
        }
    }

    private symbolic.comp.StateModelChecker createModelChecker(PropertiesFile propertiesFile) throws PrismException {
        if (propertiesFile == null) {
            propertiesFile = this.parsePropertiesString("");
        }
        symbolic.comp.StateModelChecker stateModelChecker = symbolic.comp.StateModelChecker.createModelChecker(this.getModelType(), this, this.getBuiltModelSymbolic(), propertiesFile);
        return stateModelChecker;
    }

    private StateModelChecker createModelCheckerExplicit(PropertiesFile propertiesFile) throws PrismException {
        StateModelChecker stateModelChecker = StateModelChecker.createModelChecker(this.getModelType(), this);
        stateModelChecker.setModelCheckingInfo(this.getModelInfo(), propertiesFile, this.getRewardGenerator());
        stateModelChecker.setExportTarget(this.exportTarget);
        stateModelChecker.setExportTargetFilename(this.exportTargetFilename);
        stateModelChecker.setExportProductTrans(this.exportProductTrans);
        stateModelChecker.setExportProductTransFilename(this.exportProductTransFilename);
        stateModelChecker.setExportProductStates(this.exportProductStates);
        stateModelChecker.setExportProductStatesFilename(this.exportProductStatesFilename);
        stateModelChecker.setExportProductVector(this.exportProductVector);
        stateModelChecker.setExportProductVectorFilename(this.exportProductVectorFilename);
        stateModelChecker.setStoreVector(this.storeVector);
        stateModelChecker.setGenStrat(this.genStrat);
        stateModelChecker.setRestrictStratToReach(this.restrictStratToReach);
        stateModelChecker.setDoBisim(this.doBisim);
        return stateModelChecker;
    }

    private static String getStringForExportType(int n) {
        switch (n) {
            case 1: {
                return "in plain text format";
            }
            case 2: {
                return "in Matlab format";
            }
            case 3: {
                return "in Dot format";
            }
            case 5: {
                return "in rows format";
            }
            case 6: {
                return "in Dot format (with states)";
            }
        }
        return "in ? format";
    }

    @Deprecated
    public void exportTransToFile(boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelTransitions(file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportStateRewardsToFile(int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelStateRewards(file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportTransRewardsToFile(boolean bl, int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelTransRewards(file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportStatesToFile(int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelStates(file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportObservationsToFile(int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelObservations(file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportLabelsToFile(PropertiesFile propertiesFile, int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelLabels(propertiesFile, file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportPropLabelsToFile(PropertiesFile propertiesFile, int n, File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelPropLabels(propertiesFile, file, Prism.convertExportType(n));
    }

    @Deprecated
    public void exportToDotFile(File file) throws FileNotFoundException, PrismException {
        this.exportBuiltModelTransitions(file, new ModelExportOptions(ModelExportFormat.DD_DOT));
    }

    @Deprecated
    public void exportBuiltModelCombined(File file, ModelExportOptions modelExportOptions) throws PrismException, FileNotFoundException {
        this.exportBuiltModel(file, modelExportOptions);
    }

    @Deprecated
    public void doSteadyState() throws PrismException {
        this.exportSteadyStateProbabilities(null, ModelExportFormat.EXPLICIT, null);
    }

    @Deprecated
    public void doSteadyState(int n, File file, File file2) throws PrismException {
        this.exportSteadyStateProbabilities(file, Prism.convertExportType(n), file2);
    }

    @Deprecated
    public void doTransient(double d) throws PrismException {
        this.exportTransientProbabilities(d, null, ModelExportFormat.EXPLICIT, null);
    }

    @Deprecated
    public void doTransient(double d, int n, File file, File file2) throws PrismException {
        this.exportTransientProbabilities(d, file, Prism.convertExportType(n), file2);
    }

    @Deprecated
    public void doTransient(UndefinedConstants undefinedConstants, int n, File file, File file2) throws PrismException {
        this.exportTransientProbabilities(undefinedConstants, file, Prism.convertExportType(n), file2);
    }

    public static int convertExportType(ModelExportOptions modelExportOptions) {
        switch (modelExportOptions.getFormat()) {
            case EXPLICIT: {
                return 1;
            }
            case MATLAB: {
                return 2;
            }
            case DOT: {
                return 3;
            }
        }
        return 1;
    }

    public static int convertExportTypeTrans(ModelExportOptions modelExportOptions) {
        switch (modelExportOptions.getFormat()) {
            case EXPLICIT: {
                return modelExportOptions.getExplicitRows() ? 5 : 1;
            }
            case MATLAB: {
                return 2;
            }
            case DOT: {
                return modelExportOptions.getShowStates() ? 6 : 3;
            }
        }
        return 1;
    }

    public static ModelExportOptions convertExportType(int n) {
        ModelExportOptions modelExportOptions = new ModelExportOptions();
        switch (n) {
            case 1: {
                modelExportOptions.setFormat(ModelExportFormat.EXPLICIT);
                break;
            }
            case 2: {
                modelExportOptions.setFormat(ModelExportFormat.MATLAB);
                break;
            }
            case 3: {
                modelExportOptions.setFormat(ModelExportFormat.DOT);
                modelExportOptions.setShowStates(false);
                break;
            }
            case 6: {
                modelExportOptions.setFormat(ModelExportFormat.DOT);
                modelExportOptions.setShowStates(true);
                break;
            }
            case 5: {
                modelExportOptions.setFormat(ModelExportFormat.EXPLICIT);
                modelExportOptions.setExplicitRows(true);
            }
        }
        return modelExportOptions;
    }

    @Deprecated
    public Result modelCheckExact(PropertiesFile propertiesFile, Property property) throws PrismException {
        boolean bl = this.settings.getBoolean("prism.exact.enabled");
        this.settings.set("prism.exact.enabled", Boolean.TRUE);
        Result result = this.modelCheck(propertiesFile, property);
        this.settings.set("prism.exact.enabled", bl);
        return result;
    }

    @Deprecated
    public Result modelCheckParametric(PropertiesFile propertiesFile, Property property, String[] stringArray, String[] stringArray2, String[] stringArray3) throws PrismException {
        boolean bl = this.param;
        String[] stringArray4 = this.paramNames;
        String[] stringArray5 = this.paramLowerBounds;
        String[] stringArray6 = this.paramUpperBounds;
        this.setParametric(stringArray, stringArray2, stringArray3);
        Result result = this.modelCheck(propertiesFile, property);
        if (bl) {
            this.setParametric(stringArray4, stringArray5, stringArray6);
        } else {
            this.setParametricOff();
        }
        return result;
    }

    private static /* synthetic */ String lambda$doExportBuiltModelLabels$0(LabelList labelList, int n) {
        return labelList.getLabelName(n);
    }

    public class ModelDetails {
        ModelSource modelSource = null;
        ModelType modelType = null;
        ModelInfo modelInfo = null;
        ModulesFile modulesFile = null;
        ModelGenerator<?> modelGenerator = null;
        RewardInfo rewardInfo = null;
        RewardGenerator<?> rewardGenerator = null;
        Values definedMFConstants = null;
        boolean definedMFConstantsAreExact = false;
        Model<?> model = null;
        symbolic.model.Model modelSymb = null;
        explicit.Model<?> modelExpl = null;
        ModelBuildType modelBuildType = null;
        boolean modelDigitalClocks = false;

        ModelDetails() {
        }

        ModelDetails(ModelDetails modelDetails) {
            this.modelSource = modelDetails.modelSource;
            this.modelType = modelDetails.modelType;
            this.modelInfo = modelDetails.modelInfo;
            this.modulesFile = modelDetails.modulesFile;
            this.modelGenerator = modelDetails.modelGenerator;
            this.rewardInfo = modelDetails.rewardInfo;
            this.rewardGenerator = modelDetails.rewardGenerator;
            this.definedMFConstants = modelDetails.definedMFConstants;
            this.definedMFConstantsAreExact = modelDetails.definedMFConstantsAreExact;
            this.model = modelDetails.model;
            this.modelSymb = modelDetails.modelSymb;
            this.modelExpl = modelDetails.modelExpl;
            this.modelBuildType = modelDetails.modelBuildType;
            this.modelDigitalClocks = modelDetails.modelDigitalClocks;
        }
    }

    public static enum ModelSource {
        PRISM_MODEL,
        MODEL_GENERATOR,
        EXPLICIT_FILES,
        BUILT_MODEL;


        public String description() {
            switch (this.ordinal()) {
                case 0: {
                    return "PRISM model";
                }
                case 1: {
                    return "model generator";
                }
                case 2: {
                    return "explicit files";
                }
                case 3: {
                    return "built model";
                }
            }
            return this.toString();
        }
    }

    public static enum ModelBuildType {
        SYMBOLIC,
        EXPLICIT,
        EXACT,
        PARAM;


        public String description() {
            switch (this.ordinal()) {
                case 0: {
                    return "symbolic";
                }
                case 1: {
                    return "explicit";
                }
                case 2: {
                    return "exact";
                }
                case 3: {
                    return "parametric";
                }
            }
            return this.toString();
        }
    }

    public static enum PrismEngine {
        SYMBOLIC,
        EXPLICIT,
        EXACT,
        PARAM;


        public String description() {
            switch (this.ordinal()) {
                case 0: {
                    return "symbolic";
                }
                case 1: {
                    return "explicit";
                }
                case 2: {
                    return "exact";
                }
                case 3: {
                    return "parametric";
                }
            }
            return this.toString();
        }
    }
}

