/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import pepa.compiler.InternalError;
import pepa.compiler.Main;
import prism.PrismException;
import prism.PrismLanguageTranslator;

public class PEPA2Prism
extends PrismLanguageTranslator {
    private File modelFile;

    @Override
    public String getName() {
        return "pepa";
    }

    @Override
    public void load(File file) throws PrismException {
        this.modelFile = file;
    }

    @Override
    public void load(String string) throws PrismException {
        try {
            this.modelFile = File.createTempFile("tempPepa" + System.currentTimeMillis(), ".pepa");
            FileWriter fileWriter = new FileWriter(this.modelFile);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            if (this.modelFile != null) {
                this.modelFile.delete();
                this.modelFile = null;
            }
            throw new PrismException("Couldn't create temporary file for PEPA conversion");
        }
    }

    @Override
    public void load(InputStream inputStream) throws PrismException {
        try {
            this.modelFile = File.createTempFile("tempPepa" + System.currentTimeMillis(), ".pepa");
            FileWriter fileWriter = new FileWriter(this.modelFile);
            int n = inputStream.read();
            while (n != -1) {
                fileWriter.write(n);
                n = inputStream.read();
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            if (this.modelFile != null) {
                this.modelFile.delete();
                this.modelFile = null;
            }
            throw new PrismException("Couldn't create temporary file for PEPA conversion");
        }
    }

    @Override
    public String translateToString() throws PrismException {
        String string = null;
        try {
            string = Main.compile(String.valueOf(this.modelFile));
        }
        catch (InternalError internalError) {
            throw new PrismException("Could not import PEPA model:\n" + internalError.getMessage());
        }
        return string;
    }

    @Override
    public void translate(PrintStream printStream) throws PrismException {
        printStream.print(this.translateToString());
    }
}

