/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import prism.Pair;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismSettings;

public class OptionsIntervalIteration {
    private BoundMethod boundMethod = BoundMethod.DEFAULT;
    private boolean boundComputationVerbose = false;
    private boolean resultSelectMidpoint = true;
    private boolean checkMonotonicity = false;
    private boolean enforceMonotonicityBelow = true;
    private boolean enforceMonotonicityAbove = true;
    private Double manualLowerBound = null;
    private Double manualUpperBound = null;
    private static final String boundMethodsList = "default, variant-1-coarse, variant-1-fine, variant-2, dsmpi";

    public OptionsIntervalIteration(String string) throws PrismException {
        this.fromOptionsString(string);
    }

    public static OptionsIntervalIteration from(PrismComponent prismComponent) throws PrismException {
        return OptionsIntervalIteration.from(prismComponent.getSettings());
    }

    public static OptionsIntervalIteration from(PrismSettings prismSettings) throws PrismException {
        return new OptionsIntervalIteration(prismSettings.getString("prism.intervalIterOptions"));
    }

    public static void validate(String string) throws PrismException {
        new OptionsIntervalIteration(string);
    }

    public BoundMethod getBoundMethod() {
        return this.boundMethod;
    }

    public boolean isBoundComputationVerbose() {
        return this.boundComputationVerbose;
    }

    public boolean isSelectMidpointForResult() {
        return this.resultSelectMidpoint;
    }

    public boolean isCheckMonotonicity() {
        return this.checkMonotonicity;
    }

    public boolean isEnforceMonotonicityFromBelow() {
        return this.enforceMonotonicityBelow;
    }

    public boolean isEnforceMonotonicityFromAbove() {
        return this.enforceMonotonicityAbove;
    }

    public boolean hasManualLowerBound() {
        return this.manualLowerBound != null;
    }

    public Double getManualLowerBound() {
        return this.manualLowerBound;
    }

    public boolean hasManualUpperBound() {
        return this.manualUpperBound != null;
    }

    public Double getManualUpperBound() {
        return this.manualUpperBound;
    }

    public static String getOptionsDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" boundmethod=<x>     Select upper bound heuristic for reward computations\n");
        stringBuffer.append("   <x> is one of default, variant-1-coarse, variant-1-fine, variant-2, dsmpi\n");
        stringBuffer.append(" lower=<d>           Manually specify lower bound for reward computations (double value)\n");
        stringBuffer.append(" upper=<d>           Manually specify upper bound for reward computations (double value)\n");
        stringBuffer.append(" [no]boundverbose    Verbose output for upper bound computations (default = no)\n");
        stringBuffer.append(" [no]selectmidpoint  Select midpoint between upper and lower as the result (default = yes)\n");
        stringBuffer.append(" [no]monotonicbelow  Enforce monotonicity in iteration from below (default = yes)\n");
        stringBuffer.append(" [no]monotonicabove  Enforce monotonicity in iteration from above (default = yes)\n");
        stringBuffer.append(" [no]checkmonotonic  Check monotonicity, for testing (default = no)\n");
        stringBuffer.append("\nExample: boundmethod=default,upper=3.0,noselectmidpoint,checkmonotonic\n");
        return stringBuffer.toString();
    }

    private void fromOptionsString(String string) throws PrismException {
        for (Map.Entry entry : OptionsIntervalIteration.splitOptionsString(string)) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            boolean bl = true;
            switch (string2) {
                case "boundverbose": 
                case "noboundverbose": {
                    this.boundComputationVerbose = !string2.startsWith("no");
                    break;
                }
                case "selectmidpoint": 
                case "noselectmidpoint": {
                    this.resultSelectMidpoint = !string2.startsWith("no");
                    break;
                }
                case "checkmonotonic": 
                case "nocheckmonotonic": {
                    this.checkMonotonicity = !string2.startsWith("no");
                    break;
                }
                case "monotonicbelow": 
                case "nomonotonicbelow": {
                    this.enforceMonotonicityBelow = !string2.startsWith("no");
                    break;
                }
                case "monotonicabove": 
                case "nomonotonicabove": {
                    this.enforceMonotonicityAbove = !string2.startsWith("no");
                    break;
                }
                case "lower": 
                case "upper": {
                    if (string3 == null) {
                        throw new PrismException("Missing argument to interval iteration option '" + string2 + "'");
                    }
                    try {
                        Object object = Double.parseDouble(string3);
                        if (string2.equals("lower")) {
                            this.manualLowerBound = object;
                        } else {
                            this.manualUpperBound = object;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PrismException("Illegal argument to interval iteration option '" + string2 + "': " + numberFormatException.getMessage());
                    }
                    bl = false;
                    break;
                }
                case "boundmethod": {
                    if (string3 == null) {
                        throw new PrismException("Missing argument to interval iteration option '" + string2 + "'");
                    }
                    switch (string3) {
                        case "default": {
                            this.boundMethod = BoundMethod.DEFAULT;
                            break;
                        }
                        case "variant-1-coarse": {
                            this.boundMethod = BoundMethod.VARIANT_1_COARSE;
                            break;
                        }
                        case "variant-1-fine": {
                            this.boundMethod = BoundMethod.VARIANT_1_FINE;
                            break;
                        }
                        case "variant-2": {
                            this.boundMethod = BoundMethod.VARIANT_2;
                            break;
                        }
                        case "dsmpi": {
                            this.boundMethod = BoundMethod.DSMPI;
                            break;
                        }
                        default: {
                            throw new PrismException("Unknown argument to interval iteration option '" + string2 + "', expected one of default, variant-1-coarse, variant-1-fine, variant-2, dsmpi");
                        }
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new PrismException("Unknown interval iteration option '" + string2 + "'");
                }
            }
            if (!bl || string3 == null) continue;
            throw new PrismException("Interval iteration option '" + string2 + "' has additional argument (" + string3 + "), but is boolean option");
        }
    }

    private static List<Pair<String, String>> splitOptionsString(String string) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        if ("".equals(string)) {
            return arrayList;
        }
        for (String string2 : string.split(",")) {
            int n = string2.indexOf("=");
            if (n == -1) {
                arrayList.add(new Pair<String, Object>(string2.trim(), null));
                continue;
            }
            arrayList.add(new Pair<String, String>(string2.substring(0, n).trim(), string2.substring(n + 1).trim()));
        }
        return arrayList;
    }

    public static enum BoundMethod {
        DEFAULT,
        VARIANT_1_COARSE,
        VARIANT_1_FINE,
        VARIANT_2,
        DSMPI;

    }
}

