/*
 * Decompiled with CFR 0.152.
 */
package prism;

public enum ModelType {
    CTMC("continuous-time Markov chain"){

        @Override
        public boolean choicesSumToOne() {
            return false;
        }

        @Override
        public boolean continuousTime() {
            return true;
        }

        @Override
        public boolean nondeterministic() {
            return false;
        }

        @Override
        public String probabilityOrRate() {
            return ModelType.RATE;
        }
    }
    ,
    CTMDP("continuous-time Markov decision process"){

        @Override
        public boolean choicesSumToOne() {
            return false;
        }

        @Override
        public boolean continuousTime() {
            return true;
        }

        @Override
        public String probabilityOrRate() {
            return ModelType.RATE;
        }

        @Override
        public ModelType removeNondeterminism() {
            return CTMC;
        }
    }
    ,
    DTMC("discrete-time Markov chain"){

        @Override
        public boolean nondeterministic() {
            return false;
        }
    }
    ,
    LTS("labelled transition system"){

        @Override
        public boolean isProbabilistic() {
            return false;
        }

        @Override
        public String probabilityOrRate() {
            return ModelType.NEITHER;
        }

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }
    }
    ,
    MDP("Markov decision process"){

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }
    }
    ,
    POMDP("partially observable Markov decision process"){

        @Override
        public boolean partiallyObservable() {
            return true;
        }

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }
    }
    ,
    POPTA("partially observable probabilistic timed automaton"){

        @Override
        public boolean continuousTime() {
            return true;
        }

        @Override
        public boolean realTime() {
            return true;
        }

        @Override
        public boolean partiallyObservable() {
            return true;
        }

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }
    }
    ,
    PTA("probabilistic timed automaton"){

        @Override
        public boolean continuousTime() {
            return true;
        }

        @Override
        public boolean realTime() {
            return true;
        }
    }
    ,
    STPG("stochastic two-player game"){

        @Override
        public boolean multiplePlayers() {
            return true;
        }

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }
    }
    ,
    SMG("stochastic multi-player game"){

        @Override
        public boolean multiplePlayers() {
            return true;
        }

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }
    }
    ,
    IDTMC("interval discrete-time Markov chain"){

        @Override
        public boolean nondeterministic() {
            return false;
        }

        @Override
        public boolean uncertain() {
            return true;
        }

        @Override
        public boolean intervals() {
            return true;
        }
    }
    ,
    UDTMC("uncertain discrete-time Markov chain"){

        @Override
        public boolean nondeterministic() {
            return false;
        }

        @Override
        public boolean uncertain() {
            return true;
        }
    }
    ,
    IMDP("interval Markov decision process"){

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }

        @Override
        public boolean uncertain() {
            return true;
        }

        @Override
        public boolean intervals() {
            return true;
        }
    }
    ,
    UMDP("uncertain Markov decision process"){

        @Override
        public ModelType removeNondeterminism() {
            return DTMC;
        }

        @Override
        public boolean uncertain() {
            return true;
        }
    };

    private static final String PROBABILITY = "Probability";
    private static final String RATE = "Rate";
    private static final String NEITHER = "";
    private final String fullName;

    private ModelType(String string2) {
        this.fullName = string2;
    }

    public String fullName() {
        return this.fullName;
    }

    public String keyword() {
        return this.name().toLowerCase();
    }

    public boolean choicesSumToOne() {
        return true;
    }

    public boolean continuousTime() {
        return false;
    }

    public boolean realTime() {
        return false;
    }

    public boolean nondeterministic() {
        return true;
    }

    public boolean multiplePlayers() {
        return false;
    }

    public boolean isProbabilistic() {
        return true;
    }

    public String probabilityOrRate() {
        return PROBABILITY;
    }

    public boolean partiallyObservable() {
        return false;
    }

    public boolean uncertain() {
        return false;
    }

    public boolean intervals() {
        return false;
    }

    public ModelType removeNondeterminism() {
        return this;
    }

    public static ModelType parseName(String string) {
        try {
            return ModelType.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

