/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.List;
import java.util.stream.Collectors;
import prism.ActionList;
import prism.ModelType;

public interface Model<Value> {
    public ModelType getModelType();

    default public List<Object> getActions() {
        return this.findActionsUsed();
    }

    default public List<String> getActionStrings() {
        return this.getActions().stream().map(ActionList::actionString).collect(Collectors.toList());
    }

    public List<Object> findActionsUsed();

    default public boolean onlyNullActionUsed() {
        return false;
    }

    default public int actionIndex(Object object) {
        return this.getActions().indexOf(object);
    }

    public int getNumStates();

    default public int getNumPlayers() {
        ModelType modelType = this.getModelType();
        return modelType.nondeterministic() ? (modelType == ModelType.STPG ? 2 : 1) : 0;
    }

    public int getNumInitialStates();

    public int getNumTransitions();

    default public boolean numStatesExceedsInt() {
        return false;
    }

    default public String getNumStatesString() {
        return Integer.toString(this.getNumStates());
    }

    default public String getNumInitialStatesString() {
        return Integer.toString(this.getNumStates());
    }

    default public String getNumTransitionsString() {
        return Integer.toString(this.getNumStates());
    }
}

