/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.VarList;
import parser.ast.DeclarationType;
import parser.type.Type;
import prism.ModelInfo;
import prism.ModelType;

public class BasicModelInfo
implements ModelInfo {
    private ModelType modelType;
    private VarList varList;
    private List<String> labelNameList;

    public BasicModelInfo(ModelType modelType) {
        this.modelType = modelType;
        this.varList = new VarList();
        this.labelNameList = new ArrayList<String>();
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void setVarList(VarList varList) {
        this.varList = varList;
    }

    public void setLabelNameList(List<String> list) {
        this.labelNameList = list;
    }

    public VarList getVarList() {
        return this.varList;
    }

    public List<String> getLabelNameList() {
        return this.labelNameList;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public List<String> getVarNames() {
        return IntStream.range(0, this.varList.getNumVars()).mapToObj(this.varList::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<Type> getVarTypes() {
        return IntStream.range(0, this.varList.getNumVars()).mapToObj(this.varList::getType).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public DeclarationType getVarDeclarationType(int n) {
        return this.varList.getDeclarationType(n);
    }

    @Override
    public List<String> getLabelNames() {
        return this.labelNameList;
    }
}

