/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import parser.ast.ASTElement;
import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionTemporal;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.visitor.SemanticCheck;
import prism.ModelInfo;
import prism.PrismLangException;

public class PropertiesSemanticCheck
extends SemanticCheck {
    private PropertiesFile propertiesFile;
    private ModelInfo modelInfo;
    private ModulesFile modulesFile;

    public PropertiesSemanticCheck(PropertiesFile propertiesFile) {
        this(propertiesFile, null);
    }

    public PropertiesSemanticCheck(PropertiesFile propertiesFile, ModelInfo modelInfo) {
        this.setPropertiesFile(propertiesFile);
        this.setModelInfo(modelInfo);
    }

    public void setPropertiesFile(PropertiesFile propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
        this.modulesFile = modelInfo instanceof ModulesFile ? (ModulesFile)modelInfo : null;
    }

    @Override
    public Object visit(FormulaList formulaList) throws PrismLangException {
        return null;
    }

    @Override
    public void visitPost(LabelList labelList) throws PrismLangException {
        int n = labelList.size();
        for (int i = 0; i < n; ++i) {
            String string = labelList.getLabelName(i);
            if ("deadlock".equals(string)) {
                throw new PrismLangException("Cannot define a label called \"deadlock\" - this is a built-in label", labelList.getLabel(i));
            }
            if (!"init".equals(string)) continue;
            throw new PrismLangException("Cannot define a label called \"init\" - this is a built-in label", labelList.getLabel(i));
        }
    }

    @Override
    public void visitPost(ConstantList constantList) throws PrismLangException {
        int n = constantList.size();
        for (int i = 0; i < n; ++i) {
            if (constantList.getConstant(i) == null || constantList.getConstant(i).isConstant()) continue;
            throw new PrismLangException("Definition of constant \"" + constantList.getConstantName(i) + "\" is not constant", constantList.getConstant(i));
        }
    }

    @Override
    public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
        int n = expressionTemporal.getOperator();
        Expression expression = expressionTemporal.getOperand1();
        Expression expression2 = expressionTemporal.getOperand2();
        Expression expression3 = expressionTemporal.getLowerBound();
        Expression expression4 = expressionTemporal.getUpperBound();
        if (expression3 != null && !expression3.isConstant()) {
            throw new PrismLangException("Lower bound in " + expressionTemporal.getOperatorSymbol() + " operator is not constant", expression3);
        }
        if (expression4 != null && !expression4.isConstant()) {
            throw new PrismLangException("Upper bound in " + expressionTemporal.getOperatorSymbol() + " operator is not constant", expression4);
        }
        if (n == 1 && (expression != null || expression2 == null || expression3 != null || expression4 != null)) {
            throw new PrismLangException("Cannot attach bounds to " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 11 && (expression != null || expression2 != null || expression3 != null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 12 && (expression != null || expression2 != null || expression3 != null || expression4 == null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
        if (n == 14 && (expression != null || expression2 != null || expression3 != null || expression4 != null)) {
            throw new PrismLangException("Badly formed " + expressionTemporal.getOperatorSymbol() + " operator", expressionTemporal);
        }
    }

    @Override
    public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
        if (expressionProb.getModifier() != null) {
            throw new PrismLangException("Modifier \"" + expressionProb.getModifier() + "\" not supported for P operator");
        }
        if (expressionProb.getProb() != null && !expressionProb.getProb().isConstant()) {
            throw new PrismLangException("P operator probability bound is not constant", expressionProb.getProb());
        }
    }

    @Override
    public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
        Object object;
        if (expressionReward.getModifier() != null) {
            throw new PrismLangException("Modifier \"" + expressionReward.getModifier() + "\" not supported for R operator");
        }
        if (expressionReward.getRewardStructIndex() != null) {
            if (expressionReward.getRewardStructIndex() instanceof Expression) {
                object = (Expression)expressionReward.getRewardStructIndex();
                if (!((Expression)object).isConstant()) {
                    throw new PrismLangException("R operator reward struct index is not constant", (ASTElement)object);
                }
            } else if (expressionReward.getRewardStructIndex() instanceof String) {
                object = (String)expressionReward.getRewardStructIndex();
                if (this.modulesFile != null && this.modulesFile.getRewardStructIndex((String)object) == -1) {
                    throw new PrismLangException("R operator reward struct index \"" + (String)object + "\" does not exist", expressionReward);
                }
            }
        }
        if (expressionReward.getRewardStructIndexDiv() != null) {
            if (expressionReward.getRewardStructIndexDiv() instanceof Expression) {
                object = (Expression)expressionReward.getRewardStructIndexDiv();
                if (!((Expression)object).isConstant()) {
                    throw new PrismLangException("R operator reward struct index is not constant", (ASTElement)object);
                }
            } else if (expressionReward.getRewardStructIndexDiv() instanceof String) {
                object = (String)expressionReward.getRewardStructIndexDiv();
                if (this.modulesFile != null && this.modulesFile.getRewardStructIndex((String)object) == -1) {
                    throw new PrismLangException("R operator reward struct index \"" + (String)object + "\" does not exist", expressionReward);
                }
            }
        }
        if (expressionReward.getReward() != null && !expressionReward.getReward().isConstant()) {
            throw new PrismLangException("R operator reward bound is not constant", expressionReward.getReward());
        }
    }

    @Override
    public void visitPost(ExpressionSS expressionSS) throws PrismLangException {
        if (expressionSS.getModifier() != null) {
            throw new PrismLangException("Modifier \"" + expressionSS.getModifier() + "\" not supported for S operator");
        }
        if (expressionSS.getProb() != null && !expressionSS.getProb().isConstant()) {
            throw new PrismLangException("S operator probability bound is not constant", expressionSS.getProb());
        }
    }

    @Override
    public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
        LabelList labelList;
        String string = expressionLabel.getName();
        if ("deadlock".equals(string) || "init".equals(string)) {
            return;
        }
        if (this.modelInfo != null && this.modelInfo.getLabelIndex(string) != -1) {
            return;
        }
        if (this.propertiesFile != null && (labelList = this.propertiesFile.getCombinedLabelList()) != null && labelList.getLabelIndex(string) != -1) {
            return;
        }
        throw new PrismLangException("Undeclared label", expressionLabel);
    }

    @Override
    public void visitPost(ExpressionFilter expressionFilter) throws PrismLangException {
        if (expressionFilter.getOperatorType() == null) {
            throw new PrismLangException("Unknown filter type \"" + expressionFilter.getOperatorName() + "\"", expressionFilter);
        }
    }
}

