/*
 * Decompiled with CFR 0.152.
 */
package parser.type;

import java.math.BigInteger;
import param.BigRational;
import parser.EvaluateContext;
import parser.ast.DeclarationDoubleUnbounded;
import parser.ast.DeclarationType;
import parser.type.Type;
import parser.type.TypeInt;
import prism.PrismLangException;

public class TypeDouble
extends Type {
    private static TypeDouble singleton = new TypeDouble();

    private TypeDouble() {
    }

    public static TypeDouble getInstance() {
        return singleton;
    }

    @Override
    public String getTypeString() {
        return "double";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object defaultValue() {
        return 0.0;
    }

    @Override
    public DeclarationType defaultDeclarationType() {
        return new DeclarationDoubleUnbounded();
    }

    @Override
    public boolean canCastTypeTo(Type type) {
        return type instanceof TypeDouble || type instanceof TypeInt;
    }

    @Override
    public Number castValueTo(Object object) throws PrismLangException {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigRational) {
            return (BigRational)object;
        }
        if (object instanceof Integer) {
            return (double)((Integer)object).intValue();
        }
        if (object instanceof BigInteger) {
            return new BigRational((BigInteger)object);
        }
        throw new PrismLangException("Can't convert " + String.valueOf(object.getClass()) + " to type " + this.getTypeString());
    }

    @Override
    public Number castValueTo(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (evalMode) {
            case FP: {
                if (object instanceof Double) {
                    return (Double)object;
                }
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                throw new PrismLangException("Cannot cast " + String.valueOf(object.getClass()) + " to " + this.getTypeString());
            }
            case EXACT: {
                if (object instanceof BigRational) {
                    return (BigRational)object;
                }
                if (object instanceof BigInteger) {
                    return new BigRational((BigInteger)object);
                }
                if (object instanceof Double) {
                    return new BigRational(object.toString());
                }
                if (object instanceof Integer) {
                    return new BigRational(((Integer)object).intValue());
                }
                throw new PrismLangException("Cannot cast " + String.valueOf(object.getClass()) + " to " + this.getTypeString());
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + String.valueOf((Object)evalMode));
    }

    public boolean equals(Object object) {
        return object instanceof TypeDouble;
    }
}

