/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.math.BigInteger;
import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.Type;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionLiteral
extends Expression {
    Object value;
    String string;

    public ExpressionLiteral(Type type, Object object) {
        this(type, object, String.valueOf(object));
    }

    public ExpressionLiteral(Type type, Object object, String string) {
        this.type = type;
        this.value = object;
        this.string = string;
    }

    public void setValue(Object object) {
        this.value = object;
        this.string = String.valueOf(object);
    }

    public void setString(String string) {
        this.string = string;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        if (evaluateContext.getEvaluationMode() == EvaluateContext.EvalMode.EXACT) {
            if (this.type instanceof TypeDouble) {
                if (this.value instanceof BigRational) {
                    return this.value;
                }
                return new BigRational(this.string);
            }
            if (this.type instanceof TypeInt) {
                if (this.value instanceof BigInteger) {
                    return this.value;
                }
                return new BigInteger(this.string);
            }
        }
        return this.getType().castValueTo(this.value, evaluateContext.getEvaluationMode());
    }

    @Override
    public boolean returnsSingleValue() {
        return true;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionLiteral deepCopy(DeepCopy deepCopy) {
        return this;
    }

    @Override
    public ExpressionLiteral clone() {
        return (ExpressionLiteral)super.clone();
    }

    @Override
    public String toString() {
        return this.string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.string == null ? 0 : this.string.hashCode());
        n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionLiteral expressionLiteral = (ExpressionLiteral)object;
        if (this.string == null ? expressionLiteral.string != null : !this.string.equals(expressionLiteral.string)) {
            return false;
        }
        return !(this.value == null ? expressionLiteral.value != null : !this.value.equals(expressionLiteral.value));
    }
}

