/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.ast.ASTElement;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class Declaration
extends ASTElement {
    protected String name;
    protected DeclarationType declType;
    protected Expression start;

    public Declaration(String string, DeclarationType declarationType) {
        this.setName(string);
        this.setDeclType(declarationType);
        this.setStart(null);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDeclType(DeclarationType declarationType) {
        this.declType = declarationType;
        this.setType(declarationType.getType());
    }

    public void setStart(Expression expression) {
        this.start = expression;
    }

    public String getName() {
        return this.name;
    }

    public DeclarationType getDeclType() {
        return this.declType;
    }

    public Expression getStart() {
        return this.start;
    }

    public Expression getStartOrDefault() {
        return this.isStartSpecified() ? this.start : this.declType.getDefaultStart();
    }

    public boolean isStartSpecified() {
        return this.start != null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + this.name + " : ";
        object = (String)object + String.valueOf(this.declType);
        if (this.start != null) {
            object = (String)object + " init " + String.valueOf(this.start);
        }
        return object;
    }

    @Override
    public Declaration deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.declType = deepCopy.copy(this.declType);
        this.start = deepCopy.copy(this.start);
        return this;
    }

    @Override
    public Declaration clone() {
        return (Declaration)super.clone();
    }
}

