/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import param.BigRational;
import param.Point;

final class Polynomial {
    private int numVariables;
    private BigInteger[] coefficients;
    private int[] exponents;
    private HashMap<Point, BigRational> pointsSeen;
    private int size;

    Polynomial(int n, int n2) {
        this.coefficients = new BigInteger[n2];
        this.exponents = new int[n2 * n];
        this.numVariables = n;
        this.pointsSeen = new HashMap();
        this.size = 0;
    }

    void addTerm(BigInteger bigInteger, ArrayList<Integer> arrayList) {
        this.coefficients[this.size] = bigInteger;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.exponents[this.numVariables * this.size + i] = arrayList.get(i);
        }
        ++this.size;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Polynomial)) {
            return false;
        }
        Polynomial polynomial = (Polynomial)object;
        if (this.numVariables != polynomial.numVariables) {
            return false;
        }
        if (this.coefficients.length != polynomial.coefficients.length) {
            return false;
        }
        for (n = 0; n < this.coefficients.length; ++n) {
            if (this.coefficients[n].equals(polynomial.coefficients[n])) continue;
            return false;
        }
        for (n = 0; n < this.exponents.length; ++n) {
            if (this.exponents[n] == polynomial.exponents[n]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int n2 = this.numVariables;
        for (n = 0; n < this.exponents.length; ++n) {
            n2 = this.exponents[n] + (n2 << 6) + (n2 << 16) - n2;
        }
        for (n = 0; n < this.coefficients.length; ++n) {
            n2 = this.coefficients[n].hashCode() + (n2 << 6) + (n2 << 16) - n2;
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.coefficients.length; ++i) {
            BigInteger bigInteger = this.coefficients[i];
            if (bigInteger.signum() > -1) {
                if (i != 0) {
                    stringBuilder.append(" + ");
                }
                stringBuilder.append(bigInteger);
            } else {
                if (i == 0) {
                    stringBuilder.append("-");
                } else {
                    stringBuilder.append(" - ");
                }
                stringBuilder.append(bigInteger.negate());
            }
            stringBuilder.append("*");
            for (int j = 0; j < this.numVariables; ++j) {
                int n = this.exponents[this.numVariables * i + j];
                stringBuilder.append("x");
                stringBuilder.append(j);
                stringBuilder.append("^");
                stringBuilder.append(n);
                if (j >= this.numVariables - 1) continue;
                stringBuilder.append("*");
            }
        }
        return stringBuilder.toString();
    }

    BigRational evaluate(Point point, boolean bl) {
        long l = System.currentTimeMillis();
        BigRational bigRational = this.pointsSeen.get(point);
        if (bigRational != null) {
            if (!bl) {
                l = System.currentTimeMillis() - l;
                return bigRational;
            }
            l = System.currentTimeMillis() - l;
            return bigRational.cancel();
        }
        bigRational = BigRational.ZERO;
        for (int i = 0; i < this.coefficients.length; ++i) {
            BigRational bigRational2 = new BigRational(this.coefficients[i]);
            for (int j = 0; j < this.numVariables; ++j) {
                BigRational bigRational3 = point.getDimension(j).pow(this.exponents[i * this.numVariables + j]);
                bigRational2 = bigRational2.multiply(bigRational3, bl);
            }
            bigRational = bigRational.add(bigRational2, bl);
        }
        this.pointsSeen.put(point, bigRational);
        l = System.currentTimeMillis() - l;
        return bigRational;
    }

    BigRational evaluate(Point point) {
        return this.evaluate(point, true);
    }

    boolean check(Point point, boolean bl) {
        BigRational bigRational = this.evaluate(point, false);
        int n = bigRational.signum();
        return bl ? n > 0 : n >= 0;
    }
}

