/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.ListIterator;
import param.Function;
import param.FunctionFactory;

final class MutablePMC {
    private FunctionFactory functionFactory;
    private Function[] rewards;
    private Function[] times;
    ArrayList<LinkedList<Function>> transitionProbs;
    ArrayList<LinkedList<Integer>> transitionTargets;
    ArrayList<LinkedList<Integer>> incoming;
    private boolean useRewards;
    private boolean useTime;
    private BitSet initStates;
    private BitSet targetStates;
    private int numStates;

    MutablePMC(FunctionFactory functionFactory, int n, boolean bl, boolean bl2) {
        int n2;
        this.numStates = n;
        this.functionFactory = functionFactory;
        this.transitionProbs = new ArrayList(n);
        this.transitionTargets = new ArrayList(n);
        this.incoming = new ArrayList(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.transitionTargets.add(new LinkedList());
            this.transitionProbs.add(new LinkedList());
            this.incoming.add(new LinkedList());
        }
        this.useRewards = bl;
        this.useTime = bl2;
        this.initStates = new BitSet(n);
        this.targetStates = new BitSet(n);
        if (bl) {
            this.rewards = new Function[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.rewards[n2] = functionFactory.getZero();
            }
        }
        if (bl2) {
            this.times = new Function[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.times[n2] = functionFactory.getOne();
            }
        }
    }

    FunctionFactory getFunctionFactory() {
        return this.functionFactory;
    }

    void addTransition(int n, int n2, Function function) {
        ListIterator listIterator = this.transitionTargets.get(n).listIterator();
        ListIterator<Function> listIterator2 = this.transitionProbs.get(n).listIterator();
        boolean bl = false;
        while (listIterator.hasNext() && !bl) {
            int n3 = (Integer)listIterator.next();
            Function function2 = (Function)listIterator2.next();
            if (n3 != n2) continue;
            listIterator2.set(function2.add(function));
            bl = true;
        }
        if (!bl) {
            this.transitionTargets.get(n).add(n2);
            this.transitionProbs.get(n).add(function);
            this.incoming.get(n2).add(n);
        }
    }

    Function getTransProb(int n, int n2) {
        Function function = null;
        ListIterator listIterator = this.transitionTargets.get(n).listIterator();
        ListIterator listIterator2 = this.transitionProbs.get(n).listIterator();
        while (listIterator.hasNext()) {
            int n3 = (Integer)listIterator.next();
            Function function2 = (Function)listIterator2.next();
            if (n3 != n2) continue;
            function = function2;
            break;
        }
        if (function == null) {
            function = this.functionFactory.getZero();
        }
        return function;
    }

    Function getSelfLoopProb(int n) {
        Function function = null;
        ListIterator listIterator = this.transitionTargets.get(n).listIterator();
        ListIterator listIterator2 = this.transitionProbs.get(n).listIterator();
        while (listIterator.hasNext()) {
            int n2 = (Integer)listIterator.next();
            Function function2 = (Function)listIterator2.next();
            if (n2 != n) continue;
            function = function2;
            break;
        }
        if (function == null) {
            function = this.functionFactory.getZero();
        }
        return function;
    }

    void makeAbsorbing(int n) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(n);
        LinkedList<Function> linkedList2 = new LinkedList<Function>();
        linkedList2.add(this.functionFactory.getOne());
        this.transitionTargets.set(n, linkedList);
        this.transitionProbs.set(n, linkedList2);
    }

    void setInitState(int n, boolean bl) {
        this.initStates.set(n, bl);
    }

    void setTargetState(int n, boolean bl) {
        this.targetStates.set(n, bl);
    }

    void setReward(int n, Function function) {
        this.rewards[n] = function;
    }

    void setTime(int n, Function function) {
        this.times[n] = function;
    }

    Function getTime(int n) {
        return this.times[n];
    }

    boolean isTargetState(int n) {
        return this.targetStates.get(n);
    }

    boolean hasTargetStates() {
        return this.targetStates.cardinality() != 0;
    }

    boolean isInitState(int n) {
        return this.initStates.get(n);
    }

    Function getReward(int n) {
        return this.rewards[n];
    }

    int getNumStates() {
        return this.numStates;
    }

    boolean isUseRewards() {
        return this.useRewards;
    }

    boolean isUseTime() {
        return this.useTime;
    }
}

