/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.Iterator;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2ba.MyBitSet;
import jltl2dstar.DA_State;
import jltl2dstar.DRA;
import jltl2dstar.NBA;
import jltl2dstar.NBA_State;
import prism.PrismException;

public class DBA2DRA {
    public static DRA dba2dra(NBA nBA, boolean bl) throws PrismException {
        APSet aPSet = nBA.getAPSet();
        DRA dRA = new DRA(aPSet);
        dRA.acceptance().newAcceptancePair();
        for (int i = 0; i < nBA.size(); ++i) {
            dRA.newState();
            if (bl) {
                if (nBA.get(i).isFinal()) {
                    dRA.acceptance().stateIn_U(0, i, true);
                }
                dRA.acceptance().stateIn_L(0, i, true);
                continue;
            }
            if (!nBA.get(i).isFinal()) continue;
            dRA.acceptance().stateIn_L(0, i, true);
        }
        if (nBA.getStartState() != null) {
            dRA.setStartState(dRA.get(nBA.getStartState().getName()));
        }
        DA_State dA_State = null;
        for (int i = 0; i < nBA.size(); ++i) {
            NBA_State nBA_State = nBA.get(i);
            DA_State dA_State2 = dRA.get(i);
            Iterator<APElement> iterator = aPSet.elementIterator();
            while (iterator.hasNext()) {
                APElement aPElement = iterator.next();
                MyBitSet myBitSet = nBA_State.getEdge(aPElement);
                int n = 0;
                if (myBitSet != null) {
                    n = myBitSet.cardinality();
                }
                DA_State dA_State3 = null;
                if (myBitSet == null || n == 0) {
                    if (dA_State == null) {
                        dA_State = dRA.newState();
                        if (bl) {
                            dA_State.acceptance().addTo_L(0);
                        }
                    }
                    dA_State3 = dA_State;
                } else if (n == 1) {
                    int n2 = myBitSet.nextSetBit(0);
                    dA_State3 = dRA.get(n2);
                } else {
                    throw new PrismException("NBA is no DBA!");
                }
                dA_State2.edges().put(aPElement, dA_State3);
            }
        }
        if (dA_State != null) {
            Iterator<APElement> iterator = aPSet.elementIterator();
            while (iterator.hasNext()) {
                dA_State.edges().put(iterator.next(), dA_State);
            }
        }
        return dRA;
    }
}

