/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2dstar.DA_State;
import jltl2dstar.DRA;
import jltl2dstar.RabinAcceptance;
import jltl2dstar.StateMapper;
import jltl2dstar.UnionAcceptanceCalculator;
import jltl2dstar.UnionNBA2DRA;
import jltl2dstar.UnionState;
import prism.PrismException;

public class DAUnionAlgorithm {
    private DRA _da_1;
    private DRA _da_2;
    private DRA _result_da;
    private UnionAcceptanceCalculator _acceptance_calculator;
    private boolean _detailed_states;

    public DAUnionAlgorithm(DRA dRA, DRA dRA2, boolean bl, boolean bl2) throws PrismException {
        this._da_1 = dRA;
        this._da_2 = dRA2;
        this._detailed_states = bl2;
        this._acceptance_calculator = new UnionAcceptanceCalculator(dRA.acceptance(), dRA2.acceptance());
        if (this._da_1.getAPSet() != this._da_2.getAPSet()) {
            throw new PrismException("Can't create union of DAs: APSets don't match");
        }
        APSet aPSet = dRA.getAPSet();
        if (!this._da_1.isCompact() || !this._da_2.isCompact()) {
            throw new PrismException("Can't create union of DAs: Not compact");
        }
        this._result_da = new DRA(aPSet);
    }

    DRA getResultDA() {
        return this._result_da;
    }

    public UnionState.Result delta(UnionState unionState, APElement aPElement) throws PrismException {
        DA_State dA_State = this._da_1.get(unionState.da_state_1).edges().get(aPElement);
        DA_State dA_State2 = this._da_2.get(unionState.da_state_2).edges().get(aPElement);
        UnionState unionState2 = this.createState(dA_State.getName(), dA_State2.getName());
        return new UnionState.Result(unionState2);
    }

    public UnionState getStartState() throws PrismException {
        if (this._da_1.getStartState() == null || this._da_2.getStartState() == null) {
            throw new PrismException("DA has no start state!");
        }
        return this.createState(this._da_1.getStartState().getName(), this._da_2.getStartState().getName());
    }

    public void prepareAcceptance(RabinAcceptance rabinAcceptance) {
        this._acceptance_calculator.prepareAcceptance(rabinAcceptance);
    }

    public boolean checkEmpty() {
        return false;
    }

    public static DRA calculateUnion(DRA dRA, DRA dRA2, boolean bl, boolean bl2) throws PrismException {
        if (!dRA.isCompact()) {
            dRA.makeCompact();
        }
        if (!dRA2.isCompact()) {
            dRA2.makeCompact();
        }
        DAUnionAlgorithm dAUnionAlgorithm = new DAUnionAlgorithm(dRA, dRA2, bl, bl2);
        UnionNBA2DRA unionNBA2DRA = new UnionNBA2DRA(bl2);
        unionNBA2DRA.convert(dAUnionAlgorithm, dAUnionAlgorithm.getResultDA(), 0, new StateMapper<UnionState.Result, UnionState, DA_State>());
        return dAUnionAlgorithm.getResultDA();
    }

    private UnionState createState(int n, int n2) {
        UnionState unionState = new UnionState(n, n2, this._acceptance_calculator);
        if (this._detailed_states) {
            Object object = "<TABLE BORDER=\"1\" CELLBORDER=\"0\"><TR><TD>";
            object = this._da_1.get(n).hasDescription() ? (String)object + this._da_1.get(n).getDescription() : (String)object + n;
            object = (String)object + "</TD><TD>U</TD><TD>";
            object = this._da_2.get(n2).hasDescription() ? (String)object + this._da_2.get(n2).getDescription() : (String)object + n2;
            object = (String)object + "</TD></TR></TABLE>";
            unionState.setDescription((String)object);
        }
        return unionState;
    }
}

