/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jltl2ba.APElement;
import jltl2ba.APSet;
import jltl2dstar.DA_State;
import jltl2dstar.RabinAcceptance;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class DA {
    private Vector<DA_State> _index;
    private APSet _ap_set;
    private DA_State _start_state;
    private boolean _is_compact;
    private String _comment;
    private RabinAcceptance _acceptance;

    public DA(APSet aPSet) {
        this._ap_set = aPSet;
        this._start_state = null;
        this._is_compact = true;
        this._comment = "";
        this._index = new Vector();
        this._acceptance = new RabinAcceptance();
    }

    public static DA newInstance(APSet aPSet) {
        return new DA(aPSet);
    }

    public DA_State newState() {
        DA_State dA_State = new DA_State(this);
        int n = this._index.size();
        dA_State.setName(n);
        this._index.add(dA_State);
        this._acceptance.addState(n);
        return dA_State;
    }

    public void constructEmpty() {
        DA_State dA_State = this.newState();
        this.setStartState(dA_State);
        Iterator<APElement> iterator = this.getAPSet().elementIterator();
        while (iterator.hasNext()) {
            dA_State.edges().put(iterator.next(), dA_State);
        }
    }

    public int size() {
        return this._index.size();
    }

    public Iterator<DA_State> iterator() {
        return this._index.iterator();
    }

    public DA_State get(int n) {
        return this._index.get(n);
    }

    public int getAPSize() {
        return this._ap_set.size();
    }

    public APSet getAPSet() {
        return this._ap_set;
    }

    public void switchAPSet(APSet aPSet) throws PrismException {
        if (aPSet.size() != this._ap_set.size()) {
            throw new PrismException("New APSet has to have the same size as the old APSet!");
        }
        this._ap_set = aPSet;
    }

    public int getIndexForState(DA_State dA_State) {
        return this._index.indexOf(dA_State);
    }

    public void setStartState(DA_State dA_State) {
        this._start_state = dA_State;
    }

    public DA_State getStartState() {
        return this._start_state;
    }

    public boolean isCompact() {
        return this._is_compact && this.acceptance().isCompact();
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public String getComment() {
        return this._comment;
    }

    public RabinAcceptance acceptance() {
        return this._acceptance;
    }

    public void makeCompact() throws PrismException {
        this.acceptance().makeCompact();
        if (!this._is_compact) {
            boolean bl = false;
            Vector<Integer> vector = new Vector<Integer>(this._index.size());
            int n = 0;
            for (int i = 0; i < this._index.size(); ++i) {
                if (this._index.get(i) != null) {
                    vector.set(i, n);
                    if (n != i) {
                        this._index.set(n, this._index.get(i));
                        this._index.set(i, null);
                        bl = true;
                    }
                    ++n;
                    continue;
                }
                while (this._index.get(i) == null && i < this._index.size()) {
                    ++i;
                }
                if (i < this._index.size()) break;
            }
            if (bl) {
                this._index.setSize(n);
                this.acceptance().moveStates(vector);
            }
            this._is_compact = true;
        }
    }

    public void print(String string, PrintStream printStream) throws PrismException {
        int n;
        if (!this.isCompact()) {
            throw new PrismException("DA is not compact!");
        }
        if (this.getStartState() == null) {
            throw new PrismException("No start state in DA!");
        }
        printStream.println(string + " v2 explicit");
        if (this._comment != "") {
            printStream.println("Comment: \"" + this._comment + "\"");
        }
        printStream.println("States: " + this._index.size());
        this._acceptance.outputAcceptanceHeader(printStream);
        int n2 = this.getStartState().getName();
        printStream.println("Start: " + n2);
        printStream.print("AP: " + this.getAPSize());
        for (n = 0; n < this.getAPSize(); ++n) {
            printStream.print(" \"" + this.getAPSet().getAP(n) + "\"");
        }
        printStream.println();
        printStream.println("---");
        for (n = 0; n < this._index.size(); ++n) {
            DA_State dA_State = this._index.get(n);
            printStream.print("State: " + n);
            if (dA_State.hasDescription()) {
                printStream.print(" \"" + dA_State.getDescription() + "\"");
            }
            printStream.println();
            this._acceptance.outputAcceptanceForState(printStream, n);
            Iterator<APElement> iterator = this._ap_set.elementIterator();
            while (iterator.hasNext()) {
                APElement aPElement = iterator.next();
                DA_State dA_State2 = dA_State.edges().get(aPElement);
                printStream.println(dA_State2.getName());
            }
        }
    }

    public void printHOA(String string, PrintStream printStream) throws PrismException {
        if (!string.equals("DRA")) {
            throw new PrismNotSupportedException("HOA printing for " + string + " currently not supported");
        }
        printStream.println("HOA: v1");
        printStream.println("States: " + this.size());
        this._ap_set.print_hoa(printStream);
        printStream.println("Start: " + this.getStartState().getName());
        this._acceptance.outputAcceptanceHeaderHOA(printStream);
        printStream.println("properties: trans-labels explicit-labels state-acc no-univ-branch deterministic");
        printStream.println("--BODY--");
        for (DA_State dA_State : this._index) {
            printStream.print("State: " + dA_State.getName() + " ");
            this._acceptance.outputAcceptanceForStateHOA(printStream, dA_State.getName());
            for (Map.Entry<APElement, DA_State> entry : dA_State.edges().entrySet()) {
                APElement aPElement = entry.getKey();
                String string2 = "[" + aPElement.toStringHOA(this._ap_set.size()) + "]";
                DA_State dA_State2 = entry.getValue();
                printStream.print(string2);
                printStream.print(" ");
                printStream.println(dA_State2);
            }
        }
        printStream.println("--END--");
    }

    public void printDot(String string, PrintStream printStream) throws PrismException {
        int n;
        if (!this.isCompact()) {
            throw new PrismException("DA is not compact!");
        }
        if (this.getStartState() == null) {
            throw new PrismException("No start state in DA!");
        }
        int n2 = this.getStartState().getName();
        printStream.println("digraph model {");
        for (n = 0; n < this._index.size(); ++n) {
            if (n == n2) {
                printStream.println("\t" + n + " [label=\"" + n + "\", shape=ellipse]");
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < this._acceptance.size(); ++i) {
                if (this._acceptance.isStateInAcceptance_L(i, n)) {
                    printStream.println("\t" + n + " [label=\"" + n + "\", shape=doublecircle]");
                    bl = true;
                    break;
                }
                if (!this._acceptance.isStateInAcceptance_U(i, n)) continue;
                printStream.println("\t" + n + " [label=\"" + n + "\", shape=box]");
                bl = true;
                break;
            }
            if (bl) continue;
            printStream.println("\t" + n + " [label=\"" + n + "\", shape=circle]");
        }
        for (n = 0; n < this._index.size(); ++n) {
            DA_State dA_State = this._index.get(n);
            for (Map.Entry<APElement, DA_State> entry : dA_State.edges().entrySet()) {
                printStream.println("\t" + n + " -> " + entry.getValue().getName() + " [label=\"" + entry.getKey().toString(this._ap_set, true) + "\"]");
            }
        }
        printStream.println("}");
    }
}

