/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.List;
import jdd.DebugJDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.JDDVectorConsumer;
import jdd.SanityJDD;
import prism.PrismLog;

public class JDD {
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int MIN = 5;
    public static final int MAX = 6;
    public static final int EQUALS = 7;
    public static final int NOTEQUALS = 8;
    public static final int GREATERTHAN = 9;
    public static final int GREATERTHANEQUALS = 10;
    public static final int LESSTHAN = 11;
    public static final int LESSTHANEQUALS = 12;
    public static final int FLOOR = 13;
    public static final int CEIL = 14;
    public static final int POW = 15;
    public static final int MOD = 16;
    public static final int LOGXY = 17;
    public static final int ZERO_ONE = 1;
    public static final int LOW = 2;
    public static final int NORMAL = 3;
    public static final int HIGH = 4;
    public static final int LIST = 5;
    public static final int CMU = 1;
    public static final int BOULDER = 2;
    public static JDDNode ZERO;
    public static JDDNode ONE;
    public static JDDNode PLUS_INFINITY;
    public static JDDNode MINUS_INFINITY;

    public static native long GetCUDDManager();

    private static native void DD_SetOutputStream(long var0);

    private static native long DD_GetOutputStream();

    private static native void DD_InitialiseCUDD();

    private static native void DD_InitialiseCUDD(long var0, double var2);

    private static native void DD_SetCUDDMaxMem(long var0);

    private static native void DD_SetCUDDEpsilon(double var0);

    private static native void DD_CloseDownCUDD(boolean var0);

    static native void DD_Ref(long var0);

    static native void DD_Deref(long var0);

    private static native void DD_PrintCacheInfo();

    private static native boolean DD_GetErrorFlag();

    private static native long DD_Create();

    private static native long DD_Constant(double var0);

    private static native long DD_PlusInfinity();

    private static native long DD_MinusInfinity();

    private static native long DD_Var(int var0);

    private static native long DD_Not(long var0);

    private static native long DD_Or(long var0, long var2);

    private static native long DD_And(long var0, long var2);

    private static native long DD_Xor(long var0, long var2);

    private static native long DD_Implies(long var0, long var2);

    private static native long DD_Apply(int var0, long var1, long var3);

    private static native long DD_MonadicApply(int var0, long var1);

    private static native long DD_Restrict(long var0, long var2);

    private static native long DD_ITE(long var0, long var2, long var4);

    private static native long DD_PermuteVariables(long var0, long var2, long var4, int var6);

    private static native long DD_SwapVariables(long var0, long var2, long var4, int var6);

    private static native long DD_VariablesGreaterThan(long var0, long var2, int var4);

    private static native long DD_VariablesGreaterThanEquals(long var0, long var2, int var4);

    private static native long DD_VariablesLessThan(long var0, long var2, int var4);

    private static native long DD_VariablesLessThanEquals(long var0, long var2, int var4);

    private static native long DD_VariablesEquals(long var0, long var2, int var4);

    private static native long DD_ThereExists(long var0, long var2, int var4);

    private static native long DD_ForAll(long var0, long var2, int var4);

    private static native long DD_SumAbstract(long var0, long var2, int var4);

    private static native long DD_ProductAbstract(long var0, long var2, int var4);

    private static native long DD_MinAbstract(long var0, long var2, int var4);

    private static native long DD_MaxAbstract(long var0, long var2, int var4);

    private static native long DD_GreaterThan(long var0, double var2);

    private static native long DD_GreaterThanEquals(long var0, double var2);

    private static native long DD_LessThan(long var0, double var2);

    private static native long DD_LessThanEquals(long var0, double var2);

    private static native long DD_Equals(long var0, double var2);

    private static native long DD_Interval(long var0, double var2, double var4);

    private static native long DD_RoundOff(long var0, int var2);

    private static native boolean DD_EqualSupNorm(long var0, long var2, double var4);

    private static native double DD_FindMin(long var0);

    private static native double DD_FindMinPositive(long var0);

    private static native double DD_FindMax(long var0);

    private static native double DD_FindMaxFinite(long var0);

    private static native long DD_RestrictToFirst(long var0, long var2, int var4);

    private static native boolean DD_IsZeroOneMTBDD(long var0);

    private static native int DD_GetNumNodes(long var0);

    private static native int DD_GetNumTerminals(long var0);

    private static native double DD_GetNumMinterms(long var0, int var2);

    private static native double DD_GetNumPaths(long var0);

    private static native void DD_PrintInfo(long var0, int var2);

    private static native void DD_PrintInfoBrief(long var0, int var2);

    private static native void DD_PrintSupport(long var0);

    private static native void DD_PrintSupportNames(long var0, List<String> var2);

    private static native long DD_GetSupport(long var0);

    private static native void DD_PrintTerminals(long var0);

    private static native void DD_PrintTerminalsAndNumbers(long var0, int var2);

    private static native long DD_SetVectorElement(long var0, long var2, int var4, long var5, double var7);

    private static native long DD_SetMatrixElement(long var0, long var2, int var4, long var5, int var7, long var8, long var10, double var12);

    private static native long DD_Set3DMatrixElement(long var0, long var2, int var4, long var5, int var7, long var8, int var10, long var11, long var13, long var15, double var17);

    private static native double DD_GetVectorElement(long var0, long var2, int var4, long var5);

    private static native long DD_Identity(long var0, long var2, int var4);

    private static native long DD_Transpose(long var0, long var2, long var4, int var6);

    private static native long DD_MatrixMultiply(long var0, long var2, long var4, int var6, int var7);

    private static native void DD_PrintVector(long var0, long var2, int var4, int var5);

    private static native void DD_PrintMatrix(long var0, long var2, int var4, long var5, int var7, int var8);

    private static native void DD_PrintVectorFiltered(long var0, long var2, long var4, int var6, int var7);

    private static native void DD_ExportDDToDotFile(long var0, String var2);

    private static native void DD_ExportDDToDotFileLabelled(long var0, String var2, List<String> var3);

    private static native void DD_ExportMatrixToPPFile(long var0, long var2, int var4, long var5, int var7, String var8);

    private static native void DD_Export3dMatrixToPPFile(long var0, long var2, int var4, long var5, int var7, long var8, int var10, String var11);

    private static native void DD_ExportMatrixToMatlabFile(long var0, long var2, int var4, long var5, int var7, String var8, String var9);

    private static native void DD_ExportMatrixToSpyFile(long var0, long var2, int var4, long var5, int var7, int var8, String var9);

    static native int DebugJDD_GetRefCount(long var0);

    static native long[] DebugJDD_GetExternalRefCounts();

    public static void SetOutputStream(long l) {
        JDD.DD_SetOutputStream(l);
    }

    public static long GetOutputStream() {
        return JDD.DD_GetOutputStream();
    }

    public static void InitialiseCUDD() {
        JDD.DD_InitialiseCUDD();
        ZERO = JDD.Constant(0.0);
        ONE = JDD.Constant(1.0);
        PLUS_INFINITY = JDD.PlusInfinity();
        MINUS_INFINITY = JDD.MinusInfinity();
    }

    public static void InitialiseCUDD(long l, double d) {
        JDD.DD_InitialiseCUDD(l, d);
        ZERO = JDD.Constant(0.0);
        ONE = JDD.Constant(1.0);
        PLUS_INFINITY = JDD.PlusInfinity();
        MINUS_INFINITY = JDD.MinusInfinity();
    }

    public static void SetCUDDMaxMem(long l) {
        JDD.DD_SetCUDDMaxMem(l);
    }

    public static void SetCUDDEpsilon(double d) {
        JDD.DD_SetCUDDEpsilon(d);
    }

    public static void CloseDownCUDD() {
        JDD.CloseDownCUDD(true);
    }

    public static void CloseDownCUDD(boolean bl) {
        JDD.Deref(ZERO);
        JDD.Deref(ONE);
        JDD.Deref(PLUS_INFINITY);
        JDD.Deref(MINUS_INFINITY);
        if (DebugJDD.debugEnabled) {
            DebugJDD.endLifeCycle();
        }
        JDD.DD_CloseDownCUDD(bl);
    }

    public static void Ref(JDDNode jDDNode) {
        long l = jDDNode.ptr();
        if (l == 0L) {
            throw new CuddOutOfMemoryException();
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.Ref(jDDNode);
        } else {
            JDD.DD_Ref(l);
        }
    }

    public static void Deref(JDDNode jDDNode) {
        long l = jDDNode.ptr();
        if (l == 0L) {
            throw new CuddOutOfMemoryException();
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.Deref(jDDNode);
        } else {
            JDD.DD_Deref(l);
        }
    }

    public static void Deref(JDDNode ... jDDNodeArray) {
        for (JDDNode jDDNode : jDDNodeArray) {
            JDD.Deref(jDDNode);
        }
    }

    public static void DerefNonNull(JDDNode jDDNode) {
        if (jDDNode != null) {
            JDD.Deref(jDDNode);
        }
    }

    public static void DerefNonNull(JDDNode ... jDDNodeArray) {
        for (JDDNode jDDNode : jDDNodeArray) {
            JDD.DerefNonNull(jDDNode);
        }
    }

    public static void DerefArray(JDDNode[] jDDNodeArray, int n) {
        if (n != jDDNodeArray.length) {
            throw new RuntimeException("Mismatch in length of dd array and expected length!");
        }
        for (JDDNode jDDNode : jDDNodeArray) {
            JDD.DerefNonNull(jDDNode);
        }
    }

    public static void DerefArrayNonNull(JDDNode[] jDDNodeArray) {
        if (jDDNodeArray != null) {
            JDD.DerefArray(jDDNodeArray, jDDNodeArray.length);
        }
    }

    public static void DerefArrayNonNull(JDDNode[] jDDNodeArray, int n) {
        if (jDDNodeArray != null) {
            JDD.DerefArray(jDDNodeArray, n);
        }
    }

    public static void PrintCacheInfo() {
        JDD.DD_PrintCacheInfo();
    }

    public static JDDNode Create() {
        return JDD.ptrToNode(JDD.DD_Create());
    }

    public static JDDNode Constant(double d) {
        if (Double.isInfinite(d)) {
            return d > 0.0 ? JDD.PlusInfinity() : JDD.MinusInfinity();
        }
        return JDD.ptrToNode(JDD.DD_Constant(d));
    }

    public static JDDNode PlusInfinity() {
        return JDD.ptrToNode(JDD.DD_PlusInfinity());
    }

    public static JDDNode MinusInfinity() {
        return JDD.ptrToNode(JDD.DD_MinusInfinity());
    }

    public static JDDNode Var(int n) {
        return JDD.ptrToNode(JDD.DD_Var(n));
    }

    public static JDDNode Not(JDDNode jDDNode) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_Not(jDDNode.ptr()));
    }

    public static JDDNode Or(JDDNode jDDNode, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsZeroOneMTBDD(jDDNode2);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_Or(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Or(JDDNode ... jDDNodeArray) {
        if (jDDNodeArray.length == 0) {
            return JDD.Constant(0.0);
        }
        JDDNode jDDNode = jDDNodeArray[0];
        for (int i = 1; i < jDDNodeArray.length; ++i) {
            jDDNode = JDD.Or(jDDNode, jDDNodeArray[i]);
        }
        return jDDNode;
    }

    public static JDDNode And(JDDNode jDDNode, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsZeroOneMTBDD(jDDNode2);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_And(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode And(JDDNode ... jDDNodeArray) {
        if (jDDNodeArray.length == 0) {
            return JDD.Constant(1.0);
        }
        JDDNode jDDNode = jDDNodeArray[0];
        for (int i = 1; i < jDDNodeArray.length; ++i) {
            jDDNode = JDD.And(jDDNode, jDDNodeArray[i]);
        }
        return jDDNode;
    }

    public static JDDNode Xor(JDDNode jDDNode, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsZeroOneMTBDD(jDDNode2);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_Xor(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Implies(JDDNode jDDNode, JDDNode jDDNode2) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_Implies(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Equiv(JDDNode jDDNode, JDDNode jDDNode2) {
        return JDD.Not(JDD.Xor(jDDNode, jDDNode2));
    }

    public static JDDNode Apply(int n, JDDNode jDDNode, JDDNode jDDNode2) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_Apply(n, jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode Times(JDDNode jDDNode, JDDNode ... jDDNodeArray) {
        JDDNode jDDNode2 = jDDNode;
        for (JDDNode jDDNode3 : jDDNodeArray) {
            jDDNode2 = JDD.Apply(3, jDDNode2, jDDNode3);
        }
        return jDDNode2;
    }

    public static JDDNode Plus(JDDNode jDDNode, JDDNode ... jDDNodeArray) {
        JDDNode jDDNode2 = jDDNode;
        for (JDDNode jDDNode3 : jDDNodeArray) {
            jDDNode2 = JDD.Apply(1, jDDNode2, jDDNode3);
        }
        return jDDNode2;
    }

    public static JDDNode Max(JDDNode jDDNode, JDDNode ... jDDNodeArray) {
        JDDNode jDDNode2 = jDDNode;
        for (JDDNode jDDNode3 : jDDNodeArray) {
            jDDNode2 = JDD.Apply(6, jDDNode2, jDDNode3);
        }
        return jDDNode2;
    }

    public static JDDNode Min(JDDNode jDDNode, JDDNode ... jDDNodeArray) {
        JDDNode jDDNode2 = jDDNode;
        for (JDDNode jDDNode3 : jDDNodeArray) {
            jDDNode2 = JDD.Apply(5, jDDNode2, jDDNode3);
        }
        return jDDNode2;
    }

    public static JDDNode MonadicApply(int n, JDDNode jDDNode) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_MonadicApply(n, jDDNode.ptr()));
    }

    public static JDDNode Restrict(JDDNode jDDNode, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_Restrict(jDDNode.ptr(), jDDNode2.ptr()));
    }

    public static JDDNode ITE(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
            DebugJDD.DD_Method_Argument(jDDNode3);
        }
        return JDD.ptrToNode(JDD.DD_ITE(jDDNode.ptr(), jDDNode2.ptr(), jDDNode3.ptr()));
    }

    public static boolean AreIntersecting(JDDNode jDDNode, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsZeroOneMTBDD(jDDNode2);
        }
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.And(jDDNode, jDDNode2);
        boolean bl = !jDDNode3.equals(ZERO);
        JDD.Deref(jDDNode3);
        return bl;
    }

    public static boolean IsContainedIn(JDDNode jDDNode, JDDNode jDDNode2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkIsZeroOneMTBDD(jDDNode2);
        }
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode3 = JDD.And(jDDNode, jDDNode2);
        boolean bl = jDDNode3.equals(jDDNode);
        JDD.Deref(jDDNode3);
        return bl;
    }

    public static JDDNode PermuteVariables(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_PermuteVariables(jDDNode.ptr(), jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode SwapVariables(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_SwapVariables(jDDNode.ptr(), jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesGreaterThan(JDDVars jDDVars, JDDVars jDDVars2) {
        return JDD.ptrToNode(JDD.DD_VariablesGreaterThan(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesGreaterThanEquals(JDDVars jDDVars, JDDVars jDDVars2) {
        return JDD.ptrToNode(JDD.DD_VariablesGreaterThanEquals(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesLessThan(JDDVars jDDVars, JDDVars jDDVars2) {
        return JDD.ptrToNode(JDD.DD_VariablesLessThan(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesLessThanEquals(JDDVars jDDVars, JDDVars jDDVars2) {
        return JDD.ptrToNode(JDD.DD_VariablesLessThanEquals(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode VariablesEquals(JDDVars jDDVars, JDDVars jDDVars2) {
        return JDD.ptrToNode(JDD.DD_VariablesEquals(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode ThereExists(JDDNode jDDNode, JDDVars jDDVars) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_ThereExists(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode ForAll(JDDNode jDDNode, JDDVars jDDVars) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_ForAll(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode SumAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_SumAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode ProductAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_ProductAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode MinAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_MinAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode MaxAbstract(JDDNode jDDNode, JDDVars jDDVars) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_MaxAbstract(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    public static JDDNode GreaterThan(JDDNode jDDNode, double d) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_GreaterThan(jDDNode.ptr(), d));
    }

    public static JDDNode GreaterThanEquals(JDDNode jDDNode, double d) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_GreaterThanEquals(jDDNode.ptr(), d));
    }

    public static JDDNode LessThan(JDDNode jDDNode, double d) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_LessThan(jDDNode.ptr(), d));
    }

    public static JDDNode LessThanEquals(JDDNode jDDNode, double d) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_LessThanEquals(jDDNode.ptr(), d));
    }

    public static JDDNode Equals(JDDNode jDDNode, double d) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_Equals(jDDNode.ptr(), d));
    }

    public static JDDNode Interval(JDDNode jDDNode, double d, double d2) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_Interval(jDDNode.ptr(), d, d2));
    }

    public static JDDNode RoundOff(JDDNode jDDNode, int n) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_RoundOff(jDDNode.ptr(), n));
    }

    public static boolean EqualSupNorm(JDDNode jDDNode, JDDNode jDDNode2, double d) {
        boolean bl = JDD.DD_EqualSupNorm(jDDNode.ptr(), jDDNode2.ptr(), d);
        JDD.checkForCuddError();
        return bl;
    }

    public static boolean IsZeroOneMTBDD(JDDNode jDDNode) {
        return JDD.DD_IsZeroOneMTBDD(jDDNode.ptr());
    }

    public static double FindMin(JDDNode jDDNode) {
        double d = JDD.DD_FindMin(jDDNode.ptr());
        JDD.checkForCuddError();
        return d;
    }

    public static double FindMinPositive(JDDNode jDDNode) {
        double d = JDD.DD_FindMinPositive(jDDNode.ptr());
        JDD.checkForCuddError();
        return d;
    }

    public static double FindMinOver(JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.ITE(jDDNode2, jDDNode.copy(), JDD.PlusInfinity());
        double d = JDD.FindMin(jDDNode3);
        JDD.Deref(jDDNode3);
        return d;
    }

    public static double FindMax(JDDNode jDDNode) {
        double d = JDD.DD_FindMax(jDDNode.ptr());
        JDD.checkForCuddError();
        return d;
    }

    public static double FindMaxFinite(JDDNode jDDNode) {
        double d = JDD.DD_FindMaxFinite(jDDNode.ptr());
        JDD.checkForCuddError();
        return d;
    }

    public static double FindMaxOver(JDDNode jDDNode, JDDNode jDDNode2) {
        JDDNode jDDNode3 = JDD.ITE(jDDNode2, jDDNode.copy(), JDD.MinusInfinity());
        double d = JDD.FindMax(jDDNode3);
        JDD.Deref(jDDNode3);
        return d;
    }

    public static JDDNode RestrictToFirst(JDDNode jDDNode, JDDVars jDDVars) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_RestrictToFirst(jDDNode.ptr(), jDDVars.array(), jDDVars.n()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double RestrictToFirstValue(JDDNode jDDNode, JDDNode jDDNode2) {
        double d;
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode2);
        }
        try {
            JDDNode jDDNode3 = jDDNode;
            JDDNode jDDNode4 = jDDNode2;
            while (!jDDNode3.isConstant()) {
                if (jDDNode4.isConstant()) {
                    throw new RuntimeException("Invalid filter");
                }
                boolean bl = jDDNode4.getElse().equals(ZERO);
                if (jDDNode3.getIndex() == jDDNode4.getIndex()) {
                    jDDNode3 = bl ? jDDNode3.getThen() : jDDNode3.getElse();
                } else if (jDDNode3.getIndex() < jDDNode4.getIndex()) {
                    throw new RuntimeException("Invalid filter");
                }
                jDDNode4 = bl ? jDDNode4.getThen() : jDDNode4.getElse();
            }
            d = jDDNode3.getValue();
        }
        catch (Throwable throwable) {
            JDD.Deref(jDDNode, jDDNode2);
            throw throwable;
        }
        JDD.Deref(jDDNode, jDDNode2);
        return d;
    }

    public static int GetNumNodes(JDDNode jDDNode) {
        int n = JDD.DD_GetNumNodes(jDDNode.ptr());
        JDD.checkForCuddError();
        return n;
    }

    public static int GetNumTerminals(JDDNode jDDNode) {
        int n = JDD.DD_GetNumTerminals(jDDNode.ptr());
        JDD.checkForCuddError();
        return n;
    }

    public static double GetNumMinterms(JDDNode jDDNode, int n) {
        double d = JDD.DD_GetNumMinterms(jDDNode.ptr(), n);
        JDD.checkForCuddError();
        return d;
    }

    public static String GetNumMintermsString(JDDNode jDDNode, int n) {
        double d = JDD.GetNumMinterms(jDDNode, n);
        if (d <= 9.223372036854776E18) {
            return "" + (long)d;
        }
        return "" + d;
    }

    public static double GetNumPaths(JDDNode jDDNode) {
        double d = JDD.DD_GetNumPaths(jDDNode.ptr());
        JDD.checkForCuddError();
        return d;
    }

    public static String GetNumPathsString(JDDNode jDDNode) {
        double d = JDD.GetNumPaths(jDDNode);
        if (d <= 9.223372036854776E18) {
            return "" + (long)d;
        }
        return "" + d;
    }

    public static boolean isSingleton(JDDNode jDDNode, JDDVars jDDVars) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsZeroOneMTBDD(jDDNode);
            SanityJDD.checkVarsAreSorted(jDDVars);
        }
        for (int i = 0; i < jDDVars.n(); ++i) {
            if (jDDNode.isConstant()) {
                return false;
            }
            if (jDDVars.getVar(i).getIndex() != jDDNode.getIndex()) {
                return false;
            }
            JDDNode jDDNode2 = jDDNode.getThen();
            JDDNode jDDNode3 = jDDNode.getElse();
            if (jDDNode2.equals(ZERO)) {
                jDDNode = jDDNode3;
                continue;
            }
            if (jDDNode3.equals(ZERO)) {
                jDDNode = jDDNode2;
                continue;
            }
            return false;
        }
        return jDDNode.equals(ONE);
    }

    public static void PrintInfo(JDDNode jDDNode, int n) {
        JDD.DD_PrintInfo(jDDNode.ptr(), n);
    }

    public static void PrintInfoBrief(JDDNode jDDNode, int n) {
        JDD.DD_PrintInfoBrief(jDDNode.ptr(), n);
    }

    public static String GetInfoString(JDDNode jDDNode, int n) {
        return JDD.GetNumNodes(jDDNode) + " nodes (" + JDD.GetNumTerminals(jDDNode) + " terminal), " + JDD.GetNumMintermsString(jDDNode, n) + " minterms";
    }

    public static String GetInfoBriefString(JDDNode jDDNode, int n) {
        return "[" + JDD.GetNumNodes(jDDNode) + "," + JDD.GetNumTerminals(jDDNode) + "," + JDD.GetNumMintermsString(jDDNode, n) + "]";
    }

    public static void PrintSupport(JDDNode jDDNode) {
        JDD.DD_PrintSupport(jDDNode.ptr());
    }

    public static void PrintSupportNames(JDDNode jDDNode, List<String> list) {
        JDD.DD_PrintSupportNames(jDDNode.ptr(), list);
    }

    public static JDDNode GetSupport(JDDNode jDDNode) {
        return JDD.ptrToNode(JDD.DD_GetSupport(jDDNode.ptr()));
    }

    public static void PrintTerminals(JDDNode jDDNode) {
        JDD.DD_PrintTerminals(jDDNode.ptr());
    }

    public static String GetTerminalsString(JDDNode jDDNode) {
        return JDD.GetTerminalsString(jDDNode, 0, false);
    }

    public static void PrintTerminalsAndNumbers(JDDNode jDDNode, int n) {
        JDD.DD_PrintTerminalsAndNumbers(jDDNode.ptr(), n);
    }

    public static String GetTerminalsAndNumbersString(JDDNode jDDNode, int n) {
        return JDD.GetTerminalsString(jDDNode, n, true);
    }

    public static String GetTerminalsString(JDDNode jDDNode, int n, boolean bl) {
        double d = 0.0;
        Object object = "";
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = jDDNode;
        double d2 = JDD.FindMin(jDDNode2);
        while (!jDDNode2.equals(MINUS_INFINITY)) {
            double d3 = JDD.FindMax(jDDNode2);
            object = (String)object + d3 + " ";
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = JDD.Equals(jDDNode2, d3);
            if (bl) {
                double d4 = JDD.GetNumMinterms(jDDNode3, n);
                d += d4;
                object = (String)object + "(" + (long)d4 + ") ";
            }
            jDDNode2 = JDD.ITE(jDDNode3, JDD.MinusInfinity(), jDDNode2);
        }
        JDD.Deref(jDDNode2);
        if (bl) {
            if (d < (double)(1 << n)) {
                object = (String)object + "-inf (" + ((double)(1 << n) - d) + ")";
            }
        } else if (d2 == Double.NEGATIVE_INFINITY) {
            object = (String)object + "-inf";
        }
        return object;
    }

    public static JDDNode SetVectorElement(JDDNode jDDNode, JDDVars jDDVars, long l, double d) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_SetVectorElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), l, d));
    }

    public static JDDNode SetMatrixElement(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, long l, long l2, double d) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_SetMatrixElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), l, l2, d));
    }

    public static JDDNode Set3DMatrixElement(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, long l, long l2, long l3, double d) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2, jDDVars3);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_Set3DMatrixElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), l, l2, l3, d));
    }

    public static double GetVectorElement(JDDNode jDDNode, JDDVars jDDVars, long l) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
        double d = JDD.DD_GetVectorElement(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), l);
        JDD.checkForCuddError();
        return d;
    }

    public static JDDNode Identity(JDDVars jDDVars, JDDVars jDDVars2) {
        if (SanityJDD.enabled) {
            SanityJDD.check(jDDVars.n() == jDDVars2.n(), "Mismatch of JDDVars sizes");
        }
        return JDD.ptrToNode(JDD.DD_Identity(jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode Transpose(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
        }
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
        }
        return JDD.ptrToNode(JDD.DD_Transpose(jDDNode.ptr(), jDDVars.array(), jDDVars2.array(), jDDVars.n()));
    }

    public static JDDNode MatrixMultiply(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, int n) {
        if (DebugJDD.debugEnabled) {
            DebugJDD.DD_Method_Argument(jDDNode);
            DebugJDD.DD_Method_Argument(jDDNode2);
        }
        return JDD.ptrToNode(JDD.DD_MatrixMultiply(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), n));
    }

    public static void PrintMinterms(PrismLog prismLog, JDDNode jDDNode) {
        JDD.PrintMinterms(prismLog, jDDNode, null);
    }

    public static void PrintMinterms(PrismLog prismLog, JDDNode jDDNode, String string) {
        JDDNode jDDNode2 = JDD.GetSupport(jDDNode);
        JDDVars jDDVars = JDDVars.fromCubeSet(jDDNode2);
        JDD.PrintMinterms(prismLog, jDDNode, jDDVars, string);
        jDDVars.derefAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PrintMinterms(PrismLog prismLog, JDDNode jDDNode, JDDVars jDDVars, String string) {
        try {
            if (string != null) {
                prismLog.println(string + ":");
            }
            prismLog.print(" Variables: (");
            boolean bl = true;
            for (JDDNode jDDNode2 : jDDVars) {
                if (!bl) {
                    prismLog.print(",");
                }
                bl = false;
                prismLog.print(jDDNode2.getIndex());
            }
            prismLog.println(")");
            Object object = new char[jDDVars.n()];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = 45;
            }
            JDD.PrintMintermsRec(prismLog, jDDNode, jDDVars, 0, (char[])object);
        }
        finally {
            JDD.Deref(jDDNode);
        }
    }

    private static void PrintMintermsRec(PrismLog prismLog, JDDNode jDDNode, JDDVars jDDVars, int n, char[] cArray) {
        if (jDDNode.isConstant()) {
            if (jDDNode.equals(ZERO)) {
                return;
            }
            prismLog.print(" |");
            for (char c : cArray) {
                prismLog.print(c);
            }
        } else {
            int n2 = jDDNode.getIndex();
            while (n < jDDVars.n()) {
                int n3 = jDDVars.getVar(n).getIndex();
                if (n3 == n2) {
                    cArray[n] = 48;
                    JDD.PrintMintermsRec(prismLog, jDDNode.getElse(), jDDVars, n + 1, cArray);
                    cArray[n] = 49;
                    JDD.PrintMintermsRec(prismLog, jDDNode.getThen(), jDDVars, n + 1, cArray);
                    cArray[n] = 45;
                    return;
                }
                if (n3 < n2) {
                    cArray[n] = 45;
                    ++n;
                    continue;
                }
                for (JDDNode jDDNode2 : jDDVars) {
                    if (jDDNode2.getIndex() != n2) continue;
                    throw new IllegalArgumentException("PrintMinterms: vars array does not appear to be sorted correctly (DD index = " + n2 + ", var index = " + n3 + ")");
                }
                throw new IllegalArgumentException("PrintMinterms: MTBDD depends on variable " + n2 + ", not included in vars");
            }
            if (jDDVars.n() == 0) {
                throw new IllegalArgumentException("PrintMinterms: MTBDD depends on variable " + n2 + ", not included in vars");
            }
            throw new UnsupportedOperationException("PrintMinterms: Implementation error");
        }
        prismLog.println("| = " + jDDNode.getValue());
    }

    public static void PrintVector(JDDNode jDDNode, JDDVars jDDVars) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
        JDD.DD_PrintVector(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), 3);
    }

    public static void PrintVector(JDDNode jDDNode, JDDVars jDDVars, int n) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
        JDD.DD_PrintVector(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), n);
    }

    public static void PrintMatrix(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
        }
        JDD.DD_PrintMatrix(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), 3);
    }

    public static void PrintMatrix(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
        }
        JDD.DD_PrintMatrix(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n);
    }

    public static void PrintVectorFiltered(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
            SanityJDD.checkIsDDOverVars(jDDNode2, jDDVars);
        }
        JDD.DD_PrintVectorFiltered(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), 3);
    }

    public static void PrintVectorFiltered(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, int n) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
            SanityJDD.checkIsDDOverVars(jDDNode2, jDDVars);
        }
        JDD.DD_PrintVectorFiltered(jDDNode.ptr(), jDDNode2.ptr(), jDDVars.array(), jDDVars.n(), n);
    }

    public static void TraverseVector(JDDNode jDDNode, JDDVars jDDVars, JDDVectorConsumer jDDVectorConsumer, int n) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars);
        }
        JDD.TraverseVectorRec(jDDNode, jDDVars, 0, 0L, jDDVectorConsumer, n);
    }

    private static void TraverseVectorRec(JDDNode jDDNode, JDDVars jDDVars, int n, long l, JDDVectorConsumer jDDVectorConsumer, int n2) {
        if (jDDNode.equals(ZERO)) {
            return;
        }
        if (n == jDDVars.getNumVars()) {
            jDDVectorConsumer.setElement(l, jDDNode.getValue(), n2);
        } else {
            JDD.Ref(jDDNode);
            JDD.Ref(jDDVars.getVar(n));
            JDDNode jDDNode2 = JDD.Restrict(jDDNode, JDD.Not(jDDVars.getVar(n)));
            JDD.Ref(jDDNode);
            JDD.Ref(jDDVars.getVar(n));
            JDDNode jDDNode3 = JDD.Restrict(jDDNode, jDDVars.getVar(n));
            JDD.TraverseVectorRec(jDDNode2, jDDVars, n + 1, l, jDDVectorConsumer, n2);
            JDD.TraverseVectorRec(jDDNode3, jDDVars, n + 1, l + (1L << jDDVars.getNumVars() - n - 1), jDDVectorConsumer, n2);
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode3);
        }
    }

    public static void ExportDDToDotFile(JDDNode jDDNode, String string) {
        JDD.DD_ExportDDToDotFile(jDDNode.ptr(), string);
    }

    public static void ExportDDToDotFileLabelled(JDDNode jDDNode, String string, List<String> list) {
        JDD.DD_ExportDDToDotFileLabelled(jDDNode.ptr(), string, list);
    }

    public static void ExportMatrixToPPFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, String string) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
            SanityJDD.check(jDDVars.n() == jDDVars2.n(), "Mismatch of JDDVars sizes");
        }
        JDD.DD_ExportMatrixToPPFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), string);
    }

    public static void Export3dMatrixToPPFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, String string) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2, jDDVars3);
            SanityJDD.check(jDDVars.n() == jDDVars2.n(), "Mismatch of JDDVars sizes");
        }
        JDD.DD_Export3dMatrixToPPFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), string);
    }

    public static void ExportMatrixToMatlabFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, String string, String string2) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
            SanityJDD.check(jDDVars.n() == jDDVars2.n(), "Mismatch of JDDVars sizes");
        }
        JDD.DD_ExportMatrixToMatlabFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), string, string2);
    }

    public static void ExportMatrixToSpyFile(JDDNode jDDNode, JDDVars jDDVars, JDDVars jDDVars2, int n, String string) {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars, jDDVars2);
            SanityJDD.check(jDDVars.n() == jDDVars2.n(), "Mismatch of JDDVars sizes");
        }
        JDD.DD_ExportMatrixToSpyFile(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), n, string);
    }

    public static JDDNode ptrToNode(long l) {
        if (l == 0L) {
            throw new CuddOutOfMemoryException();
        }
        if (DebugJDD.debugEnabled) {
            return DebugJDD.ptrToNode(l);
        }
        return new JDDNode(l);
    }

    public static void checkForCuddError() {
        if (JDD.DD_GetErrorFlag()) {
            throw new CuddOutOfMemoryException();
        }
    }

    static {
        try {
            System.loadLibrary("jdd");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }

    public static class CuddOutOfMemoryException
    extends RuntimeException {
        private static final long serialVersionUID = -3094099053041270477L;

        CuddOutOfMemoryException() {
            super("Out of memory (or other internal error) in the CUDD library");
        }
    }
}

