/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.ModelExportFormat;
import io.ModelExportOptions;
import java.io.File;
import parser.ast.PropertiesFile;
import prism.ModelInfo;
import prism.PrismException;

public class ModelExportTask {
    private ModelExportEntity entity;
    private File file;
    private ModelExportOptions exportOptions;
    private LabelExportSet labelExportSet = LabelExportSet.MODEL;
    private PropertiesFile extraLabelsSource;

    public ModelExportTask(ModelExportEntity modelExportEntity, File file) {
        this(modelExportEntity, file, new ModelExportOptions());
    }

    public ModelExportTask(ModelExportEntity modelExportEntity, File file, ModelExportOptions modelExportOptions) {
        this.entity = modelExportEntity;
        this.file = file;
        this.exportOptions = modelExportOptions;
    }

    public ModelExportTask(ModelExportEntity modelExportEntity, String string) {
        this(modelExportEntity, string, new ModelExportOptions());
    }

    public ModelExportTask(ModelExportEntity modelExportEntity, String string, ModelExportOptions modelExportOptions) {
        this.entity = modelExportEntity;
        this.file = "stdout".equals(string) ? null : new File(string);
        this.exportOptions = modelExportOptions;
    }

    public ModelExportTask(ModelExportTask modelExportTask) {
        this(modelExportTask, new ModelExportOptions(modelExportTask.exportOptions));
    }

    public ModelExportTask(ModelExportTask modelExportTask, ModelExportOptions modelExportOptions) {
        this.entity = modelExportTask.entity;
        this.file = modelExportTask.file;
        this.exportOptions = modelExportOptions;
        this.labelExportSet = modelExportTask.labelExportSet;
        this.extraLabelsSource = modelExportTask.extraLabelsSource;
    }

    public static ModelExportTask fromFilename(String string, String string2) throws PrismException {
        if (string2 == null || string2.equals("")) {
            return new ModelExportTask(ModelExportEntity.MODEL, string);
        }
        String string3 = "stdout".equals(string) ? "stdout" : string + "." + string2;
        switch (string2) {
            case "tra": {
                return new ModelExportTask(ModelExportEntity.MODEL, string3);
            }
            case "srew": {
                return new ModelExportTask(ModelExportEntity.STATE_REWARDS, string3);
            }
            case "trew": {
                return new ModelExportTask(ModelExportEntity.TRANSITION_REWARDS, string3);
            }
            case "sta": {
                return new ModelExportTask(ModelExportEntity.STATES, string3);
            }
            case "obs": {
                return new ModelExportTask(ModelExportEntity.OBSERVATIONS, string3);
            }
            case "lab": {
                return new ModelExportTask(ModelExportEntity.LABELS, string3);
            }
            case "dot": {
                return ModelExportTask.fromFormat(string3, ModelExportFormat.DOT);
            }
            case "drn": {
                return ModelExportTask.fromFormat(string3, ModelExportFormat.DRN);
            }
            case "m": {
                return ModelExportTask.fromFormat(string3, ModelExportFormat.MATLAB);
            }
        }
        return new ModelExportTask(ModelExportEntity.MODEL, string3);
    }

    public static ModelExportTask fromFormat(String string, ModelExportFormat modelExportFormat) throws PrismException {
        File file = "stdout".equals(string) ? null : new File(string);
        return ModelExportTask.fromOptions(file, new ModelExportOptions(modelExportFormat));
    }

    public static ModelExportTask fromFormat(File file, ModelExportFormat modelExportFormat) throws PrismException {
        return ModelExportTask.fromOptions(file, new ModelExportOptions(modelExportFormat));
    }

    public static ModelExportTask fromOptions(File file, ModelExportOptions modelExportOptions) throws PrismException {
        ModelExportTask modelExportTask;
        switch (modelExportOptions.getFormat()) {
            case EXPLICIT: 
            case MATLAB: {
                modelExportTask = new ModelExportTask(ModelExportEntity.MODEL, file);
                break;
            }
            case DOT: {
                modelExportTask = new ModelExportTask(ModelExportEntity.MODEL, file);
                modelExportTask.getExportOptions().setShowStates(true);
                break;
            }
            case DRN: {
                modelExportTask = new ModelExportTask(ModelExportEntity.MODEL, file);
                break;
            }
            default: {
                return null;
            }
        }
        modelExportTask.getExportOptions().apply(modelExportOptions);
        return modelExportTask;
    }

    public void setEntity(ModelExportEntity modelExportEntity) {
        this.entity = modelExportEntity;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExportOptions(ModelExportOptions modelExportOptions) {
        this.exportOptions = modelExportOptions;
    }

    public void setLabelExportSet(LabelExportSet labelExportSet) {
        this.labelExportSet = labelExportSet;
    }

    public void setExtraLabelsSource(PropertiesFile propertiesFile) {
        this.extraLabelsSource = propertiesFile;
    }

    public void replaceEmptyFileBasename(String string) {
        if (this.file != null && this.file.getName().matches("\\.[a-zA-Z]+")) {
            this.file = new File(string + this.file.getName());
        }
    }

    public ModelExportEntity getEntity() {
        return this.entity;
    }

    public boolean isApplicable(ModelInfo modelInfo) {
        return this.entity != ModelExportEntity.OBSERVATIONS || modelInfo.getModelType().partiallyObservable();
    }

    public File getFile() {
        return this.file;
    }

    public ModelExportOptions getExportOptions() {
        return this.exportOptions;
    }

    public LabelExportSet getLabelExportSet() {
        return this.labelExportSet;
    }

    public PropertiesFile getExtraLabelsSource() {
        return this.extraLabelsSource;
    }

    public boolean extraLabelsUsed() {
        return this.labelExportSet == LabelExportSet.EXTRA || this.labelExportSet == LabelExportSet.ALL;
    }

    public boolean initLabelIncluded() {
        return true;
    }

    public boolean deadlockLabelIncluded() {
        return true;
    }

    public String getMessage() {
        String string = "Exporting " + this.entity.description();
        string = string + " " + this.exportOptions.getFormat().description();
        string = string + " " + ModelExportTask.getDestinationStringForFile(this.file);
        return string;
    }

    private static String getDestinationStringForFile(File file) {
        return file == null ? "below:" : "to file \"" + String.valueOf(file) + "\"...";
    }

    public static enum ModelExportEntity {
        MODEL,
        STATE_REWARDS,
        TRANSITION_REWARDS,
        STATES,
        OBSERVATIONS,
        LABELS;


        public String description() {
            switch (this.ordinal()) {
                case 0: {
                    return "model";
                }
                case 1: {
                    return "state rewards";
                }
                case 2: {
                    return "transition rewards";
                }
                case 3: {
                    return "reachable states";
                }
                case 4: {
                    return "observations";
                }
                case 5: {
                    return "labels and satisfying states";
                }
            }
            return this.toString();
        }
    }

    public static enum LabelExportSet {
        MODEL,
        EXTRA,
        ALL;

    }
}

