/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.ModelExportFormat;
import java.util.Optional;

public class ModelExportOptions
implements Cloneable {
    private Optional<ModelExportFormat> format = Optional.empty();
    private Optional<Integer> modelPrecision = Optional.empty();
    private Optional<Boolean> showStates = Optional.empty();
    private Optional<Boolean> showActions = Optional.empty();
    private Optional<Boolean> printHeaders = Optional.empty();
    private Optional<Boolean> explicitRows = Optional.empty();

    public ModelExportOptions() {
    }

    public ModelExportOptions(ModelExportFormat modelExportFormat) {
        this.setFormat(modelExportFormat);
    }

    public ModelExportOptions(ModelExportOptions modelExportOptions) {
        this.apply(modelExportOptions);
    }

    public ModelExportOptions setFormat(ModelExportFormat modelExportFormat) {
        this.format = Optional.of(modelExportFormat);
        return this;
    }

    public ModelExportOptions setModelPrecision(int n) {
        this.modelPrecision = Optional.of(n);
        return this;
    }

    public ModelExportOptions setShowStates(boolean bl) {
        this.showStates = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setShowActions(boolean bl) {
        this.showActions = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setPrintHeaders(boolean bl) {
        this.printHeaders = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setExplicitRows(boolean bl) {
        this.explicitRows = Optional.of(bl);
        return this;
    }

    public void apply(ModelExportOptions modelExportOptions) {
        if (modelExportOptions.format.isPresent()) {
            this.setFormat(modelExportOptions.getFormat());
        }
        if (modelExportOptions.modelPrecision.isPresent()) {
            this.setModelPrecision(modelExportOptions.getModelPrecision());
        }
        if (modelExportOptions.showStates.isPresent()) {
            this.setShowStates(modelExportOptions.getShowStates());
        }
        if (modelExportOptions.showActions.isPresent()) {
            this.setShowActions(modelExportOptions.getShowActions());
        }
        if (modelExportOptions.printHeaders.isPresent()) {
            this.setPrintHeaders(modelExportOptions.getPrintHeaders());
        }
        if (modelExportOptions.explicitRows.isPresent()) {
            this.setExplicitRows(modelExportOptions.getExplicitRows());
        }
    }

    public ModelExportOptions applyTo(ModelExportOptions modelExportOptions) {
        ModelExportOptions modelExportOptions2 = modelExportOptions.clone();
        modelExportOptions2.apply(this);
        return modelExportOptions2;
    }

    public ModelExportFormat getFormat() {
        return this.format.orElse(ModelExportFormat.EXPLICIT);
    }

    public int getModelPrecision() {
        return this.modelPrecision.orElse(16);
    }

    public boolean getShowStates() {
        return this.showStates.orElse(true);
    }

    public boolean getShowActions() {
        return this.showActions.orElse(true);
    }

    public boolean getShowActions(boolean bl) {
        return this.showActions.orElse(bl);
    }

    public boolean getPrintHeaders() {
        return this.printHeaders.orElse(true);
    }

    public boolean getExplicitRows() {
        return this.explicitRows.orElse(false);
    }

    public ModelExportOptions clone() {
        try {
            return (ModelExportOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Object#clone is expected to work for Cloneable objects", cloneNotSupportedException);
        }
    }
}

