/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.modelviews.DTMCAlteredDistributions;
import explicit.modelviews.MDPView;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.PrismException;

public class MDPFromDTMC<Value>
extends MDPView<Value> {
    private DTMC<Value> model;

    public MDPFromDTMC(DTMC<Value> dTMC) {
        this.model = dTMC;
    }

    public MDPFromDTMC(MDPFromDTMC<Value> mDPFromDTMC) {
        super(mDPFromDTMC);
        this.model = mDPFromDTMC.model;
    }

    public MDPFromDTMC<Value> clone() {
        return new MDPFromDTMC<Value>(this);
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.model.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.model.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.model.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.model.isInitialState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.model.getStatesList();
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        return this.model.getConstantValues();
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.model.getLabelStates(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.model.getLabels();
    }

    @Override
    public boolean hasLabel(String string) {
        return this.model.hasLabel(string);
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n) {
        return this.model.getSuccessorsIterator(n);
    }

    @Override
    public int getNumChoices(int n) {
        return this.model.getTransitionsIterator(n).hasNext() ? 1 : 0;
    }

    @Override
    public Object getAction(int n, int n2) {
        if (n2 >= this.getNumChoices(n)) {
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
        return null;
    }

    @Override
    public boolean areAllChoiceActionsUnique() {
        return true;
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        if (n2 >= this.getNumChoices(n)) {
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
        return this.model.getSuccessorsIterator(n);
    }

    @Override
    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int n, int n2) {
        if (n2 > 0) {
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
        Iterator<Map.Entry<Integer, Value>> iterator = this.model.getTransitionsIterator(n);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException("choice index out of bounds");
        }
        return iterator;
    }

    @Override
    protected void fixDeadlocks() {
        block3: {
            assert (!this.fixedDeadlocks) : "deadlocks already fixed";
            try {
                this.model.findDeadlocks(false);
            }
            catch (PrismException prismException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"no attempt to fix deadlocks");
            }
        }
        this.model = DTMCAlteredDistributions.fixDeadlocks(this.model);
    }

    public static void main(String[] stringArray) throws PrismException {
        DTMCSimple<Double> dTMCSimple = new DTMCSimple<Double>(4);
        dTMCSimple.addInitialState(1);
        dTMCSimple.setProbability(0, 1, 0.1);
        dTMCSimple.setProbability(0, 2, 0.9);
        dTMCSimple.setProbability(1, 2, 0.2);
        dTMCSimple.setProbability(1, 3, 0.8);
        dTMCSimple.setProbability(2, 1, 0.3);
        dTMCSimple.setProbability(2, 2, 0.7);
        dTMCSimple.findDeadlocks(false);
        System.out.println(dTMCSimple);
        MDPFromDTMC mDPFromDTMC = new MDPFromDTMC(dTMCSimple);
        mDPFromDTMC.findDeadlocks(true);
        System.out.println(mDPFromDTMC);
    }
}

