/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import common.IntSet;
import common.Interval;
import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.Distribution;
import explicit.IMDPSimple;
import explicit.IterationMethod;
import explicit.IterationMethodGS;
import explicit.IterationMethodPower;
import explicit.LTLModelChecker;
import explicit.MDPModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.ProbModelChecker;
import explicit.StateValues;
import explicit.UMDP;
import explicit.Utils;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;
import java.util.BitSet;
import parser.ast.Expression;
import prism.AccuracyFactory;
import prism.Evaluator;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import strat.FMDStrategyProduct;
import strat.FMDStrategyStep;
import strat.MDStrategy;
import strat.MDStrategyArray;
import strat.Strategy;

public class UMDPModelChecker
extends ProbModelChecker {
    protected MDPModelChecker mcMDP = new MDPModelChecker(this);

    public UMDPModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        this.mcMDP.inheritSettings(this);
    }

    @Override
    protected StateValues checkProbPathFormulaCosafeLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<UMDP> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyProbLTL(this, (UMDP)model, expression, bitSet);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability probabilities...");
        UMDPModelChecker uMDPModelChecker = new UMDPModelChecker(this);
        uMDPModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = uMDPModelChecker.computeReachProbs((UMDP)lTLProduct.getProductModel(), bitSet2, minMax);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        if (modelCheckerResult.strat != null) {
            object = new FMDStrategyProduct(lTLProduct, (MDStrategy)modelCheckerResult.strat);
            this.result.setStrategy((Strategy<?>)object);
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    @Override
    protected StateValues checkRewardCoSafeLTL(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<UMDP> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyReward(this, (UMDP)model, expression, bitSet);
        Rewards rewards2 = ((MDPRewards)rewards).liftFromModel(lTLProduct);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        UMDPModelChecker uMDPModelChecker = new UMDPModelChecker(this);
        uMDPModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = uMDPModelChecker.computeReachRewards((UMDP)lTLProduct.getProductModel(), (MDPRewards<Double>)rewards2, bitSet2, minMax);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        if (modelCheckerResult.strat != null) {
            object = new FMDStrategyProduct(lTLProduct, (MDStrategy)modelCheckerResult.strat);
            this.result.setStrategy((Strategy<?>)object);
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    public ModelCheckerResult computeNextProbs(UMDP<Double> uMDP, BitSet bitSet, MinMax minMax) throws PrismException {
        long l = System.currentTimeMillis();
        uMDP.checkLowerBoundsArePositive();
        int n = uMDP.getNumStates();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(n).iterator();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        uMDP.mvMultUnc(dArray, minMax, dArray2, ofInt, null);
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        l = System.currentTimeMillis() - l;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeBoundedReachProbs(UMDP<Double> uMDP, BitSet bitSet, int n, MinMax minMax) throws PrismException {
        return this.computeBoundedUntilProbs(uMDP, null, bitSet, n, minMax);
    }

    public ModelCheckerResult computeBoundedUntilProbs(UMDP<Double> uMDP, BitSet bitSet, BitSet bitSet2, int n, MinMax minMax) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        int[] nArray = null;
        FMDStrategyStep<Double> fMDStrategyStep = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting bounded probabilistic reachability...");
        uMDP.checkLowerBoundsArePositive();
        int n3 = uMDP.getNumStates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        if (this.genStrat) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = bitSet2.get(n2) ? -2 : -1;
            }
            fMDStrategyStep = new FMDStrategyStep<Double>(uMDP, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
            dArray[n2] = dArray2[n2];
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n3);
        bitSet3.andNot(bitSet2);
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        IntSet intSet = IntSet.asIntSet(bitSet3);
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            uMDP.mvMultUnc(dArray, minMax, dArray2, intSet.iterator(), nArray);
            if (this.genStrat) {
                fMDStrategyStep.setStepChoices(n - n4, nArray);
            }
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Bounded probabilistic reachability");
        this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        if (this.genStrat) {
            modelCheckerResult.strat = fMDStrategyStep;
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachProbs(UMDP<Double> uMDP, BitSet bitSet, MinMax minMax) throws PrismException {
        return this.computeReachProbs(uMDP, null, bitSet, minMax);
    }

    public ModelCheckerResult computeUntilProbs(UMDP<Double> uMDP, BitSet bitSet, BitSet bitSet2, MinMax minMax) throws PrismException {
        return this.computeReachProbs(uMDP, bitSet, bitSet2, minMax);
    }

    public ModelCheckerResult computeReachProbs(UMDP<Double> uMDP, BitSet bitSet, BitSet bitSet2, MinMax minMax) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int[] nArray = null;
        ProbModelChecker.IMDPSolnMethod iMDPSolnMethod = this.imdpSolnMethod;
        switch (iMDPSolnMethod) {
            case VALUE_ITERATION: 
            case GAUSS_SEIDEL: {
                break;
            }
            default: {
                iMDPSolnMethod = ProbModelChecker.IMDPSolnMethod.GAUSS_SEIDEL;
                this.mainLog.printWarning("Switching to solution method \"" + iMDPSolnMethod.fullName() + "\"");
            }
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting probabilistic reachability...");
        uMDP.checkLowerBoundsArePositive();
        uMDP.checkForDeadlocks(bitSet2);
        int n = uMDP.getNumStates();
        if (this.genStrat) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = bitSet2.get(i) ? -2 : -1;
            }
        }
        BitSet bitSet3 = this.precomp && this.prob0 ? this.mcMDP.prob0(uMDP, bitSet, bitSet2, minMax.isMin(), nArray) : new BitSet();
        BitSet bitSet4 = this.precomp && this.prob1 ? this.mcMDP.prob1(uMDP, bitSet, bitSet2, minMax.isMin(), nArray) : (BitSet)bitSet2.clone();
        int n2 = bitSet4.cardinality();
        int n3 = bitSet3.cardinality();
        this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n2 + ", no=" + n3 + ", maybe=" + (n - (n2 + n3)));
        if (this.genStrat) {
            int n4;
            if (minMax.isMin()) {
                n4 = bitSet4.nextSetBit(0);
                while (n4 >= 0) {
                    if (!bitSet2.get(n4)) {
                        nArray[n4] = -2;
                    }
                    n4 = bitSet4.nextSetBit(n4 + 1);
                }
            } else {
                n4 = bitSet3.nextSetBit(0);
                while (n4 >= 0) {
                    nArray[n4] = -2;
                    n4 = bitSet3.nextSetBit(n4 + 1);
                }
            }
        }
        l = System.currentTimeMillis();
        Object object = minMax.isMin() ? "min" : "max";
        object = (String)object + (minMax.isMinUnc() ? "min" : "max");
        this.mainLog.println("Starting value iteration (" + (String)object + ")...");
        n = uMDP.getNumStates();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bitSet4.get(i) ? 1.0 : (bitSet3.get(i) ? 0.0 : 0.0);
        }
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, n);
        bitSet5.andNot(bitSet4);
        bitSet5.andNot(bitSet3);
        if (n2 + n3 < n) {
            IterationMethod iterationMethod = null;
            switch (iMDPSolnMethod) {
                case VALUE_ITERATION: {
                    iterationMethod = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
                    break;
                }
                case GAUSS_SEIDEL: {
                    iterationMethod = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
                    break;
                }
                default: {
                    throw new PrismException("Unknown solution method " + iMDPSolnMethod.fullName());
                }
            }
            IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultMinMaxUnc(uMDP, minMax, nArray);
            iterationValIter.init(dArray);
            IntSet intSet = IntSet.asIntSet(bitSet5);
            String string = (String)object + ", with " + iterationMethod.getDescriptionShort();
            modelCheckerResult = iterationMethod.doValueIteration(this, string, iterationValIter, intSet, l, null);
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet4, n);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(uMDP, nArray);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(UMDP<Double> uMDP, MDPRewards<Double> mDPRewards, BitSet bitSet, MinMax minMax) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n;
        int[] nArray = null;
        ProbModelChecker.IMDPSolnMethod iMDPSolnMethod = this.imdpSolnMethod;
        switch (iMDPSolnMethod) {
            case VALUE_ITERATION: 
            case GAUSS_SEIDEL: {
                break;
            }
            default: {
                iMDPSolnMethod = ProbModelChecker.IMDPSolnMethod.GAUSS_SEIDEL;
                this.mainLog.printWarning("Switching to solution method \"" + iMDPSolnMethod.fullName() + "\"");
            }
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected reachability...");
        uMDP.checkLowerBoundsArePositive();
        uMDP.checkForDeadlocks(bitSet);
        int n2 = uMDP.getNumStates();
        if (this.genStrat) {
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = bitSet.get(i) ? -2 : -1;
            }
        }
        BitSet bitSet2 = this.mcMDP.prob1(uMDP, null, bitSet, !minMax.isMin(), nArray);
        bitSet2.flip(0, n2);
        int n3 = bitSet.cardinality();
        int n4 = bitSet2.cardinality();
        this.mainLog.println("target=" + n3 + ", inf=" + n4 + ", rest=" + (n2 - (n3 + n4)));
        if (this.genStrat) {
            int n5;
            if (minMax.isMin()) {
                n5 = bitSet2.nextSetBit(0);
                while (n5 >= 0) {
                    nArray[n5] = -2;
                    n5 = bitSet2.nextSetBit(n5 + 1);
                }
            } else {
                n5 = bitSet2.nextSetBit(0);
                while (n5 >= 0) {
                    int n6 = uMDP.getNumChoices(n5);
                    for (n = 0; n < n6; ++n) {
                        if (!uMDP.someSuccessorsInSet(n5, n, bitSet2)) continue;
                        nArray[n5] = n;
                    }
                    n5 = bitSet2.nextSetBit(n5 + 1);
                }
            }
        }
        l = System.currentTimeMillis();
        Object object = minMax.isMin() ? "min" : "max";
        object = (String)object + (minMax.isMinUnc() ? "min" : "max");
        this.mainLog.println("Starting value iteration (" + (String)object + ")...");
        n2 = uMDP.getNumStates();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = bitSet.get(n) ? 0.0 : (bitSet2.get(n) ? Double.POSITIVE_INFINITY : 0.0);
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n2);
        bitSet3.andNot(bitSet);
        bitSet3.andNot(bitSet2);
        if (n3 + n4 < n2) {
            IterationMethod iterationMethod = null;
            switch (iMDPSolnMethod) {
                case VALUE_ITERATION: {
                    iterationMethod = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
                    break;
                }
                case GAUSS_SEIDEL: {
                    iterationMethod = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
                    break;
                }
                default: {
                    throw new PrismException("Unknown solution method " + iMDPSolnMethod.fullName());
                }
            }
            IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultRewMinMaxUnc(uMDP, mDPRewards, minMax, nArray);
            iterationValIter.init(dArray);
            IntSet intSet = IntSet.asIntSet(bitSet3);
            String string = (String)object + ", with " + iterationMethod.getDescriptionShort();
            modelCheckerResult = iterationMethod.doValueIteration(this, string, iterationValIter, intSet, l, null);
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet2, n2, Double.POSITIVE_INFINITY);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(uMDP, nArray);
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public static void main(String[] stringArray) {
        try {
            UMDPModelChecker uMDPModelChecker = new UMDPModelChecker(null);
            Evaluator evaluator = Evaluator.forDoubleInterval();
            IMDPSimple<Double> iMDPSimple = new IMDPSimple<Double>();
            iMDPSimple.setIntervalEvaluator(evaluator);
            iMDPSimple.addState();
            iMDPSimple.addState();
            iMDPSimple.addState();
            iMDPSimple.addInitialState(0);
            Distribution<Interval<Interval<Double>>> distribution = new Distribution<Interval<Interval<Double>>>(evaluator);
            distribution.add(1, new Interval<Double>(0.2, 0.4));
            distribution.add(2, new Interval<Double>(0.6, 0.8));
            iMDPSimple.addActionLabelledChoice(0, distribution, "a");
            distribution = new Distribution(evaluator);
            distribution.add(1, new Interval<Double>(0.1, 0.3));
            distribution.add(2, new Interval<Double>(0.7, 0.9));
            iMDPSimple.addActionLabelledChoice(0, distribution, "b");
            iMDPSimple.findDeadlocks(true);
            iMDPSimple.exportToDotFile("imdp.dot");
            BitSet bitSet = new BitSet();
            bitSet.set(2);
            ModelCheckerResult modelCheckerResult = uMDPModelChecker.computeReachProbs(iMDPSimple, bitSet, MinMax.min().setMinUnc(true));
            System.out.println("minmin: " + modelCheckerResult.soln[0]);
            modelCheckerResult = uMDPModelChecker.computeReachProbs(iMDPSimple, bitSet, MinMax.min().setMinUnc(false));
            System.out.println("minmax: " + modelCheckerResult.soln[0]);
            modelCheckerResult = uMDPModelChecker.computeReachProbs(iMDPSimple, bitSet, MinMax.max().setMinUnc(true));
            System.out.println("maxmin: " + modelCheckerResult.soln[0]);
            modelCheckerResult = uMDPModelChecker.computeReachProbs(iMDPSimple, bitSet, MinMax.max().setMinUnc(false));
            System.out.println("maxmax: " + modelCheckerResult.soln[0]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

