/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Distribution;
import explicit.MDPSimple;
import explicit.STPG;
import explicit.StateOwnersSimple;
import explicit.rewards.MDPRewards;
import explicit.rewards.STPGRewards;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import prism.ModelType;
import prism.PrismException;

public class STPGSimple<Value>
extends MDPSimple<Value>
implements STPG<Value> {
    protected StateOwnersSimple stateOwners;

    @Override
    public ModelType getModelType() {
        return ModelType.STPG;
    }

    public STPGSimple() {
        this.stateOwners = new StateOwnersSimple();
    }

    public STPGSimple(int n) {
        super(n);
        this.stateOwners = new StateOwnersSimple(n);
    }

    public STPGSimple(STPGSimple<Value> sTPGSimple) {
        super(sTPGSimple);
        this.stateOwners = new StateOwnersSimple(sTPGSimple.stateOwners);
    }

    public STPGSimple(STPGSimple<Value> sTPGSimple, int[] nArray) {
        super(sTPGSimple, nArray);
        this.stateOwners = new StateOwnersSimple(sTPGSimple.stateOwners, nArray);
    }

    @Override
    public void clearState(int n) {
        super.clearState(n);
        this.stateOwners.clearState(n);
        this.actionList.markNeedsRecomputing();
    }

    @Override
    public void addStates(int n) {
        super.addStates(n);
        for (int i = 0; i < n; ++i) {
            this.stateOwners.addState(0);
        }
    }

    public int addState(int n) {
        int n2 = super.addState();
        this.stateOwners.setPlayer(n2, n);
        return n2;
    }

    public void setPlayer(int n, int n2) {
        this.stateOwners.setPlayer(n, n2);
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!((List)this.trans.get(i)).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("Game has a deadlock in state " + i + (String)(this.statesList == null ? "" : ": " + String.valueOf(this.statesList.get(i))));
        }
    }

    @Override
    public int getPlayer(int n) {
        return this.stateOwners.getPlayer(n);
    }

    @Override
    public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, BitSet bitSet3) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            boolean bl4 = bl3 = this.getPlayer(i) == 0 ? bl : bl2;
            for (Distribution distribution : (List)this.trans.get(i)) {
                boolean bl5 = distribution.containsOneOf(bitSet2);
                if (bl3) {
                    if (bl5) continue;
                    bl4 = false;
                    continue;
                }
                if (!bl5) continue;
                bl4 = true;
            }
            bitSet3.set(i, bl4);
        }
    }

    @Override
    public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, BitSet bitSet4) {
        boolean bl3 = false;
        for (int i = 0; i < this.numStates; ++i) {
            if (!bitSet.get(i)) continue;
            boolean bl4 = bl3 = this.getPlayer(i) == 0 ? bl : bl2;
            for (Distribution distribution : (List)this.trans.get(i)) {
                boolean bl5;
                boolean bl6 = bl5 = distribution.containsOneOf(bitSet3) && distribution.isSubsetOf(bitSet2);
                if (bl3) {
                    if (bl5) continue;
                    bl4 = false;
                    continue;
                }
                if (!bl5) continue;
                bl4 = true;
            }
            bitSet4.set(i, bl4);
        }
    }

    @Override
    public void mvMultMinMax(double[] dArray, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 0 ? bl : bl2;
                dArray2[i] = this.mvMultMinMaxSingle(i, dArray, bl4, nArray);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl4, nArray);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultMinMaxSingle(n, dArray, bl4, nArray);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    @Override
    public double mvMultMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultMinMaxSingle(n, dArray, bl3, null);
    }

    @Override
    public List<Integer> mvMultMinMaxSingleChoices(int n, double[] dArray, boolean bl, boolean bl2, double d) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultMinMaxSingleChoices(n, dArray, bl3, d);
    }

    @Override
    public double mvMultGSMinMax(double[] dArray, boolean bl, boolean bl2, BitSet bitSet, boolean bl3, boolean bl4, int[] nArray) {
        double d = 0.0;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                double d2 = this.mvMultJacMinMaxSingle(i, dArray, bl, bl2, nArray);
                double d3 = bl4 ? Math.abs(d2 - dArray[i]) : Math.abs(d2 - dArray[i]) / d2;
                d = d3 > d ? d3 : d;
                dArray[i] = d2;
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                double d4 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2, nArray);
                double d5 = bl4 ? Math.abs(d4 - dArray[n]) : Math.abs(d4 - dArray[n]) / d4;
                d = d5 > d ? d5 : d;
                dArray[n] = d4;
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                double d6 = this.mvMultJacMinMaxSingle(n, dArray, bl, bl2, nArray);
                double d7 = bl4 ? Math.abs(d6 - dArray[n]) : Math.abs(d6 - dArray[n]) / d6;
                d = d7 > d ? d7 : d;
                dArray[n] = d6;
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return d;
    }

    @Override
    public double mvMultJacMinMaxSingle(int n, double[] dArray, boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultJacMinMaxSingle(n, dArray, bl3, nArray);
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 0 ? bl : bl2;
                dArray2[i] = this.mvMultRewMinMaxSingle(i, dArray, sTPGRewards, bl4, nArray, 1.0);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, 1.0);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, 1.0);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    @Override
    public double mvMultRewMinMaxSingle(int n, double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, int[] nArray) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl3, nArray);
    }

    @Override
    public List<Integer> mvMultRewMinMaxSingleChoices(int n, double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double d) {
        boolean bl3 = this.getPlayer(n) == 0 ? bl : bl2;
        return this.mvMultRewMinMaxSingleChoices(n, dArray, sTPGRewards, bl3, d);
    }

    @Override
    public void mvMultRewMinMax(double[] dArray, STPGRewards<Double> sTPGRewards, boolean bl, boolean bl2, double[] dArray2, BitSet bitSet, boolean bl3, int[] nArray, double d) {
        boolean bl4 = false;
        if (bitSet == null) {
            for (int i = 0; i < this.numStates; ++i) {
                bl4 = this.getPlayer(i) == 0 ? bl : bl2;
                dArray2[i] = this.mvMultRewMinMaxSingle(i, dArray, sTPGRewards, bl4, nArray, d);
            }
        } else if (bl3) {
            int n = bitSet.nextClearBit(0);
            while (n < this.numStates) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, d);
                n = bitSet.nextClearBit(n + 1);
            }
        } else {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl4 = this.getPlayer(n) == 0 ? bl : bl2;
                dArray2[n] = this.mvMultRewMinMaxSingle(n, dArray, sTPGRewards, bl4, nArray, d);
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    public double mvMultRewMinMaxSingle(int n, double[] dArray, MDPRewards<Double> mDPRewards, boolean bl, int[] nArray, double d) {
        int n2 = -1;
        double d2 = 0.0;
        boolean bl2 = true;
        int n3 = -1;
        List list = (List)this.trans.get(n);
        for (Distribution distribution : list) {
            double d3 = (Double)mDPRewards.getTransitionReward(n, ++n3);
            for (Map.Entry entry : distribution) {
                int n4 = (Integer)entry.getKey();
                double d4 = this.getEvaluator().toDouble(entry.getValue());
                d3 += d4 * dArray[n4] * d;
            }
            if (bl2 || bl && d3 < d2 || !bl && d3 > d2) {
                d2 = d3;
                if (nArray != null) {
                    n2 = n3;
                }
            }
            bl2 = false;
        }
        if (nArray != null & !bl2 && (nArray[n] == -1 || bl && d2 < dArray[n] || !bl && d2 > dArray[n] || this instanceof STPG)) {
            nArray[n] = n2;
        }
        return d2 += ((Double)mDPRewards.getStateReward(n)).doubleValue();
    }

    @Override
    public String toString() {
        Object object = "";
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = this.statesList.size() > i ? (String)object + i + "(P-" + (this.stateOwners.getPlayer(i) + 1) + " " + String.valueOf(this.statesList.get(i)) + "): " : (String)object + i + "(P-" + (this.stateOwners.getPlayer(i) + 1) + "): ";
            object = (String)object + "[";
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Object object2;
                if (j > 0) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j)) != null) {
                    object = (String)object + String.valueOf(object2) + ":";
                }
                object = (String)object + String.valueOf(((List)this.trans.get(i)).get(j));
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]\n";
        return object;
    }
}

