/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.DTMCSimple;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.POMDPSimple;
import explicit.STPGSimple;
import io.ExplicitModelImporter;
import io.PrismExplicitImporter;
import java.io.File;
import java.util.BitSet;
import java.util.List;
import parser.State;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public interface ModelSimple<Value>
extends Model<Value> {
    public void addInitialState(int var1);

    default public void buildFromExplicitImport(ExplicitModelImporter explicitModelImporter) throws PrismException {
        throw new PrismException("Explicit model not yet supported for this model");
    }

    default public void buildFromPrismExplicit(String string) throws PrismException {
        PrismExplicitImporter prismExplicitImporter = new PrismExplicitImporter(null, new File(string), null, null, null, ModelType.DTMC);
        this.buildFromExplicitImport(prismExplicitImporter);
    }

    public void clearState(int var1);

    public int addState();

    public void addStates(int var1);

    public void setStatesList(List<State> var1);

    public void addLabel(String var1, BitSet var2);

    public static ModelSimple<?> forModelType(ModelType modelType) throws PrismException {
        ModelExplicit modelExplicit = null;
        switch (modelType) {
            case DTMC: {
                modelExplicit = new DTMCSimple();
                break;
            }
            case MDP: {
                modelExplicit = new MDPSimple();
                break;
            }
            case POMDP: {
                modelExplicit = new POMDPSimple();
                break;
            }
            case IDTMC: {
                modelExplicit = new IDTMCSimple();
                break;
            }
            case IMDP: {
                modelExplicit = new IMDPSimple();
                break;
            }
            case STPG: {
                modelExplicit = new STPGSimple();
                break;
            }
            default: {
                throw new PrismNotSupportedException("Model construction not supported for " + String.valueOf((Object)modelType) + "s");
            }
        }
        return modelExplicit;
    }
}

