/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import explicit.Distribution;
import explicit.DoubleIntervalDistribution;
import explicit.IDTMC;
import explicit.IMDP;
import explicit.IntervalModelExplicit;
import explicit.IntervalUtils;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelExplicitWrapper;
import explicit.NondetModelSimple;
import explicit.SuccessorsIterator;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import prism.Evaluator;
import prism.PrismException;
import strat.MDStrategy;

public class IMDPSimple<Value>
extends ModelExplicitWrapper<Value>
implements NondetModelSimple<Value>,
IntervalModelExplicit<Value>,
IMDP<Value> {
    protected MDPSimple<Interval<Value>> mdp;

    public IMDPSimple() {
        this.model = this.mdp = new MDPSimple();
        this.createDefaultEvaluatorForMDP();
    }

    public IMDPSimple(int n) {
        this.model = this.mdp = new MDPSimple(n);
        this.createDefaultEvaluatorForMDP();
    }

    public IMDPSimple(IMDPSimple<Value> iMDPSimple) {
        this.model = this.mdp = new MDPSimple<Interval<Interval<Value>>>(iMDPSimple.mdp);
        this.createDefaultEvaluatorForMDP();
    }

    public IMDPSimple(IMDPSimple<Value> iMDPSimple, int[] nArray) {
        this.model = this.mdp = new MDPSimple<Interval<Interval<Value>>>(iMDPSimple.mdp, nArray);
        this.createDefaultEvaluatorForMDP();
    }

    private void createDefaultEvaluatorForMDP() {
        this.setIntervalEvaluator(Evaluator.forDoubleInterval());
    }

    @Override
    public void clearState(int n) {
        this.mdp.clearState(n);
    }

    @Override
    public int addState() {
        return this.mdp.addState();
    }

    @Override
    public void addStates(int n) {
        this.mdp.addStates(n);
    }

    @Override
    public void setIntervalEvaluator(Evaluator<Interval<Value>> evaluator) {
        this.mdp.setEvaluator(evaluator);
    }

    public int addChoice(int n, Distribution<Interval<Value>> distribution) {
        return this.mdp.addChoice(n, distribution);
    }

    public int addActionLabelledChoice(int n, Distribution<Interval<Value>> distribution, Object object) {
        return this.mdp.addActionLabelledChoice(n, distribution, object);
    }

    public void setAction(int n, int n2, Object object) {
        this.mdp.setAction(n, n2, object);
    }

    public void delimit(int n, int n2) {
        IntervalUtils.delimit(this.mdp.trans.get(n).get(n2), this.getEvaluator());
    }

    @Override
    public int getNumChoices(int n) {
        return this.mdp.getNumChoices(n);
    }

    @Override
    public Object getAction(int n, int n2) {
        return this.mdp.getAction(n, n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.mdp.allSuccessorsInSet(n, n2, bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.mdp.someSuccessorsInSet(n, n2, bitSet);
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        return this.mdp.getSuccessorsIterator(n, n2);
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        return this.mdp.getSuccessors(n, n2);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return this.mdp.getNumTransitions(n, n2);
    }

    @Override
    public Model<Value> constructInducedModel(MDStrategy<Value> mDStrategy) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void checkLowerBoundsArePositive() throws PrismException {
        Evaluator<Interval> evaluator = this.mdp.getEvaluator();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Iterator<Map.Entry<Integer, Interval<Value>>> iterator = this.getIntervalTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Interval<Value>> entry = iterator.next();
                    if (evaluator.gt(entry.getValue(), (Interval)evaluator.zero())) continue;
                    List<State> list = this.getStatesList();
                    String string = list == null ? "" + i : list.get(i).toString();
                    throw new PrismException("Transition probability has lower bound of 0 in state " + string);
                }
            }
        }
    }

    @Override
    public double mvMultUncSingle(int n, int n2, double[] dArray, MinMax minMax) {
        DoubleIntervalDistribution doubleIntervalDistribution = IntervalUtils.extractDoubleIntervalDistribution(this.getIntervalTransitionsIterator(n, n2), this.getNumTransitions(n, n2));
        return IDTMC.mvMultUncSingle(doubleIntervalDistribution, dArray, minMax);
    }

    @Override
    public Evaluator<Interval<Value>> getIntervalEvaluator() {
        return this.mdp.getEvaluator();
    }

    @Override
    public MDP<Interval<Value>> getIntervalModel() {
        return this.mdp;
    }

    @Override
    public Iterator<Map.Entry<Integer, Interval<Value>>> getIntervalTransitionsIterator(int n, int n2) {
        return this.mdp.getTransitionsIterator(n, n2);
    }
}

