/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMCSimple;
import explicit.DTMCSimple;
import explicit.DTMCSparse;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.LTSSimple;
import explicit.MDPExplicit;
import explicit.MDPSimple;
import explicit.MDPSparse;
import explicit.Model;
import explicit.ModelExplicit;
import io.ExplicitModelImporter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import parser.State;
import prism.Evaluator;
import prism.ModelInfo;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class ExplicitFiles2Model
extends PrismComponent {
    private boolean fixdl;
    private List<BitSet> labelBitSets;

    public ExplicitFiles2Model(PrismComponent prismComponent) {
        super(prismComponent);
        if (this.settings != null) {
            this.setFixDeadlocks(this.settings.getBoolean("prism.fixDeadlocks"));
        }
    }

    public boolean getFixDeadlocks() {
        return this.fixdl;
    }

    public void setFixDeadlocks(boolean bl) {
        this.fixdl = bl;
    }

    public Model<Double> build(ExplicitModelImporter explicitModelImporter) throws PrismException {
        return this.build(explicitModelImporter, Evaluator.forDouble());
    }

    public <Value> Model<Value> build(ExplicitModelImporter explicitModelImporter, Evaluator<Value> evaluator) throws PrismException {
        Object object;
        explicitModelImporter.setFixDeadlocks(this.fixdl);
        ModelExplicit modelExplicit = null;
        ModelInfo modelInfo = explicitModelImporter.getModelInfo();
        boolean bl = evaluator.one() instanceof Double;
        switch (modelInfo.getModelType()) {
            case DTMC: {
                object = bl ? new DTMCSparse() : new DTMCSimple();
                modelExplicit = (ModelExplicit)object;
                break;
            }
            case CTMC: {
                CTMCSimple<Value> cTMCSimple = new CTMCSimple<Value>();
                modelExplicit = cTMCSimple;
                break;
            }
            case MDP: {
                MDPExplicit mDPExplicit = bl ? new MDPSparse() : new MDPSimple();
                modelExplicit = mDPExplicit;
                break;
            }
            case IDTMC: {
                IDTMCSimple iDTMCSimple = new IDTMCSimple();
                modelExplicit = iDTMCSimple;
                break;
            }
            case IMDP: {
                IMDPSimple iMDPSimple = new IMDPSimple();
                modelExplicit = iMDPSimple;
                break;
            }
            case LTS: {
                LTSSimple lTSSimple = new LTSSimple();
                modelExplicit = lTSSimple;
                break;
            }
            case CTMDP: 
            case PTA: 
            case SMG: 
            case STPG: {
                throw new PrismNotSupportedException("Currently, importing " + String.valueOf((Object)modelInfo.getModelType()) + " is not supported");
            }
        }
        if (modelExplicit == null) {
            throw new PrismException("Could not import " + String.valueOf((Object)modelInfo.getModelType()));
        }
        modelExplicit.setEvaluator(evaluator);
        if (!modelExplicit.getModelType().uncertain()) {
            modelExplicit.setEvaluator(evaluator);
        } else {
            modelExplicit.setEvaluator(evaluator.createIntervalEvaluator());
        }
        modelExplicit.buildFromExplicitImport(explicitModelImporter);
        if (modelExplicit.getNumStates() == 0) {
            throw new PrismNotSupportedException("Imported model has no states, not supported");
        }
        this.loadLabelsAndInitialStates(explicitModelImporter, modelExplicit);
        if (!modelExplicit.getInitialStates().iterator().hasNext()) {
            throw new PrismException("Imported model has no initial states");
        }
        object = explicitModelImporter.getDeadlockStates();
        int n = ((BitSet)object).nextSetBit(0);
        while (n >= 0) {
            modelExplicit.addDeadlockState(n);
            n = ((BitSet)object).nextSetBit(n + 1);
        }
        this.loadStates(explicitModelImporter, modelExplicit);
        return modelExplicit;
    }

    private void loadLabelsAndInitialStates(ExplicitModelImporter explicitModelImporter, ModelExplicit<?> modelExplicit) throws PrismException {
        int n3;
        ModelInfo modelInfo = explicitModelImporter.getModelInfo();
        int n4 = modelInfo.getNumLabels();
        this.labelBitSets = new ArrayList<BitSet>(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            this.labelBitSets.add(new BitSet());
        }
        explicitModelImporter.extractLabelsAndInitialStates((n, n2) -> this.labelBitSets.get((int)n2).set((int)n), modelExplicit::addInitialState, modelExplicit::addDeadlockState);
        for (n3 = 0; n3 < n4; ++n3) {
            modelExplicit.addLabel(modelInfo.getLabelName(n3), this.labelBitSets.get(n3));
        }
    }

    private void loadStates(ExplicitModelImporter explicitModelImporter, ModelExplicit<?> modelExplicit) throws PrismException {
        int n3 = modelExplicit.getNumStates();
        int n4 = explicitModelImporter.getModelInfo().getNumVars();
        ArrayList<State> arrayList = new ArrayList<State>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(new State(n4));
        }
        explicitModelImporter.extractStates((n, n2, object) -> ((State)arrayList.get(n)).setValue(n2, object));
        modelExplicit.setStatesList(arrayList);
    }
}

