/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.Reducible;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import prism.Evaluator;
import simulator.RandomNumberGenerator;

public class Distribution<Value>
implements FunctionalIterable<Map.Entry<Integer, Value>> {
    protected final HashMap<Integer, Value> map;
    protected final Evaluator<Value> eval;

    @Deprecated
    public Distribution() {
        this(Evaluator.forDouble());
    }

    public Distribution(Evaluator<Value> evaluator) {
        this.eval = evaluator;
        this.map = new HashMap();
    }

    public Distribution(Iterator<Map.Entry<Integer, Value>> iterator, Evaluator<Value> evaluator) {
        this(evaluator);
        iterator.forEachRemaining(entry -> this.add((Integer)entry.getKey(), entry.getValue()));
    }

    public Distribution(Distribution<Value> distribution) {
        this(distribution.getEvaluator());
        distribution.forEach((? super E entry) -> this.map.put((Integer)entry.getKey(), entry.getValue()));
    }

    public Distribution(Distribution<Value> distribution, int[] nArray) {
        this(distribution.getEvaluator());
        distribution.forEach((? super E entry) -> this.add(nArray[(Integer)entry.getKey()], entry.getValue()));
    }

    public static Distribution<Double> ofDouble() {
        return new Distribution<Double>(Evaluator.forDouble());
    }

    public static Distribution<Double> ofDouble(Iterator<Map.Entry<Integer, Double>> iterator) {
        return new Distribution<Double>(iterator, Evaluator.forDouble());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean add(int n, Value Value2) {
        if (this.eval.isZero(Value2)) {
            return true;
        }
        Object object = this.map.merge(n, Value2, this.eval::add);
        return object != Value2;
    }

    public void set(int n, Value Value2) {
        if (this.eval.isZero(Value2)) {
            this.map.remove(n);
        } else {
            this.map.put(n, Value2);
        }
    }

    public Value get(int n) {
        return this.map.getOrDefault(n, this.eval.zero());
    }

    public boolean contains(int n) {
        return this.map.containsKey(n);
    }

    public boolean isSubsetOf(BitSet bitSet) {
        return Reducible.extend(this.getSupport()).allMatch(bitSet::get);
    }

    public boolean containsOneOf(BitSet bitSet) {
        return Reducible.extend(this.getSupport()).anyMatch(bitSet::get);
    }

    public Set<Integer> getSupport() {
        return this.map.keySet();
    }

    @Override
    public FunctionalIterator<Map.Entry<Integer, Value>> iterator() {
        return Reducible.extend(this.map.entrySet().iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public int sample() {
        return this.getValueByProbabilitySum(Math.random());
    }

    public int sample(RandomNumberGenerator randomNumberGenerator) {
        return this.getValueByProbabilitySum(randomNumberGenerator.randomUnifDouble());
    }

    private int getValueByProbabilitySum(double d) {
        if (this.isEmpty()) {
            return -1;
        }
        Iterator iterator = this.iterator();
        Map.Entry entry = null;
        Value Value2 = this.eval.zero();
        while (d >= this.eval.toDouble(Value2) && iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            Value2 = this.eval.add(Value2, entry.getValue());
        }
        return (Integer)entry.getKey();
    }

    public Value sum() {
        return (Value)this.map(Map.Entry::getValue).reduce(this.eval.zero(), this.eval::add);
    }

    public Value sumAllBut(int n) {
        return (Value)this.filter((T entry) -> (Integer)entry.getKey() != n).map(Map.Entry::getValue).reduce(this.eval.zero(), this.eval::add);
    }

    public Distribution<Value> map(int[] nArray) {
        return new Distribution<Value>(this, nArray);
    }

    public Evaluator<Value> getEvaluator() {
        return this.eval;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Distribution)) {
            return false;
        }
        HashMap<Integer, Value> hashMap = ((Distribution)object).map;
        if (this.map.size() != hashMap.size()) {
            return false;
        }
        for (Map.Entry<Integer, Value> entry : this.map.entrySet()) {
            Integer n = entry.getKey();
            Value Value2 = entry.getValue();
            Value Value3 = hashMap.get(n);
            if (Value3 != null && this.getEvaluator().equals(Value2, Value3)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toStringCSV() {
        Object object = "Value";
        for (Map.Entry entry : this) {
            object = (String)object + ", " + String.valueOf(entry.getKey());
        }
        object = (String)object + "\nProbability";
        for (Map.Entry entry : this) {
            object = (String)object + ", " + String.valueOf(entry.getValue());
        }
        object = (String)object + "\n";
        return object;
    }
}

