/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.PrimitiveIterable;
import common.iterable.Reducible;
import explicit.DTMC;
import explicit.DTMCExplicit;
import explicit.Distribution;
import explicit.SuccessorsIterator;
import explicit.Utils;
import explicit.rewards.MCRewards;
import io.ExplicitModelImporter;
import io.IOUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import prism.ActionListOwner;
import prism.Pair;
import prism.PrismException;

public class DTMCSparse
extends DTMCExplicit<Double> {
    private int[] rows;
    private int[] columns;
    private double[] probabilities;
    private Object[] actions;

    /*
     * WARNING - void declaration
     */
    public DTMCSparse(DTMC<Double> dTMC) {
        void var3_10;
        this.initialise(dTMC.getNumStates());
        if (dTMC instanceof ActionListOwner) {
            this.actionList.copyFrom(((ActionListOwner)((Object)dTMC)).getActionList());
        }
        for (Integer object : dTMC.getDeadlockStates()) {
            this.deadlocks.add(object);
        }
        for (Integer n : dTMC.getInitialStates()) {
            this.initialStates.add(n);
        }
        this.constantValues = dTMC.getConstantValues();
        this.varList = dTMC.getVarList();
        this.statesList = dTMC.getStatesList();
        for (String string : dTMC.getLabels()) {
            this.labels.put(string, dTMC.getLabelStates(string));
        }
        int n = dTMC.getNumTransitions();
        this.rows = new int[this.numStates + 1];
        this.rows[this.numStates] = n;
        this.columns = new int[n];
        this.probabilities = new double[n];
        boolean bl = false;
        int n2 = 0;
        while (var3_10 < this.numStates) {
            this.rows[var3_10] = n2;
            Iterator<Map.Entry<Integer, Pair<Double, Object>>> iterator = dTMC.getTransitionsAndActionsIterator((int)var3_10);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<Double, Object>> entry = iterator.next();
                double d = (Double)entry.getValue().first;
                if (!(d > 0.0)) continue;
                this.columns[n2] = entry.getKey();
                this.probabilities[n2] = d;
                if (entry.getValue().second != null) {
                    if (this.actions == null) {
                        this.actions = new Object[n];
                    }
                    this.actions[n2] = entry.getValue().second;
                }
                ++n2;
            }
            ++var3_10;
        }
        this.predecessorRelation = dTMC.hasStoredPredecessorRelation() ? dTMC.getPredecessorRelation(null, false) : null;
    }

    public DTMCSparse(DTMC<Double> dTMC, int[] nArray) {
        int n;
        this.initialise(dTMC.getNumStates());
        if (dTMC instanceof ActionListOwner) {
            this.actionList.copyFrom(((ActionListOwner)((Object)dTMC)).getActionList());
        }
        for (Integer n2 : dTMC.getDeadlockStates()) {
            this.deadlocks.add(nArray[n2]);
        }
        for (Integer n2 : dTMC.getInitialStates()) {
            this.initialStates.add(nArray[n2]);
        }
        this.constantValues = dTMC.getConstantValues();
        this.varList = dTMC.getVarList();
        this.statesList = null;
        this.labels.clear();
        Object object = new int[this.numStates];
        for (n = 0; n < this.numStates; ++n) {
            object[nArray[n]] = n;
        }
        n = dTMC.getNumTransitions();
        this.rows = new int[this.numStates + 1];
        this.rows[this.numStates] = n;
        this.columns = new int[n];
        this.probabilities = new double[n];
        int n3 = 0;
        for (int i = 0; i < this.numStates; ++i) {
            this.rows[i] = n3;
            Object object2 = object[i];
            Iterator<Map.Entry<Integer, Pair<Double, Object>>> iterator = dTMC.getTransitionsAndActionsIterator((int)object2);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<Double, Object>> entry = iterator.next();
                double d = (Double)entry.getValue().first;
                if (!(d > 0.0)) continue;
                this.columns[n3] = nArray[entry.getKey()];
                this.probabilities[n3] = d;
                if (entry.getValue().second != null) {
                    if (this.actions == null) {
                        this.actions = new Object[n];
                    }
                    this.actions[n3] = entry.getValue().second;
                }
                ++n3;
            }
        }
    }

    public DTMCSparse() {
    }

    @Override
    public List<Object> findActionsUsed() {
        if (this.actions == null) {
            return Collections.singletonList(null);
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        int n = this.actions.length;
        for (int i = 0; i < n; ++i) {
            linkedHashSet.add(this.actions[i]);
        }
        return new ArrayList<Object>(linkedHashSet);
    }

    @Override
    public boolean onlyNullActionUsed() {
        return this.actions == null;
    }

    @Override
    public int getNumTransitions() {
        return this.rows[this.numStates];
    }

    @Override
    public int getNumTransitions(int n) {
        return this.rows[n + 1] - this.rows[n];
    }

    public PrimitiveIterator.OfInt getSuccessorsIterator(int n) {
        return Arrays.stream(this.columns, this.rows[n], this.rows[n + 1]).iterator();
    }

    @Override
    public SuccessorsIterator getSuccessors(int n) {
        return SuccessorsIterator.from(this.getSuccessorsIterator(n), true);
    }

    @Override
    public boolean isSuccessor(int n, int n2) {
        int n3 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n3; ++i) {
            if (this.columns[i] != n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            if (bitSet.get(this.columns[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            if (!bitSet.get(this.columns[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (this.rows[i] != this.rows[i + 1]) continue;
            if (bl) {
                throw new PrismException("Can't fix deadlocks in an DTMCSparse since it cannot be modified after construction");
            }
            this.deadlocks.add(i);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (this.rows[i] != this.rows[i + 1] || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("DTMC has a deadlock in state " + i);
        }
    }

    @Override
    public void buildFromExplicitImport(ExplicitModelImporter explicitModelImporter) throws PrismException {
        this.initialise(explicitModelImporter.getNumStates());
        this.actionList.markNeedsRecomputing();
        int n = explicitModelImporter.getNumTransitions();
        this.rows = new int[this.numStates + 1];
        this.columns = new int[n];
        this.probabilities = new double[n];
        this.actions = new Object[n];
        IOUtils.MCTransitionConsumer<Double> mCTransitionConsumer = new IOUtils.MCTransitionConsumer<Double>(){
            int sLast = -1;
            int count = 0;

            @Override
            public void accept(int n, int n2, Double d, Object object) throws PrismException {
                if (n < this.sLast) {
                    throw new PrismException("Imported states/transitions must be in ascending order");
                }
                if (n != this.sLast) {
                    ((DTMCSparse)DTMCSparse.this).rows[n] = this.count;
                    this.sLast = n;
                }
                ((DTMCSparse)DTMCSparse.this).columns[this.count] = n2;
                ((DTMCSparse)DTMCSparse.this).probabilities[this.count] = d;
                ((DTMCSparse)DTMCSparse.this).actions[this.count] = object;
                ++this.count;
            }
        };
        this.rows[this.numStates] = n;
        explicitModelImporter.extractMCTransitions(mCTransitionConsumer);
    }

    @Override
    public void forEachTransition(int n, DTMC.TransitionConsumer<Double> transitionConsumer) {
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            transitionConsumer.accept(n, this.columns[i], this.probabilities[i]);
        }
    }

    @Override
    public void forEachDoubleTransition(int n, DTMC.DoubleTransitionConsumer doubleTransitionConsumer) {
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            doubleTransitionConsumer.accept(n, this.columns[i], this.probabilities[i]);
        }
    }

    @Override
    public Iterator<Map.Entry<Integer, Double>> getTransitionsIterator(final int n) {
        return new Iterator<Map.Entry<Integer, Double>>(){
            final int start;
            int col;
            final int end;
            {
                this.col = this.start = DTMCSparse.this.rows[n];
                this.end = DTMCSparse.this.rows[n + 1];
            }

            @Override
            public boolean hasNext() {
                return this.col < this.end;
            }

            @Override
            public Map.Entry<Integer, Double> next() {
                assert (this.col < this.end);
                int n2 = this.col++;
                return new AbstractMap.SimpleImmutableEntry<Integer, Double>(DTMCSparse.this.columns[n2], DTMCSparse.this.probabilities[n2]);
            }
        };
    }

    @Override
    public Iterator<Map.Entry<Integer, Pair<Double, Object>>> getTransitionsAndActionsIterator(final int n) {
        return new Iterator<Map.Entry<Integer, Pair<Double, Object>>>(){
            final int start;
            int col;
            final int end;
            {
                this.col = this.start = DTMCSparse.this.rows[n];
                this.end = DTMCSparse.this.rows[n + 1];
            }

            @Override
            public boolean hasNext() {
                return this.col < this.end;
            }

            @Override
            public Map.Entry<Integer, Pair<Double, Object>> next() {
                assert (this.col < this.end);
                int n2 = this.col++;
                Pair<Double, Object> pair = new Pair<Double, Object>(DTMCSparse.this.probabilities[n2], (DTMCSparse.this.actions == null ? null : DTMCSparse.this.actions[n2]));
                return new AbstractMap.SimpleImmutableEntry<Integer, Pair<Double, Object>>(DTMCSparse.this.columns[n2], pair);
            }
        };
    }

    @Override
    public Iterator<Object> getActionsIterator(final int n) {
        return new Iterator<Object>(){
            final int start;
            int col;
            final int end;
            {
                this.col = this.start = DTMCSparse.this.rows[n];
                this.end = DTMCSparse.this.rows[n + 1];
            }

            @Override
            public boolean hasNext() {
                return this.col < this.end;
            }

            @Override
            public Object next() {
                return DTMCSparse.this.actions == null ? null : DTMCSparse.this.actions[this.col++];
            }
        };
    }

    @Override
    public boolean prob0step(int n, BitSet bitSet) {
        boolean bl = false;
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            int n3 = this.columns[i];
            if (!bitSet.get(n3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean prob1step(int n, BitSet bitSet, BitSet bitSet2) {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            int n3 = this.columns[i];
            if (!bitSet.get(n3)) {
                bl = false;
                break;
            }
            bl2 = bl2 || bitSet2.get(n3);
        }
        return bl && bl2;
    }

    @Override
    public double mvMultSingle(int n, double[] dArray) {
        double d = 0.0;
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            int n3 = this.columns[i];
            double d2 = this.probabilities[i];
            d += d2 * dArray[n3];
        }
        return d;
    }

    @Override
    public double mvMultJacSingle(int n, double[] dArray) {
        double d = 1.0;
        double d2 = 0.0;
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            int n3 = this.columns[i];
            double d3 = this.probabilities[i];
            if (n3 != n) {
                d2 += d3 * dArray[n3];
                continue;
            }
            d -= d3;
        }
        if (d > 0.0) {
            d2 /= d;
        }
        return d2;
    }

    @Override
    public double mvMultRewSingle(int n, double[] dArray, MCRewards<Double> mCRewards) {
        double d = (Double)mCRewards.getStateReward(n);
        int n2 = this.rows[n + 1];
        for (int i = this.rows[n]; i < n2; ++i) {
            int n3 = this.columns[i];
            double d2 = this.probabilities[i];
            d += d2 * dArray[n3];
        }
        return d;
    }

    @Override
    public void vmMult(double[] dArray, double[] dArray2) {
        Arrays.fill(dArray2, 0.0);
        for (int i = 0; i < this.numStates; ++i) {
            int n = this.rows[i + 1];
            for (int j = this.rows[i]; j < n; ++j) {
                int n2 = this.columns[j];
                double d = this.probabilities[j];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + d * dArray[i];
            }
        }
    }

    @Override
    public void vmMultPowerSteadyState(double[] dArray, double[] dArray2, double[] dArray3, double d, PrimitiveIterable.OfInt ofInt) {
        int n;
        PrimitiveIterator.OfInt ofInt2 = ofInt.iterator();
        while (ofInt2.hasNext()) {
            n = ofInt2.nextInt();
            dArray2[n] = dArray[n] * (d * dArray3[n] + 1.0);
        }
        ofInt2 = ofInt.iterator();
        while (ofInt2.hasNext()) {
            n = ofInt2.nextInt();
            int n2 = this.rows[n + 1];
            for (int i = this.rows[n]; i < n2; ++i) {
                int n3 = this.columns[i];
                double d2 = this.probabilities[i];
                if (n == n3) continue;
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + d * d2 * dArray[n];
            }
        }
    }

    public String toString() {
        Function<Integer, Map.Entry<Integer, Distribution<Double>>> function = new Function<Integer, Map.Entry<Integer, Distribution<Double>>>(){

            @Override
            public final Map.Entry<Integer, Distribution<Double>> apply(Integer n) {
                Distribution distribution = new Distribution(DTMCSparse.this.getTransitionsIterator(n), DTMCSparse.this.getEvaluator());
                return new AbstractMap.SimpleImmutableEntry<Integer, Distribution<Double>>(n, distribution);
            }
        };
        Object object = "trans: [ ";
        IterableStateSet iterableStateSet = new IterableStateSet(this.numStates);
        Reducible reducible = iterableStateSet.iterator().map(function);
        while (reducible.hasNext()) {
            Map.Entry entry = (Map.Entry)reducible.next();
            object = (String)object + String.valueOf(entry.getKey()) + ": " + String.valueOf(entry.getValue());
            if (!reducible.hasNext()) continue;
            object = (String)object + ", ";
        }
        return (String)object + " ]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof DTMCSparse)) {
            return false;
        }
        DTMCSparse dTMCSparse = (DTMCSparse)object;
        if (this.numStates != dTMCSparse.numStates) {
            return false;
        }
        if (!this.initialStates.equals(dTMCSparse.initialStates)) {
            return false;
        }
        if (!Utils.doubleArraysAreEqual(this.probabilities, dTMCSparse.probabilities)) {
            return false;
        }
        if (!Utils.intArraysAreEqual(this.columns, dTMCSparse.columns)) {
            return false;
        }
        return Utils.intArraysAreEqual(this.rows, dTMCSparse.rows);
    }
}

