/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import common.IntSet;
import common.IterableBitSet;
import common.StopWatch;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.DijkstraSweepMPI;
import explicit.ExportIterations;
import explicit.IterationMethod;
import explicit.IterationMethodGS;
import explicit.IterationMethodJacobi;
import explicit.IterationMethodPower;
import explicit.LTLModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.PredecessorRelation;
import explicit.ProbModelChecker;
import explicit.Product;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import explicit.SCCInfo;
import explicit.StateModelChecker;
import explicit.StateValues;
import explicit.Utils;
import explicit.modelviews.DTMCAlteredDistributions;
import explicit.modelviews.MDPFromDTMC;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.Rewards;
import io.ModelExportFormat;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.ast.Expression;
import prism.AccuracyFactory;
import prism.ModelType;
import prism.OptionsIntervalIteration;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class DTMCModelChecker
extends ProbModelChecker {
    public DTMCModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        BitSet bitSet2;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.REACH, AcceptanceType.BUCHI, AcceptanceType.STREETT, AcceptanceType.GENERIC};
        LTLModelChecker.LTLProduct<DTMC> lTLProduct = lTLModelChecker.constructDAProductForLTLFormula(this, (DTMC)model, expression, bitSet, acceptanceTypeArray);
        this.doProductExports(lTLProduct);
        if (lTLProduct.getAcceptance() instanceof AcceptanceReach) {
            this.mainLog.println("\nSkipping BSCC computation since acceptance is defined via goal states...");
            bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        } else {
            this.mainLog.println("\nFinding accepting BSCCs...");
            bitSet2 = lTLModelChecker.findAcceptingBSCCs((Model<?>)lTLProduct.getProductModel(), lTLProduct.getAcceptance());
        }
        this.mainLog.println("\nComputing reachability probabilities...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = dTMCModelChecker.computeReachProbs((DTMC)lTLProduct.getProductModel(), bitSet2);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    @Override
    protected StateValues checkRewardCoSafeLTL(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<DTMC> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyReward(this, (DTMC)model, expression, bitSet);
        Rewards rewards2 = ((MCRewards)rewards).liftFromModel(lTLProduct);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(this);
        dTMCModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = dTMCModelChecker.computeReachRewards((DTMC)lTLProduct.getProductModel(), (MCRewards<Double>)rewards2, bitSet2);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    public ModelCheckerResult computeInstantaneousRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, int n, BitSet bitSet) throws PrismException {
        if (bitSet.cardinality() == 1) {
            return this.computeInstantaneousRewardsForwards(dTMC, mCRewards, n, bitSet.nextSetBit(0));
        }
        return this.computeInstantaneousRewardsBackwards(dTMC, mCRewards, n);
    }

    public ModelCheckerResult computeInstantaneousRewardsBackwards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, int n) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        int n3 = dTMC.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards instantaneous rewards computation...");
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = (Double)mCRewards.getStateReward(i);
        }
        for (n2 = 0; n2 < n; ++n2) {
            dTMC.mvMult(dArray, dArray2, null, false);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient instantaneous rewards computation");
        this.mainLog.println(" took " + n2 + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeInstantaneousRewardsForwards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, int n, int n2) throws PrismException {
        int n3;
        double[] dArray = new double[dTMC.getNumStates()];
        dArray[n2] = 1.0;
        ModelCheckerResult modelCheckerResult = this.computeTransientProbs(dTMC, n, dArray);
        int n4 = dTMC.getNumStates();
        double d = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = n3;
            double d2 = modelCheckerResult.soln[n5] * (Double)mCRewards.getStateReward(n3);
            modelCheckerResult.soln[n5] = d2;
            d += d2;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            modelCheckerResult.soln[n3] = 0.0;
        }
        modelCheckerResult.soln[n2] = d;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, double d) throws PrismException {
        int n;
        ModelCheckerResult modelCheckerResult = null;
        int n2 = (int)d;
        int n3 = dTMC.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards cumulative rewards computation...");
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n = 0; n < n2; ++n) {
            dTMC.mvMult(dArray, dArray2, null, false);
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                dArray2[n4] = dArray2[n4] + (Double)mCRewards.getStateReward(i);
            }
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards cumulative rewards computation");
        this.mainLog.println(" took " + n + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeTotalRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards) throws PrismException {
        BitSet bitSet;
        Object object;
        ModelCheckerResult modelCheckerResult = null;
        int n = 0;
        if (this.getDoIntervalIteration()) {
            throw new PrismNotSupportedException("Interval iteration for total rewards is currently not supported");
        }
        if (this.linEqMethod != ProbModelChecker.LinEqMethod.POWER) {
            this.linEqMethod = ProbModelChecker.LinEqMethod.POWER;
            this.mainLog.printWarning("Switching to linear equation solution method \"" + this.linEqMethod.fullName() + "\"");
        }
        int n2 = dTMC.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting total reward computation...");
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC, sCCConsumerStore);
        sCCComputer.computeSCCs();
        List<BitSet> list = sCCConsumerStore.getBSCCs();
        n = list.size();
        BitSet bitSet2 = new BitSet();
        block3: for (int i = 0; i < n; ++i) {
            object = list.get(i);
            int n3 = ((BitSet)object).nextSetBit(0);
            while (n3 >= 0) {
                if ((Double)mCRewards.getStateReward(n3) > 0.0) {
                    bitSet2.or((BitSet)object);
                    continue block3;
                }
                n3 = ((BitSet)object).nextSetBit(n3 + 1);
            }
        }
        this.mainLog.print("States in non-zero reward BSCCs: " + bitSet2.cardinality() + "\n");
        if (this.preRel) {
            object = dTMC.getPredecessorRelation(this, true);
            bitSet = this.prob0(dTMC, null, bitSet2, (PredecessorRelation)object);
        } else {
            bitSet = this.prob0(dTMC, null, bitSet2);
        }
        bitSet.flip(0, n2);
        int n4 = bitSet.cardinality();
        this.mainLog.println("inf=" + n4 + ", maybe=" + (n2 - n4));
        switch (this.linEqMethod) {
            case POWER: {
                modelCheckerResult = this.computeReachRewardsValIter(dTMC, mCRewards, new BitSet(), bitSet, null, null);
                break;
            }
            default: {
                throw new PrismException("Unknown linear equation solution method " + this.linEqMethod.fullName());
            }
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Total reward computation");
        this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        return modelCheckerResult;
    }

    public StateValues doSteadyState(DTMC<Double> dTMC) throws PrismException {
        return this.doSteadyState(dTMC, (StateValues)null);
    }

    public StateValues doSteadyState(DTMC<Double> dTMC, File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file, dTMC);
        return this.doSteadyState(dTMC, stateValues);
    }

    public StateValues doSteadyState(DTMC<Double> dTMC, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution(dTMC) : stateValues;
        ModelCheckerResult modelCheckerResult = this.computeSteadyStateProbs(dTMC, stateValues2.getDoubleArray());
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, dTMC);
    }

    public StateValues doTransient(DTMC<Double> dTMC, int n) throws PrismException {
        return this.doTransient(dTMC, n, (StateValues)null);
    }

    public StateValues doTransient(DTMC<Double> dTMC, int n, File file) throws PrismException {
        StateValues stateValues = this.readDistributionFromFile(file, dTMC);
        return this.doTransient(dTMC, n, stateValues);
    }

    public StateValues doTransient(DTMC<Double> dTMC, int n, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = stateValues == null ? this.buildInitialDistribution(dTMC) : stateValues;
        ModelCheckerResult modelCheckerResult = this.computeTransientProbs(dTMC, n, stateValues2.getDoubleArray());
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, dTMC);
    }

    public ModelCheckerResult computeNextProbs(DTMC<Double> dTMC, BitSet bitSet) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        int n = dTMC.getNumStates();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        dTMC.mvMult(dArray, dArray2, null, false);
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected double[] computeRestrictedNext(DTMC<Double> dTMC, BitSet bitSet, double[] dArray) {
        int n = dTMC.getNumStates();
        double[] dArray2 = new double[n];
        dTMC.mvMult(dArray, dArray2, bitSet, false);
        return dArray2;
    }

    public ModelCheckerResult computeReachProbs(DTMC<Double> dTMC, BitSet bitSet) throws PrismException {
        return this.computeReachProbs(dTMC, null, bitSet, null, null);
    }

    public ModelCheckerResult computeUntilProbs(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2) throws PrismException {
        return this.computeReachProbs(dTMC, bitSet, bitSet2, null, null);
    }

    public ModelCheckerResult computeReachProbs(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        Object object;
        BitSet bitSet4;
        ModelCheckerResult modelCheckerResult = null;
        PredecessorRelation predecessorRelation = null;
        ProbModelChecker.LinEqMethod linEqMethod = this.linEqMethod;
        switch (linEqMethod) {
            case POWER: 
            case GAUSS_SEIDEL: 
            case BACKWARDS_GAUSS_SEIDEL: 
            case JACOBI: {
                break;
            }
            default: {
                linEqMethod = ProbModelChecker.LinEqMethod.GAUSS_SEIDEL;
                this.mainLog.printWarning("Switching to linear equation solution method \"" + linEqMethod.fullName() + "\"");
            }
        }
        if (!(!this.doIntervalIteration || this.precomp && this.prob0 && this.prob1)) {
            throw new PrismNotSupportedException("Interval iteration requires precomputations to be active");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting probabilistic reachability...");
        dTMC.checkForDeadlocks(bitSet2);
        int n = dTMC.getNumStates();
        if (dArray != null && bitSet3 != null && !bitSet3.isEmpty()) {
            bitSet4 = (BitSet)bitSet2.clone();
            object = new IterableBitSet(bitSet3).iterator();
            while (object.hasNext()) {
                int n2 = (Integer)object.next();
                if (dArray[n2] != 1.0) continue;
                bitSet4.set(n2);
            }
            bitSet2 = bitSet4;
        }
        if (this.getExportTarget()) {
            bitSet4 = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bitSet4.set(i, dTMC.isInitialState(i));
            }
            object = Arrays.asList(bitSet4, bitSet2);
            List<String> list = Arrays.asList("init", "target");
            this.mainLog.println("\nExporting target states info to file \"" + this.getExportTargetFilename() + "\"...");
            this.exportLabels(dTMC, list, (List<BitSet>)object, new File(this.getExportTargetFilename()), ModelExportFormat.EXPLICIT);
        }
        if (this.precomp && (this.prob0 || this.prob1) && this.preRel) {
            predecessorRelation = dTMC.getPredecessorRelation(this, true);
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet5 = this.precomp && this.prob0 ? (this.preRel ? this.prob0(dTMC, bitSet, bitSet2, predecessorRelation) : this.prob0(dTMC, bitSet, bitSet2)) : new BitSet();
        l2 = System.currentTimeMillis() - l2;
        long l3 = System.currentTimeMillis();
        BitSet bitSet6 = this.precomp && this.prob1 ? (this.preRel ? this.prob1(dTMC, bitSet, bitSet2, predecessorRelation) : this.prob1(dTMC, bitSet, bitSet2)) : (BitSet)bitSet2.clone();
        l3 = System.currentTimeMillis() - l3;
        int n3 = bitSet6.cardinality();
        int n4 = bitSet5.cardinality();
        this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n - (n3 + n4)));
        if (n3 + n4 < n) {
            boolean bl = this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE;
            object = null;
            switch (linEqMethod) {
                case POWER: {
                    object = new IterationMethodPower(bl, this.termCritParam);
                    break;
                }
                case JACOBI: {
                    object = new IterationMethodJacobi(bl, this.termCritParam);
                    break;
                }
                case GAUSS_SEIDEL: 
                case BACKWARDS_GAUSS_SEIDEL: {
                    boolean bl2 = linEqMethod == ProbModelChecker.LinEqMethod.BACKWARDS_GAUSS_SEIDEL;
                    object = new IterationMethodGS(bl, this.termCritParam, bl2);
                    break;
                }
                default: {
                    throw new PrismException("Unknown linear equation solution method " + linEqMethod.fullName());
                }
            }
            modelCheckerResult = this.doIntervalIteration ? this.doIntervalIterationReachProbs(dTMC, bitSet5, bitSet6, dArray, bitSet3, (IterationMethod)object, this.getDoTopologicalValueIteration()) : this.doValueIterationReachProbs(dTMC, bitSet5, bitSet6, dArray, bitSet3, (IterationMethod)object, this.getDoTopologicalValueIteration());
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet6, n);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timeProb0 = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l2 + l3) / 1000.0;
        return modelCheckerResult;
    }

    public BitSet prob0(Model<?> model, BitSet bitSet, BitSet bitSet2, PredecessorRelation predecessorRelation) {
        long l = System.currentTimeMillis();
        if (!this.silentPrecomputations) {
            this.mainLog.println("Starting Prob0...");
        }
        if (bitSet2.isEmpty()) {
            BitSet bitSet3 = new BitSet(model.getNumStates());
            bitSet3.set(0, model.getNumStates());
            return bitSet3;
        }
        BitSet bitSet4 = predecessorRelation.calculatePreStar(bitSet, bitSet2, bitSet2);
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, model.getNumStates(), true);
        bitSet5.andNot(bitSet4);
        l = System.currentTimeMillis() - l;
        if (!this.silentPrecomputations) {
            this.mainLog.print("Prob0");
            this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet5;
    }

    public BitSet prob0(Model<?> model, BitSet bitSet, BitSet bitSet2) {
        long l = System.currentTimeMillis();
        if (!this.silentPrecomputations) {
            this.mainLog.println("Starting Prob0...");
        }
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(model.getNumStates());
            bitSet3.set(0, model.getNumStates());
            return bitSet3;
        }
        int n = model.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl) {
            ++n2;
            model.prob0step(bitSet6, bitSet4, bitSet5);
            bl = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        bitSet4.flip(0, n);
        l = System.currentTimeMillis() - l;
        if (!this.silentPrecomputations) {
            this.mainLog.print("Prob0");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet4;
    }

    public BitSet prob1(Model<?> model, BitSet bitSet, BitSet bitSet2, PredecessorRelation predecessorRelation) {
        long l = System.currentTimeMillis();
        if (!this.silentPrecomputations) {
            this.mainLog.println("Starting Prob1...");
        }
        if (bitSet2.isEmpty()) {
            return new BitSet();
        }
        BitSet bitSet3 = new BitSet();
        if (bitSet != null) {
            bitSet3.set(0, model.getNumStates(), true);
            bitSet3.andNot(bitSet);
        }
        bitSet3.or(bitSet2);
        BitSet bitSet4 = predecessorRelation.calculatePreStar(null, bitSet2, bitSet3);
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, model.getNumStates(), true);
        bitSet5.andNot(bitSet4);
        BitSet bitSet6 = predecessorRelation.calculatePreStar(null, bitSet5, bitSet3);
        BitSet bitSet7 = new BitSet();
        bitSet7.set(0, model.getNumStates(), true);
        bitSet7.andNot(bitSet6);
        l = System.currentTimeMillis() - l;
        if (!this.silentPrecomputations) {
            this.mainLog.print("Prob1");
            this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet7;
    }

    public BitSet prob1(Model<?> model, BitSet bitSet, BitSet bitSet2) {
        long l = System.currentTimeMillis();
        if (!this.silentPrecomputations) {
            this.mainLog.println("Starting Prob1...");
        }
        if (bitSet2.cardinality() == 0) {
            return new BitSet(model.getNumStates());
        }
        int n = model.getNumStates();
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl = false;
        bitSet3.set(0, n);
        while (!bl) {
            boolean bl2 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl2) {
                ++n2;
                model.prob1step(bitSet6, bitSet3, bitSet4, bitSet5);
                bl2 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl = bitSet4.equals(bitSet3);
            bitSet3.clear();
            bitSet3.or(bitSet4);
        }
        l = System.currentTimeMillis() - l;
        if (!this.silentPrecomputations) {
            this.mainLog.print("Prob1");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet3;
    }

    protected ModelCheckerResult doValueIterationReachProbs(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray2, BitSet bitSet3, IterationMethod iterationMethod, boolean bl) throws PrismException {
        double d;
        long l = System.currentTimeMillis();
        String string = (bl ? "topological, " : "") + "with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting value iteration (" + string + ")...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit DTMC ReachProbs value iteration (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = dTMC.getNumStates();
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray2 != null) {
            if (bitSet3 != null) {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet3.get(i) ? dArray2[i] : (bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : dArray2[i]));
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : dArray2[i]);
                }
            }
        } else {
            dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : d);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMult(dTMC);
        iterationValIter.init(dArray2);
        if (exportIterations != null) {
            exportIterations.exportVector(dArray2, 0);
        }
        IntSet intSet = IntSet.asIntSet(bitSet4);
        if (bl) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, dTMC, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = dTMC.mvMultJacSingle(n, dArray);
            };
            return iterationMethod.doTopologicalValueIteration(this, string, sCCInfo, iterationValIter, singletonSCCSolver, l, exportIterations);
        }
        return iterationMethod.doValueIteration(this, string, iterationValIter, intSet, l, exportIterations);
    }

    protected ModelCheckerResult computeReachProbsValIter(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        IterationMethodPower iterationMethodPower = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
        return this.doValueIterationReachProbs(dTMC, bitSet, bitSet2, dArray, bitSet3, iterationMethodPower, false);
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        return this.computeReachProbsGaussSeidel(dTMC, bitSet, bitSet2, dArray, bitSet3, false);
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3, boolean bl) throws PrismException {
        IterationMethodGS iterationMethodGS = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, bl);
        return this.doValueIterationReachProbs(dTMC, bitSet, bitSet2, dArray, bitSet3, iterationMethodGS, false);
    }

    protected ModelCheckerResult doIntervalIterationReachProbs(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, double[] dArray2, BitSet bitSet3, IterationMethod iterationMethod, boolean bl) throws PrismException {
        long l = System.currentTimeMillis();
        String string = (bl ? "topological, " : "") + "with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting interval iteration (" + string + ")...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit DTMC ReachProbs interval iteration  (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = dTMC.getNumStates();
        double[] dArray3 = dArray2 == null ? new double[n2] : dArray2;
        double[] dArray4 = new double[n2];
        if (bitSet3 != null && dArray2 != null) {
            for (int i = 0; i < n2; ++i) {
                double d = bitSet3.get(i) ? dArray2[i] : (bitSet2.get(i) ? 1.0 : (dArray3[i] = bitSet.get(i) ? 0.0 : 0.0));
                dArray4[i] = bitSet3.get(i) ? dArray2[i] : (bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : 1.0));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                double d = bitSet2.get(i) ? 1.0 : (dArray3[i] = bitSet.get(i) ? 0.0 : 0.0);
                dArray4[i] = bitSet2.get(i) ? 1.0 : (bitSet.get(i) ? 0.0 : 1.0);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray3, 0);
            exportIterations.exportVector(dArray4, 1);
        }
        IntSet intSet = IntSet.asIntSet(bitSet4);
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this);
        boolean bl2 = optionsIntervalIteration.isEnforceMonotonicityFromBelow();
        boolean bl3 = optionsIntervalIteration.isEnforceMonotonicityFromAbove();
        boolean bl4 = optionsIntervalIteration.isCheckMonotonicity();
        if (!bl3) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from above.");
        }
        if (!bl2) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from below.");
        }
        IterationMethod.IterationIntervalIter iterationIntervalIter = iterationMethod.forMvMultInterval(dTMC, true, bl2, bl4);
        IterationMethod.IterationIntervalIter iterationIntervalIter2 = iterationMethod.forMvMultInterval(dTMC, false, bl3, bl4);
        iterationIntervalIter.init(dArray3);
        iterationIntervalIter2.init(dArray4);
        if (bl) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, dTMC, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = dTMC.mvMultJacSingle(n, dArray);
            };
            return iterationMethod.doTopologicalIntervalIteration(this, string, sCCInfo, iterationIntervalIter, iterationIntervalIter2, singletonSCCSolver, l, exportIterations);
        }
        return iterationMethod.doIntervalIteration(this, string, iterationIntervalIter, iterationIntervalIter2, intSet, l, exportIterations);
    }

    public ModelCheckerResult computeBoundedReachProbs(DTMC<Double> dTMC, BitSet bitSet, int n) throws PrismException {
        return this.computeBoundedReachProbs(dTMC, null, bitSet, n, null, null);
    }

    public ModelCheckerResult computeBoundedUntilProbs(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, int n) throws PrismException {
        return this.computeBoundedReachProbs(dTMC, bitSet, bitSet2, n, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(DTMC<Double> dTMC, BitSet bitSet, BitSet bitSet2, int n, double[] dArray, double[] dArray2) throws PrismException {
        int n2;
        double[] dArray3;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting bounded probabilistic reachability...");
        int n3 = dTMC.getNumStates();
        double[] dArray4 = new double[n3];
        double[] dArray5 = dArray3 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray4[n2] = dArray3[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray4[n2] = dArray3[n2];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = Utils.minMaxOverArraySubset(dArray3, dTMC.getInitialStates(), true);
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n3);
        bitSet3.andNot(bitSet2);
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            dTMC.mvMult(dArray4, dArray3, bitSet3, false);
            if (dArray2 != null) {
                dArray2[n4] = Utils.minMaxOverArraySubset(dArray3, dTMC.getInitialStates(), true);
            }
            double[] dArray6 = dArray4;
            dArray4 = dArray3;
            dArray3 = dArray6;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Bounded probabilistic reachability");
        this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.lastSoln = dArray3;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    double computeReachRewardsUpperBound(DTMC<Double> dTMC, final MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        if (bitSet2.isEmpty()) {
            this.mainLog.println("Skipping upper bound computation, no unknown states...");
            return 0.0;
        }
        BitSet bitSet4 = (BitSet)bitSet.clone();
        bitSet4.or(bitSet3);
        DTMCAlteredDistributions<Double> dTMCAlteredDistributions = DTMCAlteredDistributions.addSelfLoops(dTMC, bitSet4);
        OptionsIntervalIteration optionsIntervalIteration = OptionsIntervalIteration.from(this);
        double d = 0.0;
        String string = null;
        switch (optionsIntervalIteration.getBoundMethod()) {
            case VARIANT_1_COARSE: {
                d = this.computeReachRewardsUpperBoundVariant1Coarse(dTMCAlteredDistributions, mCRewards, bitSet, bitSet2, bitSet3);
                string = "variant 1, coarse";
                break;
            }
            case VARIANT_1_FINE: {
                d = this.computeReachRewardsUpperBoundVariant1Fine(dTMCAlteredDistributions, mCRewards, bitSet, bitSet2, bitSet3);
                string = "variant 1, fine";
                break;
            }
            case VARIANT_2: {
                d = this.computeReachRewardsUpperBoundVariant2(dTMCAlteredDistributions, mCRewards, bitSet, bitSet2, bitSet3);
                string = "variant 2";
                break;
            }
            case DEFAULT: 
            case DSMPI: {
                MDPFromDTMC<Double> mDPFromDTMC = new MDPFromDTMC<Double>((DTMC<Double>)dTMCAlteredDistributions);
                MDPRewards<Double> mDPRewards = new MDPRewards<Double>(){

                    @Override
                    public Double getStateReward(int n) {
                        return (Double)mCRewards.getStateReward(n);
                    }

                    @Override
                    public Double getTransitionReward(int n, int n2) {
                        return 0.0;
                    }

                    @Override
                    public MDPRewards<Double> liftFromModel(Product<?> product) {
                        throw new RuntimeException("Unsupported");
                    }

                    @Override
                    public boolean hasTransitionRewards() {
                        return false;
                    }
                };
                d = DijkstraSweepMPI.computeUpperBound(this, mDPFromDTMC, mDPRewards, bitSet, bitSet2);
                string = "Dijkstra Sweep MPI";
                break;
            }
        }
        if (string == null) {
            throw new PrismException("Unknown upper bound heuristic");
        }
        this.mainLog.println("Upper bound for expectation (" + string + "): " + d);
        return d;
    }

    double computeReachRewardsUpperBoundVariant1Coarse(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        Object object;
        double[] dArray = new double[dTMC.getNumStates()];
        int[] nArray = new int[dTMC.getNumStates()];
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, dTMC, true, null);
        BitSet bitSet4 = new BitSet();
        double d = 0.0;
        int n = sCCInfo.getNumSCCs();
        block0: for (int i = 0; i < n; ++i) {
            IntSet intSet = sCCInfo.getStatesForSCC(i);
            int n2 = Math.toIntExact(intSet.cardinality());
            object = intSet.iterator();
            while (object.hasNext()) {
                int n3 = object.nextInt();
                nArray[n3] = n2;
                if (bitSet.get(n3) || bitSet3.get(n3)) {
                    assert (n2 == 1);
                    continue block0;
                }
                double d2 = 0.0;
                boolean bl = true;
                boolean bl2 = false;
                Iterator<Map.Entry<Integer, Double>> iterator = dTMC.getTransitionsIterator(n3);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    if (intSet.get(entry.getKey())) {
                        d2 += entry.getValue().doubleValue();
                        bl2 = true;
                        continue;
                    }
                    bl = false;
                }
                if (!bl) {
                    d = Math.max(d, d2);
                }
                if (n2 != 1 || bl2) continue;
                bitSet4.set(n3);
            }
        }
        double d3 = 1.0;
        for (int i = 0; i < dTMC.getNumStates(); ++i) {
            Iterator<Map.Entry<Integer, Double>> iterator = dTMC.getTransitionsIterator(i);
            while (iterator.hasNext()) {
                object = iterator.next();
                d3 = Math.min(d3, (Double)object.getValue());
            }
        }
        double d4 = 0.0;
        for (int i = 0; i < dTMC.getNumStates(); ++i) {
            if (bitSet.get(i) || bitSet3.get(i)) {
                dArray[i] = 0.0;
                continue;
            }
            if (!bitSet2.get(i)) continue;
            dArray[i] = bitSet4.get(i) ? 1.0 : 1.0 / (Math.pow(d3, nArray[i] - 1) * (1.0 - d));
            d4 += dArray[i] * (Double)mCRewards.getStateReward(i);
        }
        stopWatch.stop();
        if (OptionsIntervalIteration.from(this).isBoundComputationVerbose()) {
            this.mainLog.println("Upper bound for max expectation computation (variant 1, coarse):");
            this.mainLog.println("p = " + d3);
            this.mainLog.println("q = " + d);
            this.mainLog.println("|Ct| = " + Arrays.toString(nArray));
            this.mainLog.println("\u03b6* = " + Arrays.toString(dArray));
        }
        if (!Double.isFinite(d4)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result");
        }
        return d4;
    }

    double computeReachRewardsUpperBoundVariant1Fine(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        double[] dArray = new double[dTMC.getNumStates()];
        double[] dArray2 = new double[dTMC.getNumStates()];
        double[] dArray3 = new double[dTMC.getNumStates()];
        int[] nArray = new int[dTMC.getNumStates()];
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, dTMC, true, null);
        BitSet bitSet4 = new BitSet();
        int n = sCCInfo.getNumSCCs();
        for (int i = 0; i < n; ++i) {
            IntSet intSet = sCCInfo.getStatesForSCC(i);
            double d = 0.0;
            double d2 = 1.0;
            int n2 = Math.toIntExact(intSet.cardinality());
            FunctionalPrimitiveIterator.OfInt ofInt = intSet.iterator();
            while (ofInt.hasNext()) {
                int n3 = ofInt.nextInt();
                nArray[n3] = n2;
                double d3 = 0.0;
                boolean bl = true;
                boolean bl2 = false;
                Iterator<Map.Entry<Integer, Double>> iterator = dTMC.getTransitionsIterator(n3);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Double> entry = iterator.next();
                    if (intSet.get(entry.getKey())) {
                        d3 += entry.getValue().doubleValue();
                        d2 = Math.min(d2, entry.getValue());
                        bl2 = true;
                        continue;
                    }
                    bl = false;
                }
                if (!bl) {
                    d = Math.max(d, d3);
                }
                if (n2 != 1 || bl2) continue;
                bitSet4.set(n3);
            }
            FunctionalPrimitiveIterator.OfInt ofInt2 = intSet.iterator();
            while (ofInt2.hasNext()) {
                int n4 = (Integer)ofInt2.next();
                dArray2[n4] = d;
                dArray3[n4] = d2;
            }
        }
        double d = 0.0;
        for (int i = 0; i < dTMC.getNumStates(); ++i) {
            if (bitSet.get(i) || bitSet3.get(i)) {
                dArray[i] = 0.0;
                continue;
            }
            if (bitSet2.get(i)) {
                if (bitSet4.get(i)) {
                    dArray[i] = 1.0;
                } else {
                    if (dArray3[i] == 1.0) {
                        // empty if block
                    }
                    dArray[i] = 1.0 / (Math.pow(dArray3[i], nArray[i] - 1) * (1.0 - dArray2[i]));
                }
                d += dArray[i] * (Double)mCRewards.getStateReward(i);
                continue;
            }
            throw new PrismException("Bogus arguments: inf/target/unknown should partition state space");
        }
        stopWatch.stop();
        if (OptionsIntervalIteration.from(this).isBoundComputationVerbose()) {
            this.mainLog.println("Upper bound for max expectation computation (variant 1, fine):");
            this.mainLog.println("pt = " + Arrays.toString(dArray3));
            this.mainLog.println("qt = " + Arrays.toString(dArray2));
            this.mainLog.println("|Ct| = " + Arrays.toString(nArray));
            this.mainLog.println("\u03b6* = " + Arrays.toString(dArray));
        }
        if (!Double.isFinite(d)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result");
        }
        return d;
    }

    double computeReachRewardsUpperBoundVariant2(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        int n;
        double[] dArray = new double[dTMC.getNumStates()];
        double[] dArray2 = new double[dTMC.getNumStates()];
        StopWatch stopWatch = new StopWatch(this.getLog());
        stopWatch.start("computing an upper bound for expected reward");
        SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, dTMC, true, bitSet2::get);
        BitSet bitSet4 = (BitSet)bitSet.clone();
        int n4 = 0;
        while (true) {
            int n5;
            BitSet bitSet5 = new BitSet();
            ++n4;
            FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getClearBits(bitSet4, dTMC.getNumStates() - 1).iterator();
            while (ofInt.hasNext()) {
                n5 = ofInt.nextInt();
                if (!dTMC.someSuccessorsInSet(n5, bitSet4)) continue;
                bitSet5.set(n5);
            }
            if (bitSet5.isEmpty()) break;
            ofInt = IterableBitSet.getSetBits(bitSet5).iterator();
            while (ofInt.hasNext()) {
                double d2;
                n5 = ofInt.nextInt();
                n = sCCInfo.getSCCIndex(n5);
                dArray[n5] = d2 = dTMC.sumOverDoubleTransitions(n5, (n2, n3, d) -> {
                    if (!bitSet4.get(n3)) {
                        return 0.0;
                    }
                    boolean bl = sCCInfo.getSCCIndex(n3) == n;
                    double d2 = bl ? dArray[n3] : 1.0;
                    return d2 * d;
                });
            }
            bitSet4.or(bitSet5);
        }
        double d3 = 0.0;
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet2).iterator();
        while (ofInt.hasNext()) {
            n = ofInt.nextInt();
            dArray2[n] = 1.0 / dArray[n];
            d3 += dArray2[n] * (Double)mCRewards.getStateReward(n);
        }
        stopWatch.stop();
        if (OptionsIntervalIteration.from(this).isBoundComputationVerbose()) {
            this.mainLog.println("Upper bound for max expectation computation (variant 2):");
            this.mainLog.println("d_t = " + Arrays.toString(dArray));
            this.mainLog.println("\u03b6* = " + Arrays.toString(dArray2));
        }
        if (!Double.isFinite(d3)) {
            throw new PrismException("Problem computing an upper bound for the expectation, did not get finite result");
        }
        return d3;
    }

    public ModelCheckerResult computeReachRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet) throws PrismException {
        return this.computeReachRewards(dTMC, mCRewards, bitSet, null, null);
    }

    public ModelCheckerResult computeReachRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet object, double[] dArray, BitSet bitSet) throws PrismException {
        BitSet bitSet2;
        int n;
        Object object2;
        Object object3;
        ModelCheckerResult modelCheckerResult = null;
        ProbModelChecker.LinEqMethod linEqMethod = this.linEqMethod;
        switch (linEqMethod) {
            case POWER: 
            case GAUSS_SEIDEL: 
            case BACKWARDS_GAUSS_SEIDEL: 
            case JACOBI: {
                break;
            }
            default: {
                linEqMethod = ProbModelChecker.LinEqMethod.GAUSS_SEIDEL;
                this.mainLog.printWarning("Switching to linear equation solution method \"" + linEqMethod.fullName() + "\"");
            }
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected reachability...");
        dTMC.checkForDeadlocks((BitSet)object);
        int n2 = dTMC.getNumStates();
        if (dArray != null && bitSet != null && !bitSet.isEmpty()) {
            object3 = (BitSet)((BitSet)object).clone();
            object2 = new IterableBitSet(bitSet).iterator();
            while (object2.hasNext()) {
                n = (Integer)object2.next();
                if (dArray[n] != 1.0) continue;
                ((BitSet)object3).set(n);
            }
            object = object3;
        }
        long l2 = System.currentTimeMillis();
        if (this.preRel) {
            object3 = dTMC.getPredecessorRelation(this, true);
            bitSet2 = this.prob1(dTMC, null, (BitSet)object, (PredecessorRelation)object3);
        } else {
            bitSet2 = this.prob1(dTMC, null, (BitSet)object);
        }
        bitSet2.flip(0, n2);
        l2 = System.currentTimeMillis() - l2;
        int n3 = ((BitSet)object).cardinality();
        int n4 = bitSet2.cardinality();
        this.mainLog.println("target=" + n3 + ", inf=" + n4 + ", rest=" + (n2 - (n3 + n4)));
        if (n3 + n4 < n2) {
            boolean bl = this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE;
            switch (linEqMethod) {
                case POWER: {
                    object2 = new IterationMethodPower(bl, this.termCritParam);
                    break;
                }
                case JACOBI: {
                    object2 = new IterationMethodJacobi(bl, this.termCritParam);
                    break;
                }
                case GAUSS_SEIDEL: 
                case BACKWARDS_GAUSS_SEIDEL: {
                    n = linEqMethod == ProbModelChecker.LinEqMethod.BACKWARDS_GAUSS_SEIDEL ? 1 : 0;
                    object2 = new IterationMethodGS(bl, this.termCritParam, n != 0);
                    break;
                }
                default: {
                    throw new PrismException("Unknown linear equation solution method " + linEqMethod.fullName());
                }
            }
            modelCheckerResult = this.doIntervalIteration ? this.doIntervalIterationReachRewards(dTMC, mCRewards, (BitSet)object, bitSet2, dArray, bitSet, (IterationMethod)object2, this.getDoTopologicalValueIteration()) : this.doValueIterationReachRewards(dTMC, mCRewards, (BitSet)object, bitSet2, dArray, bitSet, (IterationMethod)object2, this.getDoTopologicalValueIteration());
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet2, n2, Double.POSITIVE_INFINITY);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsValIter(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        double[] dArray2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting value iteration...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit DTMC ReachRewards value iteration");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = dTMC.getNumStates();
        double[] dArray3 = new double[n2];
        double[] dArray4 = dArray2 = dArray == null ? new double[n2] : dArray;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = bitSet3.get(n) ? dArray[n] : (bitSet.get(n) ? 0.0 : (bitSet2.get(n) ? Double.POSITIVE_INFINITY : dArray[n]));
                    dArray3[n] = dArray2[n];
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = bitSet.get(n) ? 0.0 : (bitSet2.get(n) ? Double.POSITIVE_INFINITY : dArray[n]);
                    dArray3[n] = dArray2[n];
                }
            }
        } else {
            for (n = 0; n < n2; ++n) {
                dArray2[n] = bitSet.get(n) ? 0.0 : (bitSet2.get(n) ? Double.POSITIVE_INFINITY : 0.0);
                dArray3[n] = dArray2[n];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray3, 0);
        }
        int n3 = 0;
        boolean bl = false;
        while (!bl && n3 < this.maxIters) {
            ++n3;
            dTMC.mvMultRew(dArray3, mCRewards, dArray2, bitSet4, false);
            if (exportIterations != null) {
                exportIterations.exportVector(dArray3, 0);
            }
            bl = PrismUtils.doublesAreClose(dArray3, dArray2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray5 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray5;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Value iteration");
        this.mainLog.println(" took " + n3 + " iterations and " + (double)l / 1000.0 + " seconds.");
        if (exportIterations != null) {
            exportIterations.close();
        }
        if (!bl && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n3 + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray3;
        double d = PrismUtils.measureSupNorm(dArray3, dArray2, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.accuracy = AccuracyFactory.valueIteration(this.termCritParam, d, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.numIters = n3;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult doValueIterationReachRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, double[] dArray2, BitSet bitSet3, IterationMethod iterationMethod, boolean bl) throws PrismException {
        long l = System.currentTimeMillis();
        String string = (bl ? "topological, " : "") + "with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting value iteration (" + string + ") ...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit DTMC ReachRewards value iteration (" + string + ")");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        int n2 = dTMC.getNumStates();
        if (dArray2 != null) {
            if (bitSet3 != null) {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet3.get(i) ? dArray2[i] : (bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : dArray2[i]));
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : dArray2[i]);
                }
            }
        } else {
            dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : 0.0);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n2);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray2, 0);
        }
        IntSet intSet = IntSet.asIntSet(bitSet4);
        IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultRew(dTMC, mCRewards);
        iterationValIter.init(dArray2);
        if (bl) {
            SCCInfo sCCInfo = new SCCInfo(n2);
            SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC, sCCInfo);
            sCCComputer.computeSCCs(false, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = dTMC.mvMultRewJacSingle(n, dArray, mCRewards);
            };
            return iterationMethod.doTopologicalValueIteration(this, string, sCCInfo, iterationValIter, singletonSCCSolver, l, exportIterations);
        }
        return iterationMethod.doValueIteration(this, string, iterationValIter, intSet, l, exportIterations);
    }

    protected ModelCheckerResult doIntervalIterationReachRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards, BitSet bitSet, BitSet bitSet2, double[] dArray2, BitSet bitSet3, IterationMethod iterationMethod, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        int n2;
        double d;
        double d2;
        OptionsIntervalIteration optionsIntervalIteration;
        int n3 = dTMC.getNumStates();
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        if ((optionsIntervalIteration = OptionsIntervalIteration.from(this)).hasManualUpperBound()) {
            d2 = optionsIntervalIteration.getManualUpperBound();
            this.getLog().printWarning("Upper bound for interval iteration manually set to " + d2);
        } else {
            d2 = this.computeReachRewardsUpperBound(dTMC, mCRewards, bitSet, bitSet4, bitSet2);
        }
        if (optionsIntervalIteration.hasManualLowerBound()) {
            d = optionsIntervalIteration.getManualLowerBound();
            this.getLog().printWarning("Lower bound for interval iteration manually set to " + d);
        } else {
            d = 0.0;
        }
        long l = System.currentTimeMillis();
        String string = (bl ? "topological, " : "") + "with " + iterationMethod.getDescriptionShort();
        this.mainLog.println("Starting interval iteration (" + string + ") ...");
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = new ExportIterations("Explicit DTMC ReachRewards interval iteration (" + string + ") ...");
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        double[] dArray3 = dArray2 == null ? new double[n3] : dArray2;
        double[] dArray4 = new double[n3];
        if (dArray2 != null && bitSet3 != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet3.get(n2) ? dArray2[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d));
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d);
            }
        }
        if (dArray2 != null && bitSet3 != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet3.get(n2) ? dArray2[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d2));
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : d2);
            }
        }
        if (exportIterations != null) {
            exportIterations.exportVector(dArray3, 0);
            exportIterations.exportVector(dArray4, 1);
        }
        IntSet intSet = IntSet.asIntSet(bitSet4);
        boolean bl2 = optionsIntervalIteration.isEnforceMonotonicityFromBelow();
        boolean bl3 = optionsIntervalIteration.isEnforceMonotonicityFromAbove();
        boolean bl4 = optionsIntervalIteration.isCheckMonotonicity();
        if (!bl3) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from above.");
        }
        if (!bl2) {
            this.getLog().println("Note: Interval iteration is configured to not enforce monotonicity from below.");
        }
        IterationMethod.IterationIntervalIter iterationIntervalIter = iterationMethod.forMvMultRewInterval(dTMC, mCRewards, true, bl2, bl4);
        IterationMethod.IterationIntervalIter iterationIntervalIter2 = iterationMethod.forMvMultRewInterval(dTMC, mCRewards, false, bl3, bl4);
        iterationIntervalIter.init(dArray3);
        iterationIntervalIter2.init(dArray4);
        if (bl) {
            SCCInfo sCCInfo = SCCComputer.computeTopologicalOrdering(this, dTMC, true, bitSet4::get);
            IterationMethod.SingletonSCCSolver singletonSCCSolver = (n, dArray) -> {
                dArray[n] = dTMC.mvMultRewJacSingle(n, dArray, mCRewards);
            };
            modelCheckerResult = iterationMethod.doTopologicalIntervalIteration(this, string, sCCInfo, iterationIntervalIter, iterationIntervalIter2, singletonSCCSolver, l, exportIterations);
        } else {
            modelCheckerResult = iterationMethod.doIntervalIteration(this, string, iterationIntervalIter, iterationIntervalIter2, intSet, l, exportIterations);
        }
        double d3 = PrismUtils.findMaxFinite(modelCheckerResult.soln, intSet.iterator());
        if (d3 != Double.NEGATIVE_INFINITY) {
            this.mainLog.println("Maximum finite value in solution vector at end of interval iteration: " + d3);
        }
        return modelCheckerResult;
    }

    protected StateValues computeSteadyStateFormula(DTMC<Double> dTMC, BitSet bitSet) throws PrismException {
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, dTMC.getNumStates());
        ModelCheckerResult modelCheckerResult = this.computeSteadyStateBackwardsProbs(dTMC, dArray);
        return StateValues.createFromDoubleArray(modelCheckerResult.soln, dTMC);
    }

    public ModelCheckerResult computeSteadyStateProbs(DTMC<Double> dTMC, double[] dArray) throws PrismException {
        return this.computeSteadyStateProbs(dTMC, dArray, null);
    }

    public ModelCheckerResult computeSteadyStateProbs(DTMC<Double> dTMC, double[] dArray, BSCCPostProcessor bSCCPostProcessor) throws PrismException {
        Object object;
        int n;
        StopWatch stopWatch = new StopWatch().start();
        int n2 = dTMC.getNumStates();
        double[] dArray2 = new double[n2];
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC, sCCConsumerStore);
        sCCComputer.computeSCCs();
        List<BitSet> list = sCCConsumerStore.getBSCCs();
        BitSet bitSet = sCCConsumerStore.getNotInBSCCs();
        int n3 = list.size();
        int n4 = 0;
        BitSet bitSet2 = new BitSet();
        for (n = 0; n < n2; ++n) {
            if (dArray[n] > 0.0) {
                bitSet2.set(n);
            }
            ++n4;
        }
        n = -1;
        for (int i = 0; i < n3; ++i) {
            BitSet bitSet3 = (BitSet)bitSet2.clone();
            bitSet3.andNot(list.get(i));
            if (bitSet3.isEmpty()) {
                n = i;
                break;
            }
            if (bitSet3.cardinality() < n4) break;
        }
        if (n > -1) {
            this.mainLog.println("\nInitial states are all in one BSCC (so no reachability probabilities computed)");
            object = list.get(n);
            this.computeSteadyStateProbsForBSCC(dTMC, (BitSet)object, dArray2, bSCCPostProcessor);
        } else {
            BitSet bitSet4;
            int n5;
            object = new double[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                this.mainLog.println("\nComputing probability of reaching BSCC " + (n5 + 1));
                bitSet4 = list.get(n5);
                double[] dArray3 = this.computeUntilProbs(dTMC, (BitSet)bitSet, (BitSet)bitSet4).soln;
                object[n5] = 0.0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = n5;
                    object[n6] = object[n6] + dArray[i] * dArray3[i];
                }
                this.mainLog.print("\nProbability of reaching BSCC " + (n5 + 1) + ": " + object[n5] + "\n");
            }
            for (n5 = 0; n5 < n3; ++n5) {
                this.mainLog.println("\nComputing steady-state probabilities for BSCC " + (n5 + 1));
                bitSet4 = list.get(n5);
                this.computeSteadyStateProbsForBSCC(dTMC, bitSet4, dArray2, bSCCPostProcessor);
                int n7 = bitSet4.nextSetBit(0);
                while (n7 >= 0) {
                    int n8 = n7;
                    dArray2[n8] = dArray2[n8] * object[n5];
                    n7 = bitSet4.nextSetBit(n7 + 1);
                }
            }
        }
        object = new ModelCheckerResult();
        object.soln = dArray2;
        object.timeTaken = stopWatch.elapsedSeconds();
        return object;
    }

    public ModelCheckerResult computeSteadyStateBackwardsProbs(DTMC<Double> dTMC, double[] dArray) throws PrismException {
        return this.computeSteadyStateBackwardsProbs(dTMC, dArray, null);
    }

    public ModelCheckerResult computeSteadyStateBackwardsProbs(DTMC<Double> dTMC, double[] dArray, BSCCPostProcessor bSCCPostProcessor) throws PrismException {
        int n;
        StopWatch stopWatch = new StopWatch().start();
        int n2 = dTMC.getNumStates();
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, dTMC, sCCConsumerStore);
        sCCComputer.computeSCCs();
        List<BitSet> list = sCCConsumerStore.getBSCCs();
        BitSet bitSet = sCCConsumerStore.getNotInBSCCs();
        int n3 = list.size();
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n3; ++i) {
            int n4;
            this.mainLog.println("\nComputing steady state probabilities for BSCC " + (i + 1));
            BitSet bitSet2 = list.get(i);
            this.computeSteadyStateProbsForBSCC(dTMC, bitSet2, dArray3, bSCCPostProcessor);
            dArray2[i] = 0.0;
            if (dArray == null) {
                n4 = bitSet2.nextSetBit(0);
                while (n4 >= 0) {
                    int n5 = i;
                    dArray2[n5] = dArray2[n5] + dArray3[n4];
                    n4 = bitSet2.nextSetBit(n4 + 1);
                }
            } else {
                n4 = bitSet2.nextSetBit(0);
                while (n4 >= 0) {
                    int n6 = i;
                    dArray2[n6] = dArray2[n6] + dArray[n4] * dArray3[n4];
                    n4 = bitSet2.nextSetBit(n4 + 1);
                }
            }
            this.mainLog.print("\nValue for BSCC " + (i + 1) + ": " + dArray2[i] + "\n");
        }
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray4[n] = 0.0;
        }
        if (bitSet.isEmpty()) {
            this.mainLog.println("\nAll states are in BSCCs (so no reachability probabilities computed)");
            for (n = 0; n < n3; ++n) {
                BitSet bitSet3 = list.get(n);
                int n7 = bitSet3.nextSetBit(0);
                while (n7 >= 0) {
                    int n8 = n7;
                    dArray4[n8] = dArray4[n8] + dArray2[n];
                    n7 = bitSet3.nextSetBit(n7 + 1);
                }
            }
        } else {
            for (n = 0; n < n3; ++n) {
                if (dArray2[n] == 0.0) continue;
                this.mainLog.println("\nComputing probabilities of reaching BSCC " + (n + 1));
                BitSet bitSet4 = list.get(n);
                double[] dArray5 = this.computeUntilProbs(dTMC, (BitSet)bitSet, (BitSet)bitSet4).soln;
                for (int i = 0; i < n2; ++i) {
                    int n9 = i;
                    dArray4[n9] = dArray4[n9] + dArray5[i] * dArray2[n];
                }
            }
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray4;
        modelCheckerResult.timeTaken = stopWatch.elapsedSeconds();
        return modelCheckerResult;
    }

    public ModelCheckerResult computeSteadyStateRewards(DTMC<Double> dTMC, MCRewards<Double> mCRewards) throws PrismException {
        int n = dTMC.getNumStates();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (Double)mCRewards.getStateReward(i);
        }
        return this.computeSteadyStateBackwardsProbs(dTMC, dArray);
    }

    public ModelCheckerResult computeSteadyStateProbsForBSCC(DTMC<Double> dTMC, BitSet bitSet, double[] dArray) throws PrismException {
        return this.computeSteadyStateProbsForBSCC(dTMC, bitSet, dArray, null);
    }

    public ModelCheckerResult computeSteadyStateProbsForBSCC(DTMC<Double> dTMC, BitSet bitSet, double[] dArray, BSCCPostProcessor bSCCPostProcessor) throws PrismException {
        Object object;
        int n;
        if (dTMC.getModelType() != ModelType.DTMC) {
            throw new PrismNotSupportedException("Explicit engine currently does not support steady-state computation for " + String.valueOf((Object)dTMC.getModelType()));
        }
        IterableBitSet iterableBitSet = new IterableBitSet(bitSet);
        this.mainLog.println("Starting value iteration...");
        StopWatch stopWatch = new StopWatch(this.mainLog).start();
        int n4 = dTMC.getNumStates();
        double[] dArray2 = dArray == null ? new double[n4] : dArray;
        double[] dArray3 = new double[n4];
        double d2 = 0.0;
        double d3 = 1.0 / (double)bitSet.cardinality();
        FunctionalPrimitiveIterator.OfInt ofInt = iterableBitSet.iterator();
        while (ofInt.hasNext()) {
            int n5 = ofInt.nextInt();
            dArray2[n5] = d3;
            dTMC.forEachDoubleTransition(n5, (n2, n3, d) -> {
                if (n2 != n3) {
                    int n4 = n5;
                    dArray[n4] = dArray3[n4] - d;
                }
            });
            d2 = Math.max(d2, -dArray3[n5]);
        }
        double d4 = 0.99;
        ExportIterations exportIterations = null;
        if (this.settings.getBoolean("prism.exportIterations")) {
            exportIterations = ExportIterations.createWithUniqueFilename("Explicit DTMC BSCC steady state value iteration", "iterations-ss-bscc");
            exportIterations.exportVector(dArray2);
            this.mainLog.println("Exporting iterations to " + exportIterations.getFileName());
        }
        Object object2 = (double[])dArray2.clone();
        boolean bl = false;
        for (n = 0; !bl && n < this.maxIters; ++n) {
            dTMC.vmMultPowerSteadyState(dArray2, (double[])object2, dArray3, d4, iterableBitSet);
            bl = PrismUtils.doublesAreClose(dArray2, object2, iterableBitSet, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            object = dArray2;
            dArray2 = object2;
            object2 = object;
            if (exportIterations == null) continue;
            exportIterations.exportVector(dArray2);
        }
        stopWatch.stop();
        this.mainLog.println("Power method: " + n + " iterations in " + stopWatch.elapsedSeconds() + " seconds.");
        PrismUtils.normalise(dArray2, iterableBitSet);
        if (exportIterations != null) {
            exportIterations.exportVector(dArray2);
            exportIterations.close();
        }
        if (bSCCPostProcessor != null) {
            bSCCPostProcessor.apply(dArray2, bitSet);
        }
        if (dArray != null && dArray != dArray2) {
            object = iterableBitSet.iterator();
            while (object.hasNext()) {
                int n6 = object.nextInt();
                dArray[n6] = dArray2[n6];
            }
        }
        dArray = dArray2;
        object2 = null;
        dArray2 = null;
        if (!bl && this.errorOnNonConverge) {
            object = "Iterative method did not converge within " + n + " iterations.\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException((String)object);
        }
        object = new ModelCheckerResult();
        ((ModelCheckerResult)object).soln = dArray;
        ((ModelCheckerResult)object).numIters = n;
        ((ModelCheckerResult)object).timeTaken = stopWatch.elapsedSeconds();
        return object;
    }

    public ModelCheckerResult computeTransientProbs(DTMC<Double> dTMC, int n, double[] dArray) throws PrismException {
        int n2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting transient probability computation...");
        int n3 = dTMC.getNumStates();
        double[] dArray2 = dArray;
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n; ++n2) {
            dTMC.vmMult(dArray2, dArray3);
            double[] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Transient probability computation");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public static void main(String[] stringArray) {
        try {
            int n = 2;
            if (n == 1) {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(null);
                DTMCSimple<Double> dTMCSimple = new DTMCSimple<Double>();
                dTMCSimple.buildFromPrismExplicit(stringArray[0]);
                dTMCSimple.addInitialState(0);
                Map<String, BitSet> map = StateModelChecker.loadLabelsFile(stringArray[1]);
                BitSet bitSet = map.get(stringArray[2]);
                if (bitSet == null) {
                    throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
                }
                for (int i = 3; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("-nopre")) continue;
                    dTMCModelChecker.setPrecomp(false);
                }
                ModelCheckerResult modelCheckerResult = dTMCModelChecker.computeReachProbs(dTMCSimple, bitSet);
                System.out.println(modelCheckerResult.soln[0]);
            } else {
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(null);
                DTMCSimple<Double> dTMCSimple = new DTMCSimple<Double>(6);
                dTMCSimple.setProbability(0, 1, 0.1);
                dTMCSimple.setProbability(0, 2, 0.9);
                dTMCSimple.setProbability(1, 0, 0.4);
                dTMCSimple.setProbability(1, 3, 0.6);
                dTMCSimple.setProbability(2, 2, 0.1);
                dTMCSimple.setProbability(2, 3, 0.1);
                dTMCSimple.setProbability(2, 4, 0.5);
                dTMCSimple.setProbability(2, 5, 0.3);
                dTMCSimple.setProbability(3, 3, 1.0);
                dTMCSimple.setProbability(4, 4, 1.0);
                dTMCSimple.setProbability(5, 5, 0.3);
                dTMCSimple.setProbability(5, 4, 0.7);
                System.out.println(dTMCSimple);
                BitSet bitSet = new BitSet();
                bitSet.set(4);
                BitSet bitSet2 = new BitSet();
                bitSet2.set(1);
                bitSet2.flip(0, 6);
                System.out.println(bitSet);
                System.out.println(bitSet2);
                ModelCheckerResult modelCheckerResult = dTMCModelChecker.computeUntilProbs(dTMCSimple, bitSet2, bitSet);
                System.out.println(modelCheckerResult.soln[0]);
            }
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }

    @FunctionalInterface
    public static interface BSCCPostProcessor {
        public void apply(double[] var1, BitSet var2);
    }
}

