/*
 * Decompiled with CFR 0.152.
 */
package dv;

import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import odd.ODDUtils;
import prism.PrismException;
import prism.PrismLog;

public class IntegerVector {
    private long v;
    private int n;

    public IntegerVector(int n) throws PrismException {
        this.v = this.IV_CreateZeroVector(n);
        if (this.v == 0L) {
            throw new PrismException("Out of memory");
        }
        this.n = n;
    }

    private native long IV_CreateZeroVector(int var1);

    public IntegerVector(long l, int n) {
        this.v = l;
        this.n = n;
    }

    public IntegerVector(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) throws PrismException {
        ODDUtils.checkInt(oDDNode, "Can not create IntegerVector");
        this.v = this.IV_ConvertMTBDD(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
        this.n = (int)oDDNode.getNumStates();
    }

    private native long IV_ConvertMTBDD(long var1, long var3, int var5, long var6);

    public long getPtr() {
        return this.v;
    }

    public int getSize() {
        return this.n;
    }

    public int getElement(int n) {
        return this.IV_GetElement(this.v, this.n, n);
    }

    private native int IV_GetElement(long var1, int var3, int var4);

    public void setElement(int n, int n2) {
        this.IV_SetElement(this.v, this.n, n, n2);
    }

    private native void IV_SetElement(long var1, int var3, int var4, int var5);

    public void setAllElements(int n) {
        this.IV_SetAllElements(this.v, this.n, n);
    }

    private native void IV_SetAllElements(long var1, int var3, int var4);

    public void clear() {
        this.IV_Clear(this.v);
    }

    private native void IV_Clear(long var1);

    public void print(PrismLog prismLog) {
        for (int i = 0; i < this.n; ++i) {
            int n = this.IV_GetElement(this.v, this.n, i);
            prismLog.print(n + " ");
        }
        prismLog.println();
    }

    static {
        try {
            System.loadLibrary("dv");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

