/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public abstract class SingletonIterator<E>
implements FunctionalIterator<E> {
    protected boolean hasNext = true;

    @Override
    public SingletonIterator<E> dedupe() {
        return this;
    }

    @Override
    public SingletonIterator<E> distinct() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void release() {
        this.hasNext = false;
    }

    public static class OfLong
    extends SingletonIterator<Long>
    implements FunctionalPrimitiveIterator.OfLong {
        protected final long element;

        public OfLong(long l) {
            this.element = l;
        }

        @Override
        public long nextLong() {
            this.requireNext();
            this.release();
            return this.element;
        }

        @Override
        public OfLong dedupe() {
            return this;
        }

        @Override
        public OfLong distinct() {
            return this;
        }

        @Override
        public OptionalLong max() {
            if (this.hasNext) {
                this.release();
                return OptionalLong.of(this.element);
            }
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong min() {
            return this.max();
        }

        @Override
        public long sum() {
            return this.hasNext ? this.element : 0L;
        }
    }

    public static class OfInt
    extends SingletonIterator<Integer>
    implements FunctionalPrimitiveIterator.OfInt {
        protected final int element;

        public OfInt(int n) {
            this.element = n;
        }

        @Override
        public int nextInt() {
            this.requireNext();
            this.release();
            return this.element;
        }

        @Override
        public OfInt dedupe() {
            return this;
        }

        @Override
        public OfInt distinct() {
            return this;
        }

        @Override
        public OptionalInt max() {
            if (this.hasNext) {
                this.release();
                return OptionalInt.of(this.element);
            }
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt min() {
            return this.max();
        }

        @Override
        public long sum() {
            return this.hasNext ? (long)this.element : 0L;
        }
    }

    public static class OfDouble
    extends SingletonIterator<Double>
    implements FunctionalPrimitiveIterator.OfDouble {
        protected final double element;

        public OfDouble(double d) {
            this.element = d;
        }

        @Override
        public double nextDouble() {
            this.requireNext();
            this.release();
            return this.element;
        }

        @Override
        public OfDouble dedupe() {
            return this;
        }

        @Override
        public OfDouble distinct() {
            return this;
        }

        @Override
        public OptionalDouble max() {
            if (this.hasNext) {
                this.release();
                return OptionalDouble.of(this.element);
            }
            return OptionalDouble.empty();
        }

        @Override
        public OptionalDouble min() {
            return this.max();
        }

        @Override
        public double sum() {
            return this.hasNext ? this.element : 0.0;
        }
    }

    public static class Of<E>
    extends SingletonIterator<E> {
        protected E element;

        public Of(E e) {
            this.element = e;
        }

        @Override
        public E next() {
            this.requireNext();
            E e = this.element;
            this.release();
            return e;
        }

        @Override
        public void release() {
            super.release();
            this.element = null;
        }
    }
}

