/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterable;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.Reducible;
import java.util.HashSet;
import java.util.Set;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public abstract class Distinct<E> {
    protected final Set<E> seen = new HashSet();

    protected boolean isUnseen(E e) {
        return this.seen.add(e);
    }

    public abstract FunctionalIterable<E> getSeen();

    public static class OfLong
    extends Distinct<Long>
    implements LongPredicate {
        @Override
        public boolean test(long l) {
            return super.isUnseen(l);
        }

        public FunctionalPrimitiveIterable.OfLong getSeen() {
            return Reducible.unboxLong(this.seen);
        }
    }

    public static class OfInt
    extends Distinct<Integer>
    implements IntPredicate {
        @Override
        public boolean test(int n) {
            return super.isUnseen(n);
        }

        public FunctionalPrimitiveIterable.OfInt getSeen() {
            return Reducible.unboxInt(this.seen);
        }
    }

    public static class OfDouble
    extends Distinct<Double>
    implements DoublePredicate {
        boolean zeroSeen = false;

        @Override
        public boolean test(double d) {
            if (d == 0.0) {
                if (this.zeroSeen) {
                    return false;
                }
                this.zeroSeen = true;
                this.seen.add(d);
                return true;
            }
            return super.isUnseen(d);
        }

        public FunctionalPrimitiveIterable.OfDouble getSeen() {
            return Reducible.unboxDouble(this.seen);
        }
    }

    public static class Of<E>
    extends Distinct<E>
    implements Predicate<E> {
        @Override
        public boolean test(E e) {
            return super.isUnseen(e);
        }

        @Override
        public FunctionalIterable<E> getSeen() {
            return Reducible.extend(this.seen);
        }
    }
}

