/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.iterable.Reducible;
import java.util.Iterator;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.function.Predicate;

public class IteratorTools {
    public static boolean and(Iterator<Boolean> iterator) {
        while (iterator.hasNext()) {
            if (iterator.next().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean or(Iterator<Boolean> iterator) {
        while (iterator.hasNext()) {
            if (!iterator.next().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static long count(Iterable<?> iterable) {
        return Reducible.extend(iterable).count();
    }

    public static long count(Iterator<?> iterator) {
        return Reducible.extend(iterator).count();
    }

    public static <T> long count(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Reducible.extend(iterable).count(predicate);
    }

    public static <T> long count(Iterator<T> iterator, Predicate<? super T> predicate) {
        return Reducible.extend(iterator).count(predicate);
    }

    public static OptionalDouble max(PrimitiveIterator.OfDouble ofDouble) {
        return Reducible.extend(ofDouble).max();
    }

    public static OptionalInt max(PrimitiveIterator.OfInt ofInt) {
        return Reducible.extend(ofInt).max();
    }

    public static OptionalLong max(PrimitiveIterator.OfLong ofLong) {
        return Reducible.extend(ofLong).max();
    }

    public static OptionalDouble maxDouble(Iterator<Double> iterator) {
        return Reducible.unboxDouble((Iterator<Double>)((Object)Reducible.extend(iterator).nonNull())).max();
    }

    public static OptionalInt maxInt(Iterator<Integer> iterator) {
        return Reducible.unboxInt((Iterator<Integer>)((Object)Reducible.extend(iterator).nonNull())).max();
    }

    public static OptionalLong maxLong(Iterator<Long> iterator) {
        return Reducible.unboxLong((Iterator<Long>)((Object)Reducible.extend(iterator).nonNull())).max();
    }

    public static OptionalDouble min(PrimitiveIterator.OfDouble ofDouble) {
        return Reducible.extend(ofDouble).min();
    }

    public static OptionalInt min(PrimitiveIterator.OfInt ofInt) {
        return Reducible.extend(ofInt).min();
    }

    public static OptionalLong min(PrimitiveIterator.OfLong ofLong) {
        return Reducible.extend(ofLong).min();
    }

    public static OptionalDouble minDouble(Iterator<Double> iterator) {
        return Reducible.unboxDouble((Iterator<Double>)((Object)Reducible.extend(iterator).nonNull())).min();
    }

    public static OptionalInt minInt(Iterator<Integer> iterator) {
        return Reducible.unboxInt((Iterator<Integer>)((Object)Reducible.extend(iterator).nonNull())).min();
    }

    public static OptionalLong minLong(Iterator<Long> iterator) {
        return Reducible.unboxLong((Iterator<Long>)((Object)Reducible.extend(iterator).nonNull())).min();
    }

    public static double sum(PrimitiveIterator.OfDouble ofDouble) {
        return Reducible.extend(ofDouble).sum();
    }

    public static long sum(PrimitiveIterator.OfInt ofInt) {
        return Reducible.extend(ofInt).sum();
    }

    public static long sum(PrimitiveIterator.OfLong ofLong) {
        return Reducible.extend(ofLong).sum();
    }

    public static double sumDouble(Iterator<Double> iterator) {
        return Reducible.unboxDouble((Iterator<Double>)((Object)Reducible.extend(iterator).nonNull())).sum();
    }

    public static long sumInt(Iterator<Integer> iterator) {
        return Reducible.unboxInt((Iterator<Integer>)((Object)Reducible.extend(iterator).nonNull())).sum();
    }

    public static long sumLong(Iterator<Long> iterator) {
        return Reducible.unboxLong((Iterator<Long>)((Object)Reducible.extend(iterator).nonNull())).sum();
    }

    public static <T> void printIterator(String string, Iterator<T> iterator) {
        System.out.print(string + " = ");
        System.out.print(Reducible.extend(iterator).asString());
        System.out.println();
    }
}

