/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.Objects;

public class IterableBitSet
implements FunctionalPrimitiveIterable.OfInt {
    protected final BitSet set;
    protected final boolean clearBits;
    protected final boolean reversed;
    protected final int maxIndex;

    public IterableBitSet(BitSet bitSet) {
        this(bitSet, null, false, false);
    }

    public IterableBitSet(BitSet bitSet, Integer n, boolean bl) {
        this(bitSet, n, bl, false);
    }

    public IterableBitSet(BitSet bitSet, Integer n, boolean bl, boolean bl2) {
        Objects.requireNonNull(bitSet);
        this.set = bitSet;
        this.maxIndex = n == null ? Integer.MAX_VALUE : Math.max(n, -1);
        this.clearBits = bl;
        this.reversed = bl2;
    }

    @Override
    public FunctionalPrimitiveIterator.OfInt iterator() {
        if (!this.clearBits) {
            if (this.reversed) {
                return new SetBitsReversedIterator();
            }
            return new SetBitsIterator();
        }
        if (this.reversed) {
            return new ClearBitsReversedIterator();
        }
        return new ClearBitsIterator();
    }

    public static IterableBitSet getSetBits(BitSet bitSet) {
        return new IterableBitSet(bitSet);
    }

    public static IterableBitSet getSetBitsReversed(BitSet bitSet) {
        return new IterableBitSet(bitSet, null, false, true);
    }

    public static IterableBitSet getClearBits(BitSet bitSet, int n) {
        return new IterableBitSet(bitSet, n, true);
    }

    public static IterableBitSet getClearBitsReversed(BitSet bitSet, int n) {
        return new IterableBitSet(bitSet, n, true, true);
    }

    public static void main(String[] stringArray) {
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        bitSet.set(1);
        bitSet.set(2);
        bitSet.set(3);
        bitSet.set(5);
        bitSet.set(8);
        bitSet.set(13);
        bitSet.set(21);
        bitSet.set(Integer.MAX_VALUE);
        System.out.println("\n" + String.valueOf(bitSet) + " - set bits:");
        for (Integer n : IterableBitSet.getSetBits(bitSet)) {
            System.out.println(n);
        }
        bitSet.clear();
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet).iterator();
        if (ofInt.hasNext()) {
            Integer n;
            n = (Integer)ofInt.next();
            throw new RuntimeException("BitSet should be empty!");
        }
    }

    private class SetBitsReversedIterator
    implements FunctionalPrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        public SetBitsReversedIterator() {
            this.next = IterableBitSet.this.maxIndex < 0 ? -1 : IterableBitSet.this.set.previousSetBit(IterableBitSet.this.maxIndex);
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                this.next = IterableBitSet.this.set.previousSetBit(this.current - 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current >= 0) {
                IterableBitSet.this.set.clear(this.current);
            }
        }
    }

    private class SetBitsIterator
    implements FunctionalPrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        private SetBitsIterator() {
            this.next = IterableBitSet.this.set.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            if (this.next > IterableBitSet.this.maxIndex) {
                return false;
            }
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                int n = this.current + 1;
                this.next = n < 0 ? -1 : IterableBitSet.this.set.nextSetBit(n);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current >= 0) {
                IterableBitSet.this.set.clear(this.current);
            }
        }
    }

    private class ClearBitsReversedIterator
    implements FunctionalPrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        public ClearBitsReversedIterator() {
            this.next = IterableBitSet.this.maxIndex < 0 ? -1 : IterableBitSet.this.set.previousClearBit(IterableBitSet.this.maxIndex);
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                this.next = IterableBitSet.this.set.previousClearBit(this.current - 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current >= 0) {
                IterableBitSet.this.set.set(this.current);
            }
        }
    }

    private class ClearBitsIterator
    implements FunctionalPrimitiveIterator.OfInt {
        private int current = -1;
        private int next;

        private ClearBitsIterator() {
            this.next = IterableBitSet.this.set.nextClearBit(0);
        }

        @Override
        public boolean hasNext() {
            if (this.next > IterableBitSet.this.maxIndex) {
                return false;
            }
            return this.next >= 0;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.current = this.next;
                int n = this.current + 1;
                this.next = n < 0 ? -1 : IterableBitSet.this.set.nextClearBit(n);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current >= 0) {
                IterableBitSet.this.set.set(this.current);
            }
        }
    }
}

