/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.IterableBitSet;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.SingletonIterable;
import java.util.BitSet;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public interface IntSet
extends FunctionalPrimitiveIterable.OfInt {
    public FunctionalPrimitiveIterator.OfInt reversedIterator();

    default public long cardinality() {
        return this.count();
    }

    default public boolean get(int n) {
        return this.contains(n);
    }

    default public boolean contains(IntSet intSet) {
        return intSet.allMatch(this::contains);
    }

    default public boolean contains(BitSet bitSet) {
        return this.contains(IntSet.asIntSet(bitSet));
    }

    default public IntStream stream() {
        return StreamSupport.intStream(() -> this.spliterator(), 65, false);
    }

    default public Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.iterator(), this.cardinality(), 65);
    }

    @Override
    default public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        boolean bl = true;
        FunctionalPrimitiveIterator.OfInt ofInt = this.iterator();
        while (ofInt.hasNext()) {
            if (!bl) {
                stringBuffer.append(",");
            }
            bl = false;
            stringBuffer.append(ofInt.nextInt());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static IntSet asIntSet(BitSet bitSet) {
        return new IntSetFromBitSet(bitSet);
    }

    public static IntSet asIntSet(int n) {
        return new SingletonIntSet(n);
    }

    public static class IntSetFromBitSet
    implements IntSet {
        protected BitSet bs;
        int cardinality = -1;

        public IntSetFromBitSet(BitSet bitSet) {
            Objects.requireNonNull(bitSet);
            this.bs = bitSet;
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return IterableBitSet.getSetBits(this.bs).iterator();
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt reversedIterator() {
            return IterableBitSet.getSetBitsReversed(this.bs).iterator();
        }

        @Override
        public IntStream stream() {
            return this.bs.stream();
        }

        @Override
        public long count() {
            if (this.cardinality == -1) {
                this.cardinality = this.bs.cardinality();
            }
            return this.cardinality;
        }

        @Override
        public boolean contains(int n) {
            return this.bs.get(n);
        }

        public String toString() {
            return this.asString();
        }
    }

    public static class SingletonIntSet
    extends SingletonIterable.OfInt
    implements IntSet {
        public SingletonIntSet(int n) {
            super(n);
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt reversedIterator() {
            return this.iterator();
        }

        public String toString() {
            return "{" + this.element + "}";
        }
    }
}

