/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGClientListener;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGHeartbeatListener;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NGInputStream
extends FilterInputStream
implements Closeable {
    private final ExecutorService executor;
    private final DataInputStream din;
    private InputStream stdin = null;
    private boolean eof = false;
    private long remaining = 0L;
    private byte[] oneByteBuffer = null;
    private final DataOutputStream out;
    private boolean started = false;
    private long lastReadTime = System.currentTimeMillis();
    private final Future readFuture;
    private final Set clientListeners = new HashSet();
    private final Set heartbeatListeners = new HashSet();
    private final int heartbeatTimeoutMillis;

    public NGInputStream(InputStream in, DataOutputStream out, final PrintStream serverLog, final int heartbeatTimeoutMillis) {
        super(in);
        this.din = (DataInputStream)this.in;
        this.out = out;
        this.heartbeatTimeoutMillis = heartbeatTimeoutMillis;
        int threadCount = 2;
        this.executor = Executors.newFixedThreadPool(2);
        final Thread mainThread = Thread.currentThread();
        this.readFuture = this.executor.submit(new Runnable(){

            public void run() {
                try {
                    try {
                        Thread.currentThread().setName(mainThread.getName() + " read stream thread (NGInputStream pool)");
                        while (true) {
                            Future<?> readHeaderFuture = NGInputStream.this.executor.submit(new Runnable(){

                                public void run() {
                                    Thread.currentThread().setName(mainThread.getName() + " read chunk thread (NGInputStream pool)");
                                    try {
                                        NGInputStream.this.readChunk();
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    finally {
                                        Thread.currentThread().setName(Thread.currentThread().getName() + " (idle)");
                                    }
                                }
                            });
                            readHeaderFuture.get(heartbeatTimeoutMillis, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        NGInputStream.this.notifyClientListeners(serverLog, mainThread);
                        NGInputStream.this.readEof();
                        Thread.currentThread().setName(Thread.currentThread().getName() + " (idle)");
                    }
                    catch (ExecutionException e) {
                        NGInputStream.this.notifyClientListeners(serverLog, mainThread);
                        NGInputStream.this.readEof();
                        Thread.currentThread().setName(Thread.currentThread().getName() + " (idle)");
                    }
                    catch (TimeoutException timeoutException) {
                        NGInputStream.this.notifyClientListeners(serverLog, mainThread);
                        NGInputStream.this.readEof();
                        Thread.currentThread().setName(Thread.currentThread().getName() + " (idle)");
                    }
                }
                catch (Throwable throwable) {
                    NGInputStream.this.notifyClientListeners(serverLog, mainThread);
                    NGInputStream.this.readEof();
                    Thread.currentThread().setName(Thread.currentThread().getName() + " (idle)");
                    throw throwable;
                }
            }
        });
    }

    private synchronized void notifyClientListener(NGClientListener listener) throws InterruptedException {
        try {
            listener.clientDisconnected();
        }
        catch (NGExitException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    private synchronized void notifyClientListener(NGClientListener listener, Thread mainThread) {
        try {
            this.notifyClientListener(listener);
        }
        catch (InterruptedException e) {
            mainThread.interrupt();
        }
    }

    private synchronized void notifyClientListeners(PrintStream serverLog, Thread mainThread) {
        if (!this.eof) {
            serverLog.println(mainThread.getName() + " disconnected");
            Iterator i = this.clientListeners.iterator();
            while (i.hasNext()) {
                this.notifyClientListener((NGClientListener)i.next(), mainThread);
            }
        }
        this.clientListeners.clear();
    }

    public synchronized void close() {
        this.readEof();
        this.readFuture.cancel(true);
        this.executor.shutdownNow();
    }

    private InputStream readPayload(InputStream in, int len) throws IOException {
        int currentRead;
        byte[] receiveBuffer = new byte[len];
        for (int totalRead = 0; totalRead < len; totalRead += currentRead) {
            currentRead = in.read(receiveBuffer, totalRead, len - totalRead);
            if (currentRead >= 0) continue;
            throw new IOException("stdin EOF before payload read.");
        }
        return new ByteArrayInputStream(receiveBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readChunk() throws IOException {
        DataInputStream dataInputStream = this.din;
        synchronized (dataInputStream) {
            int hlen = this.din.readInt();
            byte chunkType = this.din.readByte();
            long readTime = System.currentTimeMillis();
            long intervalMillis = readTime - this.lastReadTime;
            NGInputStream nGInputStream = this;
            synchronized (nGInputStream) {
                this.lastReadTime = readTime;
                switch (chunkType) {
                    case 48: {
                        if (this.remaining != 0L) {
                            throw new IOException("Data received before stdin stream was emptied.");
                        }
                        this.remaining = hlen;
                        this.stdin = this.readPayload(this.in, hlen);
                        this.notify();
                        break;
                    }
                    case 46: {
                        this.readEof();
                        break;
                    }
                    case 72: {
                        Iterator i = this.heartbeatListeners.iterator();
                        while (i.hasNext()) {
                            ((NGHeartbeatListener)i.next()).heartbeatReceived(intervalMillis);
                        }
                        break;
                    }
                    default: {
                        throw new IOException("Unknown stream type: " + (char)chunkType);
                    }
                }
            }
        }
    }

    private synchronized void readEof() {
        this.eof = true;
        this.notifyAll();
    }

    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.stdin == null) {
            return 0;
        }
        return this.stdin.available();
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.oneByteBuffer == null) {
            this.oneByteBuffer = new byte[1];
        }
        return this.read(this.oneByteBuffer, 0, 1) == -1 ? -1 : this.oneByteBuffer[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int offset, int length) throws IOException {
        if (!this.started) {
            this.sendSendInput();
        }
        this.waitForChunk();
        if (this.eof) {
            return -1;
        }
        int bytesToRead = Math.min((int)this.remaining, length);
        int result = this.stdin.read(b, offset, bytesToRead);
        this.remaining -= (long)result;
        if (this.remaining == 0L) {
            this.sendSendInput();
        }
        return result;
    }

    private synchronized void waitForChunk() throws IOException {
        try {
            if (!this.eof && this.remaining == 0L) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private synchronized void sendSendInput() throws IOException {
        this.out.writeInt(0);
        this.out.writeByte(83);
        this.out.flush();
        this.started = true;
    }

    public boolean isClientConnected() {
        long intervalMillis = System.currentTimeMillis() - this.lastReadTime;
        return intervalMillis < (long)this.heartbeatTimeoutMillis;
    }

    public synchronized void addClientListener(NGClientListener listener) {
        if (!this.readFuture.isDone()) {
            this.clientListeners.add(listener);
        } else {
            try {
                this.notifyClientListener(listener);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void removeClientListener(NGClientListener listener) {
        this.clientListeners.remove(listener);
    }

    public synchronized void addHeartbeatListener(NGHeartbeatListener listener) {
        if (!this.readFuture.isDone()) {
            this.heartbeatListeners.add(listener);
        }
    }

    public synchronized void removeHeartbeatListener(NGHeartbeatListener listener) {
        this.heartbeatListeners.remove(listener);
    }
}

