/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RatPolyGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigRational> cf;
    GenPolynomialRing<GenPolynomial<BigRational>> fac;
    GenPolynomial<GenPolynomial<BigRational>> a;
    GenPolynomial<GenPolynomial<BigRational>> b;
    GenPolynomial<GenPolynomial<BigRational>> c;
    GenPolynomial<GenPolynomial<BigRational>> d;
    GenPolynomial<GenPolynomial<BigRational>> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RatPolyGenPolynomialTest.suite());
    }

    public RatPolyGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RatPolyGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cf = new GenPolynomialRing<BigRational>(new BigRational(1L), 1);
        this.fac = new GenPolynomialRing<BigRational>(this.cf, this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        RatPolyGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        RatPolyGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatPolyGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        RatPolyGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        RatPolyGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RatPolyGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.ll);
            RatPolyGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            RatPolyGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RatPolyGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((GenPolynomial<BigRational>)this.b);
        this.d = this.c.subtract((GenPolynomial<BigRational>)this.b);
        RatPolyGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.cf.random(this.kl);
        this.b = new GenPolynomial<Element>(this.fac, element, expVector);
        this.c = this.a.sum((GenPolynomial<BigRational>)this.b);
        this.d = this.a.sum((GenPolynomial<BigRational>)element, expVector);
        RatPolyGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((GenPolynomial<BigRational>)this.b);
        this.d = this.a.subtract((GenPolynomial<BigRational>)element, expVector);
        RatPolyGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<GenPolynomial<BigRational>>(this.fac);
        this.b = new GenPolynomial<Element>(this.fac, element, expVector);
        this.c = this.b.sum((GenPolynomial<BigRational>)this.a);
        this.d = this.a.sum((GenPolynomial<BigRational>)element, expVector);
        RatPolyGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((GenPolynomial<BigRational>)this.b);
        this.d = this.a.subtract((GenPolynomial<BigRational>)element, expVector);
        RatPolyGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        RatPolyGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        RatPolyGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((GenPolynomial<BigRational>)this.a);
        this.d = this.a.multiply((GenPolynomial<BigRational>)this.b);
        RatPolyGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RatPolyGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((GenPolynomial<BigRational>)this.c);
        RatPolyGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        RatPolyGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        RatPolyGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((GenPolynomial<BigRational>)this.b.multiply((GenPolynomial<BigRational>)this.c));
        this.e = this.a.multiply((GenPolynomial<BigRational>)this.b).multiply(this.c);
        RatPolyGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        RatPolyGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        GenPolynomial<BigRational> genPolynomial = this.b.leadingBaseCoefficient();
        this.e = new GenPolynomial<GenPolynomial<BigRational>>(this.fac, genPolynomial);
        this.c = this.b.multiply((GenPolynomial<BigRational>)this.e);
        this.d = this.e.multiply((GenPolynomial<BigRational>)this.b);
        RatPolyGenPolynomialTest.assertEquals((String)"b*p(y,u) = p(y,u)*b", this.c, this.d);
    }
}

