/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.LongIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class GenPolynomialIterator<C extends RingElem<C>>
implements Iterator<GenPolynomial<C>> {
    final GenPolynomialRing<C> ring;
    final Iterator<List<Long>> eviter;
    final List<ExpVector> powers;
    final List<Iterable<C>> coeffiter;
    Iterator<List<C>> itercoeff;
    GenPolynomial<C> current;

    public GenPolynomialIterator(GenPolynomialRing<C> genPolynomialRing) {
        this.ring = genPolynomialRing;
        LongIterable longIterable = new LongIterable();
        longIterable.setNonNegativeIterator();
        ArrayList<Iterable<LongIterable>> arrayList = new ArrayList<Iterable<LongIterable>>(this.ring.nvar);
        for (int i = 0; i < this.ring.nvar; ++i) {
            arrayList.add(longIterable);
        }
        CartesianProductInfinite cartesianProductInfinite = new CartesianProductInfinite(arrayList);
        this.eviter = cartesianProductInfinite.iterator();
        RingFactory ringFactory = this.ring.coFac;
        this.coeffiter = new ArrayList<Iterable<C>>();
        if (!(ringFactory instanceof Iterable) || !ringFactory.isFinite()) {
            throw new IllegalArgumentException("only for finite iterable coefficients implemented");
        }
        CartesianProduct cartesianProduct = (CartesianProduct)((Object)ringFactory);
        this.coeffiter.add(cartesianProduct);
        cartesianProduct = new CartesianProduct(this.coeffiter);
        this.itercoeff = cartesianProduct.iterator();
        this.powers = new ArrayList<ExpVector>();
        ExpVector expVector = ExpVector.create((Collection<Long>)this.eviter.next());
        this.powers.add(expVector);
        List<C> list = this.itercoeff.next();
        this.current = new GenPolynomial<RingElem>(this.ring, (RingElem)list.get(0), expVector);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public synchronized GenPolynomial<C> next() {
        CartesianProduct cartesianProduct;
        Object object;
        GenPolynomial<C> genPolynomial = this.current;
        if (!this.itercoeff.hasNext()) {
            object = ExpVector.create((Collection<Long>)this.eviter.next());
            this.powers.add(0, (ExpVector)object);
            if (this.coeffiter.size() == 1) {
                this.coeffiter.add(this.coeffiter.get(0));
                cartesianProduct = this.coeffiter.get(0);
                ArrayList<RingElem> arrayList = new ArrayList<RingElem>();
                for (RingElem abelianGroupElem : cartesianProduct) {
                    arrayList.add(abelianGroupElem);
                }
                arrayList.remove(0);
                this.coeffiter.set(0, arrayList);
            } else {
                this.coeffiter.add(this.coeffiter.get(1));
            }
            cartesianProduct = new CartesianProduct(this.coeffiter);
            this.itercoeff = cartesianProduct.iterator();
        }
        object = this.itercoeff.next();
        cartesianProduct = ((GenPolynomial)this.ring.getZERO()).copy();
        int n = 0;
        for (ExpVector expVector : this.powers) {
            RingElem ringElem;
            if ((ringElem = (RingElem)object.get(n++)).isZERO()) continue;
            if (((GenPolynomial)((Object)cartesianProduct)).val.get(expVector) != null) {
                System.out.println("error f in pol = " + expVector + ", " + ((GenPolynomial)((Object)cartesianProduct)).getMap().get(expVector));
                throw new RuntimeException("error in iterator");
            }
            ((GenPolynomial)((Object)cartesianProduct)).doPutToMap(expVector, (RingElem)ringElem);
        }
        this.current = cartesianProduct;
        return genPolynomial;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove elements");
    }
}

