/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.arith.BigRational;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.ElementaryIntegrationBernoulli;
import edu.jas.integrate.QuotIntegral;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ElementaryIntegrationAbsoluteTest
extends TestCase {
    TermOrder tord;
    QuotientRing<BigRational> qfac;
    GenPolynomialRing<BigRational> pfac;
    ElementaryIntegration<BigRational> integrator;
    QuotIntegral<BigRational> rint;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ElementaryIntegrationAbsoluteTest.suite());
    }

    public ElementaryIntegrationAbsoluteTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ElementaryIntegrationAbsoluteTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.tord = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"x"};
        this.pfac = new GenPolynomialRing<BigRational>(bigRational, 1, this.tord, stringArray);
        this.qfac = new QuotientRing<BigRational>(this.pfac);
        this.integrator = new ElementaryIntegrationBernoulli<BigRational>(bigRational);
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testRationalBernoulli() {
        GenPolynomial<BigRational> genPolynomial = this.pfac.univariate(0, 4L);
        genPolynomial = genPolynomial.sum((BigRational)this.pfac.fromInteger(4L));
        MonoidElem monoidElem = this.pfac.getONE();
        Quotient<BigRational> quotient = new Quotient<BigRational>(this.qfac, (GenPolynomial<BigRational>)monoidElem, genPolynomial);
        this.rint = this.integrator.integrate(quotient);
        ElementaryIntegrationAbsoluteTest.assertTrue((String)"isIntegral ", (boolean)this.integrator.isIntegral(this.rint));
    }
}

