/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBase;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.Syzygy;
import edu.jas.gbufd.SyzygySeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SyzygyTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBase<BigRational> bb;
    GroebnerBase<BigRational> mbb;
    Syzygy<BigRational> sz;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    GenPolynomial<BigRational> zero;
    GenPolynomial<BigRational> one;
    TermOrder tord;
    List<GenPolynomial<BigRational>> L;
    List<List<GenPolynomial<BigRational>>> K;
    List<GenPolynomial<BigRational>> V;
    List<List<GenPolynomial<BigRational>>> W;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModuleList<BigRational> Z;
    int rl = 3;
    int kl = 3;
    int ll = 7;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SyzygyTest.suite());
    }

    public SyzygyTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SyzygyTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.tord = new TermOrder();
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl, this.tord);
        this.bb = GBFactory.getImplementation(bigRational);
        this.mbb = new GroebnerBaseSeq<BigRational>();
        this.sz = new SyzygySeq<BigRational>(bigRational);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.L = null;
        this.K = null;
        this.V = null;
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.fac.getONE();
        this.zero = this.fac.getZERO();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.L = null;
        this.K = null;
        this.V = null;
        this.fac = null;
        this.tord = null;
        this.bb = null;
        this.mbb = null;
        this.sz = null;
    }

    public void testSequentialSyzygy() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        SyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.K = this.sz.zeroRelations(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
        SyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        SyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        this.K = this.sz.zeroRelations(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
        SyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        SyzygyTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.K = this.sz.zeroRelations(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
        SyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        SyzygyTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.K = this.sz.zeroRelations(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
    }

    public void testSequentialModSyzygy() {
        this.W = new ArrayList<List<GenPolynomial<BigRational>>>();
        SyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        SyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.M));
        this.N = this.mbb.GB(this.M);
        SyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.N));
        this.Z = this.sz.zeroRelations(this.N);
        SyzygyTest.assertTrue((String)"is ZR( { a) } )", (boolean)this.sz.isZeroRelation(this.Z, this.N));
        SyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.N = this.mbb.GB(this.M);
        SyzygyTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.mbb.isGB(this.N));
        this.Z = this.sz.zeroRelations(this.N);
        SyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.sz.isZeroRelation(this.Z, this.N));
        SyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.N = this.mbb.GB(this.M);
        SyzygyTest.assertTrue((String)"isGB( { a,b,c) } )", (boolean)this.mbb.isGB(this.N));
        this.Z = this.sz.zeroRelations(this.N);
        SyzygyTest.assertTrue((String)"is ZR( { a,b,c } )", (boolean)this.sz.isZeroRelation(this.Z, this.N));
    }

    public void testSequentialArbitrarySyzygy() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        SyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SyzygyTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.K = this.sz.zeroRelationsArbitrary(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
        SyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.K = this.sz.zeroRelationsArbitrary(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
        SyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.K = this.sz.zeroRelationsArbitrary(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b, c } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
        SyzygyTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.K = this.sz.zeroRelationsArbitrary(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b, c, d } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitrarySyzygyCLO() {
        PolynomialList polynomialList = null;
        String string = "(x,y) G ( ( x y + x ), ( y^2 + 1 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            SyzygyTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            SyzygyTest.fail((String)("" + iOException));
        }
        this.L = polynomialList.list;
        this.K = this.sz.zeroRelationsArbitrary(this.L);
        SyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.sz.isZeroRelation(this.K, this.L));
    }

    public void testSequentialArbitraryModSyzygy() {
        this.W = new ArrayList<List<GenPolynomial<BigRational>>>();
        SyzygyTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        SyzygyTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.M));
        this.Z = this.sz.zeroRelationsArbitrary(this.M);
        SyzygyTest.assertTrue((String)"is ZR( { a) } )", (boolean)this.sz.isZeroRelation(this.Z, this.M));
        SyzygyTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.Z = this.sz.zeroRelationsArbitrary(this.M);
        SyzygyTest.assertTrue((String)"is ZR( { a, b } )", (boolean)this.sz.isZeroRelation(this.Z, this.M));
        SyzygyTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.W.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.W);
        this.Z = this.sz.zeroRelationsArbitrary(this.M);
        SyzygyTest.assertTrue((String)"is ZR( { a,b,c } )", (boolean)this.sz.isZeroRelation(this.Z, this.M));
    }
}

