/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GroebnerBase;
import edu.jas.gbufd.RGroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RGroebnerBaseSeqTest
extends TestCase {
    ProductRing<BigRational> pfac;
    GenPolynomialRing<Product<BigRational>> fac;
    List<GenPolynomial<Product<BigRational>>> L;
    List<GenPolynomial<Product<BigRational>>> G;
    PolynomialList<Product<BigRational>> F;
    GroebnerBase<Product<BigRational>> bb;
    GenPolynomial<Product<BigRational>> a;
    GenPolynomial<Product<BigRational>> b;
    GenPolynomial<Product<BigRational>> c;
    GenPolynomial<Product<BigRational>> d;
    GenPolynomial<Product<BigRational>> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RGroebnerBaseSeqTest.suite());
    }

    public RGroebnerBaseSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RGroebnerBaseSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.pfac = new ProductRing<BigRational>(bigRational, 4);
        this.fac = new GenPolynomialRing<BigRational>(this.pfac, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new RGroebnerBaseSeq<Product<BigRational>>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<Product<BigRational>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7() {
        String string = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            RGroebnerBaseSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            RGroebnerBaseSeqTest.fail((String)("" + iOException));
        }
        int n = polynomialList.ring.nvar;
        TermOrder termOrder = polynomialList.ring.tord;
        String[] stringArray = polynomialList.ring.getVars();
        ArrayList arrayList = new ArrayList();
        arrayList.add(new ModIntegerRing(19L));
        arrayList.add(new ModIntegerRing(23L));
        ProductRing productRing = new ProductRing(arrayList);
        GenPolynomialRing<Product<ModInteger>> genPolynomialRing = new GenPolynomialRing<Product<ModInteger>>(productRing, n, termOrder, stringArray);
        List list = PolyUtil.toProduct(genPolynomialRing, polynomialList.list);
        ArrayList<GenPolynomial<Product<ModInteger>>> arrayList2 = new ArrayList<GenPolynomial<Product<ModInteger>>>();
        for (GenPolynomial<Product<ModInteger>> iterable2 : list) {
            arrayList2.add(iterable2.multiply(productRing.getAtomic(0)));
            arrayList2.add(iterable2.multiply(productRing.getAtomic(1)));
        }
        RGroebnerBaseSeq rGroebnerBaseSeq = new RGroebnerBaseSeq();
        list = arrayList2;
        List list2 = rGroebnerBaseSeq.GB(list);
        PolynomialList<Product<ModInteger>> polynomialList2 = new PolynomialList<Product<ModInteger>>(genPolynomialRing, list2);
        RGroebnerBaseSeqTest.assertFalse((String)"trings != null", (polynomialList2 == null ? 1 : 0) != 0);
        RGroebnerBaseSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)rGroebnerBaseSeq.isGB(list2));
    }
}

