/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseWalk;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrderByName;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseWalkTest
extends TestCase {
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> Lp;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    List<GenPolynomial<BigRational>> Gp;
    GroebnerBaseAbstract<BigRational> bb;
    GroebnerBaseAbstract<BigRational> bbw;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseWalkTest.suite());
    }

    public GroebnerBaseWalkTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseWalkTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.bb = GBFactory.getImplementation();
        this.bbw = new GroebnerBaseWalk<BigRational>(this.bb);
    }

    protected void tearDown() {
        this.bb.terminate();
        this.bbw.terminate();
        this.bb = null;
        this.bbw = null;
    }

    public void testFJLTGBase() {
        String string = "(y,x) L ( (x**2 - y**3), (x**3 - y**2 - x) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseWalkTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseWalkTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(FJLT) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB(FJLT) )", (boolean)this.bb.isMinimalGB(this.G));
        GroebnerBaseWalkTest.assertEquals((String)"#GB(FJLT) == 2", (int)2, (int)this.G.size());
        this.Gp = this.bbw.GB(this.F.list);
        PolynomialList polynomialList2 = new PolynomialList(this.F.ring, this.Gp);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(FJLT) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB(FJLT) )", (boolean)this.bb.isMinimalGB(this.Gp));
        GroebnerBaseWalkTest.assertEquals((String)"#GB(FJLT) == 2", (int)2, (int)this.Gp.size());
        GroebnerBaseWalkTest.assertEquals((String)"G == Gp: ", polynomialList, polynomialList2);
    }

    public void testFGLMGBase() {
        String string = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseWalkTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseWalkTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(P) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseWalkTest.assertEquals((String)"#GB(P) == 3", (int)3, (int)this.G.size());
        this.Gp = this.bbw.GB(this.F.list);
        PolynomialList polynomialList2 = new PolynomialList(this.F.ring, this.Gp);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(P2) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseWalkTest.assertEquals((String)"#GB(P2) == 3", (int)3, (int)this.Gp.size());
        GroebnerBaseWalkTest.assertEquals((String)"GB == FGLM", polynomialList, polynomialList2);
    }

    public void testTrinksGBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseWalkTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseWalkTest.fail((String)("" + iOException));
        }
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        PolynomialList polynomialList = new PolynomialList(this.F.ring, this.G);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(Trinks) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB(Trinks) )", (boolean)this.bb.isMinimalGB(this.G));
        GroebnerBaseWalkTest.assertEquals((String)"#GB(Trinks) == 6", (int)6, (int)this.G.size());
        long l2 = System.currentTimeMillis();
        this.Gp = this.bbw.GB(this.F.list);
        l2 = System.currentTimeMillis() - l2;
        PolynomialList polynomialList2 = new PolynomialList(this.F.ring, this.Gp);
        GroebnerBaseWalkTest.assertTrue((String)"findbugs ", (l + l2 >= 0L ? 1 : 0) != 0);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(Trinks) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB(Trinks) )", (boolean)this.bb.isMinimalGB(this.Gp));
        GroebnerBaseWalkTest.assertEquals((String)"G == Gp: ", polynomialList, polynomialList2);
    }

    public void testTrinksGBaseT1T2() {
        String string = "(B,S,T,Z,P,W) G|4| ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseWalkTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseWalkTest.fail((String)("" + iOException));
        }
        this.bbw = new GroebnerBaseWalk<BigRational>(this.bb, TermOrderByName.IGRLEX.blockOrder(2));
        this.Gp = this.bbw.GB(this.F.list);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB(Trinks) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB(Trinks) )", (boolean)this.bb.isMinimalGB(this.Gp));
    }

    public void testFGLMissacGBase() {
        String string = "Mod 32003 (w,z,y,x) L (  (8*w^2 + 5*w*x - 4*w*y + 2*w*z + 3*w + 5*x^2 + 2*x*y - 7*x*z - 7*x + 7*y^2 -8*y*z - 7*y + 7*z^2 - 8*z + 8),(3*w^2 - 5*w*x - 3*w*y - 6*w*z + 9*w + 4*x^2 + 2*x*y - 2*x*z + 7*x + 9*y^2 + 6*y*z + 5*y + 7*z^2 + 7*z + 5),(-2*w^2 + 9*w*x + 9*w*y - 7*w*z - 4*w + 8*x^2 + 9*x*y - 3*x*z + 8*x + 6*y^2 - 7*y*z + 4*y - 6*z^2 + 8*z + 2),(7*w^2 + 5*w*x + 3*w*y - 5*w*z - 5*w + 2*x^2 + 9*x*y - 7*x*z + 4*x -4*y^2 - 5*y*z + 6*y - 4*z^2 - 9*z + 2) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseWalkTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseWalkTest.fail((String)("" + iOException));
        }
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB() )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB() )", (boolean)this.bb.isMinimalGB(this.G));
        long l2 = System.currentTimeMillis();
        this.Gp = this.bbw.GB(this.F.list);
        l2 = System.currentTimeMillis() - l2;
        GroebnerBaseWalkTest.assertTrue((String)"findbugs ", (l + l2 >= 0L ? 1 : 0) != 0);
        GroebnerBaseWalkTest.assertTrue((String)"isGB( GB() )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseWalkTest.assertTrue((String)"isMinimalGB( GB() )", (boolean)this.bb.isMinimalGB(this.Gp));
        GroebnerBaseWalkTest.assertEquals((String)"G == Gp: ", this.G, this.Gp);
    }
}

