/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.GroebnerBaseQuotient;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseQuotientTest
extends TestCase {
    GenPolynomialRing<Quotient<BigRational>> fac;
    List<GenPolynomial<Quotient<BigRational>>> L;
    List<GenPolynomial<Quotient<BigRational>>> Lp;
    List<GenPolynomial<Quotient<BigRational>>> Lq;
    PolynomialList<Quotient<BigRational>> F;
    List<GenPolynomial<Quotient<BigRational>>> G;
    List<GenPolynomial<Quotient<BigRational>>> Gp;
    GroebnerBaseAbstract<Quotient<BigRational>> bb;
    GroebnerBaseAbstract<Quotient<BigRational>> bbp;
    GroebnerBaseAbstract<Quotient<BigRational>> bbq;
    GenPolynomial<Quotient<BigRational>> a;
    GenPolynomial<Quotient<BigRational>> b;
    GenPolynomial<Quotient<BigRational>> c;
    GenPolynomial<Quotient<BigRational>> d;
    GenPolynomial<Quotient<BigRational>> e;
    int threads = 2;
    int rl = 4;
    int kl = 1;
    int ll = 3;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseQuotientTest.suite());
    }

    public GroebnerBaseQuotientTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseQuotientTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, this.rl / 2, new String[]{"a", "b"});
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        this.fac = new GenPolynomialRing<BigRational>(quotientRing, this.rl / 2, new String[]{"x", "y"});
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseQuotient<BigRational>(quotientRing);
        this.bbp = new GroebnerBaseQuotient<BigRational>(this.threads, quotientRing);
        this.bbq = GBFactory.getImplementation(quotientRing);
    }

    protected void tearDown() {
        this.bbp.terminate();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
        this.bbp = null;
        this.bbq = null;
        ComputerThreads.terminate();
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<Quotient<BigRational>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c, d } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c, d, e } )", (boolean)this.bb.isMinimalGB(this.L));
    }

    public void testParallelGBase() {
        this.L = new ArrayList<GenPolynomial<Quotient<BigRational>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c, d } )", (boolean)this.bbp.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bbp.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbp.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c, d, e } )", (boolean)this.bbp.isMinimalGB(this.L));
    }

    public void testCompareGBase() {
        this.L = new ArrayList<GenPolynomial<Quotient<BigRational>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum((Quotient<BigRational>)((Object)this.b));
        this.d = this.c;
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        this.L.add(this.a);
        this.Lp = this.bbp.GB(this.L);
        this.Lq = this.bbq.GB(this.L);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertEquals((String)"Lp == L: ", this.Lp, this.L);
        GroebnerBaseQuotientTest.assertEquals((String)"Lq == L: ", this.Lq, this.L);
        this.L.add(this.b);
        this.Lp = this.bbp.GB(this.L);
        this.Lq = this.bbq.GB(this.L);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertEquals((String)"Lp == L: ", this.Lp, this.L);
        GroebnerBaseQuotientTest.assertEquals((String)"Lq == L: ", this.Lq, this.L);
        this.L.add(this.c);
        this.Lp = this.bbp.GB(this.L);
        this.Lq = this.bbq.GB(this.L);
        this.L = this.bb.GB(this.L);
        GroebnerBaseQuotientTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        GroebnerBaseQuotientTest.assertTrue((String)"isMinimalGB( { a, b, c } )", (boolean)this.bb.isMinimalGB(this.L));
        GroebnerBaseQuotientTest.assertEquals((String)"Lp == L: ", this.Lp, this.L);
        GroebnerBaseQuotientTest.assertEquals((String)"Lq == L: ", this.Lq, this.L);
    }
}

