/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gbufd.CharacteristicSet;
import edu.jas.gbufd.PolyGBUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CharacteristicSetSimple<C extends GcdRingElem<C>>
implements CharacteristicSet<C> {
    private static final Logger logger = LogManager.getLogger(CharacteristicSetSimple.class);
    private static final boolean debug = logger.isDebugEnabled();

    /*
     * WARNING - void declaration
     */
    @Override
    public List<GenPolynomial<C>> characteristicSet(List<GenPolynomial<C>> list) {
        Object object;
        void var8_14;
        GenPolynomial genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar <= 1) {
            GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract = GCDFactory.getImplementation(genPolynomialRing.coFac);
            GenPolynomial genPolynomial3 = greatestCommonDivisorAbstract.gcd(list).monic();
            logger.info("charSet base gcd = " + genPolynomial3);
            arrayList.add(genPolynomial3);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        ArrayList arrayList2 = new ArrayList();
        ArrayList<GenPolynomial<C>> arrayList3 = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2.isZERO()) continue;
            GenPolynomial<C> genPolynomial3 = genPolynomial2.monic();
            if (genPolynomial3.isONE()) {
                arrayList.add(genPolynomial3);
                return arrayList;
            }
            genPolynomial = PolyUtil.recursive(genPolynomialRing2, genPolynomial3);
            if (genPolynomial.degree(0) == 0L) {
                arrayList3.add(genPolynomial.leadingBaseCoefficient());
                continue;
            }
            arrayList2.add(genPolynomial);
        }
        if (arrayList2.isEmpty() && arrayList3.isEmpty()) {
            return arrayList;
        }
        OrderedPolynomialList orderedPolynomialList = new OrderedPolynomialList(genPolynomialRing2, arrayList2);
        ArrayList arrayList4 = new ArrayList(orderedPolynomialList.list);
        Collections.reverse(arrayList4);
        if (debug) {
            logger.info("positive degrees: " + arrayList4);
        }
        while (var8_14.size() > 1) {
            genPolynomial = (GenPolynomial)var8_14.remove(0);
            object = (GenPolynomial)var8_14.get(0);
            logger.info("pseudo remainder by deg = " + ((GenPolynomial)object).degree() + " in variable " + genPolynomialRing2.getVars()[0]);
            GenPolynomial genPolynomial4 = PolyUtil.recursiveSparsePseudoRemainder(genPolynomial, object);
            if (genPolynomial4.isZERO()) {
                logger.warn("variety is reducible");
                continue;
            }
            if (genPolynomial4.degree(0) == 0L) {
                arrayList3.add(genPolynomial4.leadingBaseCoefficient().monic());
                continue;
            }
            var8_14.add(genPolynomial4);
            List list2 = OrderedPolynomialList.sort(genPolynomialRing2, var8_14);
            Collections.reverse(list2);
        }
        genPolynomial = this.characteristicSet(arrayList3);
        for (GenPolynomial genPolynomial5 : genPolynomial) {
            GenPolynomial genPolynomial6 = genPolynomial5.extend(genPolynomialRing, 0, 0L);
            arrayList.add(genPolynomial6);
        }
        if (var8_14.isEmpty()) {
            return arrayList;
        }
        object = (GenPolynomial)var8_14.get(0);
        GenPolynomial genPolynomial8 = PolyUtil.distribute(genPolynomialRing, object);
        genPolynomial8 = genPolynomial8.monic();
        arrayList.add(0, genPolynomial8);
        return arrayList;
    }

    @Override
    public boolean isCharacteristicSet(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar <= 1) {
            return list.size() <= 1;
        }
        if (genPolynomialRing.nvar < list.size()) {
            return false;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        int n = 0;
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) {
                return false;
            }
            GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
            if (genPolynomial2.degree(0) == 0L) {
                arrayList.add(genPolynomial2.leadingBaseCoefficient());
                continue;
            }
            if (++n <= 1) continue;
            return false;
        }
        return this.isCharacteristicSet(arrayList);
    }

    @Override
    public GenPolynomial<C> characteristicSetReduction(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return genPolynomial.monic();
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial2 = PolyGBUtil.topPseudoRemainder(list, genPolynomial);
        genPolynomial2 = genPolynomial2.monic();
        return genPolynomial2;
    }
}

