/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableGroebnerBaseSeqTest
extends TestCase {
    int port = 4711;
    String host = "localhost";
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    List<GenSolvablePolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    GenSolvablePolynomialRing<BigRational> ring;
    SolvableGroebnerBase<BigRational> sbb;
    BigRational cfac;
    TermOrder tord;
    RelationTable<BigRational> table;
    int rl = 4;
    int kl = 10;
    int ll = 4;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableGroebnerBaseSeqTest.suite());
    }

    public SolvableGroebnerBaseSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableGroebnerBaseSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(9L);
        this.tord = new TermOrder();
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.sbb = new SolvableGroebnerBaseSeq<BigRational>();
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ring = null;
        this.tord = null;
        this.table = null;
        this.cfac = null;
        this.sbb = null;
    }

    public void testSequentialGBase() {
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testWeylSequentialGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testSequentialTSGBase() {
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }

    public void testWeylSequentialTSGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }

    public void testSequentialExtendedGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        SolvableExtendedGB<BigRational> solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftRmat( { a } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftRmat( { a, b } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftRmat( { a, b, c } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftRmat( { a, b, c, d } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftRmat( { a, b, c, d, e } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
    }

    public void testWeylSequentialExtendedGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        SolvableExtendedGB<BigRational> solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isRmat( { a } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b, c } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b, c, d } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        solvableExtendedGB = this.sbb.extLeftGB(this.L);
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(solvableExtendedGB.G));
        SolvableGroebnerBaseSeqTest.assertTrue((String)"isRmat( { a, b, c, d, e } )", (boolean)this.sbb.isLeftReductionMatrix(solvableExtendedGB));
    }
}

