/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.ReductionAbstract;
import edu.jas.gb.ReductionSeq;
import edu.jas.gb.SigPair;
import edu.jas.gb.SigPoly;
import edu.jas.gb.SigReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SigReductionSeq<C extends RingElem<C>>
implements SigReduction<C> {
    private static final Logger logger = LogManager.getLogger(SigReductionSeq.class);
    final ReductionAbstract<C> red = new ReductionSeq();

    @Override
    public GenPolynomial<C> SPolynomial(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        GenPolynomial<C> genPolynomial = this.red.SPolynomial(sigPoly.poly, sigPoly2.poly);
        return genPolynomial;
    }

    public ExpVector[] SPolynomialExpVectorFactors(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        Map.Entry entry = sigPoly.poly.leadingMonomial();
        Map.Entry entry2 = sigPoly2.poly.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        ExpVector[] expVectorArray = new ExpVector[]{expVector4, expVector5};
        return expVectorArray;
    }

    public GenPolynomial<C> SPolynomialHalf(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        Map.Entry entry = sigPoly.poly.leadingMonomial();
        Map.Entry entry2 = sigPoly2.poly.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        GenPolynomial genPolynomial = sigPoly.poly.multiply(expVector4);
        return genPolynomial;
    }

    public GenPolynomial<C>[] SPolynomialFactors(SigPoly<C> sigPoly, SigPoly<C> sigPoly2) {
        ExpVector[] expVectorArray = this.SPolynomialExpVectorFactors(sigPoly, sigPoly2);
        GenPolynomial genPolynomial = sigPoly.poly.ring.valueOf(expVectorArray[0]);
        GenPolynomial genPolynomial2 = sigPoly.poly.ring.valueOf(expVectorArray[1]);
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{genPolynomial, genPolynomial2};
        return genPolynomialArray;
    }

    @Override
    public boolean isSigReducible(List<SigPoly<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        return !this.isSigNormalform(list, list2, sigPoly);
    }

    @Override
    public boolean isSigNormalform(List<SigPoly<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        if (list.isEmpty() && list2.isEmpty()) {
            return true;
        }
        if (sigPoly.poly.isZERO()) {
            return true;
        }
        boolean bl = false;
        for (ExpVector expVector : sigPoly.poly.getMap().keySet()) {
            ExpVector expVector2;
            for (SigPoly<C> sigPoly2 : list) {
                expVector2 = sigPoly2.poly.leadingExpVector();
                bl = expVector.multipleOf(expVector2);
                if (!bl) continue;
                return false;
            }
            for (SigPoly<C> sigPoly2 : list2) {
                if (sigPoly2.poly.isZERO() || !(bl = expVector.multipleOf(expVector2 = sigPoly2.poly.leadingExpVector()))) continue;
                ExpVector expVector3 = expVector.subtract(expVector2);
                GenPolynomial genPolynomial = sigPoly2.sigma.multiply(expVector3);
                if (genPolynomial.leadingExpVector().compareTo(sigPoly.sigma.leadingExpVector()) < 0) {
                    return false;
                }
                if (genPolynomial.leadingExpVector().compareTo(sigPoly.sigma.leadingExpVector()) != 0 || genPolynomial.leadingBaseCoefficient().compareTo(sigPoly.sigma.leadingBaseCoefficient()) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSigRedundant(List<SigPoly<C>> list, SigPoly<C> sigPoly) {
        if (list.isEmpty()) {
            return false;
        }
        ExpVector expVector = sigPoly.sigma.leadingExpVector();
        if (expVector == null) {
            expVector = sigPoly.poly.ring.evzero;
        }
        for (SigPoly<C> sigPoly2 : list) {
            boolean bl;
            if (sigPoly2.sigma.isZERO()) continue;
            ExpVector expVector2 = sigPoly2.sigma.leadingExpVector();
            if (expVector2 == null) {
                expVector2 = sigPoly2.poly.ring.evzero;
            }
            if (!(bl = expVector.multipleOf(expVector2))) continue;
            ExpVector expVector3 = expVector.subtract(expVector2);
            ExpVector expVector4 = sigPoly2.poly.leadingExpVector();
            if ((expVector4 = expVector4.sum(expVector3)).compareTo(sigPoly.poly.leadingExpVector()) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isSigRedundantAlt(List<SigPoly<C>> list, SigPoly<C> sigPoly) {
        if (list.isEmpty()) {
            return false;
        }
        ExpVector expVector = sigPoly.sigma.leadingExpVector();
        if (expVector == null) {
            expVector = sigPoly.poly.ring.evzero;
        }
        for (SigPoly<C> sigPoly2 : list) {
            boolean bl;
            if (sigPoly2.sigma.isZERO()) continue;
            ExpVector expVector2 = sigPoly2.sigma.leadingExpVector();
            if (expVector2 == null) {
                expVector2 = sigPoly2.poly.ring.evzero;
            }
            if (!(bl = expVector.multipleOf(expVector2)) || sigPoly2.poly.isZERO()) continue;
            ExpVector expVector3 = sigPoly2.poly.leadingExpVector();
            ExpVector expVector4 = sigPoly.poly.leadingExpVector();
            if (!expVector4.multipleOf(expVector3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SigPoly<C> sigNormalform(List<GenPolynomial<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        Object object;
        if (list.isEmpty() && list2.isEmpty()) {
            return sigPoly;
        }
        if (sigPoly.poly.isZERO()) {
            return sigPoly;
        }
        List<GenPolynomial<C>> list3 = list;
        GenPolynomial<Object> genPolynomial = sigPoly.poly;
        GenPolynomial<Object> genPolynomial2 = sigPoly.sigma;
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        boolean bl = true;
        block0: while (!genPolynomial.isZERO() && bl) {
            bl = false;
            if ((genPolynomial = this.red.normalform(list3, genPolynomial)).isZERO()) continue;
            object = genPolynomial.leadingExpVector();
            for (SigPoly<C> sigPoly2 : list2) {
                boolean bl2;
                ExpVector expVector;
                ExpVector expVector2;
                boolean bl3;
                if (sigPoly2.poly.isZERO() || !(bl3 = ((ExpVector)object).multipleOf(expVector2 = sigPoly2.poly.leadingExpVector()))) continue;
                ExpVector expVector3 = ((ExpVector)object).subtract(expVector2);
                RingElem ringElem = (RingElem)genPolynomial.leadingBaseCoefficient().divide(sigPoly2.poly.leadingBaseCoefficient());
                GenPolynomial<RingElem> genPolynomial3 = sigPoly2.sigma.multiply(ringElem, expVector3);
                ExpVector expVector4 = genPolynomial2.leadingExpVector();
                if (expVector4 == null) {
                    expVector4 = genPolynomialRing.evzero;
                }
                if ((expVector = genPolynomial3.leadingExpVector()) == null) {
                    expVector = genPolynomialRing.evzero;
                }
                if (!(bl2 = genPolynomial3.compareTo(genPolynomial2) < 0 || expVector.compareTo(expVector4) == 0 && genPolynomial3.leadingBaseCoefficient().compareTo(genPolynomial2.leadingBaseCoefficient()) != 0)) continue;
                bl = true;
                genPolynomial = genPolynomial.subtractMultiple(ringElem, expVector3, sigPoly2.poly);
                if (expVector.invGradCompareTo(expVector4) == 0) {
                    genPolynomial2 = genPolynomial2.subtract((Object)genPolynomial3);
                }
                if (genPolynomial.isZERO()) continue block0;
                object = genPolynomial.leadingExpVector();
            }
        }
        if (!genPolynomial.isZERO() && !(object = genPolynomial.leadingBaseCoefficient()).isONE()) {
            object = (RingElem)object.inverse();
            genPolynomial = genPolynomial.multiply(object);
            genPolynomial2 = genPolynomial2.multiply(object);
        }
        return new SigPoly(genPolynomial2, genPolynomial);
    }

    public SigPoly<C> sigSemiNormalform(List<GenPolynomial<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        Object object;
        if (list.isEmpty() && list2.isEmpty()) {
            return sigPoly;
        }
        if (sigPoly.poly.isZERO()) {
            return sigPoly;
        }
        List<GenPolynomial<C>> list3 = list;
        GenPolynomial<Object> genPolynomial = sigPoly.poly;
        GenPolynomial genPolynomial2 = sigPoly.sigma;
        ExpVector expVector = genPolynomial2.leadingExpVector();
        if (expVector == null) {
            logger.info("esig = null");
        }
        boolean bl = true;
        block0: while (!genPolynomial.isZERO() && bl) {
            bl = false;
            if ((genPolynomial = this.red.normalform(list3, genPolynomial)).isZERO()) continue;
            object = genPolynomial.leadingExpVector();
            for (SigPoly<C> sigPoly2 : list2) {
                ExpVector expVector2;
                boolean bl2;
                if (sigPoly2.poly.isZERO() || !(bl2 = ((ExpVector)object).multipleOf(expVector2 = sigPoly2.poly.leadingExpVector()))) continue;
                ExpVector expVector3 = ((ExpVector)object).subtract(expVector2);
                RingElem ringElem = (RingElem)genPolynomial.leadingBaseCoefficient().divide(sigPoly2.poly.leadingBaseCoefficient());
                GenPolynomial<RingElem> genPolynomial3 = sigPoly2.sigma.multiply(ringElem, expVector3);
                ExpVector expVector4 = genPolynomial3.leadingExpVector();
                if (expVector4 == null) {
                    logger.info("eup = null");
                    throw new IllegalArgumentException("eup == null: " + genPolynomial3);
                }
                boolean bl3 = expVector4.compareTo(expVector) < 0;
                if (!bl3) continue;
                bl = true;
                if ((genPolynomial = genPolynomial.subtractMultiple(ringElem, expVector3, sigPoly2.poly)).isZERO()) continue block0;
                object = genPolynomial.leadingExpVector();
            }
        }
        if (!genPolynomial.isZERO() && !(object = genPolynomial.leadingBaseCoefficient()).isONE()) {
            object = (RingElem)object.inverse();
            genPolynomial = genPolynomial.multiply(object);
        }
        return new SigPoly(genPolynomial2, genPolynomial);
    }

    public List<GenPolynomial<C>> polys(List<SigPoly<C>> list) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (SigPoly<C> sigPoly : list) {
            if (sigPoly.poly.isZERO()) continue;
            arrayList.add(sigPoly.poly);
        }
        return arrayList;
    }

    public List<GenPolynomial<C>> sigmas(List<SigPair<C>> list) {
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (SigPair<C> sigPair : list) {
            arrayList.add(sigPair.sigma);
        }
        return arrayList;
    }

    public long minimalSigDegree(List<SigPair<C>> list) {
        long l = Long.MAX_VALUE;
        for (SigPair<C> sigPair : list) {
            long l2 = sigPair.sigma.degree();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    public List<SigPair<C>>[] minDegSubset(List<SigPair<C>> list) {
        long l = this.minimalSigDegree(list);
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>();
        ArrayList<SigPair<C>> arrayList2 = new ArrayList<SigPair<C>>();
        for (SigPair<C> sigPair : list) {
            if (sigPair.sigma.degree() == l) {
                arrayList.add(sigPair);
                continue;
            }
            arrayList2.add(sigPair);
        }
        List[] listArray = new List[]{arrayList, arrayList2};
        return listArray;
    }

    public List<SigPair<C>> sortSigma(List<SigPair<C>> list) {
        Comparator<SigPair> comparator = Comparator.comparingLong(SigPair::getSigmaDegree);
        List<SigPair<C>> list2 = list.stream().sorted(comparator).collect(Collectors.toList());
        return list2;
    }
}

