/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.GroebnerBaseSeqPairParallel;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseSeqPairParTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GroebnerBaseAbstract<BigRational> bbseq;
    GroebnerBaseAbstract<BigRational> bbpar;
    GroebnerBaseAbstract<BigRational> bbspar;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 3;
    int kl = 10;
    int ll = 7;
    int el = 3;
    float q = 0.2f;
    int threads = 2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseSeqPairParTest.suite());
    }

    public GroebnerBaseSeqPairParTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseSeqPairParTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        this.fac = new GenPolynomialRing<BigRational>(bigRational, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bbseq = new GroebnerBaseSeq<BigRational>();
        this.bbpar = new GroebnerBaseParallel<BigRational>(this.threads);
        this.bbspar = new GroebnerBaseSeqPairParallel<BigRational>(this.threads);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bbseq = null;
        this.bbpar.terminate();
        this.bbpar = null;
        this.bbspar.terminate();
        this.bbspar = null;
    }

    public void testSeqPairParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        GroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)"isGB( { a } )", (boolean)this.bbspar.isGB(this.L));
        GroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bbspar.isGB(this.L));
        GroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bbspar.isGB(this.L));
        GroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.L.add(this.d);
        this.L = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bbspar.isGB(this.L));
        GroebnerBaseSeqPairParTest.assertTrue((String)"not isZERO( e )", (!this.e.isZERO() ? 1 : 0) != 0);
        this.L.add(this.e);
        this.L = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bbspar.isGB(this.L));
    }

    public void testSequentialSeqPairParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L.add(this.a);
        List<GenPolynomial<BigRational>> list = this.bbseq.GB(this.L);
        List<GenPolynomial<BigRational>> list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.b);
        list = this.bbseq.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.c);
        list = this.bbseq.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.d);
        list = this.bbseq.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.e);
        list = this.bbseq.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp)" + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs)" + list + ", " + list2), (boolean)list2.containsAll(list));
    }

    public void testParallelSeqPairParallelGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        this.L.add(this.a);
        List<GenPolynomial<BigRational>> list = this.bbpar.GB(this.L);
        List<GenPolynomial<BigRational>> list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp) " + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs) " + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.b);
        list = this.bbpar.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp) " + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs) " + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.c);
        list = this.bbpar.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp) " + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs) " + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.d);
        list = this.bbpar.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp) " + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs) " + list + ", " + list2), (boolean)list2.containsAll(list));
        this.L = list;
        this.L.add(this.e);
        list = this.bbpar.GB(this.L);
        list2 = this.bbspar.GB(this.L);
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gs.containsAll(Gp) " + list + ", " + list2), (boolean)list.containsAll(list2));
        GroebnerBaseSeqPairParTest.assertTrue((String)("Gp.containsAll(Gs) " + list + ", " + list2), (boolean)list2.containsAll(list));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ) , ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSeqPairParTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSeqPairParTest.fail((String)("" + iOException));
        }
        long l = System.currentTimeMillis();
        this.G = this.bbspar.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        GroebnerBaseSeqPairParTest.assertTrue((String)"nonsense ", (l >= 0L ? 1 : 0) != 0);
        GroebnerBaseSeqPairParTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bbspar.isGB(this.G));
        GroebnerBaseSeqPairParTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }
}

