/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigRational;
import edu.jas.fd.QuotSolvablePolynomial;
import edu.jas.fd.QuotSolvablePolynomialRing;
import edu.jas.fd.SolvableQuotient;
import edu.jas.fd.SolvableQuotientRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuotSolvablePolynomialTest
extends TestCase {
    QuotSolvablePolynomial<BigRational> a;
    QuotSolvablePolynomial<BigRational> b;
    QuotSolvablePolynomial<BigRational> c;
    QuotSolvablePolynomial<BigRational> d;
    QuotSolvablePolynomial<BigRational> e;
    QuotSolvablePolynomial<BigRational> f;
    QuotSolvablePolynomial<BigRational> x1;
    QuotSolvablePolynomial<BigRational> x2;
    int rl = 4;
    int kl = 1;
    int ll = 4;
    int el = 3;
    float q = 0.2f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    QuotSolvablePolynomialRing<BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<SolvableQuotient<BigRational>> sring;
    GenSolvablePolynomialRing<BigRational> cring;
    SolvableQuotientRing<BigRational> qcring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        TestRunner.run((Test)QuotSolvablePolynomialTest.suite());
        ComputerThreads.terminate();
    }

    public QuotSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuotSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        this.qcring = new SolvableQuotientRing<BigRational>(this.cring);
        this.ring = new QuotSolvablePolynomialRing(this.qcring, this.tord, this.vars);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        QuotSolvablePolynomialTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        QuotSolvablePolynomialTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new QuotSolvablePolynomial<BigRational>(this.ring);
        QuotSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        QuotSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        QuotSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        QuotSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        QuotSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        QuotSolvablePolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        QuotSolvablePolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotSolvablePolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            QuotSolvablePolynomialTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
        QuotSolvablePolynomialTest.assertTrue((String)"isAssociative: ", (boolean)this.ring.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            QuotSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            QuotSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuotSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QuotSolvablePolynomial)this.a.subtract((BigRational)((Object)this.a));
        QuotSolvablePolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (QuotSolvablePolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (QuotSolvablePolynomial)this.b.subtract((BigRational)((Object)this.a));
        QuotSolvablePolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (QuotSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (QuotSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        QuotSolvablePolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (QuotSolvablePolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (QuotSolvablePolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        QuotSolvablePolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        Element element = this.qcring.random(this.kl);
        this.b = ((QuotSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QuotSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (QuotSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        QuotSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QuotSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (QuotSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        QuotSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((QuotSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (QuotSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (QuotSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        QuotSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (QuotSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (QuotSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        QuotSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.b = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        QuotSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        QuotSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        MonoidElem monoidElem = ((SolvableQuotient)this.a.leadingBaseCoefficient()).inverse();
        this.d = this.a.multiply((SolvableQuotient<BigRational>)monoidElem);
        QuotSolvablePolynomialTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((SolvableQuotient)this.d.leadingBaseCoefficient()).isONE());
        this.d = (QuotSolvablePolynomial)this.a.monic();
        QuotSolvablePolynomialTest.assertTrue((String)"a.monic(): ", (boolean)((SolvableQuotient)this.d.leadingBaseCoefficient()).isONE());
    }

    public void testCommutative() {
        QuotSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.ring = new QuotSolvablePolynomialRing(this.qcring, this.ring);
        QuotSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        QuotSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        QuotSolvablePolynomialTest.assertEquals((String)"b*a == a*b: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((QuotSolvablePolynomial)this.b.sum((BigRational)((Object)this.c)));
        this.e = (QuotSolvablePolynomial)this.a.multiply(this.b).sum((BigRational)((Object)this.a.multiply(this.c)));
        QuotSolvablePolynomialTest.assertEquals((String)"a*(b+c) = a*b+a*c", this.d, this.e);
    }

    public void testSolvableCoeffs() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        QuotSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        QuotSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        SolvableQuotientRing<BigRational> solvableQuotientRing = new SolvableQuotientRing<BigRational>(genSolvablePolynomialRing);
        QuotSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)solvableQuotientRing.isAssociative());
        this.ring = new QuotSolvablePolynomialRing(solvableQuotientRing, this.ring);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        QuotSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        QuotSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        QuotSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.polCoeff.parse("x");
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.polCoeff.parse("b x + a");
        this.ring.polCoeff.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), genSolvablePolynomial2);
        QuotSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        QuotSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial2 : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial2;
            this.a = new QuotSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial3 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial3;
                this.b = new QuotSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply(this.b);
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                QuotSolvablePolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.parse("x^2 + a b");
        this.b = this.ring.parse("a b^2 + a");
        this.b = (QuotSolvablePolynomial)this.b.inverse();
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        QuotSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.e = (QuotSolvablePolynomial)this.b.inverse();
        QuotSolvablePolynomialTest.assertTrue((String)"b*b^-1 == 1", (boolean)this.e.multiply(this.b).isONE());
        this.c = this.e.multiply(this.c);
        this.d = this.d.multiply(this.e);
        QuotSolvablePolynomialTest.assertTrue((String)"a == b * 1/b * a", (boolean)this.a.equals(this.c));
        QuotSolvablePolynomialTest.assertTrue((String)"a == a * 1/b * b", (boolean)this.a.equals(this.d));
    }
}

