/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigDecimalComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import java.math.MathContext;

public class Roots {
    public static BigInteger root(BigInteger bigInteger, int n) {
        BigInteger bigInteger2;
        if (n == 1) {
            return bigInteger;
        }
        if (n == 2) {
            return Roots.sqrt(bigInteger);
        }
        if (n < 1) {
            throw new IllegalArgumentException("negative root not defined");
        }
        if (bigInteger == null || bigInteger.isZERO() || bigInteger.isONE()) {
            return bigInteger;
        }
        if (bigInteger.signum() < 0) {
            throw new ArithmeticException("root of negative not defined: " + bigInteger);
        }
        int n2 = bigInteger.val.bitLength() + 2;
        MathContext mathContext = new MathContext(n2);
        BigDecimal bigDecimal = new BigDecimal(bigInteger.val, mathContext);
        BigDecimal bigDecimal2 = Roots.root(bigDecimal, n);
        java.math.BigInteger bigInteger3 = bigDecimal2.val.toBigInteger();
        BigInteger bigInteger4 = new BigInteger(bigInteger3);
        while (bigInteger.compareTo(bigInteger2 = (BigInteger)bigInteger4.power(n)) < 0) {
            bigInteger4 = bigInteger4.subtract(BigInteger.ONE);
        }
        return bigInteger4;
    }

    public static BigInteger sqrt(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger == null || bigInteger.isZERO() || bigInteger.isONE()) {
            return bigInteger;
        }
        if (bigInteger.signum() < 0) {
            throw new ArithmeticException("root of negative not defined: " + bigInteger);
        }
        int n = bigInteger.val.bitLength() + 2;
        MathContext mathContext = new MathContext(n);
        BigDecimal bigDecimal = new BigDecimal(bigInteger.val, mathContext);
        BigDecimal bigDecimal2 = Roots.sqrt(bigDecimal);
        java.math.BigInteger bigInteger3 = bigDecimal2.val.toBigInteger();
        BigInteger bigInteger4 = new BigInteger(bigInteger3);
        while (bigInteger.compareTo(bigInteger2 = bigInteger4.multiply(bigInteger4)) < 0) {
            bigInteger4 = bigInteger4.subtract(BigInteger.ONE);
        }
        return bigInteger4;
    }

    public static BigInteger sqrtInt(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (bigInteger == null || bigInteger.isZERO() || bigInteger.isONE()) {
            return bigInteger;
        }
        int n = bigInteger.signum();
        if (n < 0) {
            throw new ArithmeticException("root of negative not defined: " + bigInteger);
        }
        int n2 = bigInteger.val.bitLength();
        int n3 = n2 - n2 / 2;
        BigInteger bigInteger4 = bigInteger3 = new BigInteger(bigInteger.val.shiftRight(n3));
        while (!bigInteger4.isZERO()) {
            bigInteger4 = new BigInteger(bigInteger4.val.shiftRight(1));
            bigInteger2 = bigInteger3.sum(bigInteger4);
            n = bigInteger.compareTo(bigInteger2.multiply(bigInteger2));
            if (n == 0) {
                return bigInteger2;
            }
            if (n <= 0) continue;
            bigInteger3 = bigInteger2;
        }
        do {
            if ((n = bigInteger.compareTo((bigInteger2 = bigInteger3.sum(BigInteger.ONE)).multiply(bigInteger2))) == 0) {
                return bigInteger2;
            }
            if (n <= 0) continue;
            bigInteger3 = bigInteger2;
        } while (n >= 0);
        return bigInteger3;
    }

    public static BigDecimal sqrt(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.isZERO() || bigDecimal.isONE()) {
            return bigDecimal;
        }
        if (bigDecimal.signum() < 0) {
            throw new ArithmeticException("root of negative not defined: " + bigDecimal);
        }
        if (bigDecimal.abs().val.compareTo(BigDecimal.ONE.val) < 0) {
            BigDecimal bigDecimal2 = bigDecimal.inverse();
            bigDecimal2 = Roots.sqrt(bigDecimal2);
            bigDecimal2 = bigDecimal2.inverse();
            return bigDecimal2;
        }
        MathContext mathContext = bigDecimal.context;
        BigDecimal bigDecimal3 = new BigDecimal("0.1");
        int n = Math.max(mathContext.getPrecision(), MathContext.DECIMAL64.getPrecision());
        bigDecimal3 = (BigDecimal)bigDecimal3.power(n / 2);
        BigDecimal bigDecimal4 = new BigDecimal(bigDecimal.val, mathContext);
        BigDecimal bigDecimal5 = new BigDecimal(0.5, mathContext);
        BigDecimal bigDecimal6 = bigDecimal4.multiply(bigDecimal5);
        int n2 = 0;
        while (true) {
            BigDecimal bigDecimal7 = bigDecimal6.sum(bigDecimal4.divide(bigDecimal6));
            bigDecimal7 = bigDecimal7.multiply(bigDecimal5);
            BigDecimal bigDecimal8 = bigDecimal6.subtract(bigDecimal7).abs();
            bigDecimal6 = bigDecimal7;
            if (bigDecimal8.val.compareTo(bigDecimal3.val) <= 0) break;
            if (n2++ % 11 != 0) continue;
            bigDecimal3 = bigDecimal3.sum(bigDecimal3);
        }
        return bigDecimal6;
    }

    public static BigDecimal root(BigDecimal bigDecimal, int n) {
        if (n == 1) {
            return bigDecimal;
        }
        if (n == 2) {
            return Roots.sqrt(bigDecimal);
        }
        if (n < 1) {
            throw new IllegalArgumentException("negative root not defined");
        }
        if (bigDecimal == null || bigDecimal.isZERO() || bigDecimal.isONE()) {
            return bigDecimal;
        }
        if (bigDecimal.signum() < 0) {
            throw new ArithmeticException("root of negative not defined: " + bigDecimal);
        }
        if (bigDecimal.abs().val.compareTo(BigDecimal.ONE.val) < 0) {
            BigDecimal bigDecimal2 = bigDecimal.inverse();
            bigDecimal2 = Roots.root(bigDecimal2, n);
            return bigDecimal2.inverse();
        }
        MathContext mathContext = bigDecimal.context;
        BigDecimal bigDecimal3 = new BigDecimal("0.1");
        int n2 = Math.max(mathContext.getPrecision(), MathContext.DECIMAL64.getPrecision());
        bigDecimal3 = (BigDecimal)bigDecimal3.power(n2 / 3 * 2);
        BigDecimal bigDecimal4 = bigDecimal;
        BigDecimal bigDecimal5 = new BigDecimal(n, mathContext);
        BigDecimal bigDecimal6 = new BigDecimal(1.0 / (double)n, mathContext);
        BigDecimal bigDecimal7 = new BigDecimal(1.0, mathContext);
        bigDecimal7 = bigDecimal7.subtract(bigDecimal6);
        BigDecimal bigDecimal8 = bigDecimal4.multiply(bigDecimal6);
        int n3 = 0;
        while (true) {
            BigDecimal bigDecimal9 = (BigDecimal)bigDecimal8.power(n - 1);
            BigDecimal bigDecimal10 = bigDecimal4.divide(bigDecimal9.multiply(bigDecimal5));
            bigDecimal10 = bigDecimal8.multiply(bigDecimal7).sum(bigDecimal10);
            BigDecimal bigDecimal11 = bigDecimal8.subtract(bigDecimal10).abs();
            bigDecimal8 = bigDecimal10;
            if (bigDecimal11.val.compareTo(bigDecimal3.val) <= 0) break;
            if (n3++ % 11 != 0) continue;
            bigDecimal3 = bigDecimal3.sum(bigDecimal3);
        }
        return bigDecimal8;
    }

    public static BigDecimalComplex sqrt(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex.isZERO() || bigDecimalComplex.isONE()) {
            return bigDecimalComplex;
        }
        if (bigDecimalComplex.im.isZERO() && bigDecimalComplex.re.signum() > 0) {
            BigDecimal bigDecimal = Roots.sqrt(bigDecimalComplex.re);
            return new BigDecimalComplex(bigDecimal);
        }
        BigDecimal bigDecimal = bigDecimalComplex.re.abs().sum(bigDecimalComplex.abs().re);
        BigDecimal bigDecimal2 = new BigDecimal(2L);
        BigDecimal bigDecimal3 = new BigDecimal("0.5");
        BigDecimal bigDecimal4 = bigDecimal.multiply(bigDecimal3);
        BigDecimal bigDecimal5 = Roots.sqrt(bigDecimal4);
        if (bigDecimalComplex.re.signum() >= 0) {
            return new BigDecimalComplex(bigDecimal5, bigDecimalComplex.im.divide(bigDecimal5.multiply(bigDecimal2)));
        }
        bigDecimal4 = bigDecimal5;
        if (bigDecimalComplex.im.signum() < 0) {
            bigDecimal4 = bigDecimal4.negate();
        }
        return new BigDecimalComplex(bigDecimalComplex.im.abs().divide(bigDecimal5.multiply(bigDecimal2)), bigDecimal4);
    }

    public static BigRational sqrt(BigRational bigRational) {
        if (bigRational == null || bigRational.isZERO() || bigRational.isONE()) {
            return bigRational;
        }
        if (bigRational.signum() < 0) {
            throw new ArithmeticException("root of negative not defined: " + bigRational);
        }
        BigDecimal bigDecimal = new BigDecimal(bigRational);
        BigDecimal bigDecimal2 = Roots.sqrt(bigDecimal);
        BigRational bigRational2 = new BigRational(bigDecimal2.toString());
        return bigRational2;
    }

    public static BigComplex sqrt(BigComplex bigComplex) {
        if (bigComplex == null || bigComplex.isZERO() || bigComplex.isONE()) {
            return bigComplex;
        }
        BigDecimalComplex bigDecimalComplex = new BigDecimalComplex(bigComplex);
        BigDecimalComplex bigDecimalComplex2 = Roots.sqrt(bigDecimalComplex);
        BigComplex bigComplex2 = new BigComplex(bigDecimalComplex2.toString());
        return bigComplex2;
    }
}

