/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PrimeList
implements Iterable<BigInteger> {
    private static volatile List<BigInteger> SMALL_LIST = null;
    private static volatile List<BigInteger> LOW_LIST = null;
    private static volatile List<BigInteger> MEDIUM_LIST = null;
    private static volatile List<BigInteger> LARGE_LIST = null;
    private static volatile List<BigInteger> MERSENNE_LIST = null;
    private List<BigInteger> val = null;
    private BigInteger last;

    public PrimeList() {
        this(Range.medium);
    }

    public PrimeList(Range range) {
        switch (range) {
            case small: {
                if (SMALL_LIST != null) {
                    this.val = SMALL_LIST;
                    break;
                }
                this.val = new ArrayList<BigInteger>(50);
                this.addSmall();
                SMALL_LIST = this.val;
                break;
            }
            case low: {
                if (LOW_LIST != null) {
                    this.val = LOW_LIST;
                    break;
                }
                this.val = new ArrayList<BigInteger>(50);
                this.addLow();
                LOW_LIST = this.val;
                break;
            }
            default: {
                if (MEDIUM_LIST != null) {
                    this.val = MEDIUM_LIST;
                    break;
                }
                this.val = new ArrayList<BigInteger>(50);
                this.addMedium();
                MEDIUM_LIST = this.val;
                break;
            }
            case large: {
                if (LARGE_LIST != null) {
                    this.val = LARGE_LIST;
                    break;
                }
                this.val = new ArrayList<BigInteger>(50);
                this.addLarge();
                LARGE_LIST = this.val;
                break;
            }
            case mersenne: {
                if (MERSENNE_LIST != null) {
                    this.val = MERSENNE_LIST;
                    break;
                }
                this.val = new ArrayList<BigInteger>(50);
                this.addMersenne();
                MERSENNE_LIST = this.val;
            }
        }
        this.last = this.get(this.size() - 1);
    }

    private void addSmall() {
        this.val.add(BigInteger.valueOf(2L));
        this.val.add(BigInteger.valueOf(3L));
        this.val.add(BigInteger.valueOf(5L));
        this.val.add(BigInteger.valueOf(7L));
        this.val.add(BigInteger.valueOf(11L));
        this.val.add(BigInteger.valueOf(13L));
        this.val.add(BigInteger.valueOf(17L));
        this.val.add(BigInteger.valueOf(19L));
        this.val.add(BigInteger.valueOf(23L));
        this.val.add(BigInteger.valueOf(29L));
    }

    private void addLow() {
        this.val.add(PrimeList.getLongPrime(15, 19));
        this.val.add(PrimeList.getLongPrime(15, 49));
        this.val.add(PrimeList.getLongPrime(15, 51));
        this.val.add(PrimeList.getLongPrime(15, 55));
        this.val.add(PrimeList.getLongPrime(15, 61));
        this.val.add(PrimeList.getLongPrime(15, 75));
        this.val.add(PrimeList.getLongPrime(15, 81));
        this.val.add(PrimeList.getLongPrime(15, 115));
        this.val.add(PrimeList.getLongPrime(15, 121));
        this.val.add(PrimeList.getLongPrime(15, 135));
        this.val.add(PrimeList.getLongPrime(16, 15));
        this.val.add(PrimeList.getLongPrime(16, 17));
        this.val.add(PrimeList.getLongPrime(16, 39));
        this.val.add(PrimeList.getLongPrime(16, 57));
        this.val.add(PrimeList.getLongPrime(16, 87));
        this.val.add(PrimeList.getLongPrime(16, 89));
        this.val.add(PrimeList.getLongPrime(16, 99));
        this.val.add(PrimeList.getLongPrime(16, 113));
        this.val.add(PrimeList.getLongPrime(16, 117));
        this.val.add(PrimeList.getLongPrime(16, 123));
    }

    private void addMedium() {
        this.val.add(PrimeList.getLongPrime(28, 57));
        this.val.add(PrimeList.getLongPrime(28, 89));
        this.val.add(PrimeList.getLongPrime(28, 95));
        this.val.add(PrimeList.getLongPrime(28, 119));
        this.val.add(PrimeList.getLongPrime(28, 125));
        this.val.add(PrimeList.getLongPrime(28, 143));
        this.val.add(PrimeList.getLongPrime(28, 165));
        this.val.add(PrimeList.getLongPrime(28, 183));
        this.val.add(PrimeList.getLongPrime(28, 213));
        this.val.add(PrimeList.getLongPrime(28, 273));
        this.val.add(PrimeList.getLongPrime(29, 3));
        this.val.add(PrimeList.getLongPrime(29, 33));
        this.val.add(PrimeList.getLongPrime(29, 43));
        this.val.add(PrimeList.getLongPrime(29, 63));
        this.val.add(PrimeList.getLongPrime(29, 73));
        this.val.add(PrimeList.getLongPrime(29, 75));
        this.val.add(PrimeList.getLongPrime(29, 93));
        this.val.add(PrimeList.getLongPrime(29, 99));
        this.val.add(PrimeList.getLongPrime(29, 121));
        this.val.add(PrimeList.getLongPrime(29, 133));
        this.val.add(PrimeList.getLongPrime(32, 5));
        this.val.add(PrimeList.getLongPrime(32, 17));
        this.val.add(PrimeList.getLongPrime(32, 65));
        this.val.add(PrimeList.getLongPrime(32, 99));
        this.val.add(PrimeList.getLongPrime(32, 107));
        this.val.add(PrimeList.getLongPrime(32, 135));
        this.val.add(PrimeList.getLongPrime(32, 153));
        this.val.add(PrimeList.getLongPrime(32, 185));
        this.val.add(PrimeList.getLongPrime(32, 209));
        this.val.add(PrimeList.getLongPrime(32, 267));
    }

    private void addLarge() {
        this.val.add(PrimeList.getLongPrime(59, 55));
        this.val.add(PrimeList.getLongPrime(59, 99));
        this.val.add(PrimeList.getLongPrime(59, 225));
        this.val.add(PrimeList.getLongPrime(59, 427));
        this.val.add(PrimeList.getLongPrime(59, 517));
        this.val.add(PrimeList.getLongPrime(59, 607));
        this.val.add(PrimeList.getLongPrime(59, 649));
        this.val.add(PrimeList.getLongPrime(59, 687));
        this.val.add(PrimeList.getLongPrime(59, 861));
        this.val.add(PrimeList.getLongPrime(59, 871));
        this.val.add(PrimeList.getLongPrime(60, 93));
        this.val.add(PrimeList.getLongPrime(60, 107));
        this.val.add(PrimeList.getLongPrime(60, 173));
        this.val.add(PrimeList.getLongPrime(60, 179));
        this.val.add(PrimeList.getLongPrime(60, 257));
        this.val.add(PrimeList.getLongPrime(60, 279));
        this.val.add(PrimeList.getLongPrime(60, 369));
        this.val.add(PrimeList.getLongPrime(60, 395));
        this.val.add(PrimeList.getLongPrime(60, 399));
        this.val.add(PrimeList.getLongPrime(60, 453));
        this.val.add(PrimeList.getLongPrime(63, 25));
        this.val.add(PrimeList.getLongPrime(63, 165));
        this.val.add(PrimeList.getLongPrime(63, 259));
        this.val.add(PrimeList.getLongPrime(63, 301));
        this.val.add(PrimeList.getLongPrime(63, 375));
        this.val.add(PrimeList.getLongPrime(63, 387));
        this.val.add(PrimeList.getLongPrime(63, 391));
        this.val.add(PrimeList.getLongPrime(63, 409));
        this.val.add(PrimeList.getLongPrime(63, 457));
        this.val.add(PrimeList.getLongPrime(63, 471));
    }

    private void addMersenne() {
        this.val.add(PrimeList.getMersennePrime(2));
        this.val.add(PrimeList.getMersennePrime(3));
        this.val.add(PrimeList.getMersennePrime(5));
        this.val.add(PrimeList.getMersennePrime(7));
        this.val.add(PrimeList.getMersennePrime(13));
        this.val.add(PrimeList.getMersennePrime(17));
        this.val.add(PrimeList.getMersennePrime(19));
        this.val.add(PrimeList.getMersennePrime(31));
        this.val.add(PrimeList.getMersennePrime(61));
        this.val.add(PrimeList.getMersennePrime(89));
        this.val.add(PrimeList.getMersennePrime(107));
        this.val.add(PrimeList.getMersennePrime(127));
        this.val.add(PrimeList.getMersennePrime(521));
        this.val.add(PrimeList.getMersennePrime(607));
        this.val.add(PrimeList.getMersennePrime(1279));
        this.val.add(PrimeList.getMersennePrime(2203));
        this.val.add(PrimeList.getMersennePrime(2281));
        this.val.add(PrimeList.getMersennePrime(3217));
        this.val.add(PrimeList.getMersennePrime(4253));
        this.val.add(PrimeList.getMersennePrime(4423));
        this.val.add(PrimeList.getMersennePrime(9689));
        this.val.add(PrimeList.getMersennePrime(9941));
        this.val.add(PrimeList.getMersennePrime(11213));
        this.val.add(PrimeList.getMersennePrime(19937));
    }

    public static BigInteger getLongPrime(int n, int n2) {
        if (n < 30) {
            return BigInteger.valueOf((1 << n) - n2);
        }
        return BigInteger.ONE.shiftLeft(n).subtract(BigInteger.valueOf(n2));
    }

    public static BigInteger getMersennePrime(int n) {
        return BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
    }

    protected boolean checkPrimes() {
        return this.checkPrimes(this.size());
    }

    protected boolean checkPrimes(int n) {
        int n2 = 0;
        for (BigInteger bigInteger : this.val) {
            if (n2++ >= n) break;
            boolean bl = bigInteger.isProbablePrime(63);
            if (bl) continue;
            System.out.println("not prime = " + bigInteger);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.val.toString();
    }

    public int size() {
        return this.val.size();
    }

    public BigInteger get(int n) {
        BigInteger bigInteger;
        if (n < this.size()) {
            bigInteger = this.val.get(n);
        } else if (n == this.size()) {
            bigInteger = this.last.nextProbablePrime();
            this.val.add(bigInteger);
            this.last = bigInteger;
        } else {
            bigInteger = this.get(n - 1);
            bigInteger = this.last.nextProbablePrime();
            this.val.add(bigInteger);
            this.last = bigInteger;
        }
        return bigInteger;
    }

    @Override
    public Iterator<BigInteger> iterator() {
        return new Iterator<BigInteger>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not implemented");
            }

            @Override
            public BigInteger next() {
                ++this.index;
                return PrimeList.this.get(this.index);
            }
        };
    }

    public static enum Range {
        small,
        low,
        medium,
        large,
        mersenne;

    }
}

