/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvablePolynomial;
import edu.jas.application.SolvableResidue;
import edu.jas.application.SolvableResidueRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResidueSolvablePolynomialRing<C extends GcdRingElem<C>>
extends GenSolvablePolynomialRing<SolvableResidue<C>> {
    public final RecSolvablePolynomialRing<C> polCoeff;
    public final ResidueSolvablePolynomial<C> ZERO;
    public final ResidueSolvablePolynomial<C> ONE;
    private static final Logger logger = LogManager.getLogger(ResidueSolvablePolynomialRing.class);
    private static final boolean debug = logger.isDebugEnabled();

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), (String[])null, (RelationTable<SolvableResidue<C>>)null);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, int n, RelationTable<SolvableResidue<C>> relationTable) {
        this(ringFactory, n, new TermOrder(), (String[])null, relationTable);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, (String[])null, (RelationTable<SolvableResidue<C>>)null);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, int n, TermOrder termOrder, RelationTable<SolvableResidue<C>> relationTable) {
        this(ringFactory, n, termOrder, (String[])null, relationTable);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, (RelationTable<SolvableResidue<C>>)null);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, (RelationTable<SolvableResidue<C>>)null);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, (RelationTable<SolvableResidue<C>>)null);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<SolvableResidue<C>> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        SolvableResidue solvableResidue;
        SolvableResidueRing solvableResidueRing = (SolvableResidueRing)ringFactory;
        this.polCoeff = new RecSolvablePolynomialRing(solvableResidueRing.ring, n, termOrder, stringArray);
        if (this.table.size() > 0) {
            solvableResidue = null;
            ExpVector expVector = null;
            GenSolvablePolynomial genSolvablePolynomial = null;
            this.polCoeff.table.update((ExpVector)((Object)solvableResidue), expVector, genSolvablePolynomial);
        }
        this.ZERO = new ResidueSolvablePolynomial(this);
        solvableResidue = (SolvableResidue)this.coFac.getONE();
        this.ONE = new ResidueSolvablePolynomial(this, solvableResidue, this.evzero);
    }

    public ResidueSolvablePolynomialRing(RingFactory<SolvableResidue<C>> ringFactory, ResidueSolvablePolynomialRing residueSolvablePolynomialRing) {
        this(ringFactory, residueSolvablePolynomialRing.nvar, residueSolvablePolynomialRing.tord, residueSolvablePolynomialRing.getVars(), (RelationTable<SolvableResidue<C>>)null);
    }

    @Override
    public String toString() {
        Object object = super.toString();
        object = PrettyPrint.isTrue() ? (String)object + "\n" + this.polCoeff.coeffTable.toString(this.vars) : (String)object + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return object;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toScript();
        stringBuffer.append(string2);
        if (this.table.size() > 0) {
            string = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            string = this.polCoeff.coeffTable.toScript();
            stringBuffer.append(",coeffrel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ResidueSolvablePolynomialRing)) {
            return false;
        }
        ResidueSolvablePolynomialRing residueSolvablePolynomialRing = null;
        try {
            residueSolvablePolynomialRing = (ResidueSolvablePolynomialRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (residueSolvablePolynomialRing == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(residueSolvablePolynomialRing.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.polCoeff.coeffTable.hashCode();
        return n;
    }

    @Override
    public ResidueSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public ResidueSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.coeffTable.size() == 0) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        if (!this.polCoeff.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ResidueSolvablePolynomial residueSolvablePolynomial = (ResidueSolvablePolynomial)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                ResidueSolvablePolynomial residueSolvablePolynomial2 = (ResidueSolvablePolynomial)list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    ResidueSolvablePolynomial residueSolvablePolynomial3;
                    ResidueSolvablePolynomial residueSolvablePolynomial4 = (ResidueSolvablePolynomial)list.get(k);
                    ResidueSolvablePolynomial residueSolvablePolynomial5 = residueSolvablePolynomial4.multiply(residueSolvablePolynomial2).multiply(residueSolvablePolynomial);
                    if (residueSolvablePolynomial5.equals(residueSolvablePolynomial3 = residueSolvablePolynomial4.multiply(residueSolvablePolynomial2.multiply(residueSolvablePolynomial)))) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info("Xk = " + residueSolvablePolynomial4 + ", Xj = " + residueSolvablePolynomial2 + ", Xi = " + residueSolvablePolynomial);
                        logger.info("p = ( Xk * Xj ) * Xi = " + residueSolvablePolynomial5);
                        logger.info("q = Xk * ( Xj * Xi ) = " + residueSolvablePolynomial3);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ResidueSolvablePolynomial<C> fromInteger(long l) {
        return new ResidueSolvablePolynomial(this, (SolvableResidue)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public ResidueSolvablePolynomial<C> fromInteger(BigInteger bigInteger) {
        return new ResidueSolvablePolynomial(this, (SolvableResidue)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public ResidueSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public ResidueSolvablePolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public ResidueSolvablePolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public ResidueSolvablePolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            SolvableResidue solvableResidue = (SolvableResidue)this.coFac.random(n, random);
            genSolvablePolynomial = (ResidueSolvablePolynomial)genSolvablePolynomial.sum(solvableResidue, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public ResidueSolvablePolynomial<C> copy(ResidueSolvablePolynomial<C> residueSolvablePolynomial) {
        return new ResidueSolvablePolynomial(this, residueSolvablePolynomial.getMap());
    }

    @Override
    public ResidueSolvablePolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public ResidueSolvablePolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        ResidueSolvablePolynomial residueSolvablePolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            residueSolvablePolynomial = new ResidueSolvablePolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error(iOException.toString() + " parse " + this);
            residueSolvablePolynomial = this.ZERO;
        }
        return residueSolvablePolynomial;
    }

    @Override
    public ResidueSolvablePolynomial<C> univariate(int n) {
        return (ResidueSolvablePolynomial)super.univariate(n);
    }

    @Override
    public ResidueSolvablePolynomial<C> univariate(int n, long l) {
        return (ResidueSolvablePolynomial)super.univariate(n, l);
    }

    @Override
    public ResidueSolvablePolynomial<C> univariate(int n, int n2, long l) {
        return (ResidueSolvablePolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<ResidueSolvablePolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<ResidueSolvablePolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<ResidueSolvablePolynomial<C>> univariateList(int n, long l) {
        ArrayList<ResidueSolvablePolynomial<C>> arrayList = new ArrayList<ResidueSolvablePolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((ResidueSolvablePolynomial<C>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public ResidueSolvablePolynomialRing<C> extend(int n) {
        return this.extend(n, false);
    }

    @Override
    public ResidueSolvablePolynomialRing<C> extend(int n, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(n, bl);
        ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing = new ResidueSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        residueSolvablePolynomialRing.table.extend(this.table);
        residueSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return residueSolvablePolynomialRing;
    }

    @Override
    public ResidueSolvablePolynomialRing<C> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    @Override
    public ResidueSolvablePolynomialRing<C> extend(String[] stringArray, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray, bl);
        ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing = new ResidueSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        residueSolvablePolynomialRing.table.extend(this.table);
        residueSolvablePolynomialRing.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return residueSolvablePolynomialRing;
    }

    @Override
    public ResidueSolvablePolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing = new ResidueSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        residueSolvablePolynomialRing.table.contract(this.table);
        residueSolvablePolynomialRing.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return residueSolvablePolynomialRing;
    }

    @Override
    public ResidueSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public ResidueSolvablePolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing = new ResidueSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.getVars());
        residueSolvablePolynomialRing.partial = bl;
        residueSolvablePolynomialRing.table.reverse(this.table);
        residueSolvablePolynomialRing.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return residueSolvablePolynomialRing;
    }

    public ResidueSolvablePolynomial<C> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial2 = ((ResidueSolvablePolynomial)this.getZERO()).copy();
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        RingFactory ringFactory = this.coFac;
        SolvableResidueRing solvableResidueRing = (SolvableResidueRing)ringFactory;
        for (Map.Entry entry : genSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)entry.getValue();
            SolvableResidue solvableResidue = new SolvableResidue(solvableResidueRing, genSolvablePolynomial3);
            if (solvableResidue.isZERO()) continue;
            genSolvablePolynomial2.doPutToMap(expVector, solvableResidue);
        }
        return genSolvablePolynomial2;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(ResidueSolvablePolynomial<C> residueSolvablePolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (residueSolvablePolynomial == null || residueSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry entry : residueSolvablePolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            SolvableResidue solvableResidue = (SolvableResidue)entry.getValue();
            GenSolvablePolynomial genSolvablePolynomial2 = solvableResidue.val;
            if (genSolvablePolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(GenPolynomial<SolvableResidue<C>> genPolynomial) {
        GenSolvablePolynomial genSolvablePolynomial = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genSolvablePolynomial;
        }
        for (Map.Entry<ExpVector, SolvableResidue<C>> entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = entry.getKey();
            SolvableResidue<C> solvableResidue = entry.getValue();
            GenSolvablePolynomial genSolvablePolynomial2 = solvableResidue.val;
            if (genSolvablePolynomial2.isZERO()) continue;
            genSolvablePolynomial.doPutToMap(expVector, genSolvablePolynomial2);
        }
        return genSolvablePolynomial;
    }
}

